/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.style;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.Tree;
import org.openrewrite.internal.StreamUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaStyle;
import org.openrewrite.java.tree.J;

public class ImportLayoutStyle
implements JavaStyle {
    private Map<String, Object> layout;
    private Layout.Builder layoutBuilder;
    private int classCountToUseStarImport = 5;
    private int nameCountToUseStarImport = 3;

    @JsonIgnore
    public int getClassCountToUseStarImport() {
        return this.classCountToUseStarImport;
    }

    @JsonIgnore
    public int getNameCountToUseStarImport() {
        return this.nameCountToUseStarImport;
    }

    @JsonProperty(value="layout")
    public void setLayout(Map<String, Object> layout) {
        this.layout = layout;
        this.classCountToUseStarImport = (Integer)layout.getOrDefault("classCountToUseStarImport", 5);
        this.nameCountToUseStarImport = (Integer)layout.getOrDefault("nameCountToUseStarImport", 3);
        Layout.Builder builder = new Layout.Builder(this.classCountToUseStarImport, this.nameCountToUseStarImport);
        for (String block : (List)layout.get("blocks")) {
            if ((block = block.trim()).equals("<blank line>")) {
                builder.blankLine();
                continue;
            }
            if (block.startsWith("import ")) {
                block = block.substring("import ".length());
                boolean statik = false;
                if (block.startsWith("static")) {
                    statik = true;
                    block = block.substring("static ".length());
                }
                if (block.equals("all other imports")) {
                    if (statik) {
                        builder.importStaticAllOthers();
                        continue;
                    }
                    builder.importAllOthers();
                    continue;
                }
                if (statik) {
                    builder.staticImportPackage(block);
                    continue;
                }
                builder.importPackage(block);
                continue;
            }
            throw new IllegalArgumentException("Syntax error in layout block [" + block + "]");
        }
        this.layoutBuilder = builder;
    }

    public Map<String, Object> getLayout() {
        return Collections.unmodifiableMap(this.layout);
    }

    @NonNull
    public List<J.Import> orderImports(@NonNull List<J.Import> originalImports) {
        if (this.layoutBuilder == null) {
            this.layoutBuilder = new Layout.Builder(5, 3).importAllOthers().blankLine().importPackage("javax.*").importPackage("java.*").blankLine().importStaticAllOthers();
        }
        Layout layout = this.layoutBuilder.build();
        ArrayList<J.Import> orderedImports = new ArrayList<J.Import>();
        assert (layout.getBlocks().stream().anyMatch(it -> it instanceof Layout.Block.AllOthers && ((Layout.Block.AllOthers)it).isStatic())) : "There must be at least one block that accepts all static imports, but no such block was found in the specified layout";
        assert (layout.getBlocks().stream().anyMatch(it -> it instanceof Layout.Block.AllOthers && !((Layout.Block.AllOthers)it).isStatic())) : "There must be at least one block that accepts all non-static imports, but no such block was found in the specified layout";
        Map<Boolean, List<Layout.Block>> blockGroups = layout.getBlocks().stream().collect(Collectors.partitioningBy(block -> block instanceof Layout.Block.AllOthers));
        List<Layout.Block> blocksNoCatchalls = blockGroups.get(false);
        List<Layout.Block> blocksOnlyCatchalls = blockGroups.get(true);
        for (J.Import anImport : originalImports) {
            boolean accepted = false;
            for (Layout.Block block2 : blocksNoCatchalls) {
                if (!block2.accept(anImport)) continue;
                accepted = true;
                break;
            }
            if (!accepted) {
                for (Layout.Block block2 : blocksOnlyCatchalls) {
                    if (!block2.accept(anImport)) continue;
                    accepted = true;
                    break;
                }
            }
            assert (accepted) : "Every import must be accepted by at least one block, but this import was not: " + anImport.printTrimmed();
        }
        int importIndex = 0;
        String extraLineSpace = "";
        for (Layout.Block block3 : layout.getBlocks()) {
            if (block3 instanceof Layout.Block.BlankLines) {
                extraLineSpace = "";
                for (int i = 0; i < ((Layout.Block.BlankLines)block3).getCount(); ++i) {
                    extraLineSpace = extraLineSpace + "\n";
                }
                continue;
            }
            for (J.Import orderedImport : block3.orderedImports()) {
                String prefix;
                String string = prefix = importIndex == 0 ? originalImports.get(0).getPrefix() : extraLineSpace + "\n";
                if (!orderedImport.getPrefix().equals(prefix)) {
                    orderedImports.add((J.Import)orderedImport.withPrefix(prefix));
                } else {
                    orderedImports.add(orderedImport);
                }
                extraLineSpace = "";
                ++importIndex;
            }
        }
        return orderedImports;
    }

    public static ImportLayoutStyle getDefaultImportLayoutStyle() {
        return new ImportLayoutStyle();
    }

    @NonNull
    public static ImportLayoutStyle layout(int classCountToUseStarImport, int nameCountToUseStarImport, String ... blocks) {
        HashMap<String, Object> settings = new HashMap<String, Object>(3);
        settings.put("classCountToUseStarImport", classCountToUseStarImport);
        settings.put("nameCountToUseStarImport", nameCountToUseStarImport);
        settings.put("blocks", Arrays.asList(blocks));
        ImportLayoutStyle style = new ImportLayoutStyle();
        style.setLayout(settings);
        return style;
    }

    private static class Layout {
        private final List<Block> blocks;

        private Layout(List<Block> blocks) {
            this.blocks = blocks == null ? Collections.emptyList() : blocks;
        }

        private List<Block> getBlocks() {
            return this.blocks;
        }

        private static class Builder {
            private final List<Block> blocks = new ArrayList<Block>();
            private final int classCountToUseStarImport;
            private final int nameCountToUseStarImport;

            private Builder(int classCountToUseStarImport, int nameCountToUseStarImport) {
                this.classCountToUseStarImport = classCountToUseStarImport;
                this.nameCountToUseStarImport = nameCountToUseStarImport;
            }

            private Builder importAllOthers() {
                this.blocks.add(new Block.AllOthers(false, this.classCountToUseStarImport, this.nameCountToUseStarImport));
                return this;
            }

            private Builder importStaticAllOthers() {
                this.blocks.add(new Block.AllOthers(true, this.classCountToUseStarImport, this.nameCountToUseStarImport));
                return this;
            }

            private Builder blankLine() {
                if (!this.blocks.isEmpty() && this.blocks.get(this.blocks.size() - 1) instanceof Block.BlankLines) {
                    ((Block.BlankLines)this.blocks.get(this.blocks.size() - 1)).count++;
                } else {
                    this.blocks.add(new Block.BlankLines());
                }
                return this;
            }

            private Builder importPackage(String packageWildcard, boolean withSubpackages) {
                this.blocks.add(new Block.ImportPackage(false, packageWildcard, withSubpackages, this.classCountToUseStarImport, this.nameCountToUseStarImport));
                return this;
            }

            private Builder importPackage(String packageWildcard) {
                return this.importPackage(packageWildcard, true);
            }

            private Builder staticImportPackage(String packageWildcard, boolean withSubpackages) {
                this.blocks.add(new Block.ImportPackage(true, packageWildcard, withSubpackages, this.classCountToUseStarImport, this.nameCountToUseStarImport));
                return this;
            }

            private Builder staticImportPackage(String packageWildcard) {
                return this.staticImportPackage(packageWildcard, true);
            }

            private Layout build() {
                for (Block block : this.blocks) {
                    if (!(block instanceof Block.AllOthers)) continue;
                    ((Block.AllOthers)block).setPackageImports(this.blocks.stream().filter(b -> b.getClass().equals(Block.ImportPackage.class)).map(Block.ImportPackage.class::cast).collect(Collectors.toList()));
                }
                return new Layout(this.blocks);
            }
        }

        private static interface Block {
            public boolean accept(J.Import var1);

            public List<J.Import> orderedImports();

            public static class AllOthers
            extends ImportPackage {
                private final boolean statik;
                private Collection<ImportPackage> packageImports = Collections.emptyList();

                public AllOthers(boolean statik, int classCountToUseStarImport, int nameCountToUseStarImport) {
                    super(statik, "*", true, classCountToUseStarImport, nameCountToUseStarImport);
                    this.statik = statik;
                }

                public void setPackageImports(Collection<ImportPackage> packageImports) {
                    this.packageImports = packageImports;
                }

                public boolean isStatic() {
                    return this.statik;
                }

                @Override
                public boolean accept(J.Import anImport) {
                    if (this.packageImports.stream().noneMatch(pi -> pi.accept(anImport))) {
                        super.accept(anImport);
                    }
                    return anImport.isStatic() == this.statik;
                }
            }

            public static class ImportPackage
            implements Block {
                static final Comparator<J.Import> IMPORT_SORTING = (i1, i2) -> {
                    String[] import1 = i1.getQualid().printTrimmed().split("\\.");
                    String[] import2 = i2.getQualid().printTrimmed().split("\\.");
                    for (int i = 0; i < Math.min(import1.length, import2.length); ++i) {
                        int diff = import1[i].compareTo(import2[i]);
                        if (diff == 0) continue;
                        return diff;
                    }
                    if (import1.length == import2.length) {
                        return 0;
                    }
                    return import1.length > import2.length ? 1 : -1;
                };
                private final List<J.Import> imports = new ArrayList<J.Import>();
                private final boolean statik;
                private final Pattern packageWildcard;
                private final int classCountToUseStarImport;
                private final int nameCountToUseStarImport;

                public ImportPackage(boolean statik, String packageWildcard, boolean withSubpackages, int classCountToUseStarImport, int nameCountToUseStarImport) {
                    this.statik = statik;
                    this.classCountToUseStarImport = classCountToUseStarImport;
                    this.nameCountToUseStarImport = nameCountToUseStarImport;
                    this.packageWildcard = Pattern.compile(packageWildcard.replace(".", "\\.").replace("*", withSubpackages ? ".+" : "[^.]+"));
                }

                @Override
                public boolean accept(J.Import anImport) {
                    if (anImport.isStatic() == this.statik && this.packageWildcard.matcher(anImport.getQualid().printTrimmed()).matches()) {
                        this.imports.add(anImport);
                        return true;
                    }
                    return false;
                }

                @Override
                public List<J.Import> orderedImports() {
                    Map groupedImports = this.imports.stream().sorted(IMPORT_SORTING).collect(Collectors.groupingBy(anImport -> {
                        if (anImport.isStatic()) {
                            return anImport.getTypeName();
                        }
                        return anImport.getPackageName();
                    }, LinkedHashMap::new, Collectors.toList()));
                    return groupedImports.values().stream().flatMap(importGroup -> {
                        J.Import toStar = (J.Import)importGroup.get(0);
                        boolean statik1 = toStar.isStatic();
                        int threshold = statik1 ? this.nameCountToUseStarImport : this.classCountToUseStarImport;
                        boolean starImportExists = importGroup.stream().anyMatch(it -> it.getQualid().getSimpleName().equals("*"));
                        if (importGroup.size() >= threshold || starImportExists && importGroup.size() > 1) {
                            return Stream.of(toStar.withQualid(toStar.getQualid().withName(toStar.getQualid().getName().withName("*"))));
                        }
                        return importGroup.stream().filter(StreamUtils.distinctBy(Tree::printTrimmed));
                    }).collect(Collectors.toList());
                }
            }

            public static class BlankLines
            implements Block {
                private int count = 1;

                private int getCount() {
                    return this.count;
                }

                @Override
                public boolean accept(J.Import anImport) {
                    return false;
                }

                @Override
                public List<J.Import> orderedImports() {
                    return Collections.emptyList();
                }
            }
        }
    }
}

