/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.openrewrite.Incubating;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.JavaType;

@Incubating(since="6.1.0")
public class MethodTypeBuilder {
    JavaType.FullyQualified declaringType = null;
    Set<Flag> flags = new HashSet<Flag>();
    JavaType resolvedReturnType;
    JavaType genericReturnType;
    String name;
    List<Parameter> parameters = new ArrayList<Parameter>();

    public static MethodTypeBuilder newMethodType() {
        return new MethodTypeBuilder();
    }

    public MethodTypeBuilder declaringClass(String fullyQualifiedClassName) {
        this.declaringType = JavaType.Class.build(fullyQualifiedClassName);
        return this;
    }

    public MethodTypeBuilder flags(Flag ... flags) {
        this.flags.addAll(Arrays.asList(flags));
        return this;
    }

    public MethodTypeBuilder name(String name) {
        this.name = name;
        return this;
    }

    public MethodTypeBuilder returnType(String type) {
        this.resolvedReturnType = JavaType.buildType(type);
        return this;
    }

    public MethodTypeBuilder returnType(String resolvedType, String genericType) {
        this.resolvedReturnType = JavaType.buildType(resolvedType);
        this.genericReturnType = new JavaType.GenericTypeVariable(genericType, JavaType.Class.build("java.lang.Object"));
        return this;
    }

    public MethodTypeBuilder returnType(JavaType type) {
        this.resolvedReturnType = type;
        return this;
    }

    public MethodTypeBuilder returnType(JavaType resolvedType, JavaType genericType) {
        this.resolvedReturnType = resolvedType;
        this.genericReturnType = genericType;
        return this;
    }

    public MethodTypeBuilder parameter(String type, String name) {
        this.parameters.add(new Parameter(JavaType.buildType(type), JavaType.buildType(type), name));
        return this;
    }

    public MethodTypeBuilder parameter(String resolvedType, String genericType, String name) {
        this.parameters.add(new Parameter(JavaType.buildType(resolvedType), new JavaType.GenericTypeVariable(genericType, JavaType.Class.build("java.lang.Object")), name));
        return this;
    }

    public MethodTypeBuilder parameter(JavaType type, String name) {
        this.parameters.add(new Parameter(type, type, name));
        return this;
    }

    public MethodTypeBuilder parameter(JavaType resolvedType, JavaType genericType, String name) {
        this.parameters.add(new Parameter(resolvedType, genericType, name));
        return this;
    }

    public JavaType.Method build() {
        if (StringUtils.isBlank((String)this.name)) {
            throw new IllegalArgumentException("The method name is required.");
        }
        if (this.declaringType == null) {
            throw new IllegalArgumentException("The declaring type is required.");
        }
        if (this.resolvedReturnType == null) {
            this.resolvedReturnType = JavaType.Primitive.Void;
        }
        if (this.genericReturnType == null) {
            this.genericReturnType = JavaType.Primitive.Void;
        }
        JavaType.Method.Signature resolvedSignature = new JavaType.Method.Signature(this.resolvedReturnType, this.parameters.stream().map(Parameter::getResolvedType).collect(Collectors.toList()));
        JavaType.Method.Signature genericSignature = new JavaType.Method.Signature(this.genericReturnType, this.parameters.stream().map(Parameter::getGenericType).collect(Collectors.toList()));
        return JavaType.Method.build(this.declaringType, this.name, genericSignature, resolvedSignature, this.parameters.stream().map(Parameter::getName).collect(Collectors.toList()), this.flags);
    }

    private static class Parameter {
        JavaType resolvedType;
        JavaType genericType;
        String name;

        public JavaType getResolvedType() {
            return this.resolvedType;
        }

        public JavaType getGenericType() {
            return this.genericType;
        }

        public String getName() {
            return this.name;
        }

        @ConstructorProperties(value={"resolvedType", "genericType", "name"})
        public Parameter(JavaType resolvedType, JavaType genericType, String name) {
            this.resolvedType = resolvedType;
            this.genericType = genericType;
            this.name = name;
        }
    }
}

