/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.AbstractJavaSourceVisitor;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class FindInheritedFields
extends AbstractJavaSourceVisitor<List<JavaType.Var>> {
    private final String fullyQualifiedClassName;

    public FindInheritedFields(String fullyQualifiedClassName) {
        this.fullyQualifiedClassName = fullyQualifiedClassName;
    }

    public Iterable<Tag> getTags() {
        return Tags.of((String)"type", (String)this.fullyQualifiedClassName);
    }

    public List<JavaType.Var> defaultTo(Tree t) {
        return Collections.emptyList();
    }

    private List<JavaType.Var> superFields(@Nullable JavaType.Class type) {
        if (type == null || type.getSupertype() == null) {
            return Collections.emptyList();
        }
        ArrayList<JavaType.Var> types = new ArrayList<JavaType.Var>();
        type.getMembers().stream().filter(m -> !m.hasFlags(Flag.Private) && TypeUtils.hasElementType(m.getType(), this.fullyQualifiedClassName)).forEach(types::add);
        types.addAll(this.superFields(type.getSupertype()));
        return types;
    }

    @Override
    public List<JavaType.Var> visitClassDecl(J.ClassDecl classDecl) {
        JavaType.Class asClass = TypeUtils.asClass(classDecl.getType());
        return this.superFields(asClass == null ? null : asClass.getSupertype());
    }
}

