/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import org.openrewrite.RefactorVisitor;
import org.openrewrite.java.AddImport;
import org.openrewrite.java.JavaIsoRefactorVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

public class UseStaticImport
extends JavaIsoRefactorVisitor {
    private MethodMatcher methodMatcher;

    public void setMethod(String method) {
        this.methodMatcher = new MethodMatcher(method);
    }

    @Override
    public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method) {
        if (this.methodMatcher.matches(method) && method.getSelect() != null) {
            this.andThen((RefactorVisitor)new Scoped(method));
        }
        return super.visitMethodInvocation(method);
    }

    public static class Scoped
    extends JavaIsoRefactorVisitor {
        private final J.MethodInvocation scope;

        public Scoped(J.MethodInvocation scope) {
            this.scope = scope;
        }

        @Override
        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method) {
            if (this.scope.isScope(method) && method.getSelect() != null) {
                if (method.getType() != null) {
                    JavaType.FullyQualified receiverType = method.getType().getDeclaringType();
                    this.maybeRemoveImport(receiverType);
                    AddImport addStatic = new AddImport();
                    addStatic.setType(receiverType.getFullyQualifiedName());
                    addStatic.setStaticMethod(method.getSimpleName());
                    addStatic.setOnlyIfReferenced(false);
                    if (!this.andThen().contains(addStatic)) {
                        this.andThen((RefactorVisitor)addStatic);
                    }
                }
                return method.withSelect(null).withName(method.getName().withFormatting(method.getSelect().getFormatting()));
            }
            return super.visitMethodInvocation(method);
        }
    }
}

