/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.Validated;
import org.openrewrite.java.JavaIsoRefactorVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.TreeBuilder;

public class ChangeMethodName
extends JavaIsoRefactorVisitor {
    private MethodMatcher methodMatcher;
    private String name;

    public ChangeMethodName() {
        this.setCursoringOn();
    }

    public void setMethod(String method) {
        this.methodMatcher = new MethodMatcher(method);
    }

    public void setName(String name) {
        this.name = name;
    }

    public Validated validate() {
        return Validated.required((String)"method", (Object)this.methodMatcher).and(Validated.required((String)"name", (Object)this.name));
    }

    @Override
    public J.MethodDecl visitMethod(J.MethodDecl method) {
        J.MethodDecl m = super.visitMethod(method);
        J.ClassDecl classDecl = (J.ClassDecl)this.getCursor().firstEnclosing(J.ClassDecl.class);
        assert (classDecl != null);
        if (this.methodMatcher.matches(method, classDecl)) {
            m = m.withName(m.getName().withName(this.name));
        }
        return m;
    }

    @Override
    public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method) {
        if (this.methodMatcher.matches(method)) {
            this.andThen((RefactorVisitor)new Scoped(method, this.name));
        }
        return super.visitMethodInvocation(method);
    }

    @Override
    public J.FieldAccess visitFieldAccess(J.FieldAccess fieldAccess) {
        Expression target;
        J.FieldAccess f = super.visitFieldAccess(fieldAccess);
        if (f.isFullyQualifiedClassReference(this.methodMatcher) && (target = f.getTarget()) instanceof J.FieldAccess) {
            String className = target.printTrimmed();
            String fullyQualified = className + "." + this.name;
            return (J.FieldAccess)TreeBuilder.buildName(fullyQualified, f.getFormatting(), f.getId());
        }
        return f;
    }

    public static class Scoped
    extends JavaIsoRefactorVisitor {
        private final J.MethodInvocation scope;
        private final String name;

        public Scoped(J.MethodInvocation scope, String name) {
            this.scope = scope;
            this.name = name;
        }

        public Iterable<Tag> getTags() {
            return Tags.of((String)"name", (String)this.name);
        }

        @Override
        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method) {
            return this.scope.isScope(method) && !method.getSimpleName().equals(this.name) ? method.withName(method.getName().withName(this.name)) : super.visitMethodInvocation(method);
        }
    }
}

