/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.Tree;
import org.openrewrite.Validated;
import org.openrewrite.internal.StreamUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoRefactorVisitor;
import org.openrewrite.java.RemoveUnusedImports;
import org.openrewrite.java.style.ImportLayoutStyle;
import org.openrewrite.java.tree.J;

public class OrderImports
extends JavaIsoRefactorVisitor {
    static final Comparator<J.Import> IMPORT_SORTING = (i1, i2) -> {
        String[] import1 = i1.getQualid().printTrimmed().split("\\.");
        String[] import2 = i2.getQualid().printTrimmed().split("\\.");
        for (int i = 0; i < Math.min(import1.length, import2.length); ++i) {
            int diff = import1[i].compareTo(import2[i]);
            if (diff == 0) continue;
            return diff;
        }
        if (import1.length == import2.length) {
            return 0;
        }
        return import1.length > import2.length ? 1 : -1;
    };
    @Nullable
    Layout importLayout;
    private boolean removeUnused = true;

    @JsonIgnore
    public void setLayout(Layout importLayout) {
        this.importLayout = importLayout;
    }

    public void setRemoveUnused(boolean removeUnused) {
        this.removeUnused = removeUnused;
    }

    public static Layout intellij() {
        return Layout.builder(5, 3).importAllOthers().blankLine().importPackage("javax.*").importPackage("java.*").blankLine().importStaticAllOthers().build();
    }

    public Validated validate() {
        return this.importLayout == null ? Validated.none() : this.importLayout.validate();
    }

    @Override
    public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu) {
        ArrayList<J.Import> orderedImports = new ArrayList<J.Import>();
        if (this.importLayout == null) {
            this.importLayout = Optional.ofNullable((ImportLayoutStyle)cu.getStyle(ImportLayoutStyle.class)).map(ImportLayoutStyle::orderImportLayout).orElse(OrderImports.intellij());
        }
        List blocks = this.importLayout.blocks;
        blocks.forEach(Layout.Block::reset);
        assert (blocks.stream().anyMatch(it -> it instanceof Layout.Block.AllOthers && ((Layout.Block.AllOthers)it).statik)) : "There must be at least one block that accepts all static imports, but no such block was found in the specified layout";
        assert (blocks.stream().anyMatch(it -> it instanceof Layout.Block.AllOthers && !((Layout.Block.AllOthers)it).statik)) : "There must be at least one block that accepts all non-static imports, but no such block was found in the specified layout";
        Map<Boolean, List<Layout.Block>> blockGroups = blocks.stream().collect(Collectors.partitioningBy(block -> block instanceof Layout.Block.AllOthers));
        List<Layout.Block> blocksNoCatchalls = blockGroups.get(false);
        List<Layout.Block> blocksOnlyCatchalls = blockGroups.get(true);
        for (J.Import anImport : cu.getImports()) {
            boolean accepted = false;
            for (Layout.Block block2 : blocksNoCatchalls) {
                if (!block2.accept(anImport)) continue;
                accepted = true;
                break;
            }
            if (!accepted) {
                for (Layout.Block block2 : blocksOnlyCatchalls) {
                    if (!block2.accept(anImport)) continue;
                    accepted = true;
                    break;
                }
            }
            assert (accepted) : "Every import must be accepted by at least one block, but this import was not: " + anImport.printTrimmed();
        }
        int importIndex = 0;
        String extraLineSpace = "";
        for (Layout.Block block3 : blocks) {
            if (block3 instanceof Layout.Block.BlankLines) {
                extraLineSpace = "";
                for (int i = 0; i < ((Layout.Block.BlankLines)block3).count; ++i) {
                    extraLineSpace = extraLineSpace + "\n";
                }
                continue;
            }
            for (J.Import orderedImport : block3.orderedImports()) {
                String prefix;
                String string = prefix = importIndex == 0 ? cu.getImports().get(0).getPrefix() : extraLineSpace + "\n";
                if (!orderedImport.getPrefix().equals(prefix)) {
                    orderedImports.add((J.Import)orderedImport.withPrefix(prefix));
                } else {
                    orderedImports.add(orderedImport);
                }
                extraLineSpace = "";
                ++importIndex;
            }
        }
        if (this.removeUnused) {
            this.andThen((RefactorVisitor)new RemoveUnusedImports(this.importLayout.classCountToUseStarImport, this.importLayout.nameCountToUseStarImport));
        }
        if (orderedImports.size() != cu.getImports().size()) {
            return cu.withImports(orderedImports);
        }
        for (int i = 0; i < orderedImports.size(); ++i) {
            if (orderedImports.get(i) == cu.getImports().get(i)) continue;
            return cu.withImports(orderedImports);
        }
        return cu;
    }

    public static class Layout {
        private final List<Block> blocks;
        private final int classCountToUseStarImport;
        private final int nameCountToUseStarImport;

        Layout(List<Block> blocks, int classCountToUseStarImport, int nameCountToUseStarImport) {
            this.blocks = blocks;
            this.classCountToUseStarImport = classCountToUseStarImport;
            this.nameCountToUseStarImport = nameCountToUseStarImport;
        }

        public List<Block> getBlocks() {
            return this.blocks;
        }

        public int getClassCountToUseStarImport() {
            return this.classCountToUseStarImport;
        }

        public int getNameCountToUseStarImport() {
            return this.nameCountToUseStarImport;
        }

        public Validated validate() {
            return Validated.valid((String)"layout", (Object)(this.blocks.stream().filter(b -> b instanceof Block.AllOthers && !((Block.AllOthers)b).isStatic()).count() == 1L ? 1 : 0));
        }

        public static Builder builder(int classCountToUseStarImport, int nameCountToUseStarImport) {
            return new Builder(classCountToUseStarImport, nameCountToUseStarImport);
        }

        public static class Builder {
            private final List<Block> blocks = new ArrayList<Block>();
            private final int classCountToUseStarImport;
            private final int nameCountToUseStarImport;

            public Builder(int classCountToUseStarImport, int nameCountToUseStarImport) {
                this.classCountToUseStarImport = classCountToUseStarImport;
                this.nameCountToUseStarImport = nameCountToUseStarImport;
            }

            public Builder importAllOthers() {
                this.blocks.add(new Block.AllOthers(false, this.classCountToUseStarImport, this.nameCountToUseStarImport));
                return this;
            }

            public Builder importStaticAllOthers() {
                this.blocks.add(new Block.AllOthers(true, this.classCountToUseStarImport, this.nameCountToUseStarImport));
                return this;
            }

            public Builder blankLine() {
                if (!this.blocks.isEmpty() && this.blocks.get(this.blocks.size() - 1) instanceof Block.BlankLines) {
                    ((Block.BlankLines)this.blocks.get(this.blocks.size() - 1)).count++;
                } else {
                    this.blocks.add(new Block.BlankLines());
                }
                return this;
            }

            public Builder importPackage(String packageWildcard, boolean withSubpackages) {
                this.blocks.add(new Block.ImportPackage(false, packageWildcard, withSubpackages, this.classCountToUseStarImport, this.nameCountToUseStarImport));
                return this;
            }

            public Builder importPackage(String packageWildcard) {
                return this.importPackage(packageWildcard, true);
            }

            public Builder staticImportPackage(String packageWildcard, boolean withSubpackages) {
                this.blocks.add(new Block.ImportPackage(true, packageWildcard, withSubpackages, this.classCountToUseStarImport, this.nameCountToUseStarImport));
                return this;
            }

            public Builder staticImportPackage(String packageWildcard) {
                return this.staticImportPackage(packageWildcard, true);
            }

            public Layout build() {
                for (Block block : this.blocks) {
                    if (!(block instanceof Block.AllOthers)) continue;
                    ((Block.AllOthers)block).setPackageImports(this.blocks.stream().filter(b -> b.getClass().equals(Block.ImportPackage.class)).map(Block.ImportPackage.class::cast).collect(Collectors.toList()));
                }
                return new Layout(this.blocks, this.classCountToUseStarImport, this.nameCountToUseStarImport);
            }
        }

        public static interface Block {
            public boolean accept(J.Import var1);

            public void reset();

            public List<J.Import> orderedImports();

            public static class AllOthers
            extends ImportPackage {
                private final boolean statik;
                private Collection<ImportPackage> packageImports = Collections.emptyList();

                public AllOthers(boolean statik, int classCountToUseStarImport, int nameCountToUseStarImport) {
                    super(statik, "*", true, classCountToUseStarImport, nameCountToUseStarImport);
                    this.statik = statik;
                }

                public void setPackageImports(Collection<ImportPackage> packageImports) {
                    this.packageImports = packageImports;
                }

                public boolean isStatic() {
                    return this.statik;
                }

                @Override
                public boolean accept(J.Import anImport) {
                    if (this.packageImports.stream().noneMatch(pi -> pi.accept(anImport))) {
                        super.accept(anImport);
                    }
                    return anImport.isStatic() == this.statik;
                }
            }

            public static class ImportPackage
            implements Block {
                private final List<J.Import> imports = new ArrayList<J.Import>();
                private final boolean statik;
                private final Pattern packageWildcard;
                private final int classCountToUseStarImport;
                private final int nameCountToUseStarImport;

                public ImportPackage(boolean statik, String packageWildcard, boolean withSubpackages, int classCountToUseStarImport, int nameCountToUseStarImport) {
                    this.statik = statik;
                    this.classCountToUseStarImport = classCountToUseStarImport;
                    this.nameCountToUseStarImport = nameCountToUseStarImport;
                    this.packageWildcard = Pattern.compile(packageWildcard.replace(".", "\\.").replace("*", withSubpackages ? ".+" : "[^.]+"));
                }

                @Override
                public boolean accept(J.Import anImport) {
                    if (anImport.isStatic() == this.statik && this.packageWildcard.matcher(anImport.getQualid().printTrimmed()).matches()) {
                        this.imports.add(anImport);
                        return true;
                    }
                    return false;
                }

                @Override
                public void reset() {
                    this.imports.clear();
                }

                @Override
                public List<J.Import> orderedImports() {
                    Map groupedImports = this.imports.stream().sorted(IMPORT_SORTING).collect(Collectors.groupingBy(anImport -> {
                        if (anImport.isStatic()) {
                            return anImport.getTypeName();
                        }
                        return anImport.getPackageName();
                    }, LinkedHashMap::new, Collectors.toList()));
                    return groupedImports.values().stream().flatMap(importGroup -> {
                        J.Import toStar = (J.Import)importGroup.get(0);
                        boolean statik1 = toStar.isStatic();
                        int threshold = statik1 ? this.nameCountToUseStarImport : this.classCountToUseStarImport;
                        boolean starImportExists = importGroup.stream().anyMatch(it -> it.getQualid().getSimpleName().equals("*"));
                        if (importGroup.size() >= threshold || starImportExists && importGroup.size() > 1) {
                            return Stream.of(toStar.withQualid(toStar.getQualid().withName(toStar.getQualid().getName().withName("*"))));
                        }
                        return importGroup.stream().filter(StreamUtils.distinctBy(Tree::printTrimmed));
                    }).collect(Collectors.toList());
                }
            }

            public static class BlankLines
            implements Block {
                private int count = 1;

                @Override
                public boolean accept(J.Import anImport) {
                    return false;
                }

                @Override
                public void reset() {
                }

                @Override
                public List<J.Import> orderedImports() {
                    return Collections.emptyList();
                }
            }
        }
    }
}

