/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.openrewrite.Formatting;
import org.openrewrite.Incubating;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.Tree;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.java.JavaIsoRefactorVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.refactor.Formatter;

@Incubating(since="2.1.0")
public class AutoFormat
extends JavaIsoRefactorVisitor {
    private final J[] scope;

    public AutoFormat(J ... scope) {
        this.scope = scope;
    }

    @Override
    public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu) {
        this.andThen((RefactorVisitor)new FixNewlines());
        this.andThen((RefactorVisitor)new FixIndentation());
        return super.visitCompilationUnit(cu);
    }

    public boolean isIdempotent() {
        return false;
    }

    private class FixIndentation
    extends JavaIsoRefactorVisitor {
        FixIndentation() {
            this.setCursoringOn();
        }

        public J reduce(J r1, J r2) {
            J j = (J)super.reduce((Object)r1, (Object)r2);
            if (r2 != null && r2.getPrefix().startsWith("|")) {
                j = (J)j.withPrefix(r2.getPrefix().substring(1));
            }
            return j;
        }

        public J visitTree(Tree tree) {
            J j = (J)super.visitTree(tree);
            String prefix = tree.getPrefix();
            if (prefix.contains("\n") && Arrays.stream(AutoFormat.this.scope).anyMatch(s -> this.getCursor().isScopeInPath((Tree)s))) {
                int indentMultiple = (int)this.getCursor().getPathAsStream().filter(J.Block.class::isInstance).count();
                if (tree instanceof J.Block.End) {
                    --indentMultiple;
                }
                Formatter.Result wholeSourceIndent = this.formatter.wholeSourceIndent();
                String shiftedPrefix = "|" + prefix.substring(0, prefix.lastIndexOf(10) + 1) + IntStream.range(0, indentMultiple * wholeSourceIndent.getIndentToUse()).mapToObj(n -> wholeSourceIndent.isIndentedWithSpaces() ? " " : "\t").collect(Collectors.joining(""));
                if (!shiftedPrefix.equals(prefix)) {
                    j = (J)j.withPrefix(shiftedPrefix);
                }
            }
            return j;
        }
    }

    private class FixNewlines
    extends JavaIsoRefactorVisitor {
        FixNewlines() {
            this.setCursoringOn();
        }

        public String indentLine(String prefix) {
            if (!prefix.isEmpty() && Arrays.stream(AutoFormat.this.scope).anyMatch(s -> this.getCursor().isScopeInPath((Tree)s))) {
                int indentMultiple = (int)this.getCursor().getPathAsStream().filter(J.Block.class::isInstance).count();
                Formatter.Result wholeSourceIndent = this.formatter.wholeSourceIndent();
                int nonWhiteSpaceIndex = StringUtils.indexOfNonWhitespace((String)prefix);
                boolean insideJavaDocComment = false;
                if (nonWhiteSpaceIndex == -1) {
                    nonWhiteSpaceIndex = prefix.length();
                } else if (prefix.charAt(nonWhiteSpaceIndex) == '*') {
                    insideJavaDocComment = true;
                }
                String indentation = prefix.substring(0, nonWhiteSpaceIndex);
                String comment = prefix.substring(nonWhiteSpaceIndex);
                String newIndentation = indentation.substring(0, indentation.lastIndexOf(10) + 1) + IntStream.range(0, indentMultiple * wholeSourceIndent.getIndentToUse()).mapToObj(n -> wholeSourceIndent.isIndentedWithSpaces() ? " " : "\t").collect(Collectors.joining(""));
                if (insideJavaDocComment) {
                    newIndentation = newIndentation + " ";
                }
                return newIndentation + comment;
            }
            return prefix;
        }

        private <T extends J> T spaceHorizontally(T j) {
            if (Arrays.stream(AutoFormat.this.scope).anyMatch(s -> this.getCursor().isScopeInPath((Tree)s))) {
                Formatting originalFormatting = j.getFormatting();
                String newPrefix = Arrays.stream(originalFormatting.getPrefix().split("\\n")).map(this::indentLine).collect(Collectors.joining("\n"));
                if (originalFormatting.getPrefix().endsWith("\n")) {
                    newPrefix = newPrefix + '\n';
                }
                j = (J)j.withFormatting(originalFormatting.withPrefix(newPrefix));
            }
            return j;
        }

        private <T extends J> T spaceVertically(T j) {
            Formatting originalFormatting = j.getFormatting();
            List splitPrefix = StringUtils.splitCStyleComments((String)originalFormatting.getPrefix());
            String newPrefix = Stream.concat(Stream.of((String)splitPrefix.get(0)).map(it -> StringUtils.ensureNewlineCountBeforeComment((String)it, (int)2)), splitPrefix.stream().skip(1L).map(it -> StringUtils.ensureNewlineCountBeforeComment((String)it, (int)1))).collect(Collectors.joining());
            return (T)((J)j.withFormatting(originalFormatting.withPrefix(newPrefix)));
        }

        @Override
        public J.MethodDecl visitMethod(J.MethodDecl methodDecl) {
            J.MethodDecl m = super.visitMethod(methodDecl);
            if (Arrays.stream(AutoFormat.this.scope).anyMatch(s -> this.getCursor().isScopeInPath((Tree)s))) {
                m = this.spaceHorizontally(m);
                ArrayList<J.Annotation> annotations = new ArrayList<J.Annotation>((m = this.spaceVertically(m)).getAnnotations());
                if (!annotations.isEmpty()) {
                    for (int i = 1; i < annotations.size(); ++i) {
                        if (((J.Annotation)annotations.get(i)).getPrefix().contains("\n")) continue;
                        annotations.set(i, (J.Annotation)((J.Annotation)annotations.get(i)).withPrefix("\n"));
                    }
                    ArrayList<J.Modifier> modifiers = new ArrayList<J.Modifier>((m = m.withAnnotations(annotations)).getModifiers());
                    if (!modifiers.isEmpty()) {
                        if (!((J.Modifier)modifiers.get(0)).getPrefix().contains("\n")) {
                            modifiers.set(0, (J.Modifier)((J.Modifier)modifiers.get(0)).withPrefix("\n"));
                            m = m.withModifiers(modifiers);
                        }
                    } else if (m.getReturnTypeExpr() != null && !m.getReturnTypeExpr().getPrefix().contains("\n")) {
                        m = m.withReturnTypeExpr((TypeTree)m.getReturnTypeExpr().withPrefix("\n"));
                    } else if (!m.getName().getPrefix().contains("\n")) {
                        m = m.withName((J.Ident)m.getName().withPrefix("\n"));
                    }
                }
            }
            return m;
        }

        @Override
        public J.ClassDecl visitClassDecl(J.ClassDecl classDecl) {
            J.ClassDecl cd = super.visitClassDecl(classDecl);
            if (Arrays.stream(AutoFormat.this.scope).anyMatch(s -> this.getCursor().isScopeInPath((Tree)s))) {
                cd = this.spaceHorizontally(cd);
                ArrayList<J.Annotation> annotations = new ArrayList<J.Annotation>((cd = this.spaceVertically(cd)).getAnnotations());
                if (!annotations.isEmpty()) {
                    if (((J.Annotation)annotations.get(0)).getFormatting().getPrefix().contains("\n")) {
                        annotations.set(0, (J.Annotation)((J.Annotation)annotations.get(0)).withPrefix(""));
                    }
                    for (int i = 1; i < annotations.size(); ++i) {
                        if (((J.Annotation)annotations.get(i)).getPrefix().contains("\n")) continue;
                        annotations.set(i, (J.Annotation)((J.Annotation)annotations.get(i)).withPrefix("\n"));
                    }
                    ArrayList<J.Modifier> modifiers = new ArrayList<J.Modifier>((cd = cd.withAnnotations(annotations)).getModifiers());
                    if (!modifiers.isEmpty()) {
                        if (!((J.Modifier)modifiers.get(0)).getPrefix().contains("\n")) {
                            modifiers.set(0, (J.Modifier)((J.Modifier)modifiers.get(0)).withPrefix("\n"));
                            cd = cd.withModifiers(modifiers);
                        }
                    } else if (!cd.getKind().getPrefix().contains("\n")) {
                        cd = cd.withKind((J.ClassDecl.Kind)cd.getKind().withPrefix("\n"));
                    }
                }
            }
            return cd;
        }
    }
}

