/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.java.AutoFormat;
import org.openrewrite.java.JavaIsoRefactorVisitor;
import org.openrewrite.java.style.DeclarationOrderStyle;
import org.openrewrite.java.tree.J;

public class InsertDeclaration {

    public static class Scoped
    extends JavaIsoRefactorVisitor {
        private final J.ClassDecl enclosing;
        private final J declaration;
        private DeclarationOrderStyle.Layout layout;

        public Scoped(J.ClassDecl enclosing, J declaration) {
            this.enclosing = enclosing;
            this.declaration = declaration;
        }

        @Override
        public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu) {
            this.layout = cu.getStyle(DeclarationOrderStyle.class).map(DeclarationOrderStyle::getLayout).orElse(DeclarationOrderStyle.Layout.DEFAULT);
            return super.visitCompilationUnit(cu);
        }

        @Override
        public J.ClassDecl visitClassDecl(J.ClassDecl classDecl) {
            J.ClassDecl c = super.visitClassDecl(classDecl);
            if (c.isScope(this.enclosing)) {
                if (c.getBody().getStatements().stream().anyMatch(s -> s.isScope(this.declaration))) {
                    return c;
                }
                ArrayList<J> declarations = new ArrayList<J>(c.getBody().getStatements());
                declarations.add(this.declaration);
                this.layout.reset();
                declarations.forEach(this.layout::accept);
                HashSet<J> before = new HashSet<J>();
                J formattedDeclaration = this.declaration;
                List<J> orderedDeclarations = this.layout.orderedDeclarations();
                for (J orderedDeclaration : orderedDeclarations) {
                    if (orderedDeclaration.isScope(this.declaration)) {
                        formattedDeclaration = orderedDeclaration;
                        break;
                    }
                    before.add(orderedDeclaration);
                }
                ArrayList<J> declarationsWithInsert = new ArrayList<J>();
                if (before.isEmpty()) {
                    declarationsWithInsert.add(formattedDeclaration);
                }
                for (J statement : c.getBody().getStatements()) {
                    int size = before.size();
                    before.remove(statement);
                    declarationsWithInsert.add(statement);
                    if (size != 1) continue;
                    declarationsWithInsert.add(formattedDeclaration);
                }
                c = c.withBody(c.getBody().withStatements(declarationsWithInsert));
                this.andThen((RefactorVisitor)new AutoFormat(formattedDeclaration));
            }
            return c;
        }
    }
}

