/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.openrewrite.Formatting;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaRefactorVisitor;
import org.openrewrite.java.search.FindReferencedTypes;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Statement;

public class DeleteStatement {

    public static class Scoped
    extends JavaRefactorVisitor {
        private final Statement statement;

        public Scoped(Statement statement) {
            this.statement = statement;
        }

        @Override
        public J visitIf(J.If iff) {
            J.If i = (J.If)this.refactor(iff, x$0 -> super.visitIf((J.If)x$0));
            if (this.statement.isScope(i.getThenPart())) {
                i = i.withThenPart(this.emptyBlock());
            } else if (i.getElsePart() != null && this.statement.isScope(i.getElsePart())) {
                i = i.withElsePart(i.getElsePart().withStatement(this.emptyBlock()));
            }
            return i;
        }

        @Override
        public J visitForLoop(J.ForLoop forLoop) {
            return this.statement.isScope(forLoop.getBody()) ? forLoop.withBody(this.emptyBlock()) : super.visitForLoop(forLoop);
        }

        @Override
        public J visitForEachLoop(J.ForEachLoop forEachLoop) {
            return this.statement.isScope(forEachLoop.getBody()) ? forEachLoop.withBody(this.emptyBlock()) : super.visitForEachLoop(forEachLoop);
        }

        @Override
        public J visitWhileLoop(J.WhileLoop whileLoop) {
            return this.statement.isScope(whileLoop.getBody()) ? whileLoop.withBody(this.emptyBlock()) : super.visitWhileLoop(whileLoop);
        }

        @Override
        public J visitDoWhileLoop(J.DoWhileLoop doWhileLoop) {
            return this.statement.isScope(doWhileLoop.getBody()) ? doWhileLoop.withBody(this.emptyBlock()) : super.visitDoWhileLoop(doWhileLoop);
        }

        @Override
        public J visitBlock(J.Block<J> block) {
            J.Block b = (J.Block)this.refactor(block, x$0 -> super.visitBlock((J.Block)x$0));
            if (block.getStatements().stream().anyMatch(arg_0 -> ((Statement)this.statement).isScope(arg_0))) {
                b = b.withStatements(b.getStatements().stream().filter(s -> !this.statement.isScope((Tree)s)).collect(Collectors.toList()));
            }
            return b;
        }

        public J visitTree(Tree tree) {
            if (this.statement.isScope(tree)) {
                ((Set)new FindReferencedTypes().visit(tree)).forEach(this::maybeRemoveImport);
            }
            return (J)super.visitTree(tree);
        }

        private J.Block<J> emptyBlock() {
            return new J.Block<J>(Tree.randomId(), null, Collections.emptyList(), Formatting.EMPTY, new J.Block.End(Tree.randomId(), Formatting.format((String)"")));
        }
    }
}

