/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.ArrayList;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.java.AutoFormat;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRefactorVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TreeBuilder;
import org.openrewrite.java.tree.TypeUtils;

public class GenerateGetter
extends JavaRefactorVisitor {
    private JavaType.Class type;
    private String field;

    public void setType(String enclosingClassType) {
        this.type = JavaType.Class.build(enclosingClassType);
    }

    public void setField(String field) {
        this.field = field;
    }

    public Validated validate() {
        return Validated.required((String)"type", (Object)this.type).and(Validated.required((String)"field", (Object)this.field));
    }

    @Override
    public J visitClassDecl(J.ClassDecl classDecl) {
        if (TypeUtils.isOfClassType(classDecl.getType(), this.type.getFullyQualifiedName())) {
            classDecl.getFields().stream().filter(field -> field.getVars().stream().anyMatch(var -> this.field.equals(var.getSimpleName()))).findAny().ifPresent(field -> this.andThen((RefactorVisitor)new Scoped(classDecl, (J.VariableDecls)field)));
        }
        return super.visitClassDecl(classDecl);
    }

    public static class Scoped
    extends JavaRefactorVisitor {
        private final J.ClassDecl clazz;
        private final J.VariableDecls field;

        public Scoped(J.ClassDecl clazz, J.VariableDecls field) {
            this.setCursoringOn();
            this.field = field;
            this.clazz = clazz;
        }

        @Override
        public J visitClassDecl(J.ClassDecl classDecl) {
            boolean isMissingTargetField;
            J.ClassDecl cd = (J.ClassDecl)this.refactor(classDecl, x$0 -> super.visitClassDecl((J.ClassDecl)x$0));
            if (!this.clazz.isScope(cd)) {
                return cd;
            }
            assert (this.field.getTypeExpr() != null);
            assert (this.clazz.getType() != null);
            String simpleFieldName = this.field.getVars().get(0).getSimpleName();
            MethodMatcher getterMatcher = new MethodMatcher(this.clazz.getType().getFullyQualifiedName() + " get" + StringUtils.capitalize((String)simpleFieldName) + "()");
            boolean getterAlreadyExists = classDecl.getMethods().stream().anyMatch(it -> getterMatcher.matches((J.MethodDecl)it, classDecl));
            if (getterAlreadyExists) {
                return cd;
            }
            boolean bl = isMissingTargetField = !cd.getFields().stream().filter(arg_0 -> ((J.VariableDecls)this.field).isScope(arg_0)).findAny().isPresent();
            if (isMissingTargetField) {
                return cd;
            }
            J.CompilationUnit cu = (J.CompilationUnit)this.getCursor().firstEnclosing(J.CompilationUnit.class);
            assert (cu != null);
            Object jp = ((JavaParser.Builder)JavaParser.fromJavaVersion().styles(cu.getStyles())).build();
            J.VariableDecls.NamedVar fieldVar = this.field.getVars().get(0);
            String fieldName = fieldVar.getSimpleName();
            assert (fieldVar.getType() != null);
            JavaType.FullyQualified type = TypeUtils.asFullyQualified(fieldVar.getType());
            J.MethodDecl getMethod = TreeBuilder.buildMethodDeclaration(jp, classDecl, "public " + this.field.getTypeExpr().print().trim() + " get" + StringUtils.capitalize((String)fieldName) + "() {\n    return " + fieldName + ";\n}\n", new JavaType[]{type});
            this.andThen((RefactorVisitor)new AutoFormat(getMethod));
            J.Block<J> body = cd.getBody();
            ArrayList<J> statements = new ArrayList<J>(body.getStatements());
            statements.add(getMethod);
            cd = cd.withBody(body.withStatements(statements));
            return cd;
        }
    }
}

