/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.style;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import org.openrewrite.java.JavaStyle;
import org.openrewrite.java.OrderImports;

public class ImportLayoutStyle
implements JavaStyle {
    private Map<String, Object> layout;

    public OrderImports orderImports() {
        OrderImports.Layout.Builder builder = OrderImports.Layout.builder((Integer)this.layout.getOrDefault("classCountToUseStarImport", 5), (Integer)this.layout.getOrDefault("nameCountToUseStarImport", 3));
        for (String block : (List)this.layout.get("blocks")) {
            if ((block = block.trim()).equals("<blank line>")) {
                builder = builder.blankLine();
                continue;
            }
            if (!block.startsWith("import ")) continue;
            block = block.substring("import ".length());
            boolean statik = false;
            if (block.startsWith("static")) {
                statik = true;
                block = block.substring("static ".length());
            }
            if (block.equals("all other imports")) {
                builder = statik ? builder.importStaticAllOthers() : builder.importAllOthers();
                continue;
            }
            builder = statik ? builder.staticImportPackage(block) : builder.importPackage(block);
        }
        OrderImports.Layout layout = builder.build();
        OrderImports orderImports = new OrderImports();
        orderImports.setLayout(layout);
        return orderImports;
    }

    public Map<String, Object> getLayout() {
        return this.layout;
    }

    @JsonProperty(value="layout")
    public void setLayout(Map<String, Object> layout) {
        this.layout = layout;
    }
}

