/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.stream.Collectors;
import org.openrewrite.Cursor;
import org.openrewrite.SourceVisitor;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Statement;

public abstract class JavaSourceVisitor<R>
extends SourceVisitor<R> {
    public J.CompilationUnit enclosingCompilationUnit() {
        J.CompilationUnit cu = (J.CompilationUnit)this.getCursor().firstEnclosing(J.CompilationUnit.class);
        if (cu == null) {
            throw new IllegalStateException("Expected to find a J.CompilationUnit in " + this);
        }
        return cu;
    }

    public J.Block<?> enclosingBlock() {
        return (J.Block)this.getCursor().firstEnclosing(J.Block.class);
    }

    @Nullable
    public J.MethodDecl enclosingMethod() {
        return (J.MethodDecl)this.getCursor().firstEnclosing(J.MethodDecl.class);
    }

    public J.ClassDecl enclosingClass() {
        return (J.ClassDecl)this.getCursor().firstEnclosing(J.ClassDecl.class);
    }

    public boolean isInSameNameScope(Cursor higher, Cursor lower) {
        return higher.getPathAsStream().filter(t -> t instanceof J.Block || t instanceof J.MethodDecl || t instanceof J.Try || t instanceof J.ForLoop || t instanceof J.ForEachLoop).findAny().map(higherNameScope -> lower.getPathAsStream().takeWhile(t -> !(t instanceof J.ClassDecl) || ((J.ClassDecl)t).getKind() instanceof J.ClassDecl.Kind.Class && !((J.ClassDecl)t).hasModifier("static")).anyMatch(higherNameScope::equals)).orElse(false);
    }

    public boolean isInSameNameScope(Cursor lower) {
        return this.isInSameNameScope(this.getCursor(), lower);
    }

    private R visitTypeNameAfter(R r, @Nullable NameTree name) {
        return (R)(name == null ? r : this.reduce(r, this.visitTypeName(name)));
    }

    private R visitTypeNamesAfter(R r, @Nullable Iterable<? extends NameTree> names) {
        if (names != null) {
            for (NameTree nameTree : names) {
                if (nameTree == null) continue;
                r = this.reduce(r, this.visitTypeName(nameTree));
            }
        }
        return (R)r;
    }

    public R visitExpression(Expression expr) {
        if (expr.getType() instanceof JavaType.FullyQualified) {
            JavaType.FullyQualified exprType = (JavaType.FullyQualified)expr.getType();
            if (expr instanceof J.FieldAccess ? ((J.FieldAccess)expr).getSimpleName().equals(exprType.getClassName()) : expr instanceof J.Ident && ((J.Ident)expr).getSimpleName().equals(exprType.getClassName())) {
                return (R)this.reduce(this.defaultTo(expr), this.visitTypeName((NameTree)((Object)expr)));
            }
        }
        return (R)this.defaultTo(expr);
    }

    public R visitStatement(Statement statement) {
        return (R)this.defaultTo(statement);
    }

    public R visitTypeName(NameTree name) {
        return (R)this.defaultTo(name);
    }

    public R visitAnnotatedType(J.AnnotatedType annotatedType) {
        return (R)this.reduce(this.defaultTo(annotatedType), this.reduce(this.visitExpression(annotatedType), this.visitTypeNameAfter(this.visitAfter(this.visit(annotatedType.getTypeExpr()), annotatedType.getAnnotations()), annotatedType.getTypeExpr())));
    }

    public R visitAnnotation(J.Annotation annotation) {
        return (R)this.reduce(this.defaultTo(annotation), this.reduce(this.visitExpression(annotation), this.visitTypeNameAfter(this.visitAfter(this.visit(annotation.getAnnotationType()), annotation.getArgs() == null ? null : annotation.getArgs().getArgs()), annotation.getAnnotationType())));
    }

    public R visitArrayAccess(J.ArrayAccess arrayAccess) {
        return (R)this.reduce(this.defaultTo(arrayAccess), this.reduce(this.visitExpression(arrayAccess), this.visitAfter(this.visit(arrayAccess.getDimension().getIndex()), arrayAccess.getIndexed())));
    }

    public R visitArrayType(J.ArrayType arrayType) {
        return (R)this.reduce(this.defaultTo(arrayType), this.reduce(this.visitExpression(arrayType), this.visitTypeNameAfter(this.visit(arrayType.getElementType()), arrayType.getElementType())));
    }

    public R visitAssert(J.Assert azzert) {
        return (R)this.reduce(this.defaultTo(azzert), this.reduce(this.visitStatement(azzert), this.visit(azzert.getCondition())));
    }

    public R visitAssign(J.Assign assign) {
        return (R)this.reduce(this.defaultTo(assign), this.reduce(this.visitExpression(assign), this.reduce(this.visitStatement(assign), this.visitAfter(this.visit(assign.getVariable()), assign.getAssignment()))));
    }

    public R visitAssignOp(J.AssignOp assignOp) {
        return (R)this.reduce(this.defaultTo(assignOp), this.reduce(this.visitExpression(assignOp), this.reduce(this.visitStatement(assignOp), this.visitAfter(this.visit(assignOp.getVariable()), assignOp.getAssignment()))));
    }

    public R visitBinary(J.Binary binary) {
        return (R)this.reduce(this.defaultTo(binary), this.reduce(this.visitExpression(binary), this.visitAfter(this.visit(binary.getLeft()), binary.getRight())));
    }

    public R visitBlock(J.Block<J> block) {
        return (R)this.reduce(this.defaultTo(block), this.reduce(this.visitStatement(block), this.visit(block.getStatements())));
    }

    public R visitBreak(J.Break breakStatement) {
        return (R)this.reduce(this.defaultTo(breakStatement), this.reduce(this.visitStatement(breakStatement), this.visit(breakStatement.getLabel())));
    }

    public R visitCase(J.Case caze) {
        return (R)this.reduce(this.defaultTo(caze), this.reduce(this.visitStatement(caze), this.visitAfter(this.visit(caze.getStatements()), caze.getPattern())));
    }

    public R visitCatch(J.Try.Catch catzh) {
        return (R)this.reduce(this.defaultTo(catzh), this.visitAfter(this.visit(catzh.getBody()), catzh.getParam()));
    }

    public R visitClassDecl(J.ClassDecl classDecl) {
        return (R)this.reduce(this.defaultTo(classDecl), this.reduce(this.visitStatement(classDecl), this.visitTypeNamesAfter(this.visitTypeNameAfter(this.visitAfter(this.visitAfter(this.visitAfter(this.visitAfter(this.visitAfter(this.visitAfter(this.visit(classDecl.getBody()), classDecl.getModifiers()), classDecl.getName()), classDecl.getTypeParameters()), classDecl.getExtends()), classDecl.getImplements()), classDecl.getAnnotations()), classDecl.getExtends() == null ? null : classDecl.getExtends().getFrom()), classDecl.getImplements() == null ? null : classDecl.getImplements().getFrom())));
    }

    public R visitCompilationUnit(J.CompilationUnit cu) {
        return (R)this.reduce(this.defaultTo(cu), this.visitAfter(this.visitAfter(this.visit(cu.getImports()), cu.getPackageDecl()), cu.getClasses()));
    }

    public R visitContinue(J.Continue continueStatement) {
        return (R)this.reduce(this.defaultTo(continueStatement), this.reduce(this.visitStatement(continueStatement), this.visit(continueStatement.getLabel())));
    }

    public R visitDoWhileLoop(J.DoWhileLoop doWhileLoop) {
        return (R)this.reduce(this.defaultTo(doWhileLoop), this.reduce(this.visitStatement(doWhileLoop), this.visitAfter(this.visit(doWhileLoop.getBody()), doWhileLoop.getWhileCondition().getCondition())));
    }

    public R visitEmpty(J.Empty empty) {
        return (R)this.reduce(this.defaultTo(empty), this.reduce(this.visitExpression(empty), this.visitStatement(empty)));
    }

    public R visitEnumValue(J.EnumValue enoom) {
        return (R)this.reduce(this.defaultTo(enoom), this.reduce(this.visitStatement(enoom), this.visitAfter(this.visit(enoom.getName()), enoom.getInitializer() == null ? null : enoom.getInitializer().getArgs())));
    }

    public R visitEnumValueSet(J.EnumValueSet enums) {
        return (R)this.reduce(this.defaultTo(enums), this.reduce(this.visitStatement(enums), this.visit(enums.getEnums())));
    }

    public R visitFinally(J.Try.Finally finallie) {
        return (R)this.reduce(this.defaultTo(finallie), this.visit(finallie.getBody()));
    }

    public R visitFieldAccess(J.FieldAccess fieldAccess) {
        return (R)this.reduce(this.defaultTo(fieldAccess), this.reduce(this.visitExpression(fieldAccess), this.visitTypeNameAfter(this.visitAfter(this.visit(fieldAccess.getTarget()), fieldAccess.getName()), fieldAccess.asClassReference())));
    }

    public R visitForEachLoop(J.ForEachLoop forEachLoop) {
        return (R)this.reduce(this.defaultTo(forEachLoop), this.reduce(this.visitStatement(forEachLoop), this.visitAfter(this.visitAfter(this.visit(forEachLoop.getBody()), forEachLoop.getControl().getIterable()), forEachLoop.getControl().getVariable())));
    }

    public R visitForLoop(J.ForLoop forLoop) {
        return (R)this.reduce(this.defaultTo(forLoop), this.reduce(this.visitStatement(forLoop), this.visitAfter(this.visitAfter(this.visitAfter(this.visit(forLoop.getBody()), forLoop.getControl().getUpdate()), forLoop.getControl().getCondition()), forLoop.getControl().getInit())));
    }

    public R visitIdentifier(J.Ident ident) {
        return (R)this.reduce(this.defaultTo(ident), this.visitExpression(ident));
    }

    public R visitIf(J.If iff) {
        return (R)this.reduce(this.defaultTo(iff), this.reduce(this.visitStatement(iff), this.visitAfter(this.visitAfter(this.visit(iff.getThenPart()), iff.getElsePart()), iff.getIfCondition())));
    }

    public R visitElse(J.If.Else elze) {
        return (R)this.reduce(this.defaultTo(elze), this.visit(elze.getStatement()));
    }

    public R visitImport(J.Import impoort) {
        return (R)this.reduce(this.defaultTo(impoort), this.visit(impoort.getQualid()));
    }

    public R visitInstanceOf(J.InstanceOf instanceOf) {
        return (R)this.reduce(this.defaultTo(instanceOf), this.reduce(this.visitExpression(instanceOf), this.visitAfter(this.visit(instanceOf.getExpr()), instanceOf.getClazz())));
    }

    public R visitLabel(J.Label label) {
        return (R)this.reduce(this.defaultTo(label), this.reduce(this.visitStatement(label), this.visitAfter(this.visit(label.getLabel()), label.getStatement())));
    }

    public R visitLambda(J.Lambda lambda) {
        return (R)this.reduce(this.defaultTo(lambda), this.reduce(this.visitExpression(lambda), this.visitAfter(this.visit(lambda.getParamSet().getParams()), lambda.getBody())));
    }

    public R visitLiteral(J.Literal literal) {
        return (R)this.reduce(this.defaultTo(literal), this.visitExpression(literal));
    }

    public R visitMemberReference(J.MemberReference memberRef) {
        return (R)this.reduce(this.defaultTo(memberRef), this.visitAfter(this.visitAfter(this.visit(memberRef.getTypeParameters()), memberRef.getReference()), memberRef.getContaining()));
    }

    public R visitMethod(J.MethodDecl method) {
        return (R)this.reduce(this.defaultTo(method), this.visitTypeNamesAfter(this.visitTypeNameAfter(this.visitAfter(this.visitAfter(this.visitAfter(this.visitAfter(this.visitAfter(this.visitAfter(this.visitAfter(this.visitAfter(this.visit(method.getBody()), method.getModifiers()), method.getTypeParameters()), method.getName()), method.getReturnTypeExpr()), method.getParams().getParams()), method.getThrows() == null ? null : method.getThrows().getExceptions()), method.getAnnotations()), method.getDefaultValue()), method.getReturnTypeExpr()), method.getThrows() == null ? null : method.getThrows().getExceptions()));
    }

    public R visitMethodInvocation(J.MethodInvocation method) {
        Object selectTypeVisit = method.getSelect() instanceof NameTree && method.getType() != null && method.getType().hasFlags(Flag.Static) ? this.visitTypeName((NameTree)((Object)method.getSelect())) : this.defaultTo(method);
        return (R)this.reduce(this.defaultTo(method), this.reduce(this.visitStatement(method), this.reduce(this.visitExpression(method), this.reduce(selectTypeVisit, this.visitAfter(this.visitAfter(this.visitAfter(this.visit(method.getArgs().getArgs()), method.getName()), method.getTypeParameters()), method.getSelect())))));
    }

    public R visitMultiCatch(J.MultiCatch multiCatch) {
        return (R)this.reduce(this.defaultTo(multiCatch), this.visitTypeNamesAfter(this.visit(multiCatch.getAlternatives()), multiCatch.getAlternatives()));
    }

    public R visitMultiVariable(J.VariableDecls multiVariable) {
        Object varTypeVisit = multiVariable.getTypeExpr() instanceof J.MultiCatch ? this.defaultTo(multiVariable) : (multiVariable.getTypeExpr() == null ? this.defaultTo(multiVariable) : this.visitTypeName(multiVariable.getTypeExpr()));
        return (R)this.reduce(this.defaultTo(multiVariable), this.reduce(this.visitStatement(multiVariable), this.reduce(varTypeVisit, this.visitAfter(this.visitAfter(this.visitAfter(this.visit(multiVariable.getVars()), multiVariable.getTypeExpr()), multiVariable.getModifiers()), multiVariable.getAnnotations()))));
    }

    public R visitNewArray(J.NewArray newArray) {
        return (R)this.reduce(this.defaultTo(newArray), this.reduce(this.visitExpression(newArray), this.visitTypeNameAfter(this.visitAfter(this.visitAfter(this.visit(newArray.getTypeExpr()), newArray.getDimensions().stream().map(J.NewArray.Dimension::getSize).collect(Collectors.toList())), newArray.getInitializer() == null ? null : newArray.getInitializer().getElements()), newArray.getTypeExpr())));
    }

    public R visitNewClass(J.NewClass newClass) {
        return (R)this.reduce(this.defaultTo(newClass), this.reduce(this.visitExpression(newClass), this.reduce(this.visitStatement(newClass), this.visitTypeNameAfter(this.visitAfter(this.visitAfter(this.visit(newClass.getBody()), newClass.getArgs().getArgs()), newClass.getClazz()), newClass.getClazz()))));
    }

    public R visitPackage(J.Package pkg) {
        return (R)this.reduce(this.defaultTo(pkg), this.visit(pkg.getExpr()));
    }

    public R visitParameterizedType(J.ParameterizedType type) {
        return (R)this.reduce(this.defaultTo(type), this.reduce(this.visitExpression(type), this.visitTypeNameAfter(this.visitAfter(this.visit(type.getTypeParameters()), type.getClazz()), type.getClazz())));
    }

    public <T extends J> R visitParentheses(J.Parentheses<T> parens) {
        return (R)this.reduce(this.defaultTo(parens), this.reduce(this.visitExpression(parens), this.visit((Tree)parens.getTree())));
    }

    public R visitPrimitive(J.Primitive primitive) {
        return (R)this.reduce(this.defaultTo(primitive), this.visitExpression(primitive));
    }

    public R visitReturn(J.Return retrn) {
        return (R)this.reduce(this.defaultTo(retrn), this.reduce(this.visitStatement(retrn), this.visit(retrn.getExpr())));
    }

    public R visitSwitch(J.Switch switzh) {
        return (R)this.reduce(this.defaultTo(switzh), this.reduce(this.visitStatement(switzh), this.visitAfter(this.visit(switzh.getCases()), switzh.getSelector())));
    }

    public R visitSynchronized(J.Synchronized synch) {
        return (R)this.reduce(this.defaultTo(synch), this.reduce(this.visitStatement(synch), this.visitAfter(this.visit(synch.getBody()), synch.getLock())));
    }

    public R visitTernary(J.Ternary ternary) {
        return (R)this.reduce(this.defaultTo(ternary), this.reduce(this.visitExpression(ternary), this.visitAfter(this.visitAfter(this.visit(ternary.getFalsePart()), ternary.getTruePart()), ternary.getCondition())));
    }

    public R visitThrow(J.Throw thrown) {
        return (R)this.reduce(this.defaultTo(thrown), this.reduce(this.visitStatement(thrown), this.visit(thrown.getException())));
    }

    public R visitTry(J.Try tryable) {
        return (R)this.reduce(this.defaultTo(tryable), this.reduce(this.visitStatement(tryable), this.visitAfter(this.visitAfter(this.visitAfter(this.visit(tryable.getBody()), tryable.getResources() == null ? null : tryable.getResources().getDecls()), tryable.getCatches()), tryable.getFinally())));
    }

    public R visitTypeCast(J.TypeCast typeCast) {
        return (R)this.reduce(this.defaultTo(typeCast), this.reduce(this.visitExpression(typeCast), this.visitTypeNameAfter(this.visitAfter(this.visit(typeCast.getClazz()), typeCast.getExpr()), typeCast.getClazz().getTree())));
    }

    public R visitTypeParameter(J.TypeParameter typeParam) {
        return (R)this.reduce(this.defaultTo(typeParam), this.visitTypeNameAfter(this.visitTypeNamesAfter(this.visitAfter(this.visitAfter(this.visit(typeParam.getAnnotations()), typeParam.getName()), typeParam.getBounds() == null ? null : typeParam.getBounds().getTypes()), typeParam.getBounds() == null ? null : typeParam.getBounds().getTypes()), typeParam.getName() instanceof NameTree ? (NameTree)((Object)typeParam.getName()) : null));
    }

    public R visitTypeParameters(J.TypeParameters typeParams) {
        return (R)this.reduce(this.defaultTo(typeParams), this.visit(typeParams.getParams()));
    }

    public R visitUnary(J.Unary unary) {
        return (R)this.reduce(this.defaultTo(unary), this.reduce(this.visitStatement(unary), this.reduce(this.visitExpression(unary), this.visit(unary.getExpr()))));
    }

    public R visitUnparsedSource(J.UnparsedSource unparsed) {
        return (R)this.reduce(this.defaultTo(unparsed), this.reduce(this.visitStatement(unparsed), this.visitExpression(unparsed)));
    }

    public R visitVariable(J.VariableDecls.NamedVar variable) {
        return (R)this.reduce(this.defaultTo(variable), this.visitAfter(this.visitAfter(this.visit(variable.getInitializer()), variable.getDimensionsAfterName()), variable.getName()));
    }

    public R visitWhileLoop(J.WhileLoop whileLoop) {
        return (R)this.reduce(this.defaultTo(whileLoop), this.reduce(this.visitStatement(whileLoop), this.visitAfter(this.visit(whileLoop.getBody()), whileLoop.getCondition())));
    }

    public R visitWildcard(J.Wildcard wildcard) {
        return (R)this.reduce(this.defaultTo(wildcard), this.reduce(this.visitExpression(wildcard), this.visitTypeNameAfter(this.visitAfter(this.visit(wildcard.getBound()), wildcard.getBoundedType()), wildcard.getBoundedType())));
    }
}

