/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import org.openrewrite.Cursor;
import org.openrewrite.Formatting;
import org.openrewrite.Tree;
import org.openrewrite.java.ShiftFormatRightVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.refactor.Formatter;

public class JavaFormatter
extends Formatter {
    public JavaFormatter(J.CompilationUnit cu) {
        super((Tree)cu);
    }

    public Formatting format(Tree relativeToEnclosing) {
        Tree[] siblings = new Tree[]{};
        if (relativeToEnclosing instanceof J.Block) {
            siblings = (Tree[])((J.Block)relativeToEnclosing).getStatements().toArray(Tree[]::new);
        } else if (relativeToEnclosing instanceof J.Case) {
            siblings = (Tree[])((J.Case)relativeToEnclosing).getStatements().toArray(Tree[]::new);
        }
        Formatter.Result indentation = this.findIndent(JavaFormatter.enclosingIndent(relativeToEnclosing), siblings);
        return Formatting.format((String)indentation.getPrefix());
    }

    public Formatting format(Cursor cursor) {
        return this.format(cursor.firstEnclosing(J.Block.class));
    }

    public ShiftFormatRightVisitor shiftRight(Tree moving, Tree into, Tree enclosesBoth) {
        int shift = JavaFormatter.enclosingIndent(into) - this.findIndent(JavaFormatter.enclosingIndent(enclosesBoth), new Tree[]{moving}).getEnclosingIndent();
        return new ShiftFormatRightVisitor(moving, shift, this.wholeSourceIndent().isIndentedWithSpaces());
    }

    public static int enclosingIndent(Tree enclosesBoth) {
        return enclosesBoth instanceof J.Block ? ((J.Block)enclosesBoth).getIndent() : (int)enclosesBoth.getFormatting().getPrefix().chars().dropWhile(c -> c == 10 || c == 13).takeWhile(Character::isWhitespace).count();
    }

    public boolean isIndentedWithSpaces() {
        return this.wholeSourceIndent().isIndentedWithSpaces();
    }
}

