/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.refactor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openrewrite.Formatting;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.refactor.JavaRefactorVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

public class AddField
extends JavaRefactorVisitor {
    private final J.ClassDecl scope;
    private final List<J.Modifier> modifiers;
    private final String clazz;
    private final String name;
    @Nullable
    private final String init;

    public AddField(J.ClassDecl scope, List<J.Modifier> modifiers, String clazz, String name, @Nullable String init) {
        super("java.AddField", "field.class", clazz, "field.name", name);
        this.scope = scope;
        this.modifiers = modifiers;
        this.clazz = clazz;
        this.name = name;
        this.init = init;
    }

    @Override
    public J visitClassDecl(J.ClassDecl classDecl) {
        J.ClassDecl c = (J.ClassDecl)this.refactor(classDecl, x$0 -> super.visitClassDecl((J.ClassDecl)x$0));
        if (this.scope.isScope(classDecl)) {
            if (classDecl.getBody().getStatements().stream().filter(s -> s instanceof J.VariableDecls).map(J.VariableDecls.class::cast).noneMatch(mv -> mv.getVars().stream().anyMatch(var -> var.getSimpleName().equals(this.name)))) {
                J.Block<J> body = c.getBody();
                JavaType.Class classType = JavaType.Class.build(this.clazz);
                this.maybeAddImport(classType);
                J.VariableDecls newField = new J.VariableDecls(Tree.randomId(), Collections.emptyList(), this.modifiers, J.Ident.build(Tree.randomId(), classType.getClassName(), classType, this.modifiers.isEmpty() ? Formatting.EMPTY : Formatting.format((String)" ")), null, Collections.emptyList(), Collections.singletonList(new J.VariableDecls.NamedVar(Tree.randomId(), J.Ident.build(Tree.randomId(), this.name, null, Formatting.format((String)"", (String)(this.init == null ? "" : " "))), Collections.emptyList(), this.init == null ? null : new J.UnparsedSource(Tree.randomId(), this.init, Formatting.format((String)" ")), classType, Formatting.format((String)" "))), this.formatter.format(body));
                ArrayList<J> statements = new ArrayList<J>(body.getStatements().size() + 1);
                statements.add(newField);
                statements.addAll(body.getStatements());
                c = c.withBody(body.withStatements(statements));
            }
        }
        return c;
    }
}

