/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import com.sun.source.tree.Tree;
import com.sun.tools.javac.comp.Annotate;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Modules;
import com.sun.tools.javac.comp.Todo;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.openrewrite.Formatting;
import org.openrewrite.internal.lang.NonNullApi;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.internal.JavaParserVisitor;
import org.openrewrite.java.tree.J;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullApi
public class JavaParser {
    private static final Logger logger = LoggerFactory.getLogger(JavaParser.class);
    private MeterRegistry meterRegistry = Metrics.globalRegistry;
    private final boolean relaxedClassTypeMatching;
    private boolean logCompilationWarningsAndErrors = true;
    @Nullable
    private final java.util.List<Path> classpath;
    private final Charset charset;
    private final JavacFileManager pfm;
    private final Context context = new Context();
    private final JavaCompiler compiler;
    private final ResettableLog compilerLog = new ResettableLog(this.context);

    public static java.util.List<Path> dependenciesFromClasspath(String ... artifactNames) {
        java.util.List artifactNamePatterns = Arrays.stream(artifactNames).map(name -> Pattern.compile(name + "-.*?\\.jar$")).collect(Collectors.toList());
        return Arrays.stream(System.getProperty("java.class.path").split("\\Q" + System.getProperty("path.separator") + "\\E")).filter(cpEntry -> artifactNamePatterns.stream().anyMatch(namePattern -> namePattern.matcher((CharSequence)cpEntry).find())).map(cpEntry -> new File((String)cpEntry).toPath()).collect(Collectors.toList());
    }

    public JavaParser() {
        this(null, Charset.defaultCharset(), false);
    }

    public JavaParser(@Nullable java.util.List<Path> classpath) {
        this(classpath, Charset.defaultCharset(), false);
    }

    public JavaParser(@Nullable java.util.List<Path> classpath, Charset charset, boolean relaxedClassTypeMatching) {
        this.classpath = classpath;
        this.charset = charset;
        this.relaxedClassTypeMatching = relaxedClassTypeMatching;
        this.pfm = new JavacFileManager(this.context, true, charset);
        Options.instance(this.context).put("allowStringFolding", "false");
        this.compiler = new JavaCompiler(this.context);
        this.compiler.genEndPos = true;
        this.compiler.keepComments = true;
        this.compilerLog.setWriters(new PrintWriter(new Writer(){

            @Override
            public void write(char[] cbuf, int off, int len) {
                String log = new String(Arrays.copyOfRange(cbuf, off, len));
                if (JavaParser.this.logCompilationWarningsAndErrors && !log.isBlank()) {
                    logger.warn(log);
                }
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() {
            }
        }));
    }

    public java.util.List<J.CompilationUnit> parse(java.util.List<Path> sourceFiles, @Nullable Path relativeTo) {
        if (this.classpath != null) {
            if (this.context.get(JavaFileManager.class) != this.pfm) {
                throw new IllegalStateException("JavaFileManager has been forked unexpectedly");
            }
            try {
                this.pfm.setLocation(StandardLocation.CLASS_PATH, this.classpath.stream().map(Path::toFile).collect(Collectors.toList()));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        Iterable<? extends JavaFileObject> fileObjects = this.pfm.getJavaFileObjects((Path[])this.filterSourceFiles(sourceFiles).toArray(Path[]::new));
        LinkedHashMap cus = StreamSupport.stream(fileObjects.spliterator(), false).collect(Collectors.toMap(p -> Paths.get(p.toUri()), filename -> (JCTree.JCCompilationUnit)Timer.builder((String)"rewrite.parse").description("The time spent by the JDK in parsing and tokenizing the source file").tag("file.type", "Java").tag("step", "JDK parsing").register(this.meterRegistry).record(() -> this.compiler.parse((JavaFileObject)filename)), (e2, e1) -> e1, LinkedHashMap::new));
        try {
            this.initModules(cus.values());
            this.enterAll(cus.values());
            Annotate annotate = Annotate.instance(this.context);
            while (annotate.annotationsBlocked()) {
                annotate.unblockAnnotations();
            }
            this.compiler.attribute(new TimedTodo(this.compiler.todo));
        }
        catch (Throwable t) {
            logger.warn("Failed symbol entering or attribution", t);
        }
        return cus.entrySet().stream().map(cuByPath -> (J.CompilationUnit)Timer.builder((String)"rewrite.parse").description("The time spent mapping the OpenJDK AST to Rewrite's AST").tag("file.type", "Java").tag("step", "Map to Rewrite AST").register(this.meterRegistry).record(() -> {
            Path path = (Path)cuByPath.getKey();
            logger.trace("Building AST for {}", (Object)path.toAbsolutePath().getFileName());
            try {
                JavaParserVisitor parser = new JavaParserVisitor(relativeTo == null ? path : relativeTo.relativize(path), Files.readString(path, this.charset), this.relaxedClassTypeMatching);
                return (J.CompilationUnit)parser.scan((Tree)cuByPath.getValue(), Formatting.EMPTY);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        })).collect(Collectors.toList());
    }

    public J.CompilationUnit parse(String source, String whichDependsOn) {
        return this.parse(source, Collections.singletonList(whichDependsOn));
    }

    public J.CompilationUnit parse(String source, java.util.List<String> whichDependOn) {
        return this.parse(source, (String[])whichDependOn.toArray(String[]::new));
    }

    public java.util.List<J.CompilationUnit> parse(java.util.List<Path> sourceFiles) {
        return this.parse(sourceFiles, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public J.CompilationUnit parse(String source, String ... whichDependOn) {
        Path temp = Files.createTempDirectory("sources", new FileAttribute[0]);
        Pattern classPattern = Pattern.compile("(class|interface|enum)\\s*(<[^>]*>)?\\s+(\\w+)");
        Function<String, String> simpleName = sourceStr -> {
            Matcher classMatcher = classPattern.matcher((CharSequence)sourceStr);
            return classMatcher.find() ? classMatcher.group(3) : null;
        };
        Function<String, Path> sourceFile = sourceText -> {
            Path file = temp.resolve((String)simpleName.apply((String)sourceText) + ".java");
            try {
                Files.writeString(file, (CharSequence)sourceText, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return file;
        };
        try {
            java.util.List<J.CompilationUnit> cus = this.parse(Stream.concat(Arrays.stream(whichDependOn).map(sourceFile), Stream.of(sourceFile.apply(source))).collect(Collectors.toList()));
            J.CompilationUnit compilationUnit = cus.get(cus.size() - 1);
            Files.walk(temp, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            return compilationUnit;
        }
        catch (Throwable throwable) {
            try {
                Files.walk(temp, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    public void reset() {
        this.compilerLog.reset();
        this.pfm.flush();
        Check.instance(this.context).newRound();
    }

    public JavaParser setLogCompilationWarningsAndErrors(boolean logCompilationWarningsAndErrors) {
        this.logCompilationWarningsAndErrors = logCompilationWarningsAndErrors;
        return this;
    }

    public JavaParser setMeterRegistry(MeterRegistry registry) {
        this.meterRegistry = registry;
        return this;
    }

    private void initModules(Collection<JCTree.JCCompilationUnit> cus) {
        Modules modules = Modules.instance(this.context);
        modules.initModules(List.from(cus));
    }

    private void enterAll(Collection<JCTree.JCCompilationUnit> cus) {
        Enter enter = Enter.instance(this.context);
        List<JCTree.JCCompilationUnit> compilationUnits = List.from((JCTree.JCCompilationUnit[])cus.toArray(JCTree.JCCompilationUnit[]::new));
        enter.main(compilationUnits);
    }

    private java.util.List<Path> filterSourceFiles(java.util.List<Path> sourceFiles) {
        return sourceFiles.stream().filter(source -> source.getFileName().toString().endsWith(".java")).collect(Collectors.toList());
    }

    private class TimedTodo
    extends Todo {
        private final Todo todo;
        private Timer.Sample sample;

        private TimedTodo(Todo todo) {
            super(new Context());
            this.todo = todo;
        }

        @Override
        public boolean isEmpty() {
            if (this.sample != null) {
                this.sample.stop(Timer.builder((String)"rewrite.parse").description("The time spent by the JDK in type attributing the source file").tag("file.type", "Java").tag("step", "Type attribution").register(JavaParser.this.meterRegistry));
            }
            return this.todo.isEmpty();
        }

        @Override
        public Env<AttrContext> remove() {
            this.sample = Timer.start();
            return (Env)this.todo.remove();
        }
    }

    private static class ResettableLog
    extends Log {
        protected ResettableLog(Context context) {
            super(context);
        }

        public void reset() {
            this.sourceMap.clear();
        }
    }
}

