/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import java.beans.ConstructorProperties;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.openrewrite.Cursor;
import org.openrewrite.Formatting;
import org.openrewrite.Tree;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNullApi;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaSourceVisitor;
import org.openrewrite.java.refactor.JavaFormatter;
import org.openrewrite.java.refactor.ShiftFormatRightVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullApi
public class TreeBuilder {
    private static final Logger logger = LoggerFactory.getLogger(TreeBuilder.class);
    private static final Pattern whitespacePrefixPattern = Pattern.compile("^\\s*");
    private static final Pattern whitespaceSuffixPattern = Pattern.compile("\\s*[^\\s]+(\\s*)");

    private TreeBuilder() {
    }

    public static <T extends TypeTree & Expression> T buildName(String fullyQualifiedName) {
        return TreeBuilder.buildName(fullyQualifiedName, Formatting.EMPTY);
    }

    public static <T extends TypeTree & Expression> T buildName(String fullyQualifiedName, Formatting fmt) {
        String[] parts = fullyQualifiedName.split("\\.");
        Object fullName = "";
        Expression expr = null;
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            if (i == 0) {
                fullName = part;
                expr = J.Ident.build(Tree.randomId(), part, null, Formatting.EMPTY);
                continue;
            }
            fullName = (String)fullName + "." + part;
            Matcher whitespacePrefix = whitespacePrefixPattern.matcher(part);
            Formatting identFmt = whitespacePrefix.matches() ? Formatting.format((String)whitespacePrefix.group(0)) : Formatting.EMPTY;
            Matcher whitespaceSuffix = whitespaceSuffixPattern.matcher(part);
            whitespaceSuffix.matches();
            Formatting partFmt = i == parts.length - 1 ? Formatting.EMPTY : Formatting.format((String)"", (String)whitespaceSuffix.group(1));
            expr = new J.FieldAccess(Tree.randomId(), expr, J.Ident.build(Tree.randomId(), part.trim(), null, identFmt), Character.isUpperCase(part.charAt(0)) || i == parts.length - 1 ? JavaType.Class.build((String)fullName) : null, partFmt);
        }
        return (T)((TypeTree)expr.withFormatting(fmt));
    }

    public static <T extends J> List<T> buildSnippet(J.CompilationUnit containing, Cursor insertionScope, String snippet, JavaType.Class ... imports) {
        JavaParser parser = new JavaParser(Collections.emptyList(), Charset.defaultCharset(), true);
        String source = Arrays.stream(imports).map(i -> "import " + i.getFullyQualifiedName() + ";").collect(Collectors.joining("\n", "", "\n\n")) + "class CodeSnippet {\n" + ((List)new ListScopeVariables(insertionScope).visit(containing)).stream().collect(Collectors.joining(";\n  ", "  // variables visible in the insertion scope\n  ", ";\n")) + "\n  // the contents of this block are the snippet\n  {\n" + StringUtils.trimIndent((String)snippet) + "\n  }\n}";
        if (logger.isDebugEnabled()) {
            logger.debug("Building code snippet using synthetic class:");
            logger.debug(source);
        }
        J.CompilationUnit cu = parser.parse(source, new String[0]);
        List<J> statements = cu.getClasses().get(0).getBody().getStatements();
        J.Block block = (J.Block)statements.get(statements.size() - 1);
        JavaFormatter formatter = new JavaFormatter(cu);
        return block.getStatements().stream().map(stat -> {
            ShiftFormatRightVisitor shiftRight = new ShiftFormatRightVisitor(stat.getId(), JavaFormatter.enclosingIndent(insertionScope.getTree()) + formatter.findIndent(JavaFormatter.enclosingIndent(insertionScope.getTree()), new Tree[]{stat}).getEnclosingIndent(), formatter.isIndentedWithSpaces());
            return (J)shiftRight.visit((Tree)stat);
        }).collect(Collectors.toList());
    }

    private static class ListScopeVariables
    extends JavaSourceVisitor<List<String>> {
        private final Cursor scope;

        public boolean isCursored() {
            return true;
        }

        public List<String> defaultTo(@Nullable Tree t) {
            return Collections.emptyList();
        }

        @Override
        public List<String> visitVariable(J.VariableDecls.NamedVar variable) {
            if (this.isInSameNameScope(this.scope)) {
                J.VariableDecls variableDecls = (J.VariableDecls)this.getCursor().getParentOrThrow().getTree();
                JavaType type = variableDecls.getTypeExpr() == null ? variable.getType() : variableDecls.getTypeExpr().getType();
                String typeName = "";
                if (type instanceof JavaType.Class) {
                    typeName = ((JavaType.Class)type).getFullyQualifiedName();
                } else if (type instanceof JavaType.ShallowClass) {
                    typeName = ((JavaType.ShallowClass)type).getFullyQualifiedName();
                } else if (type instanceof JavaType.GenericTypeVariable) {
                    typeName = ((JavaType.GenericTypeVariable)type).getFullyQualifiedName();
                } else if (type instanceof JavaType.Primitive) {
                    typeName = ((JavaType.Primitive)type).getKeyword();
                }
                return Collections.singletonList(typeName + " " + variable.getSimpleName());
            }
            return (List)super.visitVariable(variable);
        }

        @ConstructorProperties(value={"scope"})
        public ListScopeVariables(Cursor scope) {
            this.scope = scope;
        }
    }
}

