/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.refactor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openrewrite.Formatting;
import org.openrewrite.Tree;
import org.openrewrite.java.refactor.ScopedJavaRefactorVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public class ReorderMethodArguments
extends ScopedJavaRefactorVisitor {
    private final String[] byArgumentNames;
    private String[] originalParamNames;

    public ReorderMethodArguments(J.MethodInvocation scope, String ... byArgumentNames) {
        super(scope.getId());
        this.byArgumentNames = byArgumentNames;
        this.originalParamNames = new String[0];
    }

    public ReorderMethodArguments withOriginalParamNames(String ... originalParamNames) {
        this.originalParamNames = originalParamNames;
        return this;
    }

    public String getName() {
        return "core.ReorderMethodArguments";
    }

    public boolean isIdempotent() {
        return false;
    }

    @Override
    public J visitMethodInvocation(J.MethodInvocation method) {
        if (this.isScope() && method.getType() != null) {
            List<String> paramNames;
            List<String> list = paramNames = this.originalParamNames.length == 0 ? method.getType().getParamNames() : Arrays.asList(this.originalParamNames);
            if (paramNames == null) {
                throw new IllegalStateException("There is no source attachment for method " + method.getType().getDeclaringType().getFullyQualifiedName() + "." + method.getSimpleName() + "(..). Provide a reference for original parameter names by calling setOriginalParamNames(..)");
            }
            List<Expression> originalArgs = method.getArgs().getArgs();
            int resolvedParamCount = method.getType().getResolvedSignature() == null ? originalArgs.size() : method.getType().getResolvedSignature().getParamTypes().size();
            int i = 0;
            ArrayList<Expression> reordered = new ArrayList<Expression>(originalArgs.size());
            ArrayList<Formatting> formattings = new ArrayList<Formatting>(originalArgs.size());
            for (String name : this.byArgumentNames) {
                int fromPos = paramNames.indexOf(name);
                if (originalArgs.size() > resolvedParamCount && fromPos == resolvedParamCount - 1) {
                    List<Expression> varargs = originalArgs.subList(fromPos, originalArgs.size());
                    reordered.addAll(varargs);
                    int n = i;
                    int n2 = i++;
                    originalArgs.subList(n, n2 + varargs.size()).stream().map(Tree::getFormatting).forEach(formattings::add);
                    continue;
                }
                if (fromPos < 0 || originalArgs.size() <= fromPos) continue;
                reordered.add(originalArgs.get(fromPos));
                formattings.add(originalArgs.get(i++).getFormatting());
            }
            i = 0;
            for (Expression expression : reordered) {
                reordered.set(i, (Expression)expression.withFormatting((Formatting)formattings.get(i++)));
            }
            return method.withArgs(method.getArgs().withArgs(reordered));
        }
        return super.visitMethodInvocation(method);
    }
}

