/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.refactor;

import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.stream.Collectors;
import org.openrewrite.Formatting;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.refactor.JavaRefactorVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.TreeBuilder;
import org.openrewrite.java.tree.TypeUtils;

public class RemoveImport
extends JavaRefactorVisitor {
    private final String clazz;
    private final MethodMatcher methodMatcher;
    private final JavaType.Class classType;
    private J.Import namedImport;
    private J.Import starImport;
    private J.Import staticStarImport;
    private final Set<String> referencedTypes = new HashSet<String>();
    private final Set<J.Ident> referencedMethods = new HashSet<J.Ident>();
    private final Set<String> referencedFields = new HashSet<String>();
    private final Set<J.Import> staticNamedImports = Collections.newSetFromMap(new IdentityHashMap());

    public RemoveImport(String clazz) {
        this.clazz = clazz;
        this.methodMatcher = new MethodMatcher(clazz + " *(..)");
        this.classType = JavaType.Class.build(clazz);
    }

    public String getName() {
        return "core.RemoveImport{classType=" + this.clazz + "}";
    }

    public boolean isCursored() {
        return true;
    }

    @Override
    public J visitCompilationUnit(J.CompilationUnit cu) {
        J.CompilationUnit c = (J.CompilationUnit)this.refactor(cu, x$0 -> super.visitCompilationUnit((J.CompilationUnit)x$0));
        return this.staticImportDeletions(this.classImportDeletions(c));
    }

    @Override
    public J visitImport(J.Import impoort) {
        if (impoort.isStatic()) {
            if (impoort.getQualid().getTarget().printTrimmed().equals(this.clazz)) {
                if ("*".equals(impoort.getQualid().getSimpleName())) {
                    this.staticStarImport = impoort;
                } else {
                    this.staticNamedImports.add(impoort);
                }
            }
        } else if (impoort.getQualid().printTrimmed().equals(this.clazz)) {
            this.namedImport = impoort;
        } else if ("*".equals(impoort.getQualid().getSimpleName()) && this.clazz.startsWith(impoort.getQualid().getTarget().printTrimmed())) {
            this.starImport = impoort;
        }
        return super.visitImport(impoort);
    }

    @Override
    public J visitTypeName(NameTree name) {
        JavaType.Class asClass = TypeUtils.asClass(name.getType());
        if (asClass != null && asClass.getPackageName().equals(this.classType.getPackageName())) {
            if (this.getCursor().getPathAsStream().noneMatch(J.Import.class::isInstance)) {
                this.referencedTypes.add(asClass.getFullyQualifiedName());
            }
        }
        return (J)super.visitTypeName(name);
    }

    @Override
    public J visitIdentifier(J.Ident ident) {
        if (this.getCursor().getPathAsStream().noneMatch(J.Import.class::isInstance)) {
            this.referencedFields.add(ident.getSimpleName());
        }
        return super.visitIdentifier(ident);
    }

    @Override
    public J visitMethodInvocation(J.MethodInvocation method) {
        if (this.methodMatcher.matches(method) && method.getType() != null && method.getType().getDeclaringType().getFullyQualifiedName().equals(this.clazz)) {
            this.referencedMethods.add(method.getName());
        }
        return super.visitMethodInvocation(method);
    }

    private J.CompilationUnit classImportDeletions(J.CompilationUnit cu) {
        if (this.namedImport != null && this.referencedTypes.stream().noneMatch(t -> t.equals(this.clazz))) {
            return this.delete(cu, this.namedImport);
        }
        if (this.starImport != null && this.referencedTypes.isEmpty()) {
            return this.delete(cu, this.starImport);
        }
        if (this.starImport != null && this.referencedTypes.size() == 1) {
            return cu.withImports(cu.getImports().stream().map(i -> i == this.starImport ? new J.Import(Tree.randomId(), (J.FieldAccess)TreeBuilder.buildName(this.referencedTypes.iterator().next(), Formatting.format((String)" ")), false, i.getFormatting()) : i).collect(Collectors.toList()));
        }
        return cu;
    }

    private J.CompilationUnit staticImportDeletions(J.CompilationUnit cu) {
        if (this.staticStarImport != null) {
            JavaType.Class qualidType = TypeUtils.asClass(this.staticStarImport.getQualid().getTarget().getType());
            if (this.referencedMethods.isEmpty() && this.noFieldReferences(qualidType, null)) {
                cu = this.delete(cu, this.staticStarImport);
            }
        }
        for (J.Import staticImport : this.staticNamedImports) {
            String methodOrField = staticImport.getQualid().getSimpleName();
            JavaType.Class qualidType = TypeUtils.asClass(staticImport.getQualid().getTarget().getType());
            if (!this.referencedMethods.stream().noneMatch(m -> m.getSimpleName().equals(methodOrField)) || !this.noFieldReferences(qualidType, methodOrField)) continue;
            cu = this.delete(cu, staticImport);
        }
        return cu;
    }

    private boolean noFieldReferences(@Nullable JavaType.Class qualidType, @Nullable String fieldName) {
        return qualidType == null || (fieldName != null ? !this.referencedFields.contains(fieldName) : this.referencedFields.stream().noneMatch(f -> qualidType.getMembers().stream().anyMatch(v -> f.equals(v.getName())) || qualidType.getVisibleSupertypeMembers().stream().anyMatch(v -> f.equals(v.getName()))));
    }

    private J.CompilationUnit delete(J.CompilationUnit cu, J.Import impoort) {
        return cu.withImports(cu.getImports().stream().filter(i -> i != impoort).collect(Collectors.toList()));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveImport)) {
            return false;
        }
        RemoveImport other = (RemoveImport)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$clazz = this.clazz;
        String other$clazz = other.clazz;
        return !(this$clazz == null ? other$clazz != null : !this$clazz.equals(other$clazz));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RemoveImport;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $clazz = this.clazz;
        result = result * 59 + ($clazz == null ? 43 : $clazz.hashCode());
        return result;
    }
}

