/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.refactor;

import java.util.function.Function;
import org.apache.commons.lang.StringEscapeUtils;
import org.openrewrite.java.refactor.ScopedJavaRefactorVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public class ChangeLiteral
extends ScopedJavaRefactorVisitor {
    private final Function<Object, Object> transform;

    public ChangeLiteral(Expression scope, Function<Object, Object> transform) {
        super(scope.getId());
        this.transform = transform;
    }

    public String getName() {
        return "core.ChangeLiteral";
    }

    @Override
    public J visitLiteral(J.Literal literal) {
        if (this.isScopeInCursorPath()) {
            Object transformedSource;
            Object transformed = this.transform.apply(literal.getValue());
            if (transformed == literal.getValue() || literal.getType() == null) {
                return literal;
            }
            block0 : switch (literal.getType()) {
                case Boolean: 
                case Byte: 
                case Int: 
                case Short: 
                case Void: {
                    transformedSource = transformed.toString();
                    break;
                }
                case Char: {
                    String escaped;
                    switch (escaped = StringEscapeUtils.escapeJavaScript((String)transformed.toString())) {
                        case "\\\"": {
                            transformedSource = "'\"'";
                            break block0;
                        }
                        case "\\/": {
                            transformedSource = "'/'";
                            break block0;
                        }
                    }
                    transformedSource = "'" + escaped + "'";
                    break;
                }
                case Double: {
                    transformedSource = transformed.toString() + "d";
                    break;
                }
                case Float: {
                    transformedSource = transformed.toString() + "f";
                    break;
                }
                case Long: {
                    transformedSource = transformed.toString() + "L";
                    break;
                }
                case String: {
                    transformedSource = "\"" + StringEscapeUtils.escapeJava((String)transformed.toString()) + "\"";
                    break;
                }
                case Wildcard: {
                    transformedSource = "*";
                    break;
                }
                case Null: {
                    transformedSource = "null";
                    break;
                }
                default: {
                    transformedSource = "";
                }
            }
            return literal.withValue(transformed).withValueSource((String)transformedSource);
        }
        return literal;
    }
}

