/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MinimumJava11;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.java.tree.TypeUtilsAssertions;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpec;
import org.openrewrite.test.SourceSpecs;

class TypeUtilsTest
implements RewriteTest {
    TypeUtilsTest() {
    }

    static Consumer<SourceSpec<J.CompilationUnit>> typeIsPresent() {
        return s -> s.afterRecipe(cu -> {
            JavaType.Method fooMethodType = ((J.MethodDeclaration)((J.ClassDeclaration)cu.getClasses().get(0)).getBody().getStatements().get(0)).getMethodType();
            org.assertj.core.api.Assertions.assertThat((Optional)TypeUtils.findOverriddenMethod((JavaType.Method)fooMethodType)).isPresent();
        });
    }

    @Test
    void isOverrideBasicInterface() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"interface Interface {\n    void foo();\n}\n"), Assertions.java((String)"class Clazz implements Interface {\n    @Override void foo() { }\n}\n", TypeUtilsTest.typeIsPresent())});
    }

    @Test
    void isOverrideBasicInheritance() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Superclass {\n    void foo() { }\n}\n"), Assertions.java((String)"class Clazz extends Superclass {\n    @Override void foo() { }\n}\n", TypeUtilsTest.typeIsPresent())});
    }

    @Test
    void isOverrideOnlyVisible() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"package foo;\npublic class Superclass {\n    void foo() { }\n}\n"), Assertions.java((String)"package bar;\nimport foo.Superclass;\nclass Clazz extends Superclass {\n    public void foo() { }\n}\n", s -> s.afterRecipe(cu -> {
            JavaType.Method fooMethodType = ((J.MethodDeclaration)((J.ClassDeclaration)cu.getClasses().get(0)).getBody().getStatements().get(0)).getMethodType();
            org.assertj.core.api.Assertions.assertThat((Optional)TypeUtils.findOverriddenMethod((JavaType.Method)fooMethodType)).isEmpty();
        }))});
    }

    @Test
    void isOverrideParameterizedInterface() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.util.Comparator;\n\nclass TestComparator implements Comparator<String> {\n    @Override public int compare(String o1, String o2) {\n        return 0;\n    }\n}\n", TypeUtilsTest.typeIsPresent())});
    }

    @Test
    void isOverrideParameterizedMethod() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"interface Interface {\n    <T> void foo(T t);\n}\n"), Assertions.java((String)"class Clazz implements Interface {\n    @Override <T> void foo(T t) { }\n}\n", TypeUtilsTest.typeIsPresent())});
    }

    @Test
    void isOverrideConsidersTypeParameterPositions() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"interface Interface <T, Y> {\n     void foo(Y y, T t);\n}\n"), Assertions.java((String)"class Clazz implements Interface<Integer, String> {\n    void foo(Integer t, String y) { }\n\n    @Override\n    void foo(String y, Integer t) { }\n}\n", s -> s.afterRecipe(cu -> {
            List methods = ((J.ClassDeclaration)cu.getClasses().get(0)).getBody().getStatements();
            org.assertj.core.api.Assertions.assertThat((Optional)TypeUtils.findOverriddenMethod((JavaType.Method)((J.MethodDeclaration)methods.get(0)).getMethodType())).isEmpty();
            org.assertj.core.api.Assertions.assertThat((Optional)TypeUtils.findOverriddenMethod((JavaType.Method)((J.MethodDeclaration)methods.get(1)).getMethodType())).isPresent();
        }))});
    }

    @Test
    void arrayIsFullyQualifiedOfType() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    Integer[][] integer1;\n    Integer[] integer2;\n}\n", spec -> spec.afterRecipe(cu -> new JavaIsoVisitor<Object>(this){

            public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, Object o) {
                org.assertj.core.api.Assertions.assertThat((Object)multiVariable.getTypeExpression().getType()).isInstanceOf(JavaType.Array.class);
                org.assertj.core.api.Assertions.assertThat((boolean)TypeUtils.isOfClassType((JavaType)multiVariable.getTypeExpression().getType(), (String)"java.lang.Integer")).isTrue();
                return super.visitVariableDeclarations(multiVariable, o);
            }

            public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, Object o) {
                org.assertj.core.api.Assertions.assertThat((Object)variable.getVariableType().getType()).isInstanceOf(JavaType.Array.class);
                return super.visitVariable(variable, o);
            }
        }.visit((Tree)cu, (Object)new InMemoryExecutionContext())))});
    }

    @Test
    void isFullyQualifiedOfType() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    Integer integer1;\n    Integer integer2;\n}\n", spec -> spec.afterRecipe(cu -> new JavaIsoVisitor<Object>(this){

            public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, Object o) {
                org.assertj.core.api.Assertions.assertThat((Object)variable.getVariableType().getType()).isInstanceOf(JavaType.Class.class);
                return super.visitVariable(variable, o);
            }
        }.visit((Tree)cu, (Object)new InMemoryExecutionContext())))});
    }

    @Test
    void methodWithAnnotationsIsOfType() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    @Deprecated\n    void foo() {}\n}\n", spec -> spec.afterRecipe(cu -> new JavaIsoVisitor<Object>(this){

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, Object o) {
                org.assertj.core.api.Assertions.assertThat((boolean)TypeUtils.isOfType((JavaType)method.getMethodType(), (JavaType)method.getMethodType())).isTrue();
                org.assertj.core.api.Assertions.assertThat((boolean)TypeUtils.isOfType((JavaType)method.getMethodType().withAnnotations(Collections.emptyList()), (JavaType)method.getMethodType())).isTrue();
                org.assertj.core.api.Assertions.assertThat((boolean)TypeUtils.isOfType((JavaType)method.getMethodType(), (JavaType)method.getMethodType().withAnnotations(Collections.emptyList()))).isTrue();
                return method;
            }
        }.visit((Tree)cu, (Object)new InMemoryExecutionContext())))});
    }

    @Test
    void isParameterizedTypeOfType() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    java.util.List<Integer> li;\n    java.util.List<Object> lo;\n}\n", spec -> spec.afterRecipe(cu -> new JavaIsoVisitor<Object>(this){

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, Object o) {
                J.VariableDeclarations.NamedVariable li = (J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)classDecl.getBody().getStatements().get(0)).getVariables().get(0);
                J.VariableDeclarations.NamedVariable lo = (J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)classDecl.getBody().getStatements().get(1)).getVariables().get(0);
                JavaType.Parameterized listIntegerType = (JavaType.Parameterized)li.getVariableType().getType();
                JavaType.Parameterized listObjectType = (JavaType.Parameterized)lo.getVariableType().getType();
                org.assertj.core.api.Assertions.assertThat((boolean)TypeUtils.isAssignableTo((JavaType)listIntegerType.getType(), (JavaType)listIntegerType)).isTrue();
                org.assertj.core.api.Assertions.assertThat((boolean)TypeUtils.isAssignableTo((JavaType)listObjectType, (JavaType)listIntegerType)).isFalse();
                org.assertj.core.api.Assertions.assertThat((boolean)TypeUtils.isAssignableTo((JavaType)listIntegerType, (JavaType)listObjectType)).isFalse();
                return classDecl;
            }
        }.visit((Tree)cu, (Object)new InMemoryExecutionContext())))});
    }

    @Test
    void isAssignableToWildcard() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    java.util.List<?> l = new java.util.ArrayList<String>();\n}\n", spec -> spec.afterRecipe(cu -> new JavaIsoVisitor<Object>(this){

            public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, Object o) {
                JavaType.Parameterized wildcardList = (JavaType.Parameterized)variable.getVariableType().getType();
                JavaType.FullyQualified rawList = wildcardList.getType();
                JavaType.Parameterized stringArrayList = (JavaType.Parameterized)variable.getInitializer().getType();
                org.assertj.core.api.Assertions.assertThat((boolean)TypeUtils.isAssignableTo((JavaType)wildcardList, (JavaType)stringArrayList)).isTrue();
                org.assertj.core.api.Assertions.assertThat((boolean)TypeUtils.isAssignableTo((JavaType)wildcardList, (JavaType)stringArrayList)).isTrue();
                org.assertj.core.api.Assertions.assertThat((boolean)TypeUtils.isAssignableTo((JavaType)wildcardList, (JavaType)rawList)).isTrue();
                return variable;
            }
        }.visit((Tree)cu, (Object)new InMemoryExecutionContext())))});
    }

    @Test
    void isParameterizedTypeWithShallowClassesOfType() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    java.util.List<Integer> integer1;\n}\n", spec -> spec.afterRecipe(cu -> new JavaIsoVisitor<Object>(this){

            public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, Object o) {
                JavaType varType = variable.getVariableType().getType();
                org.assertj.core.api.Assertions.assertThat((Object)varType).isInstanceOf(JavaType.Parameterized.class);
                JavaType.Parameterized shallowParameterizedType = new JavaType.Parameterized(null, (JavaType.FullyQualified)JavaType.ShallowClass.build((String)"java.util.List"), Collections.singletonList(JavaType.ShallowClass.build((String)"java.lang.Integer")));
                org.assertj.core.api.Assertions.assertThat((boolean)TypeUtils.isOfType((JavaType)varType, (JavaType)shallowParameterizedType)).isTrue();
                return super.visitVariable(variable, o);
            }
        }.visit((Tree)cu, (Object)new InMemoryExecutionContext())))});
    }

    @Test
    void isAssignableToGenericTypeVariable1() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.util.Map;\nimport java.util.function.Supplier;\n\nclass Test {\n    <K, V> void m(Supplier<? extends Map<K, ? extends V>> map) {\n    }\n    void foo() {\n        Map<String, Integer> map = null;\n        m(() -> map);\n    }\n}\n", spec -> spec.afterRecipe(cu -> new JavaIsoVisitor<Object>(this){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, Object o) {
                JavaType paramType = (JavaType)method.getMethodType().getParameterTypes().get(0);
                org.assertj.core.api.Assertions.assertThat((Object)paramType).isInstanceOf(JavaType.Parameterized.class);
                JavaType argType = ((Expression)method.getArguments().get(0)).getType();
                org.assertj.core.api.Assertions.assertThat((Object)argType).isInstanceOf(JavaType.Parameterized.class);
                org.assertj.core.api.Assertions.assertThat((boolean)TypeUtils.isAssignableTo((JavaType)paramType, (JavaType)argType)).isTrue();
                return method;
            }
        }.visit((Tree)cu, (Object)new InMemoryExecutionContext())))});
    }

    @MinimumJava11
    @Test
    void isAssignableToGenericTypeVariable2() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.util.Collection;\nimport java.util.List;\n\nclass Test {\n    public <T extends Collection<String>> T test() {\n        return (T) get();\n    }\n    public List<String> get() {\n        return List.of(\"a\", \"b\", \"c\");\n    }\n}\n", spec -> spec.afterRecipe(cu -> new JavaIsoVisitor<Object>(this){

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, Object o) {
                if ("test".equals(method.getSimpleName())) {
                    J.Return return_ = (J.Return)method.getBody().getStatements().get(0);
                    J.TypeCast cast = (J.TypeCast)return_.getExpression();
                    org.assertj.core.api.Assertions.assertThat((boolean)TypeUtils.isAssignableTo((JavaType)cast.getType(), (JavaType)cast.getExpression().getType(), (TypeUtils.ComparisonContext)TypeUtils.ComparisonContext.BOUND)).isFalse();
                    org.assertj.core.api.Assertions.assertThat((boolean)TypeUtils.isAssignableTo((JavaType)cast.getType(), (JavaType)cast.getExpression().getType(), (TypeUtils.ComparisonContext)TypeUtils.ComparisonContext.INFER)).isTrue();
                }
                return method;
            }
        }.visit((Tree)cu, (Object)new InMemoryExecutionContext())))});
    }

    @Test
    void isAssignableToGenericTypeVariable3() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.util.Collection;\nimport java.util.List;\n\nimport static java.util.Collections.singletonList;\n\nclass Test<T extends Collection<String>> {\n\n    void consumeClass(T collection) {\n    }\n\n    <T extends Collection<String>> void consumeMethod(T collection) {\n    }\n\n    void test() {\n        List<String> list = singletonList(\"hello\");\n        consumeMethod(null);\n        consumeClass(null);\n    }\n}\n", spec -> spec.afterRecipe(cu -> new JavaIsoVisitor<Object>(this){

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, Object o) {
                if ("test".equals(method.getSimpleName())) {
                    J.Block block = (J.Block)this.getCursor().getParentTreeCursor().getValue();
                    J.MethodDeclaration consumeClass = (J.MethodDeclaration)block.getStatements().get(0);
                    J.MethodDeclaration consumeMethod = (J.MethodDeclaration)block.getStatements().get(1);
                    J.VariableDeclarations.NamedVariable list = (J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)method.getBody().getStatements().get(0)).getVariables().get(0);
                    JavaType consumeClassParamType = ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)consumeClass.getParameters().get(0)).getVariables().get(0)).getType();
                    JavaType consumeMethodParamType = ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)consumeMethod.getParameters().get(0)).getVariables().get(0)).getType();
                    org.assertj.core.api.Assertions.assertThat((boolean)TypeUtils.isAssignableTo((JavaType)consumeClassParamType, (JavaType)list.getType(), (TypeUtils.ComparisonContext)TypeUtils.ComparisonContext.INFER)).isTrue();
                    org.assertj.core.api.Assertions.assertThat((boolean)TypeUtils.isAssignableTo((JavaType)consumeMethodParamType, (JavaType)list.getType(), (TypeUtils.ComparisonContext)TypeUtils.ComparisonContext.INFER)).isTrue();
                }
                return method;
            }
        }.visit((Tree)cu, (Object)new InMemoryExecutionContext())))});
    }

    @Test
    void isAssignableToLong() {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Long, (JavaType)JavaType.Primitive.Long));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Long, (JavaType)JavaType.Primitive.Int));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Long, (JavaType)JavaType.Primitive.Short));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Long, (JavaType)JavaType.Primitive.Char));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Long, (JavaType)JavaType.Primitive.Byte));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Long, (JavaType)JavaType.Primitive.Double));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Long, (JavaType)JavaType.Primitive.Float));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Long, (JavaType)JavaType.Primitive.Boolean));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Long, (JavaType)JavaType.Primitive.None));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Long, (JavaType)JavaType.Primitive.Void));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Long, (JavaType)JavaType.Primitive.String));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Long, (JavaType)JavaType.Primitive.Null));
    }

    @Test
    void isAssignableToInt() {
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Int, (JavaType)JavaType.Primitive.Long));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Int, (JavaType)JavaType.Primitive.Int));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Int, (JavaType)JavaType.Primitive.Short));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Int, (JavaType)JavaType.Primitive.Char));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Int, (JavaType)JavaType.Primitive.Byte));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Int, (JavaType)JavaType.Primitive.Double));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Int, (JavaType)JavaType.Primitive.Float));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Int, (JavaType)JavaType.Primitive.Boolean));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Int, (JavaType)JavaType.Primitive.None));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Int, (JavaType)JavaType.Primitive.Void));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Int, (JavaType)JavaType.Primitive.String));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Int, (JavaType)JavaType.Primitive.Null));
    }

    @Test
    void isAssignableToShort() {
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Short, (JavaType)JavaType.Primitive.Long));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Short, (JavaType)JavaType.Primitive.Int));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Short, (JavaType)JavaType.Primitive.Short));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Short, (JavaType)JavaType.Primitive.Char));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Short, (JavaType)JavaType.Primitive.Byte));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Short, (JavaType)JavaType.Primitive.Double));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Short, (JavaType)JavaType.Primitive.Float));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Short, (JavaType)JavaType.Primitive.Boolean));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Short, (JavaType)JavaType.Primitive.None));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Short, (JavaType)JavaType.Primitive.Void));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Short, (JavaType)JavaType.Primitive.String));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Short, (JavaType)JavaType.Primitive.Null));
    }

    @Test
    void isAssignableToChar() {
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Char, (JavaType)JavaType.Primitive.Long));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Char, (JavaType)JavaType.Primitive.Int));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Char, (JavaType)JavaType.Primitive.Short));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Char, (JavaType)JavaType.Primitive.Char));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Char, (JavaType)JavaType.Primitive.Byte));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Char, (JavaType)JavaType.Primitive.Double));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Char, (JavaType)JavaType.Primitive.Float));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Char, (JavaType)JavaType.Primitive.Boolean));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Char, (JavaType)JavaType.Primitive.None));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Char, (JavaType)JavaType.Primitive.Void));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Char, (JavaType)JavaType.Primitive.String));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Char, (JavaType)JavaType.Primitive.Null));
    }

    @Test
    void isAssignableToByte() {
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Byte, (JavaType)JavaType.Primitive.Long));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Byte, (JavaType)JavaType.Primitive.Int));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Byte, (JavaType)JavaType.Primitive.Short));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Byte, (JavaType)JavaType.Primitive.Char));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Byte, (JavaType)JavaType.Primitive.Byte));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Byte, (JavaType)JavaType.Primitive.Double));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Byte, (JavaType)JavaType.Primitive.Float));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Byte, (JavaType)JavaType.Primitive.Boolean));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Byte, (JavaType)JavaType.Primitive.None));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Byte, (JavaType)JavaType.Primitive.Void));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Byte, (JavaType)JavaType.Primitive.String));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Byte, (JavaType)JavaType.Primitive.Null));
    }

    @Test
    void isAssignableToDouble() {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Double, (JavaType)JavaType.Primitive.Long));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Double, (JavaType)JavaType.Primitive.Int));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Double, (JavaType)JavaType.Primitive.Short));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Double, (JavaType)JavaType.Primitive.Char));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Double, (JavaType)JavaType.Primitive.Byte));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Double, (JavaType)JavaType.Primitive.Double));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Double, (JavaType)JavaType.Primitive.Float));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Double, (JavaType)JavaType.Primitive.Boolean));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Double, (JavaType)JavaType.Primitive.None));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Double, (JavaType)JavaType.Primitive.Void));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Double, (JavaType)JavaType.Primitive.String));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Double, (JavaType)JavaType.Primitive.Null));
    }

    @Test
    void isAssignableToFloat() {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Float, (JavaType)JavaType.Primitive.Long));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Float, (JavaType)JavaType.Primitive.Int));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Float, (JavaType)JavaType.Primitive.Short));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Float, (JavaType)JavaType.Primitive.Char));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Float, (JavaType)JavaType.Primitive.Byte));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Float, (JavaType)JavaType.Primitive.Double));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Float, (JavaType)JavaType.Primitive.Float));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Float, (JavaType)JavaType.Primitive.Boolean));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Float, (JavaType)JavaType.Primitive.None));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Float, (JavaType)JavaType.Primitive.Void));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Float, (JavaType)JavaType.Primitive.String));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Float, (JavaType)JavaType.Primitive.Null));
    }

    @Test
    void isAssignableToBoolean() {
        EnumSet<JavaType.Primitive> others = EnumSet.complementOf(EnumSet.of(JavaType.Primitive.Boolean));
        for (JavaType.Primitive other : others) {
            org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Boolean, (JavaType)other));
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Boolean, (JavaType)JavaType.Primitive.Boolean));
    }

    @Test
    void arrayIsAssignableToObject() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    Object o;\n    Object[] oa;\n    String[] sa;\n    int[] ia;\n}\n", spec -> spec.afterRecipe(cu -> new JavaIsoVisitor<ExecutionContext>(this){

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                J.VariableDeclarations o = (J.VariableDeclarations)classDecl.getBody().getStatements().get(0);
                J.VariableDeclarations oa = (J.VariableDeclarations)classDecl.getBody().getStatements().get(1);
                J.VariableDeclarations sa = (J.VariableDeclarations)classDecl.getBody().getStatements().get(2);
                J.VariableDeclarations ia = (J.VariableDeclarations)classDecl.getBody().getStatements().get(3);
                JavaType object = o.getType();
                JavaType objectArray = oa.getType();
                JavaType stringArray = sa.getType();
                JavaType intArray = ia.getType();
                org.assertj.core.api.Assertions.assertThat((boolean)TypeUtils.isAssignableTo((JavaType)object, (JavaType)objectArray)).isTrue();
                org.assertj.core.api.Assertions.assertThat((boolean)TypeUtils.isAssignableTo((JavaType)object, (JavaType)stringArray)).isTrue();
                org.assertj.core.api.Assertions.assertThat((boolean)TypeUtils.isAssignableTo((JavaType)objectArray, (JavaType)stringArray)).isTrue();
                org.assertj.core.api.Assertions.assertThat((boolean)TypeUtils.isAssignableTo((JavaType)stringArray, (JavaType)objectArray)).isFalse();
                org.assertj.core.api.Assertions.assertThat((boolean)TypeUtils.isAssignableTo((JavaType)object, (JavaType)intArray)).isTrue();
                org.assertj.core.api.Assertions.assertThat((boolean)TypeUtils.isAssignableTo((JavaType)objectArray, (JavaType)intArray)).isFalse();
                return classDecl;
            }
        }.visit((Tree)cu, (Object)new InMemoryExecutionContext())))});
    }

    @Test
    void isAssignableToNone() {
        EnumSet<JavaType.Primitive> others = EnumSet.complementOf(EnumSet.of(JavaType.Primitive.None));
        for (JavaType.Primitive other : others) {
            org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.None, (JavaType)other));
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.None, (JavaType)JavaType.Primitive.None));
    }

    @Test
    void isAssignableToVoid() {
        EnumSet<JavaType.Primitive> others = EnumSet.complementOf(EnumSet.of(JavaType.Primitive.Void));
        for (JavaType.Primitive other : others) {
            org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Void, (JavaType)other));
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.Void, (JavaType)JavaType.Primitive.Void));
    }

    @Test
    void isAssignableToString() {
        EnumSet<JavaType.Primitive> others = EnumSet.complementOf(EnumSet.of(JavaType.Primitive.String, JavaType.Primitive.Null));
        for (JavaType.Primitive other : others) {
            org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.String, (JavaType)other));
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.String, (JavaType)JavaType.Primitive.String));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.Primitive.String, (JavaType)JavaType.Primitive.Null));
    }

    @Test
    void isAssignableToPrimitiveArrays() {
        JavaType.Array intArray = new JavaType.Array(null, (JavaType)JavaType.Primitive.Int, null);
        JavaType.Array longArray = new JavaType.Array(null, (JavaType)JavaType.Primitive.Long, null);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)intArray, (JavaType)intArray));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)longArray, (JavaType)intArray));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)intArray, (JavaType)longArray));
    }

    @Test
    void isAssignableToNonPrimitiveArrays() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    Object[] oa;\n    String[] sa;\n}\n", spec -> spec.afterRecipe(cu -> new JavaIsoVisitor<Object>(this){

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, Object o) {
                J.VariableDeclarations oa = (J.VariableDeclarations)classDecl.getBody().getStatements().get(0);
                J.VariableDeclarations sa = (J.VariableDeclarations)classDecl.getBody().getStatements().get(1);
                JavaType objectArray = oa.getType();
                JavaType stringArray = sa.getType();
                org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)objectArray, (JavaType)objectArray));
                org.junit.jupiter.api.Assertions.assertFalse((boolean)TypeUtils.isAssignableTo((JavaType)stringArray, (JavaType)objectArray));
                org.junit.jupiter.api.Assertions.assertTrue((boolean)TypeUtils.isAssignableTo((JavaType)objectArray, (JavaType)stringArray));
                return classDecl;
            }
        }.visit((Tree)cu, (Object)new InMemoryExecutionContext())))});
    }

    @Test
    void isAssignableFromIntersection() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.io.Serializable;\n\nclass Test {\n    Object o1 = (Serializable & Runnable) null;\n}\n", spec -> spec.afterRecipe(cu -> new JavaIsoVisitor<Object>(this){

            public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, Object o) {
                JavaType variableType = variable.getVariableType().getType();
                org.assertj.core.api.Assertions.assertThat((Object)variableType).satisfies(new ThrowingConsumer[]{type -> org.assertj.core.api.Assertions.assertThat((Object)type).isInstanceOf(JavaType.Class.class), type -> org.assertj.core.api.Assertions.assertThat((String)((JavaType.Class)type).getFullyQualifiedName()).isEqualTo("java.lang.Object")});
                J.TypeCast typeCast = (J.TypeCast)variable.getInitializer();
                org.assertj.core.api.Assertions.assertThat((Object)typeCast.getType()).satisfies(new ThrowingConsumer[]{type -> org.assertj.core.api.Assertions.assertThat((Object)type).isInstanceOf(JavaType.Intersection.class), type -> org.assertj.core.api.Assertions.assertThat((List)((JavaType.Intersection)type).getBounds()).satisfiesExactly(new ThrowingConsumer[]{bound -> org.assertj.core.api.Assertions.assertThat((String)((JavaType.Class)bound).getFullyQualifiedName()).isEqualTo("java.io.Serializable"), bound -> org.assertj.core.api.Assertions.assertThat((String)((JavaType.Class)bound).getFullyQualifiedName()).isEqualTo("java.lang.Runnable")}), type -> org.assertj.core.api.Assertions.assertThat((List)((JavaType.Intersection)type).getBounds()).allSatisfy(bound -> {
                    org.assertj.core.api.Assertions.assertThat((boolean)TypeUtils.isAssignableTo((JavaType)bound, (JavaType)type)).isTrue();
                    org.assertj.core.api.Assertions.assertThat((boolean)TypeUtils.isAssignableTo((String)((JavaType.FullyQualified)bound).getFullyQualifiedName(), (JavaType)type)).isTrue();
                }), type -> org.assertj.core.api.Assertions.assertThat((boolean)TypeUtils.isAssignableTo((JavaType)JavaType.ShallowClass.build((String)"java.lang.Object"), (JavaType)type)).isTrue(), type -> org.assertj.core.api.Assertions.assertThat((boolean)TypeUtils.isAssignableTo((String)"java.lang.Object", (JavaType)type)).isTrue()});
                return variable;
            }
        }.visit((Tree)cu, (Object)new InMemoryExecutionContext())))});
    }

    @Test
    void isWellFormedType() {
        this.rewriteRun(spec -> spec.recipe((Recipe)RewriteTest.toRecipe(() -> new JavaIsoVisitor<ExecutionContext>(this){

            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
                org.assertj.core.api.Assertions.assertThat((Collection)cu.getTypesInUse().getTypesInUse()).allMatch(TypeUtils::isWellFormedType);
                return cu;
            }
        })), new SourceSpecs[]{Assertions.java((String)"import java.io.Serializable;\n\nclass Test {\n    static <T extends Serializable &\n            Comparable<T>> T method0() {\n        return null;\n    }\n\n    static <T extends Serializable> T method1() {\n        return null;\n    }\n}\n")});
    }

    @Test
    void typeToString() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.io.*;\nimport java.util.*;\n\n@SuppressWarnings(\"all\")\npublic class Test<A extends B, B extends Number, C extends Comparable<? super C> & Serializable> {\n\n    // Plain generics\n    A a;\n    B b;\n    C c;\n\n    // Parameterized\n    Optional<A> oa;\n    Optional<B> ob;\n    Optional<C> oc;\n\n    // Wildcards\n    Optional<?> ow;\n    Optional<? extends A> oea;\n    Optional<? extends B> oeb;\n    Optional<? extends C> oec;\n    Optional<? super A> osa;\n    Optional<? super B> osb;\n    Optional<? super C> osc;\n\n    // === Raw types ===\n    List rawList;\n    Map rawMap;\n\n    // === Recursive generic ===\n    static class Recursive<T extends Comparable<T>> {}\n    Recursive<Recursive<String>> rec;\n\n    // === Arrays ===\n    int[] intArray;\n    boolean[] boolArray;\n    String[] stringArray;\n    Map<?, String>[][] wildcardArray;\n}\n", spec -> spec.afterRecipe(cu -> new JavaIsoVisitor<Object>(this){

            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, Object o) {
                try (TypeUtilsAssertions assertions = new TypeUtilsAssertions(cu);){
                    assertions.toGenericTypeString("A").isEqualTo("A extends B");
                    assertions.toGenericTypeString("B").isEqualTo("B extends java.lang.Number");
                    assertions.toGenericTypeString("C").isEqualTo("C extends java.lang.Comparable<? super C> & java.io.Serializable");
                    assertions.toString("int").isEqualTo("int");
                    assertions.toString("long").isEqualTo("long");
                    assertions.toString("double").isEqualTo("double");
                    assertions.toString("boolean").isEqualTo("boolean");
                    assertions.toString("A").isEqualTo("A");
                    assertions.toString("B").isEqualTo("B");
                    assertions.toString("C").isEqualTo("C");
                    assertions.toString("Optional<A>").isEqualTo("java.util.Optional<A>");
                    assertions.toString("Optional<B>").isEqualTo("java.util.Optional<B>");
                    assertions.toString("Optional<C>").isEqualTo("java.util.Optional<C>");
                    assertions.toString("Optional<?>").isEqualTo("java.util.Optional<?>");
                    assertions.toString("Optional<? extends A>").isEqualTo("java.util.Optional<? extends A>");
                    assertions.toString("Optional<? extends B>").isEqualTo("java.util.Optional<? extends B>");
                    assertions.toString("Optional<? extends C>").isEqualTo("java.util.Optional<? extends C>");
                    assertions.toString("Optional<? super A>").isEqualTo("java.util.Optional<? super A>");
                    assertions.toString("Optional<? super B>").isEqualTo("java.util.Optional<? super B>");
                    assertions.toString("Optional<? super C>").isEqualTo("java.util.Optional<? super C>");
                    assertions.toString("List").isEqualTo("java.util.List");
                    assertions.toString("Map").isEqualTo("java.util.Map");
                    assertions.toString("Recursive<Recursive<String>>").isEqualTo("Test$Recursive<Test$Recursive<java.lang.String>>");
                    assertions.toString("int[]").isEqualTo("int[]");
                    assertions.toString("boolean[]").isEqualTo("boolean[]");
                    assertions.toString("String[]").isEqualTo("java.lang.String[]");
                    assertions.toString("Map<?, String>[][]").isEqualTo("java.util.Map<?, java.lang.String>[][]");
                }
                return cu;
            }
        }.visit((Tree)cu, (Object)new InMemoryExecutionContext())))});
    }

    @MinimumJava11
    @Test
    void typeToString2() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.io.*;\nimport java.util.*;\n\n@SuppressWarnings(\"all\")\npublic class Test {\n    void test() {\n        var intersection = (Cloneable & Serializable) null;\n        try {} catch (NullPointerException | IllegalArgumentException exception) {}\n    }\n}\n", spec -> spec.afterRecipe(cu -> new JavaIsoVisitor<Object>(this){

            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, Object o) {
                try (TypeUtilsAssertions assertions = new TypeUtilsAssertions(cu);){
                    assertions.toString("intersection").isEqualTo("java.lang.Cloneable & java.io.Serializable");
                    assertions.toString("exception").isEqualTo("java.lang.RuntimeException");
                    assertions.toString("NullPointerException | IllegalArgumentException").isEqualTo("java.lang.NullPointerException | java.lang.IllegalArgumentException");
                }
                return cu;
            }
        }.visit((Tree)cu, (Object)new InMemoryExecutionContext())))});
    }

    @Test
    void toStringRecursiveType() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.io.*;\nimport java.util.*;\n\nabstract class Rec<T extends Rec<T>> {}\n\nabstract class One<TwoT extends Two<TwoT, OneT>, OneT extends One<TwoT, OneT>> {}\nabstract class Two<TwoT extends Two<TwoT, OneT>, OneT extends One<TwoT, OneT>> {}\n\n@SuppressWarnings(\"all\")\npublic class Test {\n    void run(Rec<?> r, One<?, ?> m) {\n        Optional.of(r).get();\n        Optional.of(m).get();\n\n        Optional.of(r).ifPresent(sr -> {});\n        Optional.of(m).ifPresent(sm -> {});\n    }\n}\n", spec -> spec.afterRecipe(cu -> new JavaIsoVisitor<Object>(this){

            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, Object o) {
                try (TypeUtilsAssertions assertions = new TypeUtilsAssertions(cu);){
                    assertions.toString("r").isEqualTo("Rec<?>");
                    assertions.toString("Optional.of(r)").isEqualTo("java.util.Optional<Rec<?>>");
                    assertions.toString("Optional.of(r).get()").isEqualTo("Rec<?>");
                    assertions.toString("sr").isEqualTo("Rec<?>");
                    assertions.toString("m").isEqualTo("One<?, ?>");
                    assertions.toString("Optional.of(m)").isEqualTo("java.util.Optional<One<?, ?>>");
                    assertions.toString("Optional.of(m).get()").isEqualTo("One<?, ?>");
                    assertions.toString("sm").isEqualTo("One<?, ?>");
                }
                return cu;
            }
        }.visit((Tree)cu, (Object)new InMemoryExecutionContext())))});
    }

    @Test
    void isOfType() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.util.List;\nimport java.util.Map;\n\nclass Test<T extends Number, U extends List<String>, V extends U, X> {\n    Integer integer;\n    int[] intArray;\n    Integer[] integerArray;\n    String[] stringArray;\n    List<String>[] genericArray;\n    Integer[][] nestedArray;\n    T[] tArray;\n    U[] uArray;\n    V[] vArray;\n    X[] xArray;\n\n    T numberType;\n    U listType;\n    V nestedListType;\n    X generic;\n\n    List<T> numberList;\n    List<String> listString;\n    Map<String, T> stringToNumberMap;\n    Map<String, X> stringToGenericMap;\n\n    List<? extends Number> extendsNumberList;\n    List<? super Integer> superIntegerList;\n\n    Map<String, List<Map<Integer, String>>> complexNested;\n}\n", spec -> spec.afterRecipe(cu -> {
            try (TypeUtilsAssertions assertions = new TypeUtilsAssertions((J.CompilationUnit)cu);){
                assertions.isOfType("int", "int").isTrue();
                assertions.isOfType("int", "Integer").isFalse();
                assertions.isOfType("Integer", "int").isFalse();
                assertions.isOfType("int[]", "int[]").isTrue();
                assertions.isOfType("Integer[]", "Integer[]").isTrue();
                assertions.isOfType("Integer[]", "int[]").isFalse();
                assertions.isOfType("int[]", "Integer[]").isFalse();
                assertions.isOfType("Integer[][]", "Integer[][]").isTrue();
                assertions.isOfType("List<String>[]", "List<String>[]").isTrue();
                assertions.isOfType("List<String>[]", "String[]").isFalse();
                assertions.isOfType("int[]", "String[]").isFalse();
                assertions.isOfType("List<String>[]", "String[]").isFalse();
                assertions.isOfType("T[]", "T[]").isTrue();
                assertions.isOfType("U[]", "U[]").isTrue();
                assertions.isOfType("T[]", "Integer[]").isFalse();
                assertions.isOfType("U[]", "List<String>[]").isFalse();
                assertions.isOfType("Integer[][]", "T[]").isFalse();
                assertions.isOfType("T[]", "Integer[][]").isFalse();
                assertions.isOfType("U[]", "Integer[][]").isFalse();
                assertions.isOfType("U[]", "V[]").isFalse();
                assertions.isOfType("V[]", "U[]").isFalse();
                assertions.isOfType("Integer[][]", "int[]").isFalse();
                assertions.isOfType("T", "T").isTrue();
                assertions.isOfType("U", "U").isTrue();
                assertions.isOfType("V", "V").isTrue();
                assertions.isOfType("T", "Integer").isFalse();
                assertions.isOfType("T", "Integer").isFalse();
                assertions.isOfType("U", "V").isFalse();
                assertions.isOfType("T", "U").isFalse();
                assertions.isOfType("List<T>", "List<T>").isTrue();
                assertions.isOfType("List<? extends Number>", "List<? extends Number>").isTrue();
                assertions.isOfType("Map<String, List<Map<Integer, String>>>", "Map<String, List<Map<Integer, String>>>").isTrue();
                assertions.isOfType("List<T>", "List<? extends Number>").isFalse();
                assertions.isOfType("List<? extends Number>", "List<T>").isFalse();
                assertions.isOfType("T", "Integer", TypeUtils.ComparisonContext.INFER).isTrue();
                assertions.isOfType("U", "Integer", TypeUtils.ComparisonContext.INFER).isFalse();
                assertions.isOfType("U", "List<String>", TypeUtils.ComparisonContext.INFER).isTrue();
                assertions.isOfType("V", "List<String>", TypeUtils.ComparisonContext.INFER).isTrue();
                assertions.isOfType("T", "Integer[]", TypeUtils.ComparisonContext.INFER).isFalse();
                assertions.isOfType("X", "Integer[]", TypeUtils.ComparisonContext.INFER).isTrue();
                assertions.isOfType("T", "int[]", TypeUtils.ComparisonContext.INFER).isFalse();
                assertions.isOfType("X", "int[]", TypeUtils.ComparisonContext.INFER).isTrue();
                assertions.isOfType("T[]", "int[]", TypeUtils.ComparisonContext.INFER).isFalse();
                assertions.isOfType("X[]", "int[]", TypeUtils.ComparisonContext.INFER).isFalse();
                assertions.isOfType("T[]", "Integer[]", TypeUtils.ComparisonContext.INFER).isTrue();
                assertions.isOfType("X[]", "Integer[]", TypeUtils.ComparisonContext.INFER).isTrue();
                assertions.isOfType("U[]", "List<String>[]", TypeUtils.ComparisonContext.INFER).isTrue();
                assertions.isOfType("V[]", "List<String>[]", TypeUtils.ComparisonContext.INFER).isTrue();
                assertions.isOfType("Integer[][]", "T[]", TypeUtils.ComparisonContext.INFER).isFalse();
                assertions.isOfType("X[]", "Integer[][]", TypeUtils.ComparisonContext.INFER).isTrue();
                assertions.isOfType("T[]", "Integer[][]", TypeUtils.ComparisonContext.INFER).isFalse();
                assertions.isOfType("U[]", "V[]", TypeUtils.ComparisonContext.INFER).isTrue();
                assertions.isOfType("V[]", "U[]", TypeUtils.ComparisonContext.INFER).isTrue();
                assertions.isOfType("Integer[][]", "int[]", TypeUtils.ComparisonContext.INFER).isFalse();
                assertions.isOfType("Map<String, T>", "Map<String, List<Map<Integer, String>>>", TypeUtils.ComparisonContext.INFER).isFalse();
                assertions.isOfType("Map<String, X>", "Map<String, List<Map<Integer, String>>>", TypeUtils.ComparisonContext.INFER).isTrue();
                assertions.isOfType("Map<String, List<Map<Integer, String>>>", "Map<String, T>", TypeUtils.ComparisonContext.INFER).isFalse();
            }
        }))});
    }

    @Test
    void isClassAssignableTo() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.io.Serializable;\nimport java.util.ArrayList;\nimport java.util.Collection;\nimport java.util.List;\n\n@SuppressWarnings(\"all\")\nclass Test<T extends Number & Serializable, U> {\n    Integer integer;\n    Boolean bool;\n    Double bool;\n    Number number;\n    Cloneable cloneable;\n    Serializable serializable;\n    String[] array;\n\n    Object obj;\n    String str;\n    List listRaw;\n    Collection collectionRaw;\n    ArrayList arrayListRaw;\n    List<String> listString;\n    T genericBounded;\n    U generic;\n}\n", spec -> spec.afterRecipe(cu -> {
            try (TypeUtilsAssertions assertions = new TypeUtilsAssertions((J.CompilationUnit)cu);){
                assertions.isAssignableTo("Integer", "int").isTrue();
                assertions.isAssignableTo("Number", "int").isTrue();
                assertions.isAssignableTo("Serializable", "int").isTrue();
                assertions.isAssignableTo("Boolean", "boolean").isTrue();
                assertions.isAssignableTo("Number", "boolean").isFalse();
                assertions.isAssignableTo("Serializable", "boolean").isTrue();
                assertions.isAssignableTo("Double", "double").isTrue();
                assertions.isAssignableTo("Number", "double").isTrue();
                assertions.isAssignableTo("Serializable", "double").isTrue();
                assertions.isAssignableTo("String", "int").isFalse();
                assertions.isAssignableTo("Object", "String").isTrue();
                assertions.isAssignableTo("String", "Object").isFalse();
                assertions.isAssignableTo("List", "String").isFalse();
                assertions.isAssignableTo("String", "null").isTrue();
                assertions.isAssignableTo("List", "null").isTrue();
                assertions.isAssignableTo("List", "List<String>").isTrue();
                assertions.isAssignableTo("Serializable", "String").isTrue();
                assertions.isAssignableTo("Collection", "ArrayList").isTrue();
                assertions.isAssignableTo("String", "Serializable").isFalse();
                assertions.isAssignableTo("Object", "String[]").isTrue();
                assertions.isAssignableTo("Cloneable", "String[]").isTrue();
                assertions.isAssignableTo("Serializable", "String[]").isTrue();
                assertions.isAssignableTo("Serializable", "T").isTrue();
                assertions.isAssignableTo("Number", "T").isTrue();
                assertions.isAssignableTo("String", "T").isFalse();
                assertions.isAssignableTo("Object", "T").isTrue();
                assertions.isAssignableTo("Number", "U").isFalse();
                assertions.isAssignableTo("Number", "U").isFalse();
                assertions.isAssignableTo("Object", "U").isTrue();
            }
        }))});
    }

    @Test
    void isParameterizedAssignableTo() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.util.*;\nimport java.util.function.Supplier;\n\nclass Test<T, U extends T, N extends Number, CS extends CharSequence> {\n    ArrayList v1;\n    Comparable<?> v2;\n    Comparable<ImplementsComparable> v3;\n    Comparable<Number> v4;\n    Comparable<String> v5;\n    ComparableSupplier<String, Number> v6;\n    ExtendsComparable v7;\n    List v8;\n    List<? extends CharSequence> v9;\n    List<? extends List<? extends CharSequence>> v10;\n    List<? super String> v11;\n    List<? super CharSequence> v25;\n    List<? super T> v26;\n    List<? super U> v27;\n    List<?> v12;\n    List<CS> v13;\n    List<CharSequence> v14;\n    List<List<? extends CharSequence>> v15;\n    List<List<String>> v16;\n    List<N> v17;\n    List<String> v18;\n    List<T> v19;\n    List<U> v20;\n    MySupplier<Number> v21;\n    Supplier<Number> v22;\n    Supplier<String> v23;\n    ImplementsComparable v24;\n    Map<N, N> mapNN;\n    Map<String, String> mapSS;\n    Map<Integer, Integer> mapII;\n    Map<Long, Integer> mapLI;\n\n    static abstract class ImplementsComparable implements Comparable<ImplementsComparable> {}\n    static abstract class ExtendsComparable extends ImplementsComparable {}\n    static abstract class MySupplier<T> implements Supplier<T> {}\n    static abstract class ComparableSupplier<T, U> extends MySupplier<U> implements Comparable<T> {}\n}\n", spec -> spec.afterRecipe(cu -> {
            try (TypeUtilsAssertions assertions = new TypeUtilsAssertions((J.CompilationUnit)cu);){
                assertions.isAssignableTo("List<? extends CharSequence>", "List<String>").isTrue();
                assertions.isAssignableTo("List<String>", "List<? extends CharSequence>").isFalse();
                assertions.isAssignableTo("List<? super String>", "List<CharSequence>").isTrue();
                assertions.isAssignableTo("List<?>", "List<String>").isTrue();
                assertions.isAssignableTo("List<?>", "ArrayList").isTrue();
                assertions.isAssignableTo("List<String>", "List").isFalse();
                assertions.isAssignableTo("List<?>", "List").isTrue();
                assertions.isAssignableTo("Comparable<?>", "ImplementsComparable").isTrue();
                assertions.isAssignableTo("Comparable<ImplementsComparable>", "ImplementsComparable").isTrue();
                assertions.isAssignableTo("Comparable<ImplementsComparable>", "ExtendsComparable").isTrue();
                assertions.isAssignableTo("Comparable<?>", "ExtendsComparable").isTrue();
                assertions.isAssignableTo("Comparable<String>", "ExtendsComparable").isFalse();
                assertions.isAssignableTo("Comparable<String>", "ComparableSupplier<String, Number>").isTrue();
                assertions.isAssignableTo("Comparable<Number>", "ComparableSupplier<String, Number>").isFalse();
                assertions.isAssignableTo("Supplier<Number>", "ComparableSupplier<String, Number>").isTrue();
                assertions.isAssignableTo("Supplier<String>", "ComparableSupplier<String, Number>").isFalse();
                assertions.isAssignableTo("MySupplier<Number>", "ComparableSupplier<String, Number>").isTrue();
                assertions.isAssignableTo("Comparable<?>", "ComparableSupplier<String, Number>").isTrue();
                assertions.isAssignableTo("List<T>", "List<String>").isFalse();
                assertions.isAssignableTo("List<T>", "List<U>").isFalse();
                assertions.isAssignableTo("List<? extends CharSequence>", "List<CS>").isTrue();
                assertions.isAssignableTo("List<? super U>", "List<? super T>").isTrue();
                assertions.isAssignableTo("List<? super String>", "List<? super CharSequence>").isTrue();
                assertions.isAssignableTo("List<? super T>", "List<? super U>").isFalse();
                assertions.isAssignableTo("List<? super CharSequence>", "List<? super String>").isFalse();
                assertions.isAssignableTo("List<? extends List<? extends CharSequence>>", "List<List<String>>").isTrue();
                assertions.isAssignableTo("List<List<? extends CharSequence>>", "List<List<String>>").isFalse();
                assertions.isAssignableTo("List<T>", "List<String>", TypeUtils.ComparisonContext.INFER).isTrue();
                assertions.isAssignableTo("List<CS>", "List<String>", TypeUtils.ComparisonContext.INFER).isTrue();
                assertions.isAssignableTo("List<N>", "List<String>", TypeUtils.ComparisonContext.INFER).isFalse();
                assertions.isAssignableTo("List<? super T>", "List<? super String>", TypeUtils.ComparisonContext.INFER).isTrue();
                assertions.isAssignableTo("Map<N, N>", "Map<String, String>", TypeUtils.ComparisonContext.INFER).isFalse();
                assertions.isAssignableTo("Map<N, N>", "Map<Integer, Integer>", TypeUtils.ComparisonContext.INFER).isTrue();
                assertions.isAssignableTo("Map<N, N>", "Map<Long, Integer>", TypeUtils.ComparisonContext.INFER).isTrue();
            }
        }))});
    }

    @Test
    void isAssignableToArray() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test<T extends CharSequence, U, V extends Number> {\n    Object[] objectArray;\n    String[] stringArray;\n    CharSequence[] charSequenceArray;\n    int[] intArray;\n    double[] doubleArray;\n    Integer[] integerArray;\n    Double[][] double2DArray;\n    Number[][] number2DArray;\n    Object[][] object2DArray;\n    String[][] string2DArray;\n    T[] genericCsArray;\n    U[] genericArray;\n    V[] genericNumericArray;\n    U generic;\n}\n", spec -> spec.afterRecipe(cu -> {
            try (TypeUtilsAssertions assertions = new TypeUtilsAssertions((J.CompilationUnit)cu);){
                assertions.isAssignableTo("String[]", "String[]").isTrue();
                assertions.isAssignableTo("Object[]", "String[]").isTrue();
                assertions.isAssignableTo("CharSequence[]", "String[]").isTrue();
                assertions.isAssignableTo("String[]", "Object[]").isFalse();
                assertions.isAssignableTo("String[]", "CharSequence[]").isFalse();
                assertions.isAssignableTo("Object[]", "int[]").isFalse();
                assertions.isAssignableTo("Object[]", "Integer[]").isTrue();
                assertions.isAssignableTo("int[]", "int[]").isTrue();
                assertions.isAssignableTo("int[]", "Integer[]").isFalse();
                assertions.isAssignableTo("Integer[]", "int[]").isFalse();
                assertions.isAssignableTo("int[]", "double[]").isFalse();
                assertions.isAssignableTo("Object[][]", "String[][]").isTrue();
                assertions.isAssignableTo("Number[][]", "Double[][]").isTrue();
                assertions.isAssignableTo("Double[][]", "Number[][]").isFalse();
                assertions.isAssignableTo("Number[][]", "Integer[]").isFalse();
                assertions.isAssignableTo("T[]", "String[]").isFalse();
                assertions.isAssignableTo("T[]", "CharSequence[]").isFalse();
                assertions.isAssignableTo("Object[]", "T[]").isTrue();
                assertions.isAssignableTo("CharSequence[]", "T[]").isTrue();
                assertions.isAssignableTo("U[]", "CharSequence[]").isFalse();
                assertions.isAssignableTo("Object[]", "U[]").isTrue();
                assertions.isAssignableTo("T[]", "String[]", TypeUtils.ComparisonContext.INFER).isTrue();
                assertions.isAssignableTo("T[]", "CharSequence[]", TypeUtils.ComparisonContext.INFER).isTrue();
                assertions.isAssignableTo("T[]", "String[][]", TypeUtils.ComparisonContext.INFER).isFalse();
                assertions.isAssignableTo("U", "String[]", TypeUtils.ComparisonContext.INFER).isTrue();
                assertions.isAssignableTo("U", "CharSequence[]", TypeUtils.ComparisonContext.INFER).isTrue();
                assertions.isAssignableTo("U", "String[][]", TypeUtils.ComparisonContext.INFER).isTrue();
                assertions.isAssignableTo("U", "int[]", TypeUtils.ComparisonContext.INFER).isTrue();
                assertions.isAssignableTo("U", "double[]", TypeUtils.ComparisonContext.INFER).isTrue();
                assertions.isAssignableTo("U[]", "String[]", TypeUtils.ComparisonContext.INFER).isTrue();
                assertions.isAssignableTo("U[]", "CharSequence[]", TypeUtils.ComparisonContext.INFER).isTrue();
                assertions.isAssignableTo("U[]", "String[][]", TypeUtils.ComparisonContext.INFER).isTrue();
                assertions.isAssignableTo("U[]", "int[]", TypeUtils.ComparisonContext.INFER).isFalse();
                assertions.isAssignableTo("V[]", "int[]", TypeUtils.ComparisonContext.INFER).isFalse();
                assertions.isAssignableTo("V[]", "Integer[]", TypeUtils.ComparisonContext.INFER).isTrue();
                assertions.isAssignableTo("U[]", "double[]", TypeUtils.ComparisonContext.INFER).isFalse();
            }
        }))});
    }

    @Test
    void isAssignableToPrimitive() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test<T, U extends Number> {\n    Byte boxedByte;\n    Character boxedChar;\n    Short boxedShort;\n    Integer boxedInt;\n    Long boxedLong;\n    Float boxedFloat;\n    Double boxedDouble;\n    Boolean boxedBoolean;\n\n    T genericT;\n    U genericU;\n}\n", spec -> spec.afterRecipe(cu -> {
            try (TypeUtilsAssertions assertions = new TypeUtilsAssertions((J.CompilationUnit)cu);){
                assertions.isAssignableTo("int", "byte").isTrue();
                assertions.isAssignableTo("int", "char").isTrue();
                assertions.isAssignableTo("int", "short").isTrue();
                assertions.isAssignableTo("int", "int").isTrue();
                assertions.isAssignableTo("int", "long").isFalse();
                assertions.isAssignableTo("float", "int").isTrue();
                assertions.isAssignableTo("double", "float").isTrue();
                assertions.isAssignableTo("float", "double").isFalse();
                assertions.isAssignableTo("int", "boolean").isFalse();
                assertions.isAssignableTo("boolean", "boolean").isTrue();
                assertions.isAssignableTo("boolean", "int").isFalse();
                assertions.isAssignableTo("int", "Integer").isTrue();
                assertions.isAssignableTo("double", "Double").isTrue();
                assertions.isAssignableTo("boolean", "Boolean").isTrue();
                assertions.isAssignableTo("Integer", "int").isTrue();
                assertions.isAssignableTo("Double", "double").isTrue();
                assertions.isAssignableTo("Boolean", "boolean").isTrue();
                assertions.isAssignableTo("int", "Boolean").isFalse();
                assertions.isAssignableTo("boolean", "Integer").isFalse();
                assertions.isAssignableTo("Boolean", "int").isFalse();
                assertions.isAssignableTo("Integer", "boolean").isFalse();
                assertions.isAssignableTo("T", "byte", TypeUtils.ComparisonContext.INFER).isTrue();
                assertions.isAssignableTo("T", "short", TypeUtils.ComparisonContext.INFER).isTrue();
                assertions.isAssignableTo("T", "char", TypeUtils.ComparisonContext.INFER).isTrue();
                assertions.isAssignableTo("T", "int", TypeUtils.ComparisonContext.INFER).isTrue();
                assertions.isAssignableTo("T", "long", TypeUtils.ComparisonContext.INFER).isTrue();
                assertions.isAssignableTo("T", "float", TypeUtils.ComparisonContext.INFER).isTrue();
                assertions.isAssignableTo("T", "double", TypeUtils.ComparisonContext.INFER).isTrue();
                assertions.isAssignableTo("T", "boolean", TypeUtils.ComparisonContext.INFER).isTrue();
                assertions.isAssignableTo("U", "byte", TypeUtils.ComparisonContext.INFER).isTrue();
                assertions.isAssignableTo("U", "short", TypeUtils.ComparisonContext.INFER).isTrue();
                assertions.isAssignableTo("U", "int", TypeUtils.ComparisonContext.INFER).isTrue();
                assertions.isAssignableTo("U", "long", TypeUtils.ComparisonContext.INFER).isTrue();
                assertions.isAssignableTo("U", "float", TypeUtils.ComparisonContext.INFER).isTrue();
                assertions.isAssignableTo("U", "double", TypeUtils.ComparisonContext.INFER).isTrue();
                assertions.isAssignableTo("U", "char", TypeUtils.ComparisonContext.INFER).isFalse();
                assertions.isAssignableTo("U", "boolean", TypeUtils.ComparisonContext.INFER).isFalse();
            }
        }))});
    }

    @Test
    void isAssignableToGenericTypeVariable() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    class A<T, U extends T, V extends U, X> {\n        T t;\n        U u;\n        V v;\n        X x;\n    }\n\n    class B<T, U extends T, V extends U, X> {\n        T t;\n        U u;\n        V v;\n        X x;\n    }\n}\n", spec -> spec.afterRecipe(cu -> {
            try (TypeUtilsAssertions assertions = new TypeUtilsAssertions((J.CompilationUnit)cu);){
                assertions.isAssignableTo("T", "T").isTrue();
                assertions.isAssignableTo("U", "U").isTrue();
                assertions.isOfType("T", "T").isTrue();
                assertions.isAssignableTo("T", "U").isTrue();
                assertions.isAssignableTo("U", "T").isFalse();
                assertions.isAssignableTo("T", "V").isTrue();
                assertions.isAssignableTo("U", "V").isTrue();
                assertions.isAssignableTo("V", "T").isFalse();
                assertions.isAssignableTo("T", "X").isFalse();
                assertions.isAssignableTo("X", "T").isFalse();
                assertions.isOfType("T", "T").isTrue();
                assertions.isOfType("U", "U").isTrue();
                assertions.isOfType("T", "U").isFalse();
                assertions.isOfType("U", "T").isFalse();
            }
        }))});
    }

    @Test
    void recursiveTypes() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"abstract class Comp implements Comparable<Comp> {}\nabstract class Ext extends Comp {}\nenum EnumType { A, B, C }\nabstract class CompT<T extends CompT<T>> implements Comparable<T> {}\nabstract class ExtT<T> extends CompT<ExtT<T>> {}\nabstract class One<TwoT extends Two<TwoT, OneT>, OneT extends One<TwoT, OneT>> {}\nabstract class Two<TwoT extends Two<TwoT, OneT>, OneT extends One<TwoT, OneT>> {}\nclass OneType extends One<TwoType, OneType> {}\nclass TwoType extends Two<TwoType, OneType> {}\n\nclass Test<E extends Enum<E>, C extends Comparable<? super C>, T> {\n    E e;\n    C c;\n    T free;\n    Comp comp;\n    Ext ext;\n    EnumType enumType;\n    Comparable<Comp> comparable;\n    CompT<?> compT;\n    CompT<ExtT<Integer>> compExtT;\n    ExtT<Integer> extT;\n    One<?, ?> oneWildcard;\n    Two<?, ?> twoWildcard;\n    OneType oneType;\n    TwoType twoType;\n}\n", spec -> spec.afterRecipe(cu -> {
            try (TypeUtilsAssertions assertions = new TypeUtilsAssertions((J.CompilationUnit)cu);){
                assertions.isOfType("Comp", "Comp").isTrue();
                assertions.isOfType("Ext", "Ext").isTrue();
                assertions.isOfType("EnumType", "EnumType").isTrue();
                assertions.isOfType("CompT<?>", "CompT<?>").isTrue();
                assertions.isOfType("CompT<ExtT<Integer>>", "CompT<ExtT<Integer>>").isTrue();
                assertions.isOfType("ExtT<Integer>", "ExtT<Integer>").isTrue();
                assertions.isOfType("CompT<ExtT<Integer>>", "ExtT<Integer>").isFalse();
                assertions.isOfType("OneType", "OneType").isTrue();
                assertions.isOfType("TwoType", "TwoType").isTrue();
                assertions.isAssignableTo("E", "EnumType", TypeUtils.ComparisonContext.BOUND).isFalse();
                assertions.isAssignableTo("E", "EnumType", TypeUtils.ComparisonContext.INFER).isTrue();
                assertions.isAssignableTo("C", "Comp", TypeUtils.ComparisonContext.BOUND).isFalse();
                assertions.isAssignableTo("C", "Ext", TypeUtils.ComparisonContext.BOUND).isFalse();
                assertions.isAssignableTo("C", "Comp", TypeUtils.ComparisonContext.INFER).isTrue();
                assertions.isAssignableTo("C", "Ext", TypeUtils.ComparisonContext.INFER).isTrue();
                assertions.isAssignableTo("C", "Comparable<Comp>", TypeUtils.ComparisonContext.BOUND).isFalse();
                assertions.isAssignableTo("C", "Comparable<Comp>", TypeUtils.ComparisonContext.INFER).isTrue();
                assertions.isAssignableTo("Comparable<Comp>", "Comp").isTrue();
                assertions.isAssignableTo("Comparable<Comp>", "Ext").isTrue();
                assertions.isAssignableTo("CompT<?>", "CompT<ExtT<Integer>>").isTrue();
                assertions.isAssignableTo("CompT<ExtT<Integer>>", "CompT<ExtT<Integer>>").isTrue();
                assertions.isAssignableTo("CompT<ExtT<Integer>>", "CompT<?>").isFalse();
                assertions.isAssignableTo("CompT<?>", "ExtT<Integer>").isTrue();
                assertions.isAssignableTo("CompT<ExtT<Integer>>", "ExtT<Integer>").isTrue();
                assertions.isAssignableTo("ExtT<Integer>", "ExtT<Integer>").isTrue();
                assertions.isAssignableTo("One<?, ?>", "OneType").isTrue();
                assertions.isAssignableTo("Two<?, ?>", "TwoType").isTrue();
                assertions.isAssignableTo("OneType", "OneType").isTrue();
                assertions.isAssignableTo("TwoType", "TwoType").isTrue();
            }
        }))});
    }

    @MinimumJava11
    @Test
    void intersectionTypes() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.io.*;\nimport java.util.*;\n\n@SuppressWarnings(\"all\")\npublic class Test {\n    void test() {\n        var intersection1 = (Cloneable & Serializable) null;\n        var intersection2 = (Serializable & Cloneable) null;\n        Serializable serializable;\n        Cloneable cloneable;\n        int[] arrayPrimitive;\n        DuplicateFormatFlagsException extendIllegal;\n        RuntimeException exception;\n        try {} catch (NullPointerException | IllegalArgumentException exception1) {}\n        try {} catch (IllegalArgumentException | NullPointerException exception2) {}\n    }\n}\n", spec -> spec.afterRecipe(cu -> {
            try (TypeUtilsAssertions assertions = new TypeUtilsAssertions((J.CompilationUnit)cu);){
                assertions.isOfType("intersection1", "intersection2").isTrue();
                assertions.isAssignableTo("intersection1", "int[]").isTrue();
                assertions.isAssignableTo("int[]", "intersection1").isFalse();
                assertions.isAssignableTo("Serializable", "intersection1").isTrue();
                assertions.isAssignableTo("Cloneable", "intersection1").isTrue();
                assertions.isOfType("NullPointerException | IllegalArgumentException", "IllegalArgumentException | NullPointerException").isTrue();
                assertions.isAssignableTo("NullPointerException | IllegalArgumentException", "DuplicateFormatFlagsException").isTrue();
                assertions.isAssignableTo("DuplicateFormatFlagsException", "NullPointerException | IllegalArgumentException").isFalse();
                assertions.isAssignableTo("NullPointerException | IllegalArgumentException", "RuntimeException").isFalse();
                assertions.isAssignableTo("RuntimeException", "NullPointerException | IllegalArgumentException").isTrue();
                assertions.isAssignableTo("exception2", "NullPointerException | IllegalArgumentException").isTrue();
            }
        }))});
    }
}

