/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import org.junit.jupiter.api.Test;
import org.openrewrite.Tree;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MinimumJava11;
import org.openrewrite.java.tree.J;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

class TryCatchTest
implements RewriteTest {
    TryCatchTest() {
    }

    @Test
    void catchRightPadding() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    void method() {\n        try {\n            String foo;\n        } catch( Exception e ) {\n        //\n        }\n    }\n}\n", spec -> spec.afterRecipe(cu -> new JavaIsoVisitor<Object>(this){

            public J.Try.Catch visitCatch(J.Try.Catch c, Object o) {
                org.assertj.core.api.Assertions.assertThat((String)c.getParameter().getPadding().getTree().getAfter().getWhitespace()).isEqualTo(" ");
                return c;
            }
        }.visit((Tree)cu, (Object)0)))});
    }

    @Test
    void tryFinally() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    void test() {\n        try {\n        }\n        finally {\n        }\n    }\n}\n")});
    }

    @Test
    void tryCatchNoFinally() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    void test() {\n        try {\n        }\n        catch(Throwable ignored) {\n        }\n    }\n}\n")});
    }

    @Test
    void tryWithResources() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.io.*;\nclass Test {\n    void test() {\n        File f = new File(\"file.txt\");\n        try (FileInputStream fis = new FileInputStream(f)) {\n        }\n        catch(IOException ignored) {\n        }\n    }\n}\n")});
    }

    @Test
    void tryWithResourcesSemiTerminated() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.io.File;\nimport java.io.FileInputStream;\nimport java.io.IOException;\nclass Test {\n    void test() {\n        File f = new File(\"file.txt\");\n        try (FileInputStream fis = new FileInputStream(f) ; ) {\n        }\n        catch(IOException ignored) {\n        }\n    }\n}\n")});
    }

    @Test
    void multiCatch() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.io.*;\nclass Test {\n    void test() {\n        File f = new File(\"file.txt\");\n        try(FileInputStream fis = new FileInputStream(f)) {}\n        catch(FileNotFoundException | RuntimeException ignored) {}\n    }\n}\n")});
    }

    @Test
    void multipleResources() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.io.*;\nclass Test {\n    void test() {\n        File f = new File(\"file.txt\");\n        try(FileInputStream fis = new FileInputStream(f); FileInputStream fis2 = new FileInputStream(f)) {}\n        catch(RuntimeException | IOException ignored) {}\n    }\n}\n")});
    }

    @Test
    void tryCatchFinally() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    void test() {\n        try {}\n        catch(Exception e) {}\n        catch(RuntimeException e) {}\n        catch(Throwable t) {}\n        finally {}\n    }\n}\n")});
    }

    @MinimumJava11
    @Test
    void tryWithResourcesIdentifier() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.io.InputStream;\nclass A {\n    void test() {\n        InputStream in;\n        try (in) {\n        }\n    }\n}\n")});
    }

    @MinimumJava11
    @Test
    void tryWithResourcesIdentifierAndVariables() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.io.File;\nimport java.io.FileInputStream;\nimport java.util.Scanner;\n\nclass A {\n    void a() throws Exception {\n        FileInputStream fis = new FileInputStream(\"file.txt\");\n        try (fis; Scanner sc = new Scanner(\"\")) {\n        }\n    }\n}\n")});
    }

    @MinimumJava11
    @Test
    void tryWithResourcesIdentifierAndSemicolon() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.io.File;\nimport java.io.FileInputStream;\nimport java.util.Scanner;\n\nclass A {\n    void a() throws Exception {\n        FileInputStream fis = new FileInputStream(\"file.txt\");\n        try (fis;) {\n        }\n    }\n}\n")});
    }
}

