/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.MinimumJava21;
import org.openrewrite.java.MinimumJava25;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

class ConstructorTest
implements RewriteTest {
    ConstructorTest() {
    }

    @Test
    void noConstructor() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public class A {}\n")});
    }

    @Test
    void defaultConstructor() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public class A {\n    public A() {}\n}\n")});
    }

    @Test
    void multipleConstructor() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public class A {\n    public A() {}\n    public A(String a) {}\n}\n")});
    }

    @Test
    void thisCallingConstructor() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public class A {\n    public A() {}\n    public A(String a) {\n        this();\n    }\n}\n")});
    }

    @Test
    void superCallingConstructor() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public class A {\n    public A() {}\n    public A(String a) {\n        super();\n    }\n}\n")});
    }

    @MinimumJava21
    @Test
    void validationBeforeThisConstructor() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public class A {\n    public A() {}\n    public A(String a) {\n        if (a.equals(\"foo\")) {\n            throw new RuntimeException();\n        }\n        this();\n    }\n}\n")});
    }

    @MinimumJava21
    @Test
    void validationBeforeSuperConstructor() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public class A {\n    public A(String a) {\n        if (a.equals(\"foo\")) {\n            throw new RuntimeException();\n        }\n        super();\n    }\n}\n")});
    }

    @MinimumJava21
    @Test
    void assignmentBeforeThisConstructor() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public class A {\n    String stringA;\n    public A() {}\n    public A(String a) {\n        stringA = a;\n        this();\n    }\n}\n")});
    }

    @MinimumJava21
    @Test
    void assignmentBeforeSuperConstructor() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public class A {\n    String stringA;\n    public A(String a) {\n        stringA = a;\n        super();\n    }\n}\n")});
    }

    @MinimumJava25
    @Nested
    class FlexibleConstructors {
        FlexibleConstructors() {
        }

        @Test
        void constructorThisWithPrologueAndEpilogue() {
            ConstructorTest.this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class A {\n    String stringA;\n    A(){}\n    A(String a) {\n        String validated = a.trim();\n        this();\n        this.stringA = validated;\n    }\n}\n")});
        }

        @Test
        void constructorSuperWithPrologueAndEpilogue() {
            ConstructorTest.this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Parent {\n    String parentString;\n    Parent(String value) {\n        this.parentString = value;\n    }\n}\n\nclass Child extends Parent {\n    String childString;\n    Child(int number, String value) {\n        String formatted = String.format(\"Number: %d\", number);\n        super(formatted);\n        this.childString = value;\n    }\n}\n")});
        }

        @Test
        void recordConstructorWithValidation() {
            ConstructorTest.this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"record Point(int x, int y) {\n    Point {\n        if (x < 0 || y < 0) {\n            throw new IllegalArgumentException(\"Coordinates must be non-negative\");\n        }\n    }\n\n    Point(String coords) {\n        String[] parts = coords.split(\",\");\n        int parsedX = Integer.parseInt(parts[0].trim());\n        int parsedY = Integer.parseInt(parts[1].trim());\n        this(parsedX, parsedY);\n    }\n}\n")});
        }

        @Test
        void constructorWithEarlyReturn() {
            ConstructorTest.this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class A {\n    String value;\n    A(){}\n    A(String input) {\n        if (input == null) {\n            this();\n            return;\n        }\n        if (input.isEmpty()) {\n            throw new IllegalArgumentException(\"Empty input\");\n        }\n        this();\n        this.value = input;\n    }\n}\n")});
        }

        @Test
        void assertStatementBeforeConstructor() {
            ConstructorTest.this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class A {\n    String someString;\n    A(){}\n    A(String input) {\n        assert input != null : \"Input must not be null\";\n        assert !input.isEmpty() : \"Input must not be empty\";\n        this();\n        someString = input;\n    }\n}\n")});
        }
    }
}

