/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.ThrowingConsumer;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTypeMappingTest;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MinimumJava11;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;
import org.openrewrite.test.TypeValidation;

class JavaParserTypeMappingTest
implements JavaTypeMappingTest,
RewriteTest {
    @Language(value="java")
    private final String goat = StringUtils.readFully((InputStream)JavaParserTypeMappingTest.class.getResourceAsStream("/JavaTypeGoat.java"));
    private final J.CompilationUnit goatCu = JavaParser.fromJavaVersion().build().parse(new String[]{this.goat}).findFirst().map(J.CompilationUnit.class::cast).orElseThrow(() -> new IllegalArgumentException("Could not parse as Java"));

    JavaParserTypeMappingTest() {
    }

    public JavaType.FullyQualified classType(final String fqn) {
        final AtomicReference type = new AtomicReference();
        new JavaVisitor<Object>(this){

            public J visitClassDeclaration(J.ClassDeclaration classDecl, Object o) {
                if (Objects.requireNonNull(classDecl.getType()).getFullyQualifiedName().equals(fqn)) {
                    type.set(classDecl.getType());
                    return classDecl;
                }
                return super.visitClassDeclaration(classDecl, o);
            }
        }.visit((Tree)this.goatCu, (Object)0);
        return (JavaType.FullyQualified)type.get();
    }

    @Test
    void annotationParameterDefaults() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"@AnAnnotation\nclass Test {\n}\n@interface AnAnnotation {\n    int scalar() default 1;\n    String[] array() default {\"a\", \"b\"};\n}\n", spec -> spec.afterRecipe(cu -> {
            JavaType.Class t = TypeUtils.asClass((JavaType)((J.Annotation)((J.ClassDeclaration)cu.getClasses().get(0)).getAllAnnotations().get(0)).getType());
            org.assertj.core.api.Assertions.assertThat(t.getMethods().stream().filter(m -> "scalar".equals(m.getName())).map(JavaType.Method::getDefaultValue).map(dv -> (String)dv.get(0))).containsExactly((Object[])new String[]{"1"});
            org.assertj.core.api.Assertions.assertThat(t.getMethods().stream().filter(m -> "array".equals(m.getName())).map(JavaType.Method::getDefaultValue).flatMap(dv -> dv.stream())).hasSize(2);
        }))});
    }

    @Test
    void parameterizedTypesAreDeeplyBasedOnBounds() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"abstract class TypeA<T extends Number> extends java.util.ArrayList<T> {}", spec -> spec.afterRecipe(cu -> {
            JavaType.Parameterized typeA = TypeUtils.asParameterized((JavaType)((J.ClassDeclaration)cu.getClasses().get(0)).getType());
            org.assertj.core.api.Assertions.assertThat((String)TypeUtils.asGeneric((JavaType)((JavaType)typeA.getTypeParameters().get(0))).toString()).isEqualTo("Generic{T extends java.lang.Number}");
            JavaType.Parameterized typeASuperType = TypeUtils.asParameterized((JavaType)typeA.getSupertype());
            org.assertj.core.api.Assertions.assertThat((String)typeASuperType.toString()).isEqualTo("java.util.ArrayList<Generic{T extends java.lang.Number}>");
            org.assertj.core.api.Assertions.assertThat((String)((JavaType)TypeUtils.asClass((JavaType)typeASuperType.getType()).getTypeParameters().get(0)).toString()).isEqualTo("Generic{E}");
        })), Assertions.java((String)"class TypeB extends TypeA<Integer> {\n    // Attempt to force the JavaTypeCache to cache the wrong parameterized super type.\n    java.util.List<String> list = new java.util.ArrayList<>();\n}\n", spec -> spec.afterRecipe(cu -> {
            JavaType.Class typeB = TypeUtils.asClass((JavaType)((J.ClassDeclaration)cu.getClasses().get(0)).getType());
            org.assertj.core.api.Assertions.assertThat((String)typeB.getSupertype().toString()).isEqualTo("TypeA<java.lang.Integer>");
            JavaType.Parameterized typeBSuperType = TypeUtils.asParameterized((JavaType)typeB.getSupertype());
            org.assertj.core.api.Assertions.assertThat((String)((JavaType)TypeUtils.asClass((JavaType)typeBSuperType.getType()).getTypeParameters().get(0)).toString()).isEqualTo("Generic{T extends java.lang.Number}");
        })), Assertions.java((String)"class TypeC<T extends String> extends java.util.ArrayList<T> {\n    // Attempt to force the JavaTypeCache to cache the wrong parameterized super type.\n    java.util.List<Object> list = new java.util.ArrayList<>();\n}\n", spec -> spec.afterRecipe(cu -> {
            JavaType.Parameterized typeC = TypeUtils.asParameterized((JavaType)((J.ClassDeclaration)cu.getClasses().get(0)).getType());
            org.assertj.core.api.Assertions.assertThat((String)TypeUtils.asGeneric((JavaType)((JavaType)typeC.getTypeParameters().get(0))).toString()).isEqualTo("Generic{T extends java.lang.String}");
            JavaType.Parameterized typeCSuperType = TypeUtils.asParameterized((JavaType)typeC.getSupertype());
            org.assertj.core.api.Assertions.assertThat((String)typeCSuperType.toString()).isEqualTo("java.util.ArrayList<Generic{T extends java.lang.String}>");
            org.assertj.core.api.Assertions.assertThat((String)((JavaType)TypeUtils.asClass((JavaType)typeCSuperType.getType()).getTypeParameters().get(0)).toString()).isEqualTo("Generic{E}");
        }))});
    }

    @MinimumJava11
    @Test
    void methodInvocationWithUnknownTypeSymbol() {
        this.rewriteRun(spec -> spec.typeValidationOptions(TypeValidation.builder().constructorInvocations(false).build()), new SourceSpecs[]{Assertions.java((String)"import java.util.ArrayList;\nimport java.util.List;\nimport java.util.stream.Collectors;\n\nclass Test {\n    class Parent {\n    }\n    class Child extends Parent {\n    }\n\n    List<Parent> method(List<Parent> values) {\n        return values.stream()\n                .map(o -> {\n                    if (o instanceof Child) {\n                        return new UnknownType(((Child) o).toString());\n                    }\n                    return o;\n                })\n                .collect(Collectors.toList());\n    }\n}\n")});
    }

    @Test
    void methodInvocationOnUnknownType() {
        this.rewriteRun(spec -> spec.typeValidationOptions(TypeValidation.builder().identifiers(false).methodDeclarations(false).constructorInvocations(false).build()), new SourceSpecs[]{Assertions.java((String)"import java.util.ArrayList;\n// do not import List to create an UnknownType\n\nclass Test {\n    class Base {\n        private int foo;\n        public boolean setFoo(int foo) {\n            this.foo = foo;\n        }\n        public int getFoo() {\n            return foo;\n        }\n    }\n    List<Base> createUnknownType(List<Integer> values) {\n        List<Base> bases = new ArrayList<>();\n        values.forEach((v) -> {\n            Base b = new Base();\n            b.setFoo(v);\n            bases.add(b);\n        });\n        return bases;\n    }\n}\n")});
    }

    @Test
    void variousMethodScopeIdentifierTypes() {
        this.rewriteRun(spec -> spec.recipe((Recipe)RewriteTest.toRecipe(() -> new JavaIsoVisitor<ExecutionContext>(this){

            public J.Binary visitBinary(J.Binary binary, ExecutionContext executionContext) {
                if (binary.getLeft() instanceof J.Identifier) {
                    J.Identifier left = (J.Identifier)binary.getLeft();
                    if ("i".equals(left.getSimpleName())) {
                        org.assertj.core.api.Assertions.assertThat((String)left.getFieldType().getType().toString()).isEqualTo("java.lang.Integer");
                    } else if ("m".equals(left.getSimpleName())) {
                        org.assertj.core.api.Assertions.assertThat((String)left.getFieldType().getType().toString()).isEqualTo("MakeEasyToFind$MultiMap");
                    }
                }
                return binary;
            }

            public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, ExecutionContext executionContext) {
                if ("l".equals(variable.getSimpleName())) {
                    org.assertj.core.api.Assertions.assertThat((String)variable.getType().toString()).isEqualTo("java.lang.Long");
                }
                return super.visitVariable(variable, (Object)executionContext);
            }
        })), new SourceSpecs[]{Assertions.java((String)"import java.util.List;\nimport java.util.stream.Collectors;\n\n@SuppressWarnings(\"ALL\")\nclass MakeEasyToFind {\n    void method(List<MultiMap> multiMaps) {\n        List<Integer> ints;\n        ints.forEach(i -> {\n            if (i != null) {\n            }\n        });\n\n        multiMaps.forEach(m -> {\n            if (m != null) {\n            }\n        });\n\n        while (true) {\n            if (multiMaps.isEmpty()) {\n                Long l;\n                break;\n            }\n        }\n    }\n\n    static class MultiMap {\n        List<Inner> inners;\n        public List<Inner> getInners() {\n            return inners;\n        }\n\n        static class Inner {\n            List<Number> numbers;\n            public List<Number> getNumbers() {\n                return numbers;\n            }\n        }\n    }\n}\n")});
    }

    @Test
    void multiMapWithSameLambdaParamNames() {
        this.rewriteRun(spec -> spec.recipe((Recipe)RewriteTest.toRecipe(() -> new JavaIsoVisitor<ExecutionContext>(this){

            public J.Lambda visitLambda(J.Lambda lambda, ExecutionContext executionContext) {
                J.Identifier param = ((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)lambda.getParameters().getParameters().get(0)).getVariables().get(0)).getName();
                if ("it1".equals(param.getSimpleName())) {
                    org.assertj.core.api.Assertions.assertThat((String)param.getType().toString()).isEqualTo("MakeEasyToFind$MultiMap");
                } else if ("it2".equals(param.getSimpleName())) {
                    org.assertj.core.api.Assertions.assertThat((String)((JavaType)TypeUtils.asParameterized((JavaType)param.getType()).getTypeParameters().get(0)).toString()).isEqualTo("MakeEasyToFind$MultiMap$Inner");
                }
                return super.visitLambda(lambda, (Object)executionContext);
            }
        })), new SourceSpecs[]{Assertions.java((String)"import java.util.List;\nimport java.util.stream.Collectors;\n\n@SuppressWarnings(\"ALL\")\nclass MakeEasyToFind {\n    void method(List<MultiMap> multiMaps) {\n        Object obj = multiMaps.stream()\n            .map(it1 -> it1.getInners())\n            .map(it2 -> it2.stream().map(i -> i.getNumbers()))\n            .collect(Collectors.toList());\n    }\n\n    static class MultiMap {\n        List<Inner> inners;\n        public List<Inner> getInners() {\n            return inners;\n        }\n\n        static class Inner {\n            List<Number> numbers;\n            public List<Number> getNumbers() {\n                return numbers;\n            }\n        }\n    }\n}\n")});
    }

    @Test
    void annotatedArrayType() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.lang.annotation.ElementType;\nimport java.lang.annotation.Target;\n\nclass TypeAnnotationTest {\n    Integer @A1 [] @A2 [ ] annotatedArray;\n\n    @Target(ElementType.TYPE_USE)\n    private @interface A1 {\n    }\n\n    @Target(ElementType.TYPE_USE)\n    private @interface A2 {\n    }\n}\n", spec -> spec.afterRecipe(cu -> {
            final AtomicBoolean firstDimension = new AtomicBoolean(false);
            final AtomicBoolean secondDimension = new AtomicBoolean(false);
            new JavaIsoVisitor<Integer>(this){

                public J.ArrayType visitArrayType(J.ArrayType arrayType, Integer n) {
                    assert (arrayType.getType() instanceof JavaType.Array);
                    JavaType.Array array = (JavaType.Array)arrayType.getType();
                    if (arrayType.getElementType() instanceof J.ArrayType) {
                        List<JavaType.FullyQualified> annotations = this.collectAnnotations((JavaType)array, new ArrayList<JavaType.FullyQualified>());
                        org.assertj.core.api.Assertions.assertThat(annotations).satisfiesExactly(new ThrowingConsumer[]{ann1 -> org.assertj.core.api.Assertions.assertThat((String)ann1.getFullyQualifiedName()).isEqualTo("TypeAnnotationTest$A1"), ann2 -> org.assertj.core.api.Assertions.assertThat((String)ann2.getFullyQualifiedName()).isEqualTo("TypeAnnotationTest$A2")});
                        firstDimension.set(true);
                    } else {
                        List<JavaType.FullyQualified> annotations = this.collectAnnotations((JavaType)array, new ArrayList<JavaType.FullyQualified>());
                        org.assertj.core.api.Assertions.assertThat(annotations).satisfiesExactly(new ThrowingConsumer[]{ann -> org.assertj.core.api.Assertions.assertThat((String)ann.getFullyQualifiedName()).isEqualTo("TypeAnnotationTest$A2")});
                        secondDimension.set(true);
                    }
                    return super.visitArrayType(arrayType, (Object)n);
                }

                private List<JavaType.FullyQualified> collectAnnotations(JavaType type, List<JavaType.FullyQualified> annotations) {
                    if (type instanceof JavaType.Array) {
                        annotations.addAll(((JavaType.Array)type).getAnnotations());
                        this.collectAnnotations(((JavaType.Array)type).getElemType(), annotations);
                    }
                    return annotations;
                }
            }.visit((Tree)cu, (Object)0);
            org.assertj.core.api.Assertions.assertThat((boolean)firstDimension.get()).isTrue();
            org.assertj.core.api.Assertions.assertThat((boolean)secondDimension.get()).isTrue();
        }))});
    }
}

