/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import org.junit.jupiter.api.Test;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.tree.J;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

class EnumTest
implements RewriteTest {
    EnumTest() {
    }

    @Test
    void enumWithAnnotations() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public enum Test {\n    @Deprecated(since = \"now\")\n    One,\n\n    @Deprecated(since = \"now\")\n    Two;\n}\n")});
    }

    @Test
    void anonymousClassInitializer() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public enum A {\n    A1(1) {\n        @Override\n        void foo() {}\n    };\n\n    A(int n) {}\n\n    abstract void foo();\n}\n")});
    }

    @Test
    void anonymousClassInitializerNoParentheses() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public enum A {\n    A2 {\n        @Override\n        void foo() {}\n    };\n\n    abstract void foo();\n}\n")});
    }

    @Test
    void enumConstructor() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public class Outer {\n    public enum A {\n        A1(1);\n\n        A(int n) {}\n    }\n\n    private static final class ContextFailedToStart {\n        private static Object[] combineArguments(String context, Throwable ex, Object[] arguments) {\n            return new Object[arguments.length + 2];\n        }\n    }\n}\n")});
    }

    @Test
    void noArguments() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public enum A {\n    A1, A2();\n}\n")});
    }

    @Test
    void enumWithParameters() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public enum A {\n    ONE(1),\n    TWO(2);\n\n    A(int n) {}\n}\n")});
    }

    @Test
    void enumWithoutParameters() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public enum A { ONE, TWO }")});
    }

    @Test
    void enumUnnecessarilyTerminatedWithSemicolon() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public enum A { ONE ; }")});
    }

    @Test
    void enumValuesTerminatedWithComma() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"enum A { ONE, }")});
    }

    @Test
    void enumWithEmptyParameters() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public enum A { ONE ( ), TWO ( ) }")});
    }

    @Test
    void enumWithParametersAndTrailingComma() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public enum A {\n    ONE(1),\n    TWO(2),\n    ;\n\n    A(int n) {}\n}\n")});
    }

    @Test
    void noValuesJustSemicolon() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public enum A {\n    ;\n    public static final String X = \"receipt-id\";\n}\n", spec -> spec.afterRecipe(cu -> {
            J.EnumValueSet enumValueStatement = (J.EnumValueSet)((J.ClassDeclaration)cu.getClasses().get(0)).getBody().getStatements().get(0);
            assert (enumValueStatement.getEnums().isEmpty());
            assert (enumValueStatement.isTerminatedWithSemicolon());
        }))});
    }
}

