/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import java.util.List;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.MinimumJava11;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

class TypeCastTest
implements RewriteTest {
    TypeCastTest() {
    }

    @Test
    void cast() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    Object o = (Class<String>) Class.forName(\"java.lang.String\");\n}\n")});
    }

    @Test
    void intersectionCast() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.io.Serializable;\nimport java.util.function.BiFunction;\n\nclass Test {\n    Serializable s = (Serializable & BiFunction<Integer, Integer, Integer>) Integer::sum;\n}\n")});
    }

    @MinimumJava11
    @Test
    void intersectionCastAssignedToVar() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.io.Serializable;\nimport java.util.function.BiFunction;\n\nclass Test {\n    void m() {\n        var s = (Serializable & BiFunction<Integer, Integer, Integer>) Integer::sum;\n    }\n}\n", spec -> spec.afterRecipe(cu -> {
            J.MethodDeclaration m = (J.MethodDeclaration)((J.ClassDeclaration)cu.getClasses().get(0)).getBody().getStatements().get(0);
            J.VariableDeclarations s = (J.VariableDeclarations)m.getBody().getStatements().get(0);
            org.assertj.core.api.Assertions.assertThat((Object)s.getType()).isInstanceOf(JavaType.Intersection.class);
            JavaType.Intersection intersection = (JavaType.Intersection)s.getType();
            org.assertj.core.api.Assertions.assertThat((List)intersection.getBounds()).satisfiesExactly(new ThrowingConsumer[]{b1 -> org.assertj.core.api.Assertions.assertThat((Object)b1).satisfies(new ThrowingConsumer[]{t -> org.assertj.core.api.Assertions.assertThat((Object)t).isInstanceOf(JavaType.Class.class), t -> org.assertj.core.api.Assertions.assertThat((String)((JavaType.Class)t).getFullyQualifiedName()).isEqualTo("java.io.Serializable")}), b2 -> org.assertj.core.api.Assertions.assertThat((Object)b2).satisfies(new ThrowingConsumer[]{t -> org.assertj.core.api.Assertions.assertThat((Object)t).isInstanceOf(JavaType.Parameterized.class), t -> org.assertj.core.api.Assertions.assertThat((String)((JavaType.Parameterized)t).getFullyQualifiedName()).isEqualTo("java.util.function.BiFunction"), t -> org.assertj.core.api.Assertions.assertThat((List)((JavaType.Parameterized)t).getTypeParameters()).hasSize(3), t -> org.assertj.core.api.Assertions.assertThat((List)((JavaType.Parameterized)t).getTypeParameters()).allSatisfy(p -> org.assertj.core.api.Assertions.assertThat((String)((JavaType.Class)p).getFullyQualifiedName()).isEqualTo("java.lang.Integer"))})});
        }))});
    }
}

