/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import java.util.List;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.openrewrite.Tree;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MinimumJava17;
import org.openrewrite.java.tree.J;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

class ClassDeclarationTest
implements RewriteTest {
    ClassDeclarationTest() {
    }

    @MinimumJava17
    @Test
    void sealedClasses() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public sealed class Shape\n    permits Square, Rectangle {\n}\n", spec -> spec.afterRecipe(cu -> org.assertj.core.api.Assertions.assertThat((List)((J.ClassDeclaration)cu.getClasses().get(0)).getPermits()).hasSize(2))), Assertions.java((String)"public non-sealed class Square extends Shape {\n   public double side;\n}\n"), Assertions.java((String)"public sealed class Rectangle extends Shape {\n    public double length, width;\n}\n")});
    }

    @MinimumJava17
    @Test
    void sealedInterfaces() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public sealed interface Shape { }\n", spec -> spec.afterRecipe(cu -> org.assertj.core.api.Assertions.assertThat((List)((J.ClassDeclaration)cu.getClasses().get(0)).getPermits()).isNull())), Assertions.java((String)"public sealed interface HasFourCorners extends Shape\n    permits Square, Rectangle {\n}\n", spec -> spec.afterRecipe(cu -> org.assertj.core.api.Assertions.assertThat((List)((J.ClassDeclaration)cu.getClasses().get(0)).getPermits()).hasSize(2))), Assertions.java((String)"public non-sealed class Square extends HasFourCorners {\n   public double side;\n}\n"), Assertions.java((String)"public sealed class Rectangle extends HasFourCorners {\n    public double length, width;\n}\n")});
    }

    @Test
    void singleLineCommentBeforeModifier() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"@Deprecated\n// Some comment\npublic final class A {}\n")});
    }

    @Test
    @Disabled(value="class A {}~~(non-whitespace)~~>;<~~")
    void trailingSemicolon() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class A {};\n")});
    }

    @Test
    void multipleClassDeclarationsInOneCompilationUnit() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public class A {}\nclass B {}\n")});
    }

    @Test
    void implementsInterface() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public interface B {}\nclass A implements B {}\n")});
    }

    @Test
    void extendsClass() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public interface B {}\nclass A extends B {}\n")});
    }

    @Test
    void typeArgumentsAndAnnotation() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public class B<T> {}\n@Deprecated public class A < T > extends B < T > {}\n")});
    }

    @Test
    void modifierOrdering() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public /* abstract */ final abstract class A {}\n")});
    }

    @Test
    void innerClass() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public class A {\n    public enum B {\n        ONE,\n        TWO\n    }\n\n    private B b;\n}\n")});
    }

    @Test
    void strictfpModifier() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public strictfp class A {}\n")});
    }

    @Test
    void hasModifier() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public strictfp class A {}\n", spec -> spec.afterRecipe(cu -> new JavaIsoVisitor<Object>(){

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, Object o) {
                org.assertj.core.api.Assertions.assertThat((List)classDecl.getModifiers()).hasSize(2);
                org.assertj.core.api.Assertions.assertThat((boolean)classDecl.hasModifier(J.Modifier.Type.Public)).isTrue();
                org.assertj.core.api.Assertions.assertThat((boolean)classDecl.hasModifier(J.Modifier.Type.Strictfp)).isTrue();
                return classDecl;
            }
        }.visit((Tree)cu, (Object)0)))});
    }

    @Test
    void unnecessarySemicolonInBody() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class A {\n    int i = 0;;\n    int j = 0;\n}\n")});
    }

    @ParameterizedTest
    @ValueSource(strings={";", ";;;", "; // comment", "; // comment;with;semicolons", "; /* comment;with;semicolons */", "; /* comment\n*/", "; // comment1\n// comment2\n;", "static String method() { return null; };"})
    void unnecessaryLeadingOrEndingSemicolons(String suffix) {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"  class A {\n      /*@@*/\n      int i = 0;\n      /*@@*/\n  }\n".replaceAll("/[*]@@[*]/", suffix))});
    }
}

