/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import org.junit.jupiter.api.Test;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.MinimumJava21;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

@MinimumJava21
class SwitchPatternMatchingTest
implements RewriteTest {
    SwitchPatternMatchingTest() {
    }

    @Test
    void shouldParseJava21PatternSwitch() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    String formatterPatternSwitch(Object obj) {\n        return switch (obj) {\n            case Integer i -> String.format(\"int %d\", i);\n            case Long l    -> String.format(\"long %d\", l);\n            case Double d  -> String.format(\"double %f\", d);\n            case String s  -> String.format(\"String %s\", s);\n            default        -> obj.toString();\n        };\n    }\n}\n")});
    }

    @Test
    void shouldSupportParsingNullSwitch() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n  void fooBarWithNull(String s) {\n      switch (s) {\n          case null -> System.out.println(\"Oops\");\n          case \"Foo\", \"Bar\" -> System.out.println(\"Great\");\n          default -> System.out.println(\"Ok\");\n      }\n  }\n}\n")});
    }

    @Test
    void shouldParseJava21EnumSupportInSwitch() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"enum Coin  { HEADS, TAILS }\n\nclass Test {\n    void switchEnum(Coin c) {\n        switch (c) {\n            case HEADS -> System.out.println(\"Heads\");\n            case Coin.TAILS -> System.out.println(\"Tails\");\n        }\n    }\n}\n")});
    }

    @Test
    void shouldParseJava21ImprovedEnumSupportInSwitch() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"sealed interface I permits Foo, Bar {}\npublic enum Foo implements I { A, B }\nfinal class Bar implements I {}\n\nclass Test {\n    void switchEnumExtendedType(I c) {\n        switch (c) {\n            case Foo.A -> System.out.println(\"It's Foo A\");\n            case Foo.B -> System.out.println(\"It's Foo B\");\n            case Bar b -> System.out.println(\"It's Bar\");\n        }\n    }\n}\n")});
    }

    @Test
    void shouldParseJava21SwitchWithRelaxedTypeRestrictions() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"record Point(int i, int j) {}\nenum Color { RED, GREEN, BLUE; }\n\nclass Test {\n    void typeTester(Object obj) {\n         switch (obj) {\n             case null     -> System.out.println(\"null\");\n             case String s -> System.out.println(\"String\");\n             case Color c  -> System.out.println(\"Color: \" + c.toString());\n             case Point p  -> System.out.println(\"Record class: \" + p.toString());\n             case int[] ia -> System.out.println(\"Array of ints of length\" + ia.length);\n             default       -> System.out.println(\"Something else\");\n         }\n    }\n}\n")});
    }

    @Test
    void shouldParseJava21SwitchWithSpecialCases() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    void integerTester(Integer i) {\n         switch (i) {\n             case -1, 1 -> System.out.println(\"special\");\n             case Integer j when (j - 1) > -1 -> System.out.println(\"pos\");\n             case Integer j -> System.out.println(\"others\");\n         }\n    }\n}\n")});
    }
}

