/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.CollectionAssert;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.EnabledOnJre;
import org.junit.jupiter.api.condition.JRE;
import org.openrewrite.Parser;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;
import org.openrewrite.test.TypeValidation;

@EnabledOnJre(value={JRE.JAVA_17})
class LombokTest
implements RewriteTest {
    LombokTest() {
    }

    public void defaults(RecipeSpec spec) {
        spec.parser((Parser.Builder)JavaParser.fromJavaVersion().classpath(new String[]{"lombok"}));
    }

    @Test
    void cleanup() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import lombok.Cleanup;\nimport java.io.*;\n\npublic class CleanupExample {\n  public static void main(String[] args) throws IOException {\n    @Cleanup InputStream in = new FileInputStream(args[0]);\n    @Cleanup OutputStream out = new FileOutputStream(args[1]);\n    byte[] b = new byte[10000];\n    while (true) {\n      int r = in.read(b);\n      if (r == -1) break;\n      out.write(b, 0, r);\n    }\n  }\n}\n")});
    }

    @Test
    void getter() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import lombok.Getter;\n\n@Getter\nclass A {\n    int n;\n\n    void test() {\n        System.out.println(getN());\n    }\n}\n")});
    }

    @Test
    void builder() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import lombok.Builder;\n\n@Builder\nclass A {\n    boolean b;\n    int n;\n    String s;\n\n    void test() {\n        A a = A.builder().n(1).b(true).s(\"foo\").build();\n    }\n}\n")});
    }

    @Test
    void tostring() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import lombok.ToString;\n\n@ToString\npublic class ToStringExample {\n  private static final int STATIC_VAR = 10;\n  private String name;\n  private Shape shape = new Square(5, 10);\n  private String[] tags;\n  @ToString.Exclude private int id;\n\n  public static class Shape {}\n\n  @ToString(callSuper=true, includeFieldNames=true)\n  public static class Square extends Shape {\n    private final int width, height;\n\n    public Square(int width, int height) {\n      this.width = width;\n      this.height = height;\n    }\n  }\n}\n")});
    }

    @Test
    void equalsAndHashCode() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import lombok.EqualsAndHashCode;\n\n@EqualsAndHashCode\npublic class ToStringExample {\n  private static final int STATIC_VAR = 10;\n  private String name;\n  @EqualsAndHashCode.Exclude private Shape shape = new Square(5, 10);\n  private String[] tags;\n  @EqualsAndHashCode.Exclude private int id;\n\n  public static class Shape {}\n\n  @EqualsAndHashCode(callSuper=true)\n  public static class Square extends Shape {\n    private final int width, height;\n\n    public Square(int width, int height) {\n      this.width = width;\n      this.height = height;\n    }\n  }\n}\n")});
    }

    @Test
    void constructor() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import lombok.*;\n\n@RequiredArgsConstructor(staticName = \"of\")\n@AllArgsConstructor(access = AccessLevel.PROTECTED)\npublic class ConstructorExample<T> {\n  private int x, y;\n  @NonNull private T description;\n\n  @NoArgsConstructor\n  public static class NoArgsExample {\n    @NonNull private String field;\n  }\n}\n")});
    }

    @Test
    void data() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import lombok.AccessLevel;\nimport lombok.Setter;\nimport lombok.Data;\nimport lombok.ToString;\n\n@Data public class DataExample {\n  private final String name;\n  @Setter(AccessLevel.PACKAGE) private int age;\n  private double score;\n  private String[] tags;\n\n  @ToString(includeFieldNames=true)\n  @Data(staticConstructor=\"of\")\n  public static class Exercise<T> {\n    private final String name;\n    private final T value;\n  }\n}\n")});
    }

    @Test
    void value() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import lombok.*;\nimport lombok.experimental.*;\n\n@Value public class ValueExample {\n  String name;\n  @With(AccessLevel.PACKAGE) @NonFinal int age;\n  double score;\n  protected String[] tags;\n\n  @ToString(includeFieldNames=true)\n  @Value(staticConstructor=\"of\")\n  public static class Exercise<T> {\n    String name;\n    T value;\n  }\n}\n")});
    }

    @Test
    void synchronize() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import lombok.Synchronized;\n\npublic class SynchronizedExample {\n  private final Object readLock = new Object();\n\n  @Synchronized\n  public static void hello() {\n    System.out.println(\"world\");\n  }\n\n  @Synchronized\n  public int answerToLife() {\n    return 42;\n  }\n\n  @Synchronized(\"readLock\")\n  public void foo() {\n    System.out.println(\"bar\");\n  }\n}\n")});
    }

    @Test
    void locked() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import lombok.Locked;\n\npublic class LockedExample {\n  private int value = 0;\n\n  @Locked.Read\n  public int getValue() {\n    return value;\n  }\n\n  @Locked.Write\n  public void setValue(int newValue) {\n    value = newValue;\n  }\n\n  @Locked(\"baseLock\")\n  public void foo() {\n    System.out.println(\"bar\");\n  }\n}\n")});
    }

    @Test
    void with() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import lombok.AccessLevel;\nimport lombok.NonNull;\nimport lombok.With;\n\npublic class WithExample {\n  @With(AccessLevel.PROTECTED) @NonNull private final String name;\n  @With private final int age;\n\n  public WithExample(@NonNull String name, int age) {\n    this.name = name;\n    this.age = age;\n  }\n}\n")});
    }

    @Test
    void lazyGetter() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import lombok.Getter;\n\npublic class GetterLazyExample {\n  @Getter(lazy=true) private final double[] cached = expensive();\n\n  private double[] expensive() {\n    double[] result = new double[1000000];\n    for (int i = 0; i < result.length; i++) {\n      result[i] = Math.asin(i);\n    }\n    return result;\n  }\n}\n")});
    }

    @Test
    void singular() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import lombok.Builder;\nimport lombok.Singular;\nimport java.util.Collection;\nimport java.util.Set;\nimport java.util.SortedMap;\n\n@Builder\npublic class SingularExample<T extends Number> {\n    private @Singular Set<String> occupations;\n    private @Singular SortedMap<Integer, T> elves;\n    private @Singular Collection<?> minutiae;\n}\n")});
    }

    @Test
    void jul() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import lombok.extern.java.Log;\n\nimport java.util.Map;\n\n@Log\nclass A {\n    String string;\n    Map<String, String> map;\n    void m() {\n        log.info(\"string = \" + string);\n        log.info(() -> \"map = %s\".formatted(map));\n    }\n}\n")});
    }

    @Test
    void val() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import lombok.val;\n\nclass A {\n    void m() {\n        val foo = \"foo\";\n    }\n}\n")});
    }

    @Test
    void sneakyThrows() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import lombok.SneakyThrows;\n\nimport java.io.UnsupportedEncodingException;\nimport java.nio.charset.StandardCharsets;\n\npublic class SneakyThrowsExample implements Runnable {\n    @SneakyThrows(UnsupportedEncodingException.class)\n    public String utf8ToString(byte[] bytes) {\n        return new String(bytes, StandardCharsets.UTF_8);\n    }\n\n    @SneakyThrows\n    public void run() {\n        try {\n            throw new Throwable();\n        } catch (RuntimeException e) {\n            throw e;\n        }\n    }\n}\n")});
    }

    @Test
    void accessors() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import lombok.experimental.Accessors;\nimport lombok.Getter;\nimport lombok.Setter;\n\n@Accessors(fluent = true)\npublic class AccessorsExample {\n    @Getter @Setter\n    private int age = 10;\n    public static void test() {\n          new AccessorsExample().age(20);\n    }\n}\n\nclass PrefixExample {\n    @Accessors(prefix = \"f\") @Getter\n    private String fName = \"Hello, World!\";\n    public static String test() {\n        return new PrefixExample().getName();\n    }\n}\n")});
    }

    @Test
    void fieldDefaults() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import lombok.AccessLevel;\nimport lombok.experimental.FieldDefaults;\nimport lombok.experimental.NonFinal;\nimport lombok.experimental.PackagePrivate;\n\n@FieldDefaults(makeFinal=true, level=AccessLevel.PRIVATE)\npublic class FieldDefaultsExample {\n  public final int a;\n  int b;\n  @NonFinal int c;\n  @PackagePrivate int d;\n  FieldDefaultsExample() {\n    a = 0;\n    b = 0;\n    d = 0;\n  }\n}\n", spec -> spec.afterRecipe(cu -> {
            List statements = ((J.ClassDeclaration)cu.getClasses().get(0)).getBody().getStatements();
            ((AbstractCollectionAssert)CollectionAssert.assertThatCollection((Collection)Objects.requireNonNull(((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)statements.get(0)).getVariables().get(0)).getVariableType()).getFlags()).as("Field 'a' explicitly specifies its modifiers, overriding the lombok defaults", new Object[0])).containsExactlyInAnyOrder((Object[])new Flag[]{Flag.Public, Flag.Final});
            ((AbstractCollectionAssert)CollectionAssert.assertThatCollection((Collection)Objects.requireNonNull(((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)statements.get(1)).getVariables().get(0)).getVariableType()).getFlags()).as("Field 'b' does not specify its modifiers, so it should use the lombok defaults", new Object[0])).containsExactlyInAnyOrder((Object[])new Flag[]{Flag.Private, Flag.Final});
            ((AbstractCollectionAssert)CollectionAssert.assertThatCollection((Collection)Objects.requireNonNull(((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)statements.get(2)).getVariables().get(0)).getVariableType()).getFlags()).as("Field 'c' is annotated with @NonFinal, so it should not be final", new Object[0])).containsExactlyInAnyOrder((Object[])new Flag[]{Flag.Private});
            ((AbstractCollectionAssert)CollectionAssert.assertThatCollection((Collection)Objects.requireNonNull(((J.VariableDeclarations.NamedVariable)((J.VariableDeclarations)statements.get(3)).getVariables().get(0)).getVariableType()).getFlags()).as("Field 'd' is annotated with @PackagePrivate, so it should be package-private", new Object[0])).containsExactlyInAnyOrder((Object[])new Flag[]{Flag.Final});
        }))});
    }

    @Test
    void delegate() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.util.ArrayList;\nimport java.util.Collection;\n\nimport lombok.experimental.Delegate;\n\npublic class DelegationExample {\n    private interface SimpleCollection {\n        boolean add(String item);\n        boolean remove(Object item);\n    }\n    @Delegate(types=SimpleCollection.class)\n    private final Collection<String> collection = new ArrayList<>();\n\n    static void test() {\n        DelegationExample example = new DelegationExample();\n        example.add(\"s\");\n        example.remove(\"s\");\n    }\n}\n\nclass ExcludesDelegateExample {\n    long counter = 0L;\n    private interface Add {\n        boolean add(String x);\n        boolean addAll(Collection<? extends String> x);\n    }\n    @Delegate(excludes=Add.class)\n    private final Collection<String> collection = new ArrayList<>();\n    public boolean add(String item) {\n        counter++;\n        return collection.add(item);\n    }\n    public boolean addAll(Collection<? extends String> col) {\n        counter += col.size();\n        return collection.addAll(col);\n    }\n}\n")});
    }

    @Test
    void utilityClass() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import lombok.experimental.UtilityClass;\n\n@UtilityClass\npublic class UtilityClassExample {\n  private final int CONSTANT = 5;\n\n  public int addSomething(int in) {\n    return in + CONSTANT;\n  }\n}\n")});
    }

    @Test
    void fieldNameConstants() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import lombok.experimental.FieldNameConstants;\n\n@FieldNameConstants\npublic class FieldNameConstantsExample {\n    private final String iAmAField;\n    private final int andSoAmI;\n    @FieldNameConstants.Exclude private final int asAmI;\n\n    public void test() {\n        System.out.println(FieldNameConstantsExample.Fields.iAmAField);\n        System.out.println(FieldNameConstantsExample.Fields.andSoAmI);\n    }\n}\n")});
    }

    @Test
    void tolerate() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import lombok.experimental.Tolerate;\nimport lombok.Setter;\n\npublic class TolerateExample {\n    @Setter\n    private String s;\n\n    @Tolerate\n    public void setS(Object s) {\n        this.s = s.toString();\n    }\n\n    public void both(String s) {\n        setS(s);\n        setS((Object)s);\n    }\n}\n")});
    }

    @Test
    void jacksonized() {
        this.rewriteRun(spec -> spec.parser((Parser.Builder)JavaParser.fromJavaVersion().classpath(new String[]{"jackson-annotations", "lombok"})), new SourceSpecs[]{Assertions.java((String)"import com.fasterxml.jackson.annotation.JsonIgnoreProperties;\nimport lombok.Builder;\nimport lombok.extern.jackson.Jacksonized;\n\n@Jacksonized\n@Builder\n@JsonIgnoreProperties(ignoreUnknown = true)\npublic class JacksonExample {\n    private List<String> strings;\n}\n")});
    }

    @Test
    void standardException() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import lombok.experimental.StandardException;\n\n@StandardException\npublic class ExampleException extends Exception {\n}\n")});
    }

    @Nested
    class LessSupported {
        LessSupported() {
        }

        @Test
        void extensionMethod() {
            LombokTest.this.rewriteRun(spec -> spec.typeValidationOptions(TypeValidation.none()), new SourceSpecs[]{Assertions.java((String)"import lombok.experimental.ExtensionMethod;\n\n@ExtensionMethod({java.util.Arrays.class, Extensions.class})\npublic class ExtensionMethodExample {\n    public String test() {\n        int[] intArray = {5, 3, 8, 2};\n        intArray.sort();\n        String iAmNull = null;\n        return iAmNull.or(\"hELlO, WORlD!\".toTitleCase());\n    }\n}\n\nclass Extensions {\n    public static <T> T or(T obj, T ifNull) {\n        return obj != null ? obj : ifNull;\n    }\n    public static String toTitleCase(String in) {\n        if (in.isEmpty()) return in;\n        return \"\" + Character.toTitleCase(in.charAt(0)) + in.substring(1).toLowerCase();\n    }\n}\n")});
        }

        @Test
        void onConstructor() {
            LombokTest.this.rewriteRun(spec -> spec.typeValidationOptions(TypeValidation.none()), new SourceSpecs[]{Assertions.java((String)"import lombok.AllArgsConstructor;\nimport lombok.Getter;\nimport lombok.Setter;\n\nimport javax.inject.Inject;\nimport javax.persistence.Id;\nimport javax.persistence.Column;\nimport javax.validation.constraints.Max;\n\n// @__ missing attribution\n@AllArgsConstructor(onConstructor=@__(@Inject))\npublic class OnXExample {\n    @Getter(onMethod_={@Id, @Column(name=\"unique-id\")}) //JDK8\n    @Setter(onParam_=@Max(10000)) //JDK8\n    private long unid;\n}\n")});
        }

        @Test
        void onConstructorNoArgs() {
            LombokTest.this.rewriteRun(spec -> spec.typeValidationOptions(TypeValidation.none()), new SourceSpecs[]{Assertions.java((String)"import lombok.NoArgsConstructor;\nimport lombok.Getter;\nimport lombok.RequiredArgsConstructor;import lombok.Setter;\n\nimport javax.inject.Inject;\n// @__ missing attribution\n@NoArgsConstructor(onConstructor = @__(@Inject))\n@RequiredArgsConstructor(onConstructor_ = @__(@Inject))\npublic class OnXExample {\n    private long unid;\n}\n")});
        }

        @Test
        void helper() {
            LombokTest.this.rewriteRun(spec -> spec.typeValidationOptions(TypeValidation.none()), new SourceSpecs[]{Assertions.java((String)"import lombok.experimental.Helper;\n\npublic class HelperExample {\n    int someMethod(int arg1) {\n        int localVar = 5;\n\n        @Helper\n        class Helpers {\n            int helperMethod(int arg) {\n                return arg + localVar;\n            }\n        }\n\n        // helperMethod missing type attribution\n        return helperMethod(10);\n    }\n}\n")});
        }
    }
}

