/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import org.junit.jupiter.api.Test;
import org.openrewrite.java.Assertions;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

class LambdaTest
implements RewriteTest {
    LambdaTest() {
    }

    @Test
    void lambda() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.util.function.Function;\nclass Test {\n    void test() {\n        Function<String, String> func = (String s) -> \"\";\n    }\n}\n")});
    }

    @Test
    void untypedLambdaParameter() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.util.*;\nclass Test {\n    void test() {\n        List<String> list = new ArrayList<>();\n        list.stream().filter(s -> s.isEmpty());\n    }\n}\n")});
    }

    @Test
    void optionalSingleParameterParentheses() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.util.*;\nclass Test {\n    void test() {\n        List<String> list = new ArrayList<>();\n        list.stream().filter((s) -> s.isEmpty());\n    }\n}\n")});
    }

    @Test
    void rightSideBlock() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public class A {\n    Action a = ( ) -> { };\n}\n\ninterface Action {\n    void call();\n}\n")});
    }

    @Test
    void multipleParameters() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"import java.util.function.BiConsumer;\nclass Test {\n    void test() {\n        BiConsumer<String, String> a = (s1, s2) -> { };\n    }\n}\n")});
    }
}

