/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import org.junit.jupiter.api.Test;
import org.openrewrite.java.Assertions;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

class MethodDeclarationTest
implements RewriteTest {
    MethodDeclarationTest() {
    }

    @Test
    void defaultValue() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public @interface A {\n    String foo() default \"foo\";\n}\n")});
    }

    @Test
    void constructor() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public class A {\n    public A() { }\n}\n")});
    }

    @Test
    void typeArguments() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    public <P, R> R foo(P p, String s, String... args) {\n        return null;\n    }\n}\n")});
    }

    @Test
    void interfaceMethodDecl() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"public interface A {\n    String getName() ;\n}\n")});
    }

    @Test
    void methodThrows() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    public void foo()  throws Exception { }\n}\n")});
    }

    @Test
    void nativeModifier() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    public native void foo();\n}\n")});
    }

    @Test
    void methodWithSuffixMultiComment() {
        this.rewriteRun(new SourceSpecs[]{Assertions.java((String)"class Test {\n    public void foo() { }/*Comments*/\n}\n")});
    }
}

