/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.marker.Quoted;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;

class TypeTreeTest {
    TypeTreeTest() {
    }

    @Test
    void buildFullyQualifiedClassName() {
        J.FieldAccess name = (J.FieldAccess)TypeTree.build((String)"java.util.List");
        Assertions.assertEquals((Object)"java.util.List", (Object)name.toString());
        Assertions.assertEquals((Object)"List", (Object)name.getSimpleName());
    }

    @Test
    void buildFullyQualifiedClassNameWithSpacing() {
        J.FieldAccess name = (J.FieldAccess)TypeTree.build((String)"java . util . List");
        Assertions.assertEquals((Object)"java . util . List", (Object)name.toString());
    }

    @Test
    void buildFullyQualifiedInnerClassName() {
        J.FieldAccess name = (J.FieldAccess)TypeTree.build((String)"a.Outer.Inner");
        Assertions.assertEquals((Object)"a.Outer.Inner", (Object)name.toString());
        Assertions.assertEquals((Object)"Inner", (Object)name.getSimpleName());
        Assertions.assertEquals((Object)"a.Outer.Inner", (Object)TypeUtils.asFullyQualified((JavaType)name.getType()).getFullyQualifiedName());
        J.FieldAccess outer = (J.FieldAccess)name.getTarget();
        Assertions.assertEquals((Object)"Outer", (Object)outer.getSimpleName());
        Assertions.assertEquals((Object)"a.Outer", (Object)TypeUtils.asFullyQualified((JavaType)outer.getType()).getFullyQualifiedName());
    }

    @Test
    void buildStaticImport() {
        J.FieldAccess name = (J.FieldAccess)TypeTree.build((String)"a.A.*");
        Assertions.assertEquals((Object)"a.A.*", (Object)name.toString());
        Assertions.assertEquals((Object)"*", (Object)name.getSimpleName());
    }

    @Test
    void buildEscapedName() {
        J.FieldAccess name = (J.FieldAccess)TypeTree.build((String)"foo.bar.`some escaped name`", (Character)Character.valueOf('`'));
        Assertions.assertTrue((boolean)name.getName().getMarkers().findFirst(Quoted.class).isPresent());
        Assertions.assertEquals((Object)"foo.bar.some escaped name", (Object)name.toString());
        Assertions.assertEquals((Object)"some escaped name", (Object)name.getSimpleName());
    }
}

