/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaTreeTest;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\b\u0010\b\u001a\u00020\u0003H\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\u000f"}, d2={"Lorg/openrewrite/java/tree/AnnotationTest;", "Lorg/openrewrite/java/tree/JavaTreeTest;", "annotationOnConstructorName", "", "jp", "Lorg/openrewrite/java/JavaParser;", "annotationWithArgument", "annotationWithDefaultArgument", "annotationsInFullyQualified", "annotationsInManyLocations", "annotationsWithComments", "multipleAnnotations", "newArrayArgument", "preserveOptionalEmptyParentheses", "typeParameterAnnotations", "rewrite-java-tck"})
public interface AnnotationTest
extends JavaTreeTest {
    @Test
    public void annotationWithDefaultArgument(@NotNull JavaParser var1);

    @Test
    public void annotationWithArgument(@NotNull JavaParser var1);

    @Test
    public void preserveOptionalEmptyParentheses(@NotNull JavaParser var1);

    @Test
    public void newArrayArgument(@NotNull JavaParser var1);

    @Test
    public void annotationsInManyLocations(@NotNull JavaParser var1);

    @Test
    public void multipleAnnotations(@NotNull JavaParser var1);

    @Test
    public void typeParameterAnnotations(@NotNull JavaParser var1);

    @Test
    public void annotationsWithComments(@NotNull JavaParser var1);

    @Test
    @Disabled
    public void annotationsInFullyQualified();

    @Test
    public void annotationOnConstructorName(@NotNull JavaParser var1);

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @Test
        public static void annotationWithDefaultArgument(@NotNull AnnotationTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            $this.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.CompilationUnit, "\n           @SuppressWarnings(\"ALL\")\n           public class A {}\n        ", new String[0]);
        }

        @Test
        public static void annotationWithArgument(@NotNull AnnotationTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            $this.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.CompilationUnit, "\n           @SuppressWarnings(value = \"ALL\")\n           public class A {}\n        ", new String[0]);
        }

        @Test
        public static void preserveOptionalEmptyParentheses(@NotNull AnnotationTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            $this.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.CompilationUnit, "\n           @Deprecated ( )\n           public class A {}\n        ", new String[0]);
        }

        @Test
        public static void newArrayArgument(@NotNull AnnotationTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            $this.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.CompilationUnit, "\n            import java.lang.annotation.Target;\n            import static java.lang.annotation.ElementType.*;\n\n            @Target({ FIELD, PARAMETER })\n            public @interface Annotation {}\n        ", new String[0]);
        }

        @Test
        public static void annotationsInManyLocations(@NotNull AnnotationTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            $this.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.CompilationUnit, "\n                import java.lang.annotation.*;\n                @Ho\n                public @Ho final @Ho class Test {\n                    @Ho private @Ho transient @Ho String s;\n                    @Ho\n                    public @Ho final @Ho <T> @Ho T merryChristmas() {\n                        return null;\n                    }\n                    @Ho\n                    public @Ho Test() {\n                    }\n                }\n                @Target({ElementType.TYPE_USE, ElementType.TYPE, ElementType.FIELD})\n                @interface Hos {\n                    Ho[] value();\n                }\n                @Target({ElementType.TYPE_USE, ElementType.TYPE, ElementType.FIELD})\n                @Repeatable(Hos.class)\n                @interface Ho {\n                }\n            ", new String[0]);
        }

        @Test
        public static void multipleAnnotations(@NotNull AnnotationTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            $this.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.CompilationUnit, "\n                import java.lang.annotation.*;\n                @B\n                @C\n                public class A {\n                }\n                @Target({ElementType.TYPE_USE, ElementType.TYPE, ElementType.FIELD})\n                @interface B {\n                }\n                @Target({ElementType.TYPE_USE, ElementType.TYPE, ElementType.FIELD})\n                @interface C {\n                }\n            ", new String[0]);
        }

        @Test
        public static void typeParameterAnnotations(@NotNull AnnotationTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            $this.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.CompilationUnit, "\n            import java.util.List;\n            import java.lang.annotation.*;\n            class TypeAnnotationTest {\n                List<@A ? extends @A String> list;\n           \n                @Target({ ElementType.FIELD, ElementType.TYPE_USE, ElementType.TYPE_PARAMETER })\n                private @interface A {\n                }\n            }\n        ", new String[0]);
        }

        @Test
        public static void annotationsWithComments(@NotNull AnnotationTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            $this.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.CompilationUnit, "\n                import java.lang.annotation.*;\n                @Yo\n                // doc\n                @Ho\n                public @Yo /* grumpy */ @Ho final @Yo\n                // happy\n                @Ho class Test {\n                    @Yo /* sleepy */ @Ho private @Yo /* bashful */ @Ho transient @Yo /* sneezy */ @Ho String s;\n                    @Yo /* dopey */ @Ho\n                    public @Yo /* evil queen */ @Ho final @Yo /* mirror */ @Ho <T> @Yo /* apple */ @Ho T itsOffToWorkWeGo() {\n                        return null;\n                    }\n                    @Yo /* snow white */ @Ho\n                    public @Yo /* prince */ @Ho Test() {\n                    }\n                }\n                @Target({ElementType.TYPE_USE, ElementType.TYPE, ElementType.FIELD})\n                @interface Hos {\n                    Ho[] value();\n                }\n                @Target({ElementType.TYPE_USE, ElementType.TYPE, ElementType.FIELD})\n                @Repeatable(Hos.class)\n                @interface Ho {\n                }\n                @Target({ElementType.TYPE_USE, ElementType.TYPE, ElementType.FIELD})\n                @interface Yos {\n                    Yo[] value();\n                }\n                @Target({ElementType.TYPE_USE, ElementType.TYPE, ElementType.FIELD})\n                @Repeatable(Yos.class)\n                @interface Yo {\n                }\n            ", new String[0]);
        }

        @Test
        @Disabled
        public static void annotationsInFullyQualified(@NotNull AnnotationTest $this) {
            String[] stringArray = new String[]{"\n                package annotation.fun;\n                import java.lang.annotation.*;\n            \n                @Target({ElementType.METHOD, ElementType.PARAMETER, ElementType.FIELD, ElementType.TYPE_USE})\n                @Retention(RetentionPolicy.RUNTIME)\n                public @interface Nullable {\n                }                \n            "};
            $this.assertParsePrintAndProcess(JavaParser.fromJavaVersion().logCompilationWarningsAndErrors(true).dependsOn(stringArray).build(), JavaTreeTest.NestingLevel.CompilationUnit, "\n            import annotation.fun.Nullable;\n            public class AnnotationFun {\n                public void justBecauseYouCanDoesntMeanYouShould(java.util.@Nullable List myList) {\n                }\n            }\n            ", new String[0]);
        }

        @Test
        public static void annotationOnConstructorName(@NotNull AnnotationTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n                import java.lang.annotation.*;\n                public class TypeAnnotationTest {\n    \n                    public @Deprecated @A TypeAnnotationTests() {\n                    }\n    \n                    @Target({ ElementType.TYPE, ElementType.TYPE_USE, ElementType.TYPE_PARAMETER })\n                    private @interface A {\n                    }\n                }\n            "};
            J.CompilationUnit cu = (J.CompilationUnit)jp.parse(stringArray).get(0);
            JavaIsoVisitor<ExecutionContext> visitor2 = new JavaIsoVisitor<ExecutionContext>(){

                @Nullable
                public J.Annotation visitAnnotation(@NotNull J.Annotation annotation2, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)annotation2, (String)"annotation");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (annotation2.getSimpleName().equals("A")) {
                        return null;
                    }
                    return super.visitAnnotation(annotation2, (Object)p);
                }
            };
            Tree tree = visitor2.visit((Tree)cu, (Object)new InMemoryExecutionContext());
            Intrinsics.checkNotNull((Object)tree, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.J.CompilationUnit");
            J.CompilationUnit after = (J.CompilationUnit)tree;
            Object e = ((J.ClassDeclaration)after.getClasses().get(0)).getBody().getStatements().get(0);
            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
            J.MethodDeclaration methodDeclaration2 = (J.MethodDeclaration)e;
            Assertions.assertThat((int)methodDeclaration2.getAllAnnotations().size()).isEqualTo(1);
            Assertions.assertThat((String)((J.Annotation)methodDeclaration2.getAllAnnotations().get(0)).getSimpleName()).isEqualTo("Deprecated");
        }
    }
}

