/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.TypeValidator;
import org.openrewrite.java.format.MinimumViableSpacingTest;
import org.openrewrite.java.tree.J;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u000f"}, d2={"Lorg/openrewrite/java/format/MinimumViableSpacingTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "recipe", "Lorg/openrewrite/Recipe;", "getRecipe", "()Lorg/openrewrite/Recipe;", "method", "", "jp", "Lorg/openrewrite/java/JavaParser;", "returnExpression", "spacesBetweenModifiers", "variableDeclarationsInClass", "variableDeclarationsInForLoops", "variableDeclarationsInMethod", "rewrite-java-tck"})
public interface MinimumViableSpacingTest
extends JavaRecipeTest {
    @NotNull
    public Recipe getRecipe();

    @Test
    public void method(@NotNull JavaParser var1);

    @Test
    public void returnExpression(@NotNull JavaParser var1);

    @Test
    public void variableDeclarationsInClass(@NotNull JavaParser var1);

    @Test
    public void variableDeclarationsInMethod(@NotNull JavaParser var1);

    @Test
    public void variableDeclarationsInForLoops(@NotNull JavaParser var1);

    @Test
    public void spacesBetweenModifiers(@NotNull JavaParser var1);

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static Recipe getRecipe(@NotNull MinimumViableSpacingTest $this) {
            Recipe recipe2 = $this.toRecipe(recipe.1.INSTANCE).doNext($this.toRecipe(recipe.2.INSTANCE));
            Intrinsics.checkNotNullExpressionValue((Object)recipe2, (String)"toRecipe {\n            o\u2026ExecutionContext>(null)})");
            return recipe2;
        }

        @Test
        public static void method(@NotNull MinimumViableSpacingTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default($this, jp, null, null, "\n            class A {\n                public <T> void foo() {\n                }\n            }\n        ", null, "\n            class A{public <T> void foo(){}}\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void returnExpression(@NotNull MinimumViableSpacingTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default($this, jp, null, null, "\n            class A {\n                public String foo() {\n                    return\"foo\";\n                }\n            }\n        ", null, "\n            class A{public String foo(){return \"foo\";}}\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void variableDeclarationsInClass(@NotNull MinimumViableSpacingTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default($this, jp, null, null, "\n            class A {\n                int unassigned;\n                int zero = 0;\n                final int one = 1;\n                public static final int ONE = 1;\n                public static final int TWO = 1, THREE = 3;\n            }\n        ", null, "\n            class A{int unassigned;int zero=0;final int one=1;public static final int ONE=1;public static final int TWO=1,THREE=3;}\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void variableDeclarationsInMethod(@NotNull MinimumViableSpacingTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default($this, jp, null, null, "\n            class A {\n                public void foo(int paramA, final int paramB) {\n                    int unassigned;\n                    int a = 1;\n                    int b, c = 5;\n                    final int d = 10;\n                    final int e, f = 20;\n                }\n            }\n        ", null, "\n            class A{public void foo(int paramA,final int paramB){int unassigned;int a=1;int b,c=5;final int d=10;final int e,f=20;}}\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void variableDeclarationsInForLoops(@NotNull MinimumViableSpacingTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default($this, jp, null, null, "\n            class Test {\n                void foo(final int[] arr) {\n                    for (int n = 0, x = 0; n < 100; n++, x++) {\n                    }\n                    \n                    for (int i: arr) {\n                    }\n                    \n                    for (final int i: arr) {\n                    }\n                }\n            }\n        ", null, "\n            class Test{void foo(final int[] arr){for(int n=0,x=0;n<100;n++,x++){}for(int i:arr){}for(final int i:arr){}}}\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void spacesBetweenModifiers(@NotNull MinimumViableSpacingTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default($this, null, null, null, "\n            public final class A {\n                public static String foo() { \n                    return \"foo\"; \n                } \n            }\n        ", null, "\n            public final class A{public static String foo(){return \"foo\";}}\n        ", 0, 0, null, null, 983, null);
        }

        @NotNull
        public static JavaParser getParser(@NotNull MinimumViableSpacingTest $this) {
            return JavaRecipeTest.DefaultImpls.getParser($this);
        }

        @NotNull
        public static ExecutionContext getExecutionContext(@NotNull MinimumViableSpacingTest $this) {
            return JavaRecipeTest.DefaultImpls.getExecutionContext($this);
        }

        @BeforeEach
        public static void beforeRecipe(@NotNull MinimumViableSpacingTest $this) {
            JavaRecipeTest.DefaultImpls.beforeRecipe($this);
        }

        @AfterEach
        public static void afterRecipe(@NotNull MinimumViableSpacingTest $this) {
            JavaRecipeTest.DefaultImpls.afterRecipe($this);
        }

        public static void assertChanged(@NotNull MinimumViableSpacingTest $this, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged($this, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull MinimumViableSpacingTest $this, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged($this, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertUnchanged(@NotNull MinimumViableSpacingTest $this, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged($this, parser, recipe2, executionContext, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull MinimumViableSpacingTest $this, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged($this, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        public static void assertChangedBase(@NotNull MinimumViableSpacingTest $this, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase($this, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull MinimumViableSpacingTest $this, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase($this, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertUnchangedBase(@NotNull MinimumViableSpacingTest $this, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase($this, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        public static void assertUnchangedBase(@NotNull MinimumViableSpacingTest $this, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase($this, parser, recipe2, executionContext, before, dependsOn);
        }

        @NotNull
        public static Recipe fromRuntimeClasspath(@NotNull MinimumViableSpacingTest $this, @NotNull String recipe2) {
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            return JavaRecipeTest.DefaultImpls.fromRuntimeClasspath($this, recipe2);
        }

        @NotNull
        public static Recipe toRecipe(@NotNull MinimumViableSpacingTest $this, @NotNull Function0<? extends TreeVisitor<?, ExecutionContext>> supplier) {
            Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
            return JavaRecipeTest.DefaultImpls.toRecipe($this, supplier);
        }
    }
}

