/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.TypeValidator;
import org.openrewrite.java.format.AutoFormat;
import org.openrewrite.java.format.BlankLines;
import org.openrewrite.java.format.BlankLinesTest;
import org.openrewrite.java.style.BlankLinesStyle;
import org.openrewrite.java.style.IntelliJ;
import org.openrewrite.java.tree.J;
import org.openrewrite.style.NamedStyles;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0006\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tH\u0017J\u0018\u0010\n\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tH\u0017J)\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0019\b\u0002\u0010\u000e\u001a\u0013\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0002\b\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tH\u0017J\u0018\u0010\u0013\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tH\u0017J\u0018\u0010\u0014\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tH\u0017J\u0018\u0010\u0015\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tH\u0017J\u0018\u0010\u0016\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tH\u0017J\u0018\u0010\u0017\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tH\u0017J\u0018\u0010\u0018\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tH\u0017J\u0018\u0010\u0019\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tH\u0017J\u0018\u0010\u001a\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tH\u0017J\u0018\u0010\u001b\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tH\u0017J\u0018\u0010\u001c\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tH\u0017J\u0018\u0010\u001d\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tH\u0017J\u0018\u0010\u001e\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tH\u0017J\u0018\u0010\u001f\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tH\u0017J\u0018\u0010 \u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tH\u0017J\u0018\u0010!\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tH\u0017J\u0018\u0010\"\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tH\u0017J\u0018\u0010#\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tH\u0017J\u0018\u0010$\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tH\u0017J\u0018\u0010%\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tH\u0017J\u0018\u0010&\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tH\u0017J\u0018\u0010'\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tH\u0017J\u0018\u0010(\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tH\u0017J\u0018\u0010)\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tH\u0017J\u0018\u0010*\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tH\u0017J\u0018\u0010+\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tH\u0017J\u0018\u0010,\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tH\u0017J\u0010\u0010-\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020.H\u0017J\u0018\u0010/\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\tH\u0017R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u00060"}, d2={"Lorg/openrewrite/java/format/BlankLinesTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "recipe", "Lorg/openrewrite/Recipe;", "getRecipe", "()Lorg/openrewrite/Recipe;", "aroundInitializer", "", "jp", "Lorg/openrewrite/java/JavaParser$Builder;", "beforeMethodBody", "blankLines", "", "Lorg/openrewrite/style/NamedStyles;", "with", "Lkotlin/Function1;", "Lorg/openrewrite/java/style/BlankLinesStyle;", "Lkotlin/ExtensionFunctionType;", "eachMethodOnItsOwnLine", "keepMaximumBeforeEndOfBlock", "keepMaximumBetweenHeaderAndPackage", "keepMaximumInCode", "keepMaximumInDeclarations", "leaveTrailingComments", "minimumAfterAnonymousClassHeader", "minimumAfterClassHeader", "minimumAfterClassHeaderNestedClasses", "minimumAfterClassHeaderNestedEnum", "minimumAfterImports", "minimumAfterPackage", "minimumAfterPackageWithImport", "minimumAroundClass", "minimumAroundClassNestedEnum", "minimumAroundField", "minimumAroundFieldInInterface", "minimumAroundMethod", "minimumAroundMethodInInterface", "minimumBeforeClassEnd", "minimumBeforeImports", "minimumBeforeImportsWithComment", "minimumBeforeImportsWithPackage", "minimumBeforePackage", "minimumBeforePackageWithComment", "minimumPackageWithComment", "noBlankLineForFirstEnum", "noImportsNoPackage", "Lorg/openrewrite/java/JavaParser;", "unchanged", "rewrite-java-tck"})
public interface BlankLinesTest
extends JavaRecipeTest {
    @NotNull
    public Recipe getRecipe();

    @NotNull
    public List<NamedStyles> blankLines(@NotNull Function1<? super BlankLinesStyle, BlankLinesStyle> var1);

    @Test
    public void leaveTrailingComments(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void noBlankLineForFirstEnum(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void eachMethodOnItsOwnLine(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void keepMaximumInDeclarations(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void keepMaximumInCode(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void keepMaximumBeforeEndOfBlock(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void keepMaximumBetweenHeaderAndPackage(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void minimumPackageWithComment(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void minimumBeforePackage(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void minimumBeforePackageWithComment(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void minimumBeforeImportsWithPackage(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void minimumBeforeImports(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void minimumBeforeImportsWithComment(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void minimumAfterPackageWithImport(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void minimumAfterPackage(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void minimumAfterImports(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void noImportsNoPackage(@NotNull JavaParser var1);

    @Test
    public void minimumAroundClass(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void minimumAroundClassNestedEnum(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void minimumAfterClassHeader(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void minimumAfterClassHeaderNestedClasses(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void minimumAfterClassHeaderNestedEnum(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void minimumBeforeClassEnd(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void minimumAfterAnonymousClassHeader(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void minimumAroundFieldInInterface(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void minimumAroundField(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void minimumAroundMethodInInterface(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void minimumAroundMethod(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void beforeMethodBody(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void aroundInitializer(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void unchanged(@NotNull JavaParser.Builder<?, ?> var1);

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static Recipe getRecipe(@NotNull BlankLinesTest $this) {
            return (Recipe)new BlankLines();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public static List<NamedStyles> blankLines(@NotNull BlankLinesTest $this, @NotNull Function1<? super BlankLinesStyle, BlankLinesStyle> with) {
            void $this$blankLines_u24lambda_u240;
            Intrinsics.checkNotNullParameter(with, (String)"with");
            BlankLinesStyle blankLinesStyle = IntelliJ.blankLines();
            Set set = SetsKt.emptySet();
            String string = "test";
            String string2 = "test";
            String string3 = "test";
            UUID uUID = Tree.randomId();
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)$this$blankLines_u24lambda_u240, (String)"this");
            BlankLinesStyle blankLinesStyle2 = (BlankLinesStyle)with.invoke((Object)$this$blankLines_u24lambda_u240);
            Collection collection = CollectionsKt.listOf((Object)blankLinesStyle2);
            Set set2 = set;
            String string4 = string;
            String string5 = string2;
            String string6 = string3;
            UUID uUID2 = uUID;
            return CollectionsKt.listOf((Object)new NamedStyles(uUID2, string6, string5, string4, set2, collection));
        }

        public static /* synthetic */ List blankLines$default(BlankLinesTest blankLinesTest, Function1 function1, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: blankLines");
            }
            if ((n & 1) != 0) {
                function1 = blankLines.1.INSTANCE;
            }
            return blankLinesTest.blankLines((Function1<? super BlankLinesStyle, BlankLinesStyle>)function1);
        }

        @Test
        public static void leaveTrailingComments(@NotNull BlankLinesTest $this, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            AutoFormat autoFormat = new AutoFormat();
            JavaParser javaParser = jp.styles((Iterable)DefaultImpls.blankLines$default($this, null, 1, null)).build();
            JavaRecipeTest javaRecipeTest = $this;
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"build()");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(javaRecipeTest, javaParser, (Recipe)autoFormat, null, "public class A {\n    private Long id; // this comment will move to wrong place\n\n    public Long id() {\n        return id;\n    }\n}", null, 20, null);
        }

        @Test
        public static void noBlankLineForFirstEnum(@NotNull BlankLinesTest $this, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            AutoFormat autoFormat = new AutoFormat();
            JavaParser javaParser = jp.styles((Iterable)DefaultImpls.blankLines$default($this, null, 1, null)).build();
            JavaRecipeTest javaRecipeTest = $this;
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"build()");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(javaRecipeTest, javaParser, (Recipe)autoFormat, null, "\n            public enum TheEnum {\n                FIRST,\n                SECOND\n            }\n        ", null, 20, null);
        }

        @Test
        public static void eachMethodOnItsOwnLine(@NotNull BlankLinesTest $this, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = $this;
            JavaParser javaParser = jp.styles((Iterable)DefaultImpls.blankLines$default($this, null, 1, null)).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.styles(blankLines()).build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, null, null, "\n            public class Test {\n                void a() {\n                }    void b() {\n                }\n            }\n        ", null, "\n            public class Test {\n                void a() {\n                }\n            \n                void b() {\n                }\n            }\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void keepMaximumInDeclarations(@NotNull BlankLinesTest $this, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = $this;
            JavaParser javaParser = jp.styles((Iterable)$this.blankLines((Function1<? super BlankLinesStyle, BlankLinesStyle>)((Function1)keepMaximumInDeclarations.1.INSTANCE))).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.styles(blankLines { w\u2026clarations(0)) }).build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, null, null, "\n            import java.util.List;\n            \n            \n            public class Test {\n            \n            \n                private int field1;\n                private int field2;\n            \n                {\n                    field1 = 2;\n                }\n            \n                public void test1() {\n                    new Runnable() {\n                        public void run() {\n                        }\n                    };\n                }\n            \n                public class InnerClass {\n                }\n\n                public enum InnerEnum {\n\n                    FIRST,\n                    SECOND\n                }\n            }\n        ", null, "\n            import java.util.List;\n            \n            public class Test {\n                private int field1;\n                private int field2;\n            \n                {\n                    field1 = 2;\n                }\n            \n                public void test1() {\n                    new Runnable() {\n                        public void run() {\n                        }\n                    };\n                }\n            \n                public class InnerClass {\n                }\n\n                public enum InnerEnum {\n                    FIRST,\n                    SECOND\n                }\n            }\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void keepMaximumInCode(@NotNull BlankLinesTest $this, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = $this;
            JavaParser javaParser = jp.styles((Iterable)$this.blankLines((Function1<? super BlankLinesStyle, BlankLinesStyle>)((Function1)keepMaximumInCode.1.INSTANCE))).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.styles(blankLines { w\u2026withInCode(0)) }).build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, null, null, "\n            public class Test {\n                private int field1;\n            \n                {\n\n\n                    field1 = 2;\n                }\n            }\n        ", null, "\n            public class Test {\n                private int field1;\n            \n                {\n                    field1 = 2;\n                }\n            }\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void keepMaximumBeforeEndOfBlock(@NotNull BlankLinesTest $this, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = $this;
            JavaParser javaParser = jp.styles((Iterable)$this.blankLines((Function1<? super BlankLinesStyle, BlankLinesStyle>)((Function1)keepMaximumBeforeEndOfBlock.1.INSTANCE))).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.styles(blankLines { w\u2026EndOfBlock(0)) }).build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, null, null, "\n            public class Test {\n                private int field1;\n            \n                {\n                    field1 = 2;\n\n\n                }\n\n                enum Test {\n                    FIRST,\n                    SECOND\n\n                }\n            }\n        ", null, "\n            public class Test {\n                private int field1;\n            \n                {\n                    field1 = 2;\n                }\n\n                enum Test {\n                    FIRST,\n                    SECOND\n                }\n            }\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void keepMaximumBetweenHeaderAndPackage(@NotNull BlankLinesTest $this, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = $this;
            JavaParser javaParser = jp.styles((Iterable)$this.blankLines((Function1<? super BlankLinesStyle, BlankLinesStyle>)((Function1)keepMaximumBetweenHeaderAndPackage.1.INSTANCE))).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.styles(blankLines {\n \u2026     )\n        }).build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, null, null, "\n            /*\n             * This is a sample file.\n             */\n\n            package com.intellij.samples;\n\n            public class Test {\n            }\n        ", null, "\n            /*\n             * This is a sample file.\n             */\n            package com.intellij.samples;\n\n            public class Test {\n            }\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void minimumPackageWithComment(@NotNull BlankLinesTest $this, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = $this;
            JavaParser javaParser = jp.styles((Iterable)$this.blankLines((Function1<? super BlankLinesStyle, BlankLinesStyle>)((Function1)minimumPackageWithComment.1.INSTANCE))).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.styles(blankLines {\n \u2026p max\"\n        }).build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, null, null, "\n            /*\n             * This is a sample file.\n             */\n            package com.intellij.samples;\n\n            public class Test {\n            }\n        ", null, "\n            /*\n             * This is a sample file.\n             */\n\n            package com.intellij.samples;\n\n            public class Test {\n            }\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void minimumBeforePackage(@NotNull BlankLinesTest $this, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = $this;
            JavaParser javaParser = jp.styles((Iterable)$this.blankLines((Function1<? super BlankLinesStyle, BlankLinesStyle>)((Function1)minimumBeforePackage.1.INSTANCE))).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.styles(blankLines {\n \u2026ackage\n        }).build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, null, null, "\n\n            package com.intellij.samples;\n\n            public class Test {\n            }\n        ", null, "\n            package com.intellij.samples;\n\n            public class Test {\n            }\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void minimumBeforePackageWithComment(@NotNull BlankLinesTest $this, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = $this;
            JavaParser javaParser = jp.styles((Iterable)$this.blankLines((Function1<? super BlankLinesStyle, BlankLinesStyle>)((Function1)minimumBeforePackageWithComment.1.INSTANCE))).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.styles(blankLines {\n \u2026p max\"\n        }).build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, null, null, "\n            /* Comment */\n            package com.intellij.samples;\n\n            public class Test {\n            }\n        ", null, "\n            /* Comment */\n\n            package com.intellij.samples;\n\n            public class Test {\n            }\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void minimumBeforeImportsWithPackage(@NotNull BlankLinesTest $this, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = $this;
            JavaParser javaParser = jp.styles((Iterable)$this.blankLines((Function1<? super BlankLinesStyle, BlankLinesStyle>)((Function1)minimumBeforeImportsWithPackage.1.INSTANCE))).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.styles(blankLines {\n \u2026ackage\n        }).build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, null, null, "\n            package com.intellij.samples;\n            import java.util.Vector;\n\n            public class Test {\n            }\n        ", null, "\n            package com.intellij.samples;\n\n            import java.util.Vector;\n\n            public class Test {\n            }\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void minimumBeforeImports(@NotNull BlankLinesTest $this, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = $this;
            JavaParser javaParser = jp.styles((Iterable)$this.blankLines((Function1<? super BlankLinesStyle, BlankLinesStyle>)((Function1)minimumBeforeImports.1.INSTANCE))).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.styles(blankLines {\n \u2026ackage\n        }).build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, null, null, "\n\n            import java.util.Vector;\n\n            public class Test {\n            }\n        ", null, "import java.util.Vector;\n\npublic class Test {\n}", 0, 0, null, null, 982, null);
        }

        @Test
        public static void minimumBeforeImportsWithComment(@NotNull BlankLinesTest $this, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = $this;
            JavaParser javaParser = jp.styles((Iterable)$this.blankLines((Function1<? super BlankLinesStyle, BlankLinesStyle>)((Function1)minimumBeforeImportsWithComment.1.INSTANCE))).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.styles(blankLines {\n \u2026ackage\n        }).build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, null, null, "\n            /*\n             * This is a sample file.\n             */\n            import java.util.Vector;\n\n            public class Test {\n            }\n        ", null, "\n            /*\n             * This is a sample file.\n             */\n\n            import java.util.Vector;\n\n            public class Test {\n            }\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void minimumAfterPackageWithImport(@NotNull BlankLinesTest $this, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = $this;
            JavaParser javaParser = jp.styles((Iterable)$this.blankLines((Function1<? super BlankLinesStyle, BlankLinesStyle>)((Function1)minimumAfterPackageWithImport.1.INSTANCE))).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.styles(blankLines {\n \u2026     )\n        }).build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, null, null, "\n            package com.intellij.samples;\n            import java.util.Vector;\n\n            public class Test {\n            }\n        ", null, "\n            package com.intellij.samples;\n\n            import java.util.Vector;\n\n            public class Test {\n            }\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void minimumAfterPackage(@NotNull BlankLinesTest $this, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = $this;
            JavaParser javaParser = jp.styles((Iterable)$this.blankLines((Function1<? super BlankLinesStyle, BlankLinesStyle>)((Function1)minimumAfterPackage.1.INSTANCE))).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.styles(blankLines {\n \u2026ge(1))\n        }).build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, null, null, "\n            package com.intellij.samples;\n            public class Test {\n            }\n        ", null, "\n            package com.intellij.samples;\n\n            public class Test {\n            }\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void minimumAfterImports(@NotNull BlankLinesTest $this, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = $this;
            JavaParser javaParser = jp.styles((Iterable)$this.blankLines((Function1<? super BlankLinesStyle, BlankLinesStyle>)((Function1)minimumAfterImports.1.INSTANCE))).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.styles(blankLines {\n \u2026ts(1))\n        }).build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, null, null, "\n            import java.util.Vector;\n            public class Test {\n            }\n        ", null, "import java.util.Vector;\n\npublic class Test {\n}", 0, 0, null, null, 982, null);
        }

        @Test
        public static void noImportsNoPackage(@NotNull BlankLinesTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default($this, jp, null, null, "\n            \n            class Test {\n            }\n        ", null, "\n            class Test {\n            }\n        ", 0, 0, null, noImportsNoPackage.1.INSTANCE, 470, null);
        }

        @Test
        public static void minimumAroundClass(@NotNull BlankLinesTest $this, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = $this;
            JavaParser javaParser = jp.styles((Iterable)$this.blankLines((Function1<? super BlankLinesStyle, BlankLinesStyle>)((Function1)minimumAroundClass.1.INSTANCE))).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.styles(blankLines {\n \u2026ss(2))\n        }).build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, null, null, "\n            import java.util.Vector;\n\n            public class Test {\n            }\n\n            class Test2 {\n                class InnerClass0 {\n                }\n                class InnerClass1 {\n                }\n            }\n        ", null, "import java.util.Vector;\n\npublic class Test {\n}\n\n\nclass Test2 {\n    class InnerClass0 {\n    }\n\n\n    class InnerClass1 {\n    }\n}", 0, 0, null, null, 982, null);
        }

        @Test
        public static void minimumAroundClassNestedEnum(@NotNull BlankLinesTest $this, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = $this;
            JavaParser javaParser = jp.styles((Iterable)$this.blankLines((Function1<? super BlankLinesStyle, BlankLinesStyle>)((Function1)minimumAroundClassNestedEnum.1.INSTANCE))).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.styles(blankLines { w\u2026roundClass(2)) }).build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, null, null, "\n            enum OuterEnum {\n                FIRST,\n                SECOND\n            }\n\n            class OuterClass {\n                enum InnerEnum0 {\n                    FIRST,\n                    SECOND\n                }\n                enum InnerEnum1 {\n                    FIRST,\n                    SECOND\n                }\n            }\n        ", null, "\n            enum OuterEnum {\n                FIRST,\n                SECOND\n            }\n\n\n            class OuterClass {\n                enum InnerEnum0 {\n                    FIRST,\n                    SECOND\n                }\n\n\n                enum InnerEnum1 {\n                    FIRST,\n                    SECOND\n                }\n            }\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void minimumAfterClassHeader(@NotNull BlankLinesTest $this, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = $this;
            JavaParser javaParser = jp.styles((Iterable)$this.blankLines((Function1<? super BlankLinesStyle, BlankLinesStyle>)((Function1)minimumAfterClassHeader.1.INSTANCE))).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.styles(blankLines {\n \u2026er(1))\n        }).build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, null, null, "\n            public class Test {\n                private int field1;\n            }\n        ", null, "\n            public class Test {\n\n                private int field1;\n            }\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void minimumAfterClassHeaderNestedClasses(@NotNull BlankLinesTest $this, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = $this;
            JavaParser javaParser = jp.styles((Iterable)$this.blankLines((Function1<? super BlankLinesStyle, BlankLinesStyle>)((Function1)minimumAfterClassHeaderNestedClasses.1.INSTANCE))).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.styles(blankLines { w\u2026lassHeader(1)) }).build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, null, null, "\n            class OuterClass {\n                class InnerClass0 {\n                    private int unused = 0;\n                }\n\n                class InnerClass1 {\n                    private int unused = 0;\n                }\n            }\n        ", null, "\n            class OuterClass {\n\n                class InnerClass0 {\n\n                    private int unused = 0;\n                }\n\n                class InnerClass1 {\n\n                    private int unused = 0;\n                }\n            }\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void minimumAfterClassHeaderNestedEnum(@NotNull BlankLinesTest $this, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = $this;
            JavaParser javaParser = jp.styles((Iterable)$this.blankLines((Function1<? super BlankLinesStyle, BlankLinesStyle>)((Function1)minimumAfterClassHeaderNestedEnum.1.INSTANCE))).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.styles(blankLines { w\u2026lassHeader(1)) }).build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, null, null, "\n            class OuterClass {\n                enum InnerEnum0 {\n                    FIRST,\n                    SECOND\n                }\n            }\n        ", null, "\n            class OuterClass {\n\n                enum InnerEnum0 {\n                    FIRST,\n                    SECOND\n                }\n            }\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void minimumBeforeClassEnd(@NotNull BlankLinesTest $this, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = $this;
            JavaParser javaParser = jp.styles((Iterable)$this.blankLines((Function1<? super BlankLinesStyle, BlankLinesStyle>)((Function1)minimumBeforeClassEnd.1.INSTANCE))).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.styles(blankLines {\n \u2026nd(1))\n        }).build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, null, null, "\n            public class Test {\n            }\n        ", null, "\n            public class Test {\n\n            }\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void minimumAfterAnonymousClassHeader(@NotNull BlankLinesTest $this, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = $this;
            JavaParser javaParser = jp.styles((Iterable)$this.blankLines((Function1<? super BlankLinesStyle, BlankLinesStyle>)((Function1)minimumAfterAnonymousClassHeader.1.INSTANCE))).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.styles(blankLines {\n \u2026er(1))\n        }).build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, null, null, "\n            public class Test {\n                public void test1() {\n                    new Runnable() {\n                        public void run() {\n                        }\n                    };\n                }\n            }\n        ", null, "\n            public class Test {\n                public void test1() {\n                    new Runnable() {\n\n                        public void run() {\n                        }\n                    };\n                }\n            }\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void minimumAroundFieldInInterface(@NotNull BlankLinesTest $this, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = $this;
            JavaParser javaParser = jp.styles((Iterable)$this.blankLines((Function1<? super BlankLinesStyle, BlankLinesStyle>)((Function1)minimumAroundFieldInInterface.1.INSTANCE))).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.styles(blankLines {\n \u2026ce(1))\n        }).build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, null, null, "\n            interface TestInterface {\n                int MAX = 10;\n                int MIN = 1;\n            }\n        ", null, "\n            interface TestInterface {\n                int MAX = 10;\n\n                int MIN = 1;\n            }\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void minimumAroundField(@NotNull BlankLinesTest $this, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = $this;
            JavaParser javaParser = jp.styles((Iterable)$this.blankLines((Function1<? super BlankLinesStyle, BlankLinesStyle>)((Function1)minimumAroundField.1.INSTANCE))).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.styles(blankLines {\n \u2026ld(1))\n        }).build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, null, null, "\n            class Test {\n                int max = 10;\n                int min = 1;\n            }\n        ", null, "\n            class Test {\n                int max = 10;\n\n                int min = 1;\n            }\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void minimumAroundMethodInInterface(@NotNull BlankLinesTest $this, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = $this;
            JavaParser javaParser = jp.styles((Iterable)$this.blankLines((Function1<? super BlankLinesStyle, BlankLinesStyle>)((Function1)minimumAroundMethodInInterface.1.INSTANCE))).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.styles(blankLines {\n \u2026ce(1))\n        }).build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, null, null, "\n            interface TestInterface {\n                void method1();\n                void method2();\n            }\n        ", null, "\n            interface TestInterface {\n                void method1();\n\n                void method2();\n            }\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void minimumAroundMethod(@NotNull BlankLinesTest $this, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = $this;
            JavaParser javaParser = jp.styles((Iterable)$this.blankLines((Function1<? super BlankLinesStyle, BlankLinesStyle>)((Function1)minimumAroundMethod.1.INSTANCE))).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.styles(blankLines {\n \u2026od(1))\n        }).build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, null, null, "\n            class Test {\n                void method1() {}\n                void method2() {}\n            }\n        ", null, "\n            class Test {\n                void method1() {}\n\n                void method2() {}\n            }\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void beforeMethodBody(@NotNull BlankLinesTest $this, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = $this;
            JavaParser javaParser = jp.styles((Iterable)$this.blankLines((Function1<? super BlankLinesStyle, BlankLinesStyle>)((Function1)beforeMethodBody.1.INSTANCE))).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.styles(blankLines {\n \u2026dy(1))\n        }).build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, null, null, "\n            class Test {\n                void method1() {}\n\n                void method2() {\n                    int n = 0;\n                }\n            }\n        ", null, "\n            class Test {\n                void method1() {\n\n                }\n\n                void method2() {\n\n                    int n = 0;\n                }\n            }\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void aroundInitializer(@NotNull BlankLinesTest $this, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = $this;
            JavaParser javaParser = jp.styles((Iterable)$this.blankLines((Function1<? super BlankLinesStyle, BlankLinesStyle>)((Function1)aroundInitializer.1.INSTANCE))).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.styles(blankLines {\n \u2026er(1))\n        }).build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, null, null, "\n            public class Test {\n                private int field1;\n                {\n                    field1 = 2;\n                }\n                private int field2;\n            }\n            public enum Enum {\n                A, B;\n                {\n                \n                }\n                private int field;\n            }\n        ", null, "\n            public class Test {\n                private int field1;\n\n                {\n                    field1 = 2;\n                }\n\n                private int field2;\n            }\n            \n            public enum Enum {\n                A, B;\n            \n                {\n                \n                }\n            \n                private int field;\n            }\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void unchanged(@NotNull BlankLinesTest $this, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = $this;
            JavaParser javaParser = jp.styles((Iterable)DefaultImpls.blankLines$default($this, null, 1, null)).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.styles(blankLines()).build()");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(javaRecipeTest, javaParser, null, null, "\n            package com.intellij.samples;\n\n            public class Test {\n            }\n        ", null, 22, null);
        }

        @NotNull
        public static JavaParser getParser(@NotNull BlankLinesTest $this) {
            return JavaRecipeTest.DefaultImpls.getParser($this);
        }

        @NotNull
        public static ExecutionContext getExecutionContext(@NotNull BlankLinesTest $this) {
            return JavaRecipeTest.DefaultImpls.getExecutionContext($this);
        }

        @BeforeEach
        public static void beforeRecipe(@NotNull BlankLinesTest $this) {
            JavaRecipeTest.DefaultImpls.beforeRecipe($this);
        }

        @AfterEach
        public static void afterRecipe(@NotNull BlankLinesTest $this) {
            JavaRecipeTest.DefaultImpls.afterRecipe($this);
        }

        public static void assertChanged(@NotNull BlankLinesTest $this, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged($this, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull BlankLinesTest $this, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged($this, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertUnchanged(@NotNull BlankLinesTest $this, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged($this, parser, recipe2, executionContext, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull BlankLinesTest $this, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged($this, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        public static void assertChangedBase(@NotNull BlankLinesTest $this, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase($this, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull BlankLinesTest $this, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase($this, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertUnchangedBase(@NotNull BlankLinesTest $this, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase($this, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        public static void assertUnchangedBase(@NotNull BlankLinesTest $this, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase($this, parser, recipe2, executionContext, before, dependsOn);
        }

        @NotNull
        public static Recipe fromRuntimeClasspath(@NotNull BlankLinesTest $this, @NotNull String recipe2) {
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            return JavaRecipeTest.DefaultImpls.fromRuntimeClasspath($this, recipe2);
        }

        @NotNull
        public static Recipe toRecipe(@NotNull BlankLinesTest $this, @NotNull Function0<? extends TreeVisitor<?, ExecutionContext>> supplier) {
            Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
            return JavaRecipeTest.DefaultImpls.toRecipe($this, supplier);
        }
    }
}

