/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dataflow;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.Cursor;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.dataflow.FindLocalFlowPaths;
import org.openrewrite.java.dataflow.LocalFlowSpec;
import org.openrewrite.java.dataflow.LocalTaintFlowSpec;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0003H\u0017J\b\u0010\u0007\u001a\u00020\u0003H\u0017J\b\u0010\b\u001a\u00020\u0003H\u0017J\b\u0010\t\u001a\u00020\u0003H\u0017J\b\u0010\n\u001a\u00020\u0003H\u0017J\b\u0010\u000b\u001a\u00020\u0003H\u0017J\b\u0010\f\u001a\u00020\u0003H\u0017J\b\u0010\r\u001a\u00020\u0003H\u0017\u00a8\u0006\u000e"}, d2={"Lorg/openrewrite/java/dataflow/FindLocalTaintFlowTest;", "Lorg/openrewrite/test/RewriteTest;", "defaults", "", "spec", "Lorg/openrewrite/test/RecipeSpec;", "taint stops at a sanitizer", "taint tracking through String join", "taint tracking through file constructor", "taint tracking through file manipulations", "taint tracking through string appending", "taint tracking through string manipulations", "taint tracking through try", "taint tracking through try with resources", "rewrite-java-tck"})
public interface FindLocalTaintFlowTest
extends RewriteTest {
    public void defaults(@NotNull RecipeSpec var1);

    @Test
    public void taint tracking through string manipulations();

    @Test
    public void taint tracking through file manipulations();

    @Test
    public void taint tracking through file constructor();

    @Test
    public void taint tracking through String join();

    @Test
    public void taint tracking through string appending();

    @Test
    public void taint stops at a sanitizer();

    @Test
    public void taint tracking through try with resources();

    @Test
    public void taint tracking through try();

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        public static void defaults(@NotNull FindLocalTaintFlowTest $this, @NotNull RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::defaults$lambda$0));
            spec.expectedCyclesThatMakeChanges(1).cycles(1);
        }

        @Test
        public static void taint tracking through string manipulations(@NotNull FindLocalTaintFlowTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                class Test {\n                    String source() { return null; }\n                    void test() {\n                        String n = source();\n                        String o = n.substring(0, 3);\n                        String p = o.toUpperCase();\n                        System.out.println(p);\n                    }\n                }\n            ", (String)"\n                class Test {\n                    String source() { return null; }\n                    void test() {\n                        String n = /*~~>*/source();\n                        String o = /*~~>*//*~~>*/n.substring(0, 3);\n                        String p = /*~~>*//*~~>*/o.toUpperCase();\n                        System.out.println(/*~~>*/p);\n                    }\n                }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void taint tracking through file manipulations(@NotNull FindLocalTaintFlowTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                import java.io.File;\n                import java.nio.file.Path;\n                class Test {\n                    File source() { return null; }\n                    void test() {\n                        {\n                            File n = source();\n                            String o = n.getAbsolutePath();\n                            String p = o.toUpperCase();\n                            System.out.println(p);\n                        }\n                        // To Path Type\n                        {\n                            File n = source();\n                            Path o = n.toPath();\n                            File p = o.toFile();\n                            System.out.println(p);\n                        }\n                    }\n                }\n            ", (String)"\n                import java.io.File;\n                import java.nio.file.Path;\n                class Test {\n                    File source() { return null; }\n                    void test() {\n                        {\n                            File n = /*~~>*/source();\n                            String o = /*~~>*//*~~>*/n.getAbsolutePath();\n                            String p = /*~~>*//*~~>*/o.toUpperCase();\n                            System.out.println(/*~~>*/p);\n                        }\n                        // To Path Type\n                        {\n                            File n = /*~~>*/source();\n                            Path o = /*~~>*//*~~>*/n.toPath();\n                            File p = /*~~>*//*~~>*/o.toFile();\n                            System.out.println(/*~~>*/p);\n                        }\n                    }\n                }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void taint tracking through file constructor(@NotNull FindLocalTaintFlowTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                import java.io.File;\n                import java.net.URI;\n                class Test {\n                    String source() { return null; }\n                    void test() {\n                        String n = source();\n                        File o = new File(n);\n                        URI p = o.toURI();\n                        System.out.println(p);\n                    }\n                }\n            ", (String)"\n                import java.io.File;\n                import java.net.URI;\n                class Test {\n                    String source() { return null; }\n                    void test() {\n                        String n = /*~~>*/source();\n                        File o = /*~~>*/new File(/*~~>*/n);\n                        URI p = /*~~>*//*~~>*/o.toURI();\n                        System.out.println(/*~~>*/p);\n                    }\n                }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void taint tracking through String join(@NotNull FindLocalTaintFlowTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                class Test {\n                    String source() { return null; }\n                    void test() {\n                        String n = source();\n                        String o = String.join(\", \", n);\n                        String p = String.join(o, \", \");\n                        String q = String.join(\" \", \"hello\", p);\n                        System.out.println(q);\n                    }\n                }\n                ", (String)"\n                class Test {\n                    String source() { return null; }\n                    void test() {\n                        String n = /*~~>*/source();\n                        String o = /*~~>*/String.join(\", \", /*~~>*/n);\n                        String p = /*~~>*/String.join(/*~~>*/o, \", \");\n                        String q = /*~~>*/String.join(\" \", \"hello\", /*~~>*/p);\n                        System.out.println(/*~~>*/q);\n                    }\n                }\n                ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void taint tracking through string appending(@NotNull FindLocalTaintFlowTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                import java.io.File;\n                class Test {\n                    String source() { return null; }\n                    void test() {\n                        String n = source();\n                        String o = \"hello \" + n ;\n                        String p = o + \" world\";\n                        String q = p + File.separatorChar;\n                        String r = q + true;\n                        System.out.println(r);\n                    }\n                }\n                ", (String)"\n                import java.io.File;\n                class Test {\n                    String source() { return null; }\n                    void test() {\n                        String n = /*~~>*/source();\n                        String o = /*~~>*/\"hello \" + /*~~>*/n ;\n                        String p = /*~~>*//*~~>*/o + \" world\";\n                        String q = /*~~>*//*~~>*/p + File.separatorChar;\n                        String r = /*~~>*//*~~>*/q + true;\n                        System.out.println(/*~~>*/r);\n                    }\n                }\n                ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void taint stops at a sanitizer(@NotNull FindLocalTaintFlowTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                import java.io.File;\n                class Test {\n                    String source() { return null; }\n                    void test() {\n                        String n = source();\n                        String o = \"hello \" + n ;\n                        String p = o + \" world\";\n                        String q = p + \"sanitizer\";\n                        String r = q + true;\n                        System.out.println(r);\n                    }\n                }\n                ", (String)"\n                import java.io.File;\n                class Test {\n                    String source() { return null; }\n                    void test() {\n                        String n = /*~~>*/source();\n                        String o = /*~~>*/\"hello \" + /*~~>*/n ;\n                        String p = /*~~>*//*~~>*/o + \" world\";\n                        String q = /*~~>*/p + \"sanitizer\";\n                        String r = q + true;\n                        System.out.println(r);\n                    }\n                }\n                ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void taint tracking through try with resources(@NotNull FindLocalTaintFlowTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                import java.io.InputStream;\n                class Test {\n                    InputStream source() { return null; }\n                    void test() {\n                        try (InputStream source = source()) {\n                            System.out.println(source.read());\n                        }\n                    }\n                }\n                ", (String)"\n                import java.io.InputStream;\n                class Test {\n                    InputStream source() { return null; }\n                    void test() {\n                        try (InputStream source = /*~~>*/source()) {\n                            System.out.println(/*~~>*/source.read());\n                        }\n                    }\n                }\n                ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void taint tracking through try(@NotNull FindLocalTaintFlowTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                import java.io.InputStream;\n                class Test {\n                    InputStream source() { return null; }\n                    void test() {\n                        InputStream source = source();\n                        try {\n                            System.out.println(source.read());\n                        } finally {\n                            source.close();\n                        }\n                    }\n                }\n                ", (String)"\n                import java.io.InputStream;\n                class Test {\n                    InputStream source() { return null; }\n                    void test() {\n                        InputStream source = /*~~>*/source();\n                        try {\n                            System.out.println(/*~~>*/source.read());\n                        } finally {\n                            /*~~>*/source.close();\n                        }\n                    }\n                }\n                ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        private static TreeVisitor defaults$lambda$0() {
            return (TreeVisitor)new FindLocalFlowPaths((LocalFlowSpec)new LocalTaintFlowSpec<J.MethodInvocation, Expression>(){

                public boolean isSource(@NotNull J.MethodInvocation mi, @NotNull Cursor cursor) {
                    Intrinsics.checkNotNullParameter((Object)mi, (String)"mi");
                    Intrinsics.checkNotNullParameter((Object)cursor, (String)"cursor");
                    return Intrinsics.areEqual((Object)mi.getName().getSimpleName(), (Object)"source");
                }

                public boolean isSink(@NotNull Expression expr, @NotNull Cursor cursor) {
                    Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
                    Intrinsics.checkNotNullParameter((Object)cursor, (String)"cursor");
                    return true;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public boolean isSanitizer(@NotNull Expression expression, @NotNull Cursor cursor) {
                    Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                    Intrinsics.checkNotNullParameter((Object)cursor, (String)"cursor");
                    if (!(expression instanceof J.Binary)) return false;
                    if (((J.Binary)expression).getOperator() != J.Binary.Type.Addition) return false;
                    Expression expression2 = ((J.Binary)expression).getRight();
                    J.Literal literal2 = expression2 instanceof J.Literal ? (J.Literal)expression2 : null;
                    if (!Intrinsics.areEqual((Object)(literal2 != null ? literal2.getValue() : null), (Object)"sanitizer")) return false;
                    return true;
                }
            });
        }
    }
}

