/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dataflow;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.Cursor;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.controlflow.Guard;
import org.openrewrite.java.dataflow.FindLocalFlowPaths;
import org.openrewrite.java.dataflow.LocalFlowSpec;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u001d\n\u0002\u0018\u0002\n\u0002\b\u001d\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0017J\b\u0010\u0004\u001a\u00020\u0003H\u0017J\b\u0010\u0005\u001a\u00020\u0003H\u0017J\b\u0010\u0006\u001a\u00020\u0003H\u0017J\b\u0010\u0007\u001a\u00020\u0003H\u0017J\b\u0010\b\u001a\u00020\u0003H\u0017J\b\u0010\t\u001a\u00020\u0003H\u0017J\b\u0010\n\u001a\u00020\u0003H\u0017J\b\u0010\u000b\u001a\u00020\u0003H\u0017J\b\u0010\f\u001a\u00020\u0003H\u0017J\b\u0010\r\u001a\u00020\u0003H\u0017J\b\u0010\u000e\u001a\u00020\u0003H\u0017J\b\u0010\u000f\u001a\u00020\u0003H\u0017J\b\u0010\u0010\u001a\u00020\u0003H\u0017J\b\u0010\u0011\u001a\u00020\u0003H\u0017J\b\u0010\u0012\u001a\u00020\u0003H\u0017J\b\u0010\u0013\u001a\u00020\u0003H\u0017J\b\u0010\u0014\u001a\u00020\u0003H\u0017J\b\u0010\u0015\u001a\u00020\u0003H\u0017J\b\u0010\u0016\u001a\u00020\u0003H\u0017J\b\u0010\u0017\u001a\u00020\u0003H\u0017J\b\u0010\u0018\u001a\u00020\u0003H\u0017J\b\u0010\u0019\u001a\u00020\u0003H\u0017J\b\u0010\u001a\u001a\u00020\u0003H\u0017J\b\u0010\u001b\u001a\u00020\u0003H\u0017J\b\u0010\u001c\u001a\u00020\u0003H\u0017J\b\u0010\u001d\u001a\u00020\u0003H\u0017J\b\u0010\u001e\u001a\u00020\u0003H\u0017J\u0010\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u0003H\u0017J\b\u0010#\u001a\u00020\u0003H\u0017J\b\u0010$\u001a\u00020\u0003H\u0017J\b\u0010%\u001a\u00020\u0003H\u0017J\b\u0010&\u001a\u00020\u0003H\u0017J\b\u0010'\u001a\u00020\u0003H\u0017J\b\u0010(\u001a\u00020\u0003H\u0017J\b\u0010)\u001a\u00020\u0003H\u0017J\b\u0010*\u001a\u00020\u0003H\u0017J\b\u0010+\u001a\u00020\u0003H\u0017J\b\u0010,\u001a\u00020\u0003H\u0017J\b\u0010-\u001a\u00020\u0003H\u0017J\b\u0010.\u001a\u00020\u0003H\u0017J\b\u0010/\u001a\u00020\u0003H\u0017J\b\u00100\u001a\u00020\u0003H\u0017J\b\u00101\u001a\u00020\u0003H\u0017J\b\u00102\u001a\u00020\u0003H\u0017J\b\u00103\u001a\u00020\u0003H\u0017J\b\u00104\u001a\u00020\u0003H\u0017J\b\u00105\u001a\u00020\u0003H\u0017J\b\u00106\u001a\u00020\u0003H\u0017J\b\u00107\u001a\u00020\u0003H\u0017J\b\u00108\u001a\u00020\u0003H\u0017J\b\u00109\u001a\u00020\u0003H\u0017J\b\u0010:\u001a\u00020\u0003H\u0017J\b\u0010;\u001a\u00020\u0003H\u0017J\b\u0010<\u001a\u00020\u0003H\u0017J\b\u0010=\u001a\u00020\u0003H\u0017\u00a8\u0006>"}, d2={"Lorg/openrewrite/java/dataflow/FindLocalFlowPathsStringTest;", "Lorg/openrewrite/test/RewriteTest;", "Objects requireNotNull is a valid flow step", "", "a class name in a constructor call is not considered as a part of dataflow", "a class name in a constructor call on parent type is not considered as a part of dataflow", "a class variable access is not considered as a part of dataflow", "a method name is not considered as a part of dataflow", "a ternary condition is not considered a data flow step", "a ternary operator is considered a data flow step", "a ternary operator is considered a data flow step 2", "a thrown exception is a guard", "a thrown exception is a guard when included in an boolean expression", "a thrown exception is a guard when included in an boolean expression De Morgan's", "assert expression", "assignment of value inside if block", "data flow for a source in a do-while block", "data flow for a source in a doubly higher block", "data flow for a source in a for each block", "data flow for a source in a for i block", "data flow for a source in a higher block", "data flow for a source in a higher block in init block", "data flow for a source in a higher block in static block", "data flow for a source in a triply higher block", "data flow for a source in a try catch block", "data flow for a source in a try catch finally block", "data flow for a source in a while block", "data flow for a source in an if block", "data flow for a source in an init", "data flow should not cross scope boundaries", "data flow should not cross scope boundaries with class scope variable conflicts", "defaults", "spec", "Lorg/openrewrite/test/RecipeSpec;", "false literal guard", "for-each loop", "generic object instantiation", "if-statement with boolean array index conditional", "lambda expression", "reassignment of a variable breaks flow", "reassignment of a variable with existing value preserves flow", "reassignment of a variable with existing value wrapped in parentheses preserves flow", "source is tracked when assigned in do while loop control parentheses", "source is tracked when assigned in for loop", "source is tracked when assigned in while loop control parentheses", "switch with multiple cases", "taint flow is not data flow but it is tracked to call site", "taint flow via append is not data flow", "taint flow via constructor call is not data flow", "the source as a literal is also a sink", "the source can be tracked through wrapped parentheses", "the source can be tracked through wrapped parentheses through casting", "the source is also a sink", "the source is also a sink double call chain", "the source is also a sink simple", "transitive assignment from literal", "transitive assignment from literal with with a guard", "transitive assignment from literal with with a negated guard", "transitive assignment from literal with with a || guard", "transitive assignment from source method", "true literal guard", "try-catch block", "rewrite-java-tck"})
public interface FindLocalFlowPathsStringTest
extends RewriteTest {
    public void defaults(@NotNull RecipeSpec var1);

    @Test
    public void transitive assignment from literal();

    @Test
    public void transitive assignment from source method();

    @Test
    public void taint flow via append is not data flow();

    @Test
    public void taint flow is not data flow but it is tracked to call site();

    @Test
    public void taint flow via constructor call is not data flow();

    @Test
    public void the source is also a sink simple();

    @Test
    public void the source as a literal is also a sink();

    @Test
    public void the source is also a sink();

    @Test
    public void the source is also a sink double call chain();

    @Test
    public void the source can be tracked through wrapped parentheses();

    @Test
    public void the source can be tracked through wrapped parentheses through casting();

    @Test
    public void source is tracked when assigned in while loop control parentheses();

    @Test
    public void source is tracked when assigned in do while loop control parentheses();

    @Test
    public void source is tracked when assigned in for loop();

    @Test
    public void assignment of value inside if block();

    @Test
    public void reassignment of a variable breaks flow();

    @Test
    public void reassignment of a variable with existing value preserves flow();

    @Test
    public void reassignment of a variable with existing value wrapped in parentheses preserves flow();

    @Test
    public void a class name in a constructor call is not considered as a part of dataflow();

    @Test
    public void a class name in a constructor call on parent type is not considered as a part of dataflow();

    @Test
    public void a method name is not considered as a part of dataflow();

    @Test
    public void a class variable access is not considered as a part of dataflow();

    @Test
    public void a ternary operator is considered a data flow step();

    @Test
    public void a ternary operator is considered a data flow step 2();

    @Test
    public void a ternary condition is not considered a data flow step();

    @Test
    public void Objects requireNotNull is a valid flow step();

    @Test
    public void transitive assignment from literal with with a guard();

    @Test
    public void transitive assignment from literal with with a || guard();

    @Test
    public void transitive assignment from literal with with a negated guard();

    @Test
    public void a thrown exception is a guard();

    @Test
    public void a thrown exception is a guard when included in an boolean expression();

    @Test
    public void a thrown exception is a guard when included in an boolean expression De Morgan's();

    @Test
    public void try-catch block();

    @Test
    public void if-statement with boolean array index conditional();

    @Test
    public void switch with multiple cases();

    @Test
    public void for-each loop();

    @Test
    public void generic object instantiation();

    @Test
    public void assert expression();

    @Test
    public void lambda expression();

    @Test
    public void true literal guard();

    @Test
    public void false literal guard();

    @Test
    public void data flow for a source in a higher block();

    @Test
    public void data flow for a source in a doubly higher block();

    @Test
    public void data flow for a source in a triply higher block();

    @Test
    public void data flow for a source in an if block();

    @Test
    public void data flow for a source in a while block();

    @Test
    public void data flow for a source in a do-while block();

    @Test
    public void data flow for a source in a for i block();

    @Test
    public void data flow for a source in a for each block();

    @Test
    public void data flow for a source in a try catch block();

    @Test
    public void data flow for a source in a try catch finally block();

    @Test
    public void data flow should not cross scope boundaries();

    @Test
    public void data flow should not cross scope boundaries with class scope variable conflicts();

    @Test
    public void data flow for a source in a higher block in static block();

    @Test
    public void data flow for a source in an init();

    @Test
    public void data flow for a source in a higher block in init block();

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        public static void defaults(@NotNull FindLocalFlowPathsStringTest $this, @NotNull RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::defaults$lambda$0));
            spec.expectedCyclesThatMakeChanges(1).cycles(1);
        }

        @Test
        public static void transitive assignment from literal(@NotNull FindLocalFlowPathsStringTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                class Test {\n                    void test() {\n                        String n = \"42\";\n                        String o = n;\n                        System.out.println(o);\n                        String p = o;\n                    }\n                }\n            ", (String)"\n                class Test {\n                    void test() {\n                        String n = /*~~>*/\"42\";\n                        String o = /*~~>*/n;\n                        System.out.println(/*~~>*/o);\n                        String p = /*~~>*/o;\n                    }\n                }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void transitive assignment from source method(@NotNull FindLocalFlowPathsStringTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                class Test {\n                    String source() {\n                        return null;\n                    }\n\n                    void test() {\n                        String n = source();\n                        String o = n;\n                        System.out.println(o);\n                        String p = o;\n                    }\n                }\n            ", (String)"\n                class Test {\n                    String source() {\n                        return null;\n                    }\n\n                    void test() {\n                        String n = /*~~>*/source();\n                        String o = /*~~>*/n;\n                        System.out.println(/*~~>*/o);\n                        String p = /*~~>*/o;\n                    }\n                }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void taint flow via append is not data flow(@NotNull FindLocalFlowPathsStringTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                class Test {\n                    void test() {\n                        String n = \"42\";\n                        String o = n + '/';\n                        System.out.println(o);\n                        String p = o;\n                    }\n                }\n            ", (String)"\n                class Test {\n                    void test() {\n                        String n = /*~~>*/\"42\";\n                        String o = /*~~>*/n + '/';\n                        System.out.println(o);\n                        String p = o;\n                    }\n                }\n                ")};
            $this.rewriteRun(DefaultImpls::taint_flow_via_append_is_not_data_flow$lambda$1, sourceSpecsArray);
        }

        @Test
        public static void taint flow is not data flow but it is tracked to call site(@NotNull FindLocalFlowPathsStringTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                class Test {\n                    void test() {\n                        String n = \"42\";\n                        String o = n.toString() + '/';\n                        System.out.println(o);\n                        String p = o;\n                    }\n                }\n            ", (String)"\n                class Test {\n                    void test() {\n                        String n = /*~~>*/\"42\";\n                        String o = /*~~>*//*~~>*/n.toString() + '/';\n                        System.out.println(o);\n                        String p = o;\n                    }\n                }\n                ")};
            $this.rewriteRun(DefaultImpls::taint_flow_is_not_data_flow_but_it_is_tracked_to_call_site$lambda$2, sourceSpecsArray);
        }

        @Test
        public static void taint flow via constructor call is not data flow(@NotNull FindLocalFlowPathsStringTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                class Test {\n                    void test() {\n                        String n = \"42\";\n                        java.io.File o = new java.io.File(n);\n                        System.out.println(o);\n                    }\n                }\n            ", (String)"\n                class Test {\n                    void test() {\n                        String n = /*~~>*/\"42\";\n                        java.io.File o = new java.io.File(/*~~>*/n);\n                        System.out.println(o);\n                    }\n                }\n                ")};
            $this.rewriteRun(DefaultImpls::taint_flow_via_constructor_call_is_not_data_flow$lambda$3, sourceSpecsArray);
        }

        @Test
        public static void the source is also a sink simple(@NotNull FindLocalFlowPathsStringTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                class Test {\n                    String source() {\n                        return null;\n                    }\n                    void sink(Object any) {\n                        // do nothing\n                    }\n                    void test() {\n                        sink(source());\n                    }\n                }\n            ", (String)"\n                class Test {\n                    String source() {\n                        return null;\n                    }\n                    void sink(Object any) {\n                        // do nothing\n                    }\n                    void test() {\n                        sink(/*~~>*/source());\n                    }\n                }\n            ")};
            $this.rewriteRun(DefaultImpls::the_source_is_also_a_sink_simple$lambda$4, sourceSpecsArray);
        }

        @Test
        public static void the source as a literal is also a sink(@NotNull FindLocalFlowPathsStringTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                class Test {\n                    void sink(Object any) {\n                        // do nothing\n                    }\n                    void test() {\n                        sink(\"42\");\n                    }\n                }\n            ", (String)"\n                class Test {\n                    void sink(Object any) {\n                        // do nothing\n                    }\n                    void test() {\n                        sink(/*~~>*/\"42\");\n                    }\n                }\n            ")};
            $this.rewriteRun(DefaultImpls::the_source_as_a_literal_is_also_a_sink$lambda$5, sourceSpecsArray);
        }

        @Test
        public static void the source is also a sink(@NotNull FindLocalFlowPathsStringTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                import java.util.Locale;\n                class Test {\n                    String source() {\n                        return null;\n                    }\n                    void test() {\n                        source();\n                        source()\n                            .toString();\n                        source()\n                            .toLowerCase(Locale.ROOT);\n                        source()\n                            .toString()\n                            .toLowerCase(Locale.ROOT);\n                    }\n                }\n            ", (String)"\n                import java.util.Locale;\n                class Test {\n                    String source() {\n                        return null;\n                    }\n                    void test() {\n                        /*~~>*/source();\n                        /*~~>*//*~~>*/source()\n                            .toString();\n                        /*~~>*/source()\n                            .toLowerCase(Locale.ROOT);\n                        /*~~>*//*~~>*/source()\n                            .toString()\n                            .toLowerCase(Locale.ROOT);\n                    }\n                }\n                ")};
            $this.rewriteRun(DefaultImpls::the_source_is_also_a_sink$lambda$6, sourceSpecsArray);
        }

        @Test
        public static void the source is also a sink double call chain(@NotNull FindLocalFlowPathsStringTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                class Test {\n                    String source() {\n                        return null;\n                    }\n                    void test() {\n                        source()\n                            .toString()\n                            .toString();\n                    }\n                }\n            ", (String)"\n                class Test {\n                    String source() {\n                        return null;\n                    }\n                    void test() {\n                        /*~~>*//*~~>*//*~~>*/source()\n                            .toString()\n                            .toString();\n                    }\n                }\n                ")};
            $this.rewriteRun(DefaultImpls::the_source_is_also_a_sink_double_call_chain$lambda$7, sourceSpecsArray);
        }

        @Test
        public static void the source can be tracked through wrapped parentheses(@NotNull FindLocalFlowPathsStringTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                import java.util.Locale;\n                class Test {\n                    String source() {\n                        return null;\n                    }\n                    void test() {\n                        (\n                            source()\n                        ).toLowerCase(Locale.ROOT);\n                        (\n                            (\n                                source()\n                            )\n                        ).toLowerCase(Locale.ROOT);\n                        (\n                            (Object) source()\n                        ).equals(null);\n                    }\n                }\n            ", (String)"\n                import java.util.Locale;\n                class Test {\n                    String source() {\n                        return null;\n                    }\n                    void test() {\n                        /*~~>*/(\n                            /*~~>*/source()\n                        ).toLowerCase(Locale.ROOT);\n                        /*~~>*/(\n                            /*~~>*/(\n                                /*~~>*/source()\n                            )\n                        ).toLowerCase(Locale.ROOT);\n                        /*~~>*/(\n                            /*~~>*/(Object) /*~~>*/source()\n                        ).equals(null);\n                    }\n                }\n                ")};
            $this.rewriteRun(DefaultImpls::the_source_can_be_tracked_through_wrapped_parentheses$lambda$8, sourceSpecsArray);
        }

        @Test
        public static void the source can be tracked through wrapped parentheses through casting(@NotNull FindLocalFlowPathsStringTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                import java.util.Locale;\n                class Test {\n                    String source() {\n                        return null;\n                    }\n                    void test() {\n                        (\n                            (String)(\n                                (Object) source()\n                            )\n                        ).toString();\n                    }\n                }\n            ", (String)"\n                import java.util.Locale;\n                class Test {\n                    String source() {\n                        return null;\n                    }\n                    void test() {\n                        /*~~>*//*~~>*/(\n                            /*~~>*/(String)/*~~>*/(\n                                /*~~>*/(Object) /*~~>*/source()\n                            )\n                        ).toString();\n                    }\n                }\n                ")};
            $this.rewriteRun(DefaultImpls::the_source_can_be_tracked_through_wrapped_parentheses_through_casting$lambda$9, sourceSpecsArray);
        }

        @Test
        public static void source is tracked when assigned in while loop control parentheses(@NotNull FindLocalFlowPathsStringTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                class Test {\n                    String source() {\n                        return null;\n                    }\n                    @SuppressWarnings(\"SillyAssignment\")\n                    void test() {\n                        String a;\n                        a = a;\n                        while ((a = source()) != null) {\n                            System.out.println(a);\n                        }\n                    }\n                }\n            ", (String)"\n            class Test {\n                String source() {\n                    return null;\n                }\n                @SuppressWarnings(\"SillyAssignment\")\n                void test() {\n                    String a;\n                    a = a;\n                    while ((a = /*~~>*/source()) != null) {\n                        System.out.println(/*~~>*/a);\n                    }\n                }\n            }\n                ")};
            $this.rewriteRun(DefaultImpls::source_is_tracked_when_assigned_in_while_loop_control_parentheses$lambda$10, sourceSpecsArray);
        }

        @Test
        public static void source is tracked when assigned in do while loop control parentheses(@NotNull FindLocalFlowPathsStringTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                class Test {\n                    String source() {\n                        return null;\n                    }\n                    @SuppressWarnings(\"SillyAssignment\")\n                    void test() {\n                        String a = null;\n                        a = a;\n                        do {\n                            System.out.println(a);\n                        } while ((a = source()) != null);\n                    }\n                }\n            ", (String)"\n            class Test {\n                String source() {\n                    return null;\n                }\n                @SuppressWarnings(\"SillyAssignment\")\n                void test() {\n                    String a = null;\n                    a = a;\n                    do {\n                        System.out.println(/*~~>*/a);\n                    } while ((a = /*~~>*/source()) != null);\n                }\n            }\n                ")};
            $this.rewriteRun(DefaultImpls::source_is_tracked_when_assigned_in_do_while_loop_control_parentheses$lambda$11, sourceSpecsArray);
        }

        @Test
        public static void source is tracked when assigned in for loop(@NotNull FindLocalFlowPathsStringTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                class Test {\n                    String source(int i) {\n                        return null;\n                    }\n                    @SuppressWarnings(\"SillyAssignment\")\n                    void test() {\n                        String a = null;\n                        a = a;\n                        for (int i = 0; i < 10 && (a = source(i)) != null; i++) {\n                            System.out.println(a);\n                        }\n                    }\n                }\n            ", (String)"\n            class Test {\n                String source(int i) {\n                    return null;\n                }\n                @SuppressWarnings(\"SillyAssignment\")\n                void test() {\n                    String a = null;\n                    a = a;\n                    for (int i = 0; i < 10 && (a = /*~~>*/source(i)) != null; i++) {\n                        System.out.println(/*~~>*/a);\n                    }\n                }\n            }\n                ")};
            $this.rewriteRun(DefaultImpls::source_is_tracked_when_assigned_in_for_loop$lambda$12, sourceSpecsArray);
        }

        @Test
        public static void assignment of value inside if block(@NotNull FindLocalFlowPathsStringTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                String source() {\n                    return null;\n                }\n                void test(boolean condition) {\n                    String a = null;\n                    if (condition) {\n                        a = source();\n                        System.out.println(a);\n                    }\n                }\n            }\n            ", (String)"\n            class Test {\n                String source() {\n                    return null;\n                }\n                void test(boolean condition) {\n                    String a = null;\n                    if (condition) {\n                        a = /*~~>*/source();\n                        System.out.println(/*~~>*/a);\n                    }\n                }\n            }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void reassignment of a variable breaks flow(@NotNull FindLocalFlowPathsStringTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                class Test {\n                    void test() {\n                        String n = \"42\";\n                        System.out.println(n);\n                        n = \"100\";\n                        System.out.println(n);\n                    }\n                }\n            ", (String)"\n                class Test {\n                    void test() {\n                        String n = /*~~>*/\"42\";\n                        System.out.println(/*~~>*/n);\n                        n = \"100\";\n                        System.out.println(n);\n                    }\n                }\n            ")};
            $this.rewriteRun(DefaultImpls::reassignment_of_a_variable_breaks_flow$lambda$13, sourceSpecsArray);
        }

        @Test
        public static void reassignment of a variable with existing value preserves flow(@NotNull FindLocalFlowPathsStringTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                class Test {\n                    void test() {\n                        String n = \"42\";\n                        System.out.println(n);\n                        n = n;\n                        System.out.println(n);\n                    }\n                }\n            ", (String)"\n                class Test {\n                    void test() {\n                        String n = /*~~>*/\"42\";\n                        System.out.println(/*~~>*/n);\n                        n = /*~~>*/n;\n                        System.out.println(/*~~>*/n);\n                    }\n                }\n            ")};
            $this.rewriteRun(DefaultImpls::reassignment_of_a_variable_with_existing_value_preserves_flow$lambda$14, sourceSpecsArray);
        }

        @Test
        public static void reassignment of a variable with existing value wrapped in parentheses preserves flow(@NotNull FindLocalFlowPathsStringTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                class Test {\n                    void test() {\n                        String n = \"42\";\n                        System.out.println(n);\n                        (n) = n;\n                        System.out.println(n);\n                    }\n                }\n            ", (String)"\n                class Test {\n                    void test() {\n                        String n = /*~~>*/\"42\";\n                        System.out.println(/*~~>*/n);\n                        (n) = /*~~>*/n;\n                        System.out.println(/*~~>*/n);\n                    }\n                }\n            ")};
            $this.rewriteRun(DefaultImpls::reassignment_of_a_variable_with_existing_value_wrapped_in_parentheses_preserves_flow$lambda$15, sourceSpecsArray);
        }

        @Test
        public static void a class name in a constructor call is not considered as a part of dataflow(@NotNull FindLocalFlowPathsStringTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                class Test {\n                    class n {}\n\n                    void test() {\n                        String n = \"42\";\n                        System.out.println(n);\n                        n = new n().toString();\n                        System.out.println(n);\n                    }\n                }\n            ", (String)"\n                class Test {\n                    class n {}\n\n                    void test() {\n                        String n = /*~~>*/\"42\";\n                        System.out.println(/*~~>*/n);\n                        n = new n().toString();\n                        System.out.println(n);\n                    }\n                }\n            ")};
            $this.rewriteRun(DefaultImpls::a_class_name_in_a_constructor_call_is_not_considered_as_a_part_of_dataflow$lambda$16, sourceSpecsArray);
        }

        @Test
        public static void a class name in a constructor call on parent type is not considered as a part of dataflow(@NotNull FindLocalFlowPathsStringTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                class Test {\n                    class n {}\n\n                    void test() {\n                        String n = \"42\";\n                        System.out.println(n);\n                        n = new Test.n().toString();\n                        System.out.println(n);\n                    }\n                }\n            ", (String)"\n                class Test {\n                    class n {}\n\n                    void test() {\n                        String n = /*~~>*/\"42\";\n                        System.out.println(/*~~>*/n);\n                        n = new Test.n().toString();\n                        System.out.println(n);\n                    }\n                }\n            ")};
            $this.rewriteRun(DefaultImpls::a_class_name_in_a_constructor_call_on_parent_type_is_not_considered_as_a_part_of_dataflow$lambda$17, sourceSpecsArray);
        }

        @Test
        public static void a method name is not considered as a part of dataflow(@NotNull FindLocalFlowPathsStringTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                class Test {\n                    String n() {\n                        return null;\n                    }\n\n                    void test() {\n                        String n = \"42\";\n                        System.out.println(n);\n                        n = n();\n                        System.out.println(n);\n                    }\n                }\n            ", (String)"\n                class Test {\n                    String n() {\n                        return null;\n                    }\n\n                    void test() {\n                        String n = /*~~>*/\"42\";\n                        System.out.println(/*~~>*/n);\n                        n = n();\n                        System.out.println(n);\n                    }\n                }\n            ")};
            $this.rewriteRun(DefaultImpls::a_method_name_is_not_considered_as_a_part_of_dataflow$lambda$18, sourceSpecsArray);
        }

        @Test
        public static void a class variable access is not considered as a part of dataflow(@NotNull FindLocalFlowPathsStringTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                class Test {\n                    String n = \"100\";\n\n                    void test() {\n                        String n = \"42\";\n                        System.out.println(n);\n                        System.out.println(this.n);\n                    }\n                }\n            ", (String)"\n                class Test {\n                    String n = \"100\";\n\n                    void test() {\n                        String n = /*~~>*/\"42\";\n                        System.out.println(/*~~>*/n);\n                        System.out.println(this.n);\n                    }\n                }\n            ")};
            $this.rewriteRun(DefaultImpls::a_class_variable_access_is_not_considered_as_a_part_of_dataflow$lambda$19, sourceSpecsArray);
        }

        @Test
        public static void a ternary operator is considered a data flow step(@NotNull FindLocalFlowPathsStringTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                class Test {\n\n                    void test(boolean conditional) {\n                        String n = conditional ? \"42\" : \"100\";\n                        System.out.println(n);\n                    }\n                }\n            ", (String)"\n                class Test {\n\n                    void test(boolean conditional) {\n                        String n = /*~~>*/conditional ? /*~~>*/\"42\" : \"100\";\n                        System.out.println(/*~~>*/n);\n                    }\n                }\n            ")};
            $this.rewriteRun(DefaultImpls::a_ternary_operator_is_considered_a_data_flow_step$lambda$20, sourceSpecsArray);
        }

        @Test
        public static void a ternary operator is considered a data flow step 2(@NotNull FindLocalFlowPathsStringTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                class Test {\n\n                    void test(boolean conditional) {\n                        String n = \"42\";\n                        String m = conditional ? \"100\" : n;\n                        System.out.println(m);\n                    }\n                }\n            ", (String)"\n                class Test {\n\n                    void test(boolean conditional) {\n                        String n = /*~~>*/\"42\";\n                        String m = /*~~>*/conditional ? \"100\" : /*~~>*/n;\n                        System.out.println(/*~~>*/m);\n                    }\n                }\n            ")};
            $this.rewriteRun(DefaultImpls::a_ternary_operator_is_considered_a_data_flow_step_2$lambda$21, sourceSpecsArray);
        }

        @Test
        public static void a ternary condition is not considered a data flow step(@NotNull FindLocalFlowPathsStringTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                class Test {\n\n                    Boolean source() {\n                        return null;\n                    }\n\n                    void test(String other) {\n                        String n = source() ? \"102\" : \"100\";\n                        System.out.println(n);\n                    }\n                }\n            ", (String)"\n                class Test {\n\n                    Boolean source() {\n                        return null;\n                    }\n\n                    void test(String other) {\n                        String n = /*~~>*/source() ? \"102\" : \"100\";\n                        System.out.println(n);\n                    }\n                }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void Objects requireNotNull is a valid flow step(@NotNull FindLocalFlowPathsStringTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                import java.util.Objects;\n                @SuppressWarnings({\"ObviousNullCheck\", \"RedundantSuppression\"})\n                class Test {\n                    void test() {\n                        String n = Objects.requireNonNull(\"42\");\n                        String o = n;\n                        System.out.println(Objects.requireNonNull(o));\n                        String p = o;\n                    }\n                }\n            ", (String)"\n                import java.util.Objects;\n                @SuppressWarnings({\"ObviousNullCheck\", \"RedundantSuppression\"})\n                class Test {\n                    void test() {\n                        String n = /*~~>*/Objects.requireNonNull(/*~~>*/\"42\");\n                        String o = /*~~>*/n;\n                        System.out.println(/*~~>*/Objects.requireNonNull(/*~~>*/o));\n                        String p = /*~~>*/o;\n                    }\n                }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void transitive assignment from literal with with a guard(@NotNull FindLocalFlowPathsStringTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                abstract class Test {\n                    abstract boolean guard();\n\n                    void test() {\n                        String n = \"42\";\n                        if (guard()) {\n                            String o = n;\n                            System.out.println(o);\n                            String p = o;\n                        } else {\n                            System.out.println(n);\n                        }\n                    }\n                }\n            ", (String)"\n                abstract class Test {\n                    abstract boolean guard();\n\n                    void test() {\n                        String n = /*~~>*/\"42\";\n                        if (guard()) {\n                            String o = n;\n                            System.out.println(o);\n                            String p = o;\n                        } else {\n                            System.out.println(/*~~>*/n);\n                        }\n                    }\n                }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void transitive assignment from literal with with a || guard(@NotNull FindLocalFlowPathsStringTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                abstract class Test {\n                    abstract boolean guard();\n\n                    void test() {\n                        String n = \"42\";\n                        if (guard() || guard()) {\n                            String o = n;\n                            System.out.println(o);\n                            String p = o;\n                        } else {\n                            System.out.println(n);\n                        }\n                    }\n                }\n            ", (String)"\n                abstract class Test {\n                    abstract boolean guard();\n\n                    void test() {\n                        String n = /*~~>*/\"42\";\n                        if (guard() || guard()) {\n                            String o = n;\n                            System.out.println(o);\n                            String p = o;\n                        } else {\n                            System.out.println(/*~~>*/n);\n                        }\n                    }\n                }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void transitive assignment from literal with with a negated guard(@NotNull FindLocalFlowPathsStringTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                abstract class Test {\n                    abstract boolean guard();\n\n                    void test() {\n                        String n = \"42\";\n                        if (!guard()) {\n                            String o = n;\n                            System.out.println(o);\n                            String p = o;\n                        } else {\n                            System.out.println(n);\n                        }\n                    }\n                }\n            ", (String)"\n                abstract class Test {\n                    abstract boolean guard();\n\n                    void test() {\n                        String n = /*~~>*/\"42\";\n                        if (!guard()) {\n                            String o = /*~~>*/n;\n                            System.out.println(/*~~>*/o);\n                            String p = /*~~>*/o;\n                        } else {\n                            System.out.println(n);\n                        }\n                    }\n                }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void a thrown exception is a guard(@NotNull FindLocalFlowPathsStringTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                abstract boolean guard();\n\n                void test() {\n                    String n = \"42\";\n                    if (!guard()) {\n                        throw new RuntimeException();\n                    }\n                    String o = n;\n                    System.out.println(o);\n                    String p = o;\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                abstract boolean guard();\n\n                void test() {\n                    String n = /*~~>*/\"42\";\n                    if (!guard()) {\n                        throw new RuntimeException();\n                    }\n                    String o = n;\n                    System.out.println(o);\n                    String p = o;\n                }\n            }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void a thrown exception is a guard when included in an boolean expression(@NotNull FindLocalFlowPathsStringTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                abstract boolean guard();\n\n                void test() {\n                    String n = \"42\";\n                    if (!guard() && !guard()) {\n                        throw new RuntimeException();\n                    }\n                    String o = n;\n                    System.out.println(o);\n                    String p = o;\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                abstract boolean guard();\n\n                void test() {\n                    String n = /*~~>*/\"42\";\n                    if (!guard() && !guard()) {\n                        throw new RuntimeException();\n                    }\n                    String o = n;\n                    System.out.println(o);\n                    String p = o;\n                }\n            }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void a thrown exception is a guard when included in an boolean expression De Morgan's(@NotNull FindLocalFlowPathsStringTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                abstract boolean guard();\n\n                void test() {\n                    String n = \"42\";\n                    if (!(guard() || guard())) {\n                        throw new RuntimeException();\n                    }\n                    String o = n;\n                    System.out.println(o);\n                    String p = o;\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                abstract boolean guard();\n\n                void test() {\n                    String n = /*~~>*/\"42\";\n                    if (!(guard() || guard())) {\n                        throw new RuntimeException();\n                    }\n                    String o = n;\n                    System.out.println(o);\n                    String p = o;\n                }\n            }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void try-catch block(@NotNull FindLocalFlowPathsStringTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                abstract boolean guard();\n\n                void test() {\n                    String n = \"42\";\n                    try {\n                        System.out.println(n);\n                    } catch (Exception e) {\n                        System.out.println(n);\n                    }\n                    String o = n;\n                    System.out.println(o);\n                    String p = o;\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                abstract boolean guard();\n\n                void test() {\n                    String n = /*~~>*/\"42\";\n                    try {\n                        System.out.println(/*~~>*/n);\n                    } catch (Exception e) {\n                        System.out.println(n);\n                    }\n                    String o = /*~~>*/n;\n                    System.out.println(/*~~>*/o);\n                    String p = /*~~>*/o;\n                }\n            }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void if-statement with boolean array index conditional(@NotNull FindLocalFlowPathsStringTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n\n                void test() {\n                    String n = \"42\";\n                    Boolean[] b = new Boolean[1];\n                    if (b[0] && (b.length == 1)) {\n                        String o = n;\n                        System.out.println(o);\n                        String p = o;\n                    } else {\n                        System.out.println(n);\n                    }\n                }\n            }\n            ", (String)"\n            abstract class Test {\n\n                void test() {\n                    String n = /*~~>*/\"42\";\n                    Boolean[] b = new Boolean[1];\n                    if (b[0] && (b.length == 1)) {\n                        String o = /*~~>*/n;\n                        System.out.println(/*~~>*/o);\n                        String p = /*~~>*/o;\n                    } else {\n                        System.out.println(/*~~>*/n);\n                    }\n                }\n            }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void switch with multiple cases(@NotNull FindLocalFlowPathsStringTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                abstract boolean guard();\n\n                void test() {\n                    String n = \"42\";\n                    switch (n) {\n                        case \"1\":\n                            System.out.println(n);\n                            break;\n                        case \"42\":\n                            System.out.println(\"Correct\");\n                            break;\n                        default:\n                            break;\n                    }\n                    String o = n + \"\";\n                    System.out.println(o);\n                    String p = o;\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                abstract boolean guard();\n\n                void test() {\n                    String n = /*~~>*/\"42\";\n                    switch (n) {\n                        case \"1\":\n                            System.out.println(n);\n                            break;\n                        case \"42\":\n                            System.out.println(\"Correct\");\n                            break;\n                        default:\n                            break;\n                    }\n                    String o = n + \"\";\n                    System.out.println(o);\n                    String p = o;\n                }\n            }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void for-each loop(@NotNull FindLocalFlowPathsStringTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                abstract boolean guard();\n\n                void test() {\n                    String n = \"42\";\n                    for (char c : n.toCharArray()) {\n                        System.out.println(c);\n                        System.out.println(n);\n                    }\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                abstract boolean guard();\n\n                void test() {\n                    String n = /*~~>*/\"42\";\n                    for (char c : /*~~>*/n.toCharArray()) {\n                        System.out.println(c);\n                        System.out.println(/*~~>*/n);\n                    }\n                }\n            }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void generic object instantiation(@NotNull FindLocalFlowPathsStringTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.LinkedList;\n            abstract class Test {\n                abstract boolean guard();\n\n                void test() {\n                    String n = \"42\";\n                    LinkedList<Integer> ll = new LinkedList<>();\n                    ll.add(1);\n                    for (int i : ll) {\n                        System.out.println(i);\n                        System.out.println(n);\n                    }\n                }\n            }\n            ", (String)"\n            import java.util.LinkedList;\n            abstract class Test {\n                abstract boolean guard();\n\n                void test() {\n                    String n = /*~~>*/\"42\";\n                    LinkedList<Integer> ll = new LinkedList<>();\n                    ll.add(1);\n                    for (int i : ll) {\n                        System.out.println(i);\n                        System.out.println(/*~~>*/n);\n                    }\n                }\n            }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void assert expression(@NotNull FindLocalFlowPathsStringTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                abstract boolean guard();\n                void test() {\n                    String n = \"42\";\n                    assert n.contains(\"4\");\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                abstract boolean guard();\n                void test() {\n                    String n = /*~~>*/\"42\";\n                    assert /*~~>*/n.contains(\"4\");\n                }\n            }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void lambda expression(@NotNull FindLocalFlowPathsStringTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.ArrayList; abstract class Test {\n                abstract boolean guard();\n\n                void test() {\n                    String n = \"42\";\n                    ArrayList<Integer> numbers = new ArrayList<Integer>();\n                    numbers.forEach( (i) -> { System.out.println(n); } );\n                }\n            }\n            ", (String)"\n            import java.util.ArrayList; abstract class Test {\n                abstract boolean guard();\n\n                void test() {\n                    String n = /*~~>*/\"42\";\n                    ArrayList<Integer> numbers = new ArrayList<Integer>();\n                    numbers.forEach( (i) -> { System.out.println(/*~~>*/n); } );\n                }\n            }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void true literal guard(@NotNull FindLocalFlowPathsStringTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                void test() {\n                    String n = \"42\";\n                    if (true) {\n                        System.out.println(n);\n                    }\n                    System.out.println(n);\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                void test() {\n                    String n = /*~~>*/\"42\";\n                    if (true) {\n                        System.out.println(/*~~>*/n);\n                    }\n                    System.out.println(/*~~>*/n);\n                }\n            }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void false literal guard(@NotNull FindLocalFlowPathsStringTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                void test() {\n                    String n = \"42\";\n                    if (false) {\n                        System.out.println(n);\n                    }\n                    System.out.println(n);\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                void test() {\n                    String n = /*~~>*/\"42\";\n                    if (false) {\n                        System.out.println(n);\n                    }\n                    System.out.println(/*~~>*/n);\n                }\n            }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void data flow for a source in a higher block(@NotNull FindLocalFlowPathsStringTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                void test() {\n                    String n;\n                    {\n                        n = \"42\";\n                    }\n                    System.out.println(n);\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                void test() {\n                    String n;\n                    {\n                        n = /*~~>*/\"42\";\n                    }\n                    System.out.println(/*~~>*/n);\n                }\n            }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void data flow for a source in a doubly higher block(@NotNull FindLocalFlowPathsStringTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                void test() {\n                    String n;\n                    {\n                        {\n                            n = \"42\";\n                        }\n                    }\n                    System.out.println(n);\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                void test() {\n                    String n;\n                    {\n                        {\n                            n = /*~~>*/\"42\";\n                        }\n                    }\n                    System.out.println(/*~~>*/n);\n                }\n            }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void data flow for a source in a triply higher block(@NotNull FindLocalFlowPathsStringTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                void test() {\n                    String n;\n                    {\n                        {\n                            {\n                                n = \"42\";\n                            }\n                        }\n                    }\n                    System.out.println(n);\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                void test() {\n                    String n;\n                    {\n                        {\n                            {\n                                n = /*~~>*/\"42\";\n                            }\n                        }\n                    }\n                    System.out.println(/*~~>*/n);\n                }\n            }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void data flow for a source in an if block(@NotNull FindLocalFlowPathsStringTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                void test(boolean condition) {\n                    String n;\n                    if (condition) {\n                        n = \"42\";\n                    }\n                    System.out.println(n);\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                void test(boolean condition) {\n                    String n;\n                    if (condition) {\n                        n = /*~~>*/\"42\";\n                    }\n                    System.out.println(/*~~>*/n);\n                }\n            }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void data flow for a source in a while block(@NotNull FindLocalFlowPathsStringTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                void test(boolean condition) {\n                    String n;\n                    while (condition) {\n                        n = \"42\";\n                    }\n                    System.out.println(n);\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                void test(boolean condition) {\n                    String n;\n                    while (condition) {\n                        n = /*~~>*/\"42\";\n                    }\n                    System.out.println(/*~~>*/n);\n                }\n            }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void data flow for a source in a do-while block(@NotNull FindLocalFlowPathsStringTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                void test(boolean condition) {\n                    String n;\n                    do {\n                        n = \"42\";\n                    } while (condition);\n                    System.out.println(n);\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                void test(boolean condition) {\n                    String n;\n                    do {\n                        n = /*~~>*/\"42\";\n                    } while (condition);\n                    System.out.println(/*~~>*/n);\n                }\n            }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void data flow for a source in a for i block(@NotNull FindLocalFlowPathsStringTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                void test(boolean condition) {\n                    String n;\n                    for(int i = 0; i < 42; i++) {\n                        n = \"42\";\n                    }\n                    System.out.println(n);\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                void test(boolean condition) {\n                    String n;\n                    for(int i = 0; i < 42; i++) {\n                        n = /*~~>*/\"42\";\n                    }\n                    System.out.println(/*~~>*/n);\n                }\n            }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void data flow for a source in a for each block(@NotNull FindLocalFlowPathsStringTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.List;\n            abstract class Test {\n                void test(boolean condition, List<Integer> integerList) {\n                    String n;\n                    for(Integer i : integerList) {\n                        n = \"42\";\n                    }\n                    System.out.println(n);\n                }\n            }\n            ", (String)"\n            import java.util.List;\n            abstract class Test {\n                void test(boolean condition, List<Integer> integerList) {\n                    String n;\n                    for(Integer i : integerList) {\n                        n = /*~~>*/\"42\";\n                    }\n                    System.out.println(/*~~>*/n);\n                }\n            }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void data flow for a source in a try catch block(@NotNull FindLocalFlowPathsStringTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                void test(boolean condition) {\n                    String n;\n                    try {\n                        n = \"42\";\n                    } catch (Exception e) {\n                        // No-op\n                    }\n                    System.out.println(n);\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                void test(boolean condition) {\n                    String n;\n                    try {\n                        n = /*~~>*/\"42\";\n                    } catch (Exception e) {\n                        // No-op\n                    }\n                    System.out.println(/*~~>*/n);\n                }\n            }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void data flow for a source in a try catch finally block(@NotNull FindLocalFlowPathsStringTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                void test(boolean condition) {\n                    String n;\n                    String o;\n                    try {\n                        n = \"42\";\n                    } catch (Exception e) {\n                        // No-op\n                    } finally {\n                        o = \"42\";\n                    }\n                    System.out.println(n);\n                    System.out.println(o);\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                void test(boolean condition) {\n                    String n;\n                    String o;\n                    try {\n                        n = /*~~>*/\"42\";\n                    } catch (Exception e) {\n                        // No-op\n                    } finally {\n                        o = /*~~>*/\"42\";\n                    }\n                    System.out.println(/*~~>*/n);\n                    System.out.println(/*~~>*/o);\n                }\n            }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void data flow should not cross scope boundaries(@NotNull FindLocalFlowPathsStringTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                void test() {\n                    {\n                        String n;\n                        {\n                            n = \"42\";\n                        }\n                        System.out.println(n);\n                    }\n                    {\n                        String n = \"hello\";\n                        System.out.println(n);\n                    }\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                void test() {\n                    {\n                        String n;\n                        {\n                            n = /*~~>*/\"42\";\n                        }\n                        System.out.println(/*~~>*/n);\n                    }\n                    {\n                        String n = \"hello\";\n                        System.out.println(n);\n                    }\n                }\n            }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void data flow should not cross scope boundaries with class scope variable conflicts(@NotNull FindLocalFlowPathsStringTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                String n;\n                void test() {\n                    {\n                        String n;\n                        {\n                            n = \"42\";\n                        }\n                        System.out.println(n);\n                    }\n                    {\n                        System.out.println(n);\n                    }\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                String n;\n                void test() {\n                    {\n                        String n;\n                        {\n                            n = /*~~>*/\"42\";\n                        }\n                        System.out.println(/*~~>*/n);\n                    }\n                    {\n                        System.out.println(n);\n                    }\n                }\n            }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void data flow for a source in a higher block in static block(@NotNull FindLocalFlowPathsStringTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                static {\n                    String n;\n                    {\n                        n = \"42\";\n                    }\n                    System.out.println(n);\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                static {\n                    String n;\n                    {\n                        n = /*~~>*/\"42\";\n                    }\n                    System.out.println(/*~~>*/n);\n                }\n            }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void data flow for a source in an init(@NotNull FindLocalFlowPathsStringTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                {\n                    String n = \"42\";\n                    System.out.println(n);\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                {\n                    String n = /*~~>*/\"42\";\n                    System.out.println(/*~~>*/n);\n                }\n            }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void data flow for a source in a higher block in init block(@NotNull FindLocalFlowPathsStringTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                {\n                    String n;\n                    {\n                        n = \"42\";\n                    }\n                    System.out.println(n);\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                {\n                    String n;\n                    {\n                        n = /*~~>*/\"42\";\n                    }\n                    System.out.println(/*~~>*/n);\n                }\n            }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        private static TreeVisitor defaults$lambda$0() {
            return (TreeVisitor)new FindLocalFlowPaths((LocalFlowSpec)new LocalFlowSpec<Expression, Expression>(){

                public boolean isSource(@NotNull Expression expr, @NotNull Cursor cursor) {
                    Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
                    Intrinsics.checkNotNullParameter((Object)cursor, (String)"cursor");
                    Expression expression = expr;
                    return expression instanceof J.Literal ? Intrinsics.areEqual((Object)((J.Literal)expr).getValue(), (Object)"42") : (expression instanceof J.MethodInvocation ? Intrinsics.areEqual((Object)((J.MethodInvocation)expr).getName().getSimpleName(), (Object)"source") : false);
                }

                public boolean isSink(@NotNull Expression expr, @NotNull Cursor cursor) {
                    Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
                    Intrinsics.checkNotNullParameter((Object)cursor, (String)"cursor");
                    return true;
                }

                public boolean isBarrierGuard(@NotNull Guard guard, boolean branch) {
                    Intrinsics.checkNotNullParameter((Object)guard, (String)"guard");
                    Expression $this$isBarrierGuard_u24lambda_u240 = guard.getExpression();
                    boolean bl = false;
                    return $this$isBarrierGuard_u24lambda_u240 instanceof J.MethodInvocation ? Intrinsics.areEqual((Object)((J.MethodInvocation)$this$isBarrierGuard_u24lambda_u240).getName().getSimpleName(), (Object)"guard") && branch : false;
                }
            });
        }

        private static void taint_flow_via_append_is_not_data_flow$lambda$1(RecipeSpec spec) {
            spec.expectedCyclesThatMakeChanges(1).cycles(1);
        }

        private static void taint_flow_is_not_data_flow_but_it_is_tracked_to_call_site$lambda$2(RecipeSpec spec) {
            spec.expectedCyclesThatMakeChanges(1).cycles(1);
        }

        private static void taint_flow_via_constructor_call_is_not_data_flow$lambda$3(RecipeSpec spec) {
            spec.expectedCyclesThatMakeChanges(1).cycles(1);
        }

        private static void the_source_is_also_a_sink_simple$lambda$4(RecipeSpec spec) {
            spec.expectedCyclesThatMakeChanges(1).cycles(1);
        }

        private static void the_source_as_a_literal_is_also_a_sink$lambda$5(RecipeSpec spec) {
            spec.expectedCyclesThatMakeChanges(1).cycles(1);
        }

        private static void the_source_is_also_a_sink$lambda$6(RecipeSpec spec) {
            spec.expectedCyclesThatMakeChanges(1).cycles(1);
        }

        private static void the_source_is_also_a_sink_double_call_chain$lambda$7(RecipeSpec spec) {
            spec.expectedCyclesThatMakeChanges(1).cycles(1);
        }

        private static void the_source_can_be_tracked_through_wrapped_parentheses$lambda$8(RecipeSpec spec) {
            spec.expectedCyclesThatMakeChanges(1).cycles(1);
        }

        private static void the_source_can_be_tracked_through_wrapped_parentheses_through_casting$lambda$9(RecipeSpec spec) {
            spec.expectedCyclesThatMakeChanges(1).cycles(1);
        }

        private static void source_is_tracked_when_assigned_in_while_loop_control_parentheses$lambda$10(RecipeSpec spec) {
            spec.expectedCyclesThatMakeChanges(1).cycles(1);
        }

        private static void source_is_tracked_when_assigned_in_do_while_loop_control_parentheses$lambda$11(RecipeSpec spec) {
            spec.expectedCyclesThatMakeChanges(1).cycles(1);
        }

        private static void source_is_tracked_when_assigned_in_for_loop$lambda$12(RecipeSpec spec) {
            spec.expectedCyclesThatMakeChanges(1).cycles(1);
        }

        private static void reassignment_of_a_variable_breaks_flow$lambda$13(RecipeSpec spec) {
            spec.expectedCyclesThatMakeChanges(1).cycles(1);
        }

        private static void reassignment_of_a_variable_with_existing_value_preserves_flow$lambda$14(RecipeSpec spec) {
            spec.expectedCyclesThatMakeChanges(1).cycles(1);
        }

        private static void reassignment_of_a_variable_with_existing_value_wrapped_in_parentheses_preserves_flow$lambda$15(RecipeSpec spec) {
            spec.expectedCyclesThatMakeChanges(1).cycles(1);
        }

        private static void a_class_name_in_a_constructor_call_is_not_considered_as_a_part_of_dataflow$lambda$16(RecipeSpec spec) {
            spec.expectedCyclesThatMakeChanges(1).cycles(1);
        }

        private static void a_class_name_in_a_constructor_call_on_parent_type_is_not_considered_as_a_part_of_dataflow$lambda$17(RecipeSpec spec) {
            spec.expectedCyclesThatMakeChanges(1).cycles(1);
        }

        private static void a_method_name_is_not_considered_as_a_part_of_dataflow$lambda$18(RecipeSpec spec) {
            spec.expectedCyclesThatMakeChanges(1).cycles(1);
        }

        private static void a_class_variable_access_is_not_considered_as_a_part_of_dataflow$lambda$19(RecipeSpec spec) {
            spec.expectedCyclesThatMakeChanges(1).cycles(1);
        }

        private static void a_ternary_operator_is_considered_a_data_flow_step$lambda$20(RecipeSpec spec) {
            spec.expectedCyclesThatMakeChanges(1).cycles(1);
        }

        private static void a_ternary_operator_is_considered_a_data_flow_step_2$lambda$21(RecipeSpec spec) {
            spec.expectedCyclesThatMakeChanges(1).cycles(1);
        }
    }
}

