/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.TypeValidator;
import org.openrewrite.java.cleanup.UnnecessaryThrows;
import org.openrewrite.java.tree.J;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\bf\u0018\u00002\u00020\u00012\u00020\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\b\u0010\u0010\u001a\u00020\bH\u0017J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\u0015\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\u0018\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0019"}, d2={"Lorg/openrewrite/java/cleanup/UnnecessaryThrowsTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "Lorg/openrewrite/test/RewriteTest;", "recipe", "Lorg/openrewrite/Recipe;", "getRecipe", "()Lorg/openrewrite/Recipe;", "abstractMethods", "", "jp", "Lorg/openrewrite/java/JavaParser;", "defaults", "spec", "Lorg/openrewrite/test/RecipeSpec;", "doNotRemoveDocumentedExceptions", "doNotRemoveExceptionCoveringOtherExceptions", "genericException", "interfaces", "necessaryThrows", "necessaryThrowsFromCloseable", "necessaryThrowsFromStaticMethod", "necessaryThrowsOnInterfaceWithExplicitOverride", "necessaryThrowsOnInterfaceWithImplicitOverride", "prevent transformation if any thrown exception has a null or unknown type", "unnecessaryThrows", "rewrite-java-tck"})
public interface UnnecessaryThrowsTest
extends JavaRecipeTest,
RewriteTest {
    @NotNull
    public Recipe getRecipe();

    public void defaults(@NotNull RecipeSpec var1);

    @Test
    public void genericException();

    @Test
    public void unnecessaryThrows(@NotNull JavaParser var1);

    @Test
    public void necessaryThrowsFromCloseable(@NotNull JavaParser var1);

    @Test
    public void necessaryThrows(@NotNull JavaParser var1);

    @Test
    public void interfaces(@NotNull JavaParser var1);

    @Test
    public void abstractMethods(@NotNull JavaParser var1);

    @Test
    public void necessaryThrowsFromStaticMethod(@NotNull JavaParser var1);

    @Test
    public void necessaryThrowsOnInterfaceWithExplicitOverride(@NotNull JavaParser var1);

    @Test
    public void necessaryThrowsOnInterfaceWithImplicitOverride(@NotNull JavaParser var1);

    @Test
    public void doNotRemoveDocumentedExceptions(@NotNull JavaParser var1);

    @Test
    public void doNotRemoveExceptionCoveringOtherExceptions(@NotNull JavaParser var1);

    @Test
    public void prevent transformation if any thrown exception has a null or unknown type(@NotNull JavaParser var1);

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static Recipe getRecipe(@NotNull UnnecessaryThrowsTest $this) {
            return (Recipe)new UnnecessaryThrows();
        }

        public static void defaults(@NotNull UnnecessaryThrowsTest $this, @NotNull RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            spec.recipe((Recipe)new UnnecessaryThrows());
        }

        @Test
        public static void genericException(@NotNull UnnecessaryThrowsTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                class Test {\n                    public <E extends Exception> void accept(Class<E> e) throws E {\n                    }\n                }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void unnecessaryThrows(@NotNull UnnecessaryThrowsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default($this, jp, null, null, "\n            import java.io.FileInputStream;\n            import java.io.FileNotFoundException;\n            import java.io.IOException;\n            import java.io.UncheckedIOException;\n            class Test {\n                private void test() throws FileNotFoundException, UncheckedIOException {\n                }\n\n                void test() throws IOException, UncheckedIOException {\n                    new FileInputStream(\"test\");\n                }\n            }\n        ", null, "\n            import java.io.FileInputStream;\n            import java.io.IOException;\n            import java.io.UncheckedIOException;\n            class Test {\n                private void test() throws UncheckedIOException {\n                }\n            \n                void test() throws IOException, UncheckedIOException {\n                    new FileInputStream(\"test\");\n                }\n            }\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void necessaryThrowsFromCloseable(@NotNull UnnecessaryThrowsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default($this, jp, null, null, "\n            import java.io.IOException;\n            import java.net.URL;\n            import java.net.URLClassLoader;\n            \n            class Test {\n                public void closeable() throws IOException {\n                    // URLClassLoader implements Closeable and throws IOException from its close() method\n                    try (URLClassLoader cl = new URLClassLoader(new URL[0])) {\n                    }\n                }\n            }\n        ", null, 22, null);
        }

        @Test
        public static void necessaryThrows(@NotNull UnnecessaryThrowsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default($this, jp, null, null, "\n            import java.io.IOException;\n            \n            class Test {\n                \n                void test() throws IOException {\n                    throw new IOException();\n                }\n            }\n        ", null, 22, null);
        }

        @Test
        public static void interfaces(@NotNull UnnecessaryThrowsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default($this, jp, null, null, "\n            import java.io.IOException;\n            \n            interface Test {\n                void test() throws IOException;\n            }\n        ", null, 22, null);
        }

        @Test
        public static void abstractMethods(@NotNull UnnecessaryThrowsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default($this, jp, null, null, "\n            import java.io.IOException;\n            \n            abstract class Test {\n                abstract void test() throws IOException;\n            }\n        ", null, 22, null);
        }

        @Test
        public static void necessaryThrowsFromStaticMethod(@NotNull UnnecessaryThrowsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default($this, jp, null, null, "\n            import javax.xml.datatype.DatatypeFactory;\n            \n            class Test {\n                void test() throws Exception {\n                    DatatypeFactory.newInstance();\n                }\n            }\n        ", null, 22, null);
        }

        @Test
        public static void necessaryThrowsOnInterfaceWithExplicitOverride(@NotNull UnnecessaryThrowsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n            public interface Foo {\n                void bar() throws Exception;\n            }\n        "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertUnchanged$default($this, jp, null, null, "\n            public class FooImpl implements Foo {\n                @Override\n                public void bar() throws Exception {\n                    // no-op\n                }\n            }\n        ", stringArray2, 6, null);
        }

        @Test
        public static void necessaryThrowsOnInterfaceWithImplicitOverride(@NotNull UnnecessaryThrowsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n            public interface Foo {\n                void bar() throws Exception;\n            }\n        "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertUnchanged$default($this, jp, null, null, "\n            public class FooImpl implements Foo {\n                public void bar() throws Exception {\n                    // no-op\n                }\n            }\n        ", stringArray2, 6, null);
        }

        @Test
        public static void doNotRemoveDocumentedExceptions(@NotNull UnnecessaryThrowsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default($this, jp, null, null, "\n            public class ParentFoo {\n                /**\n                 * @throws Exception Throws an exception\n                 */\n                public void bar() throws Exception { // this throws should not be removed\n                }\n            }\n            \n            class Foo extends ParentFoo {\n                @Override\n                public void bar() throws Exception {\n                    // no-op\n                }\n            }\n        ", null, 22, null);
        }

        @Test
        public static void doNotRemoveExceptionCoveringOtherExceptions(@NotNull UnnecessaryThrowsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default($this, jp, null, null, "\n            package com.yourorg;\n            \n            import java.io.IOException;\n            \n            class A {\n                void foo() throws Exception {\n                    throw new IOException(\"\");\n                }\n            }\n        ", null, 22, null);
        }

        @Test
        public static void prevent transformation if any thrown exception has a null or unknown type(@NotNull UnnecessaryThrowsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default($this, jp, null, null, "\n            package com.yourorg;\n            \n            import java.io.IOException;\n            \n            class A {\n                void foo() throws ExceptionWithUnknownType {\n                    someUnknownMethodInvocation();\n                }\n            }\n        ", null, 22, null);
        }

        @NotNull
        public static JavaParser getParser(@NotNull UnnecessaryThrowsTest $this) {
            return JavaRecipeTest.DefaultImpls.getParser($this);
        }

        @NotNull
        public static ExecutionContext getExecutionContext(@NotNull UnnecessaryThrowsTest $this) {
            return JavaRecipeTest.DefaultImpls.getExecutionContext($this);
        }

        @BeforeEach
        public static void beforeRecipe(@NotNull UnnecessaryThrowsTest $this) {
            JavaRecipeTest.DefaultImpls.beforeRecipe($this);
        }

        @AfterEach
        public static void afterRecipe(@NotNull UnnecessaryThrowsTest $this) {
            JavaRecipeTest.DefaultImpls.afterRecipe($this);
        }

        public static void assertChanged(@NotNull UnnecessaryThrowsTest $this, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged($this, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull UnnecessaryThrowsTest $this, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged($this, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertUnchanged(@NotNull UnnecessaryThrowsTest $this, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged($this, parser, recipe2, executionContext, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull UnnecessaryThrowsTest $this, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged($this, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        public static void assertChangedBase(@NotNull UnnecessaryThrowsTest $this, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase($this, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull UnnecessaryThrowsTest $this, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase($this, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertUnchangedBase(@NotNull UnnecessaryThrowsTest $this, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase($this, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        public static void assertUnchangedBase(@NotNull UnnecessaryThrowsTest $this, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase($this, parser, recipe2, executionContext, before, dependsOn);
        }

        @NotNull
        public static Recipe fromRuntimeClasspath(@NotNull UnnecessaryThrowsTest $this, @NotNull String recipe2) {
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            return JavaRecipeTest.DefaultImpls.fromRuntimeClasspath($this, recipe2);
        }

        @NotNull
        public static Recipe toRecipe(@NotNull UnnecessaryThrowsTest $this, @NotNull Function0<? extends TreeVisitor<?, ExecutionContext>> supplier) {
            Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
            return JavaRecipeTest.DefaultImpls.toRecipe($this, supplier);
        }
    }
}

