/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.cleanup.RenameJavaDocParamNameVisitor;
import org.openrewrite.java.cleanup.RenameJavaDocParamNameVisitorTest;
import org.openrewrite.java.tree.J;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0003H\u0017J\b\u0010\u0007\u001a\u00020\u0003H\u0017\u00a8\u0006\b"}, d2={"Lorg/openrewrite/java/cleanup/RenameJavaDocParamNameVisitorTest;", "Lorg/openrewrite/test/RewriteTest;", "defaults", "", "spec", "Lorg/openrewrite/test/RecipeSpec;", "noJavaDocParamMatch", "renameParamName", "rewrite-java-tck"})
public interface RenameJavaDocParamNameVisitorTest
extends RewriteTest {
    public void defaults(@NotNull RecipeSpec var1);

    @Test
    public void noJavaDocParamMatch();

    @Test
    public void renameParamName();

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        public static void defaults(@NotNull RenameJavaDocParamNameVisitorTest $this, @NotNull RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            spec.recipe(RewriteTest.toRecipe(DefaultImpls::defaults$lambda$0));
        }

        @Test
        public static void noJavaDocParamMatch(@NotNull RenameJavaDocParamNameVisitorTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                /**\n                 * @param noMatch\n                 */\n                void method(String oldName) {\n                }\n            }\n          ", (String)"\n            class Test {\n                /**\n                 * @param noMatch\n                 */\n                void method(String newName) {\n                }\n            }\n          ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void renameParamName(@NotNull RenameJavaDocParamNameVisitorTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                /**\n                 * @param oldName\n                 */\n                void method(String oldName) {\n                }\n            }\n          ", (String)"\n            class Test {\n                /**\n                 * @param newName\n                 */\n                void method(String newName) {\n                }\n            }\n          ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        private static TreeVisitor defaults$lambda$0() {
            return (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

                @NotNull
                public J.MethodDeclaration visitMethodDeclaration(@NotNull J.MethodDeclaration method, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    J.MethodDeclaration md = method;
                    if (Intrinsics.areEqual((Object)"method", (Object)md.getName().getSimpleName()) && md.getParameters().stream().anyMatch(arg_0 -> defaults.1.1.visitMethodDeclaration$lambda$0(defaults.1.visitMethodDeclaration.1.INSTANCE, arg_0))) {
                        J.MethodDeclaration methodDeclaration2 = new RenameJavaDocParamNameVisitor(md, "oldName", "newName").visitMethodDeclaration(md, (Object)p);
                        Intrinsics.checkNotNullExpressionValue((Object)methodDeclaration2, (String)"RenameJavaDocParamNameVi\u2026tMethodDeclaration(md, p)");
                        md = methodDeclaration2;
                    }
                    J.MethodDeclaration methodDeclaration3 = super.visitMethodDeclaration(md, (Object)p);
                    Intrinsics.checkNotNullExpressionValue((Object)methodDeclaration3, (String)"super.visitMethodDeclaration(md, p)");
                    return methodDeclaration3;
                }

                @NotNull
                public J.VariableDeclarations.NamedVariable visitVariable(@NotNull J.VariableDeclarations.NamedVariable variable, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    J.VariableDeclarations.NamedVariable v = super.visitVariable(variable, (Object)p);
                    if (Intrinsics.areEqual((Object)"oldName", (Object)variable.getSimpleName())) {
                        v = v.withName(v.getName().withSimpleName("newName"));
                    }
                    J.VariableDeclarations.NamedVariable namedVariable = v;
                    Intrinsics.checkNotNullExpressionValue((Object)namedVariable, (String)"v");
                    return namedVariable;
                }

                private static final boolean visitMethodDeclaration$lambda$0(Function1 $tmp0, Object p0) {
                    Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                    return (Boolean)$tmp0.invoke(p0);
                }
            };
        }
    }
}

