/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.TypeValidator;
import org.openrewrite.java.cleanup.RemoveUnneededBlock;
import org.openrewrite.java.tree.J;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0017"}, d2={"Lorg/openrewrite/java/cleanup/RemoveUnneededBlockTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "recipe", "Lorg/openrewrite/Recipe;", "getRecipe", "()Lorg/openrewrite/Recipe;", "doNotChangeEmptyIfBlock", "", "jp", "Lorg/openrewrite/java/JavaParser;", "doNotChangeLabeledBlock", "doNotChangeMethod", "doNotRemoveDoubleBraceInitBlocks", "doNotRemoveDoubleBraceInitBlocksInMethod", "doNotRemoveObjectArrayArrayInitializer", "doNotRemoveObjectArrayInitializer", "simplifyBlockInStaticInitializerIfBlock", "simplifyBlockNestedInIfBlock", "simplifyCraziness", "simplifyDoesNotFormatInternalCode", "simplifyDoesNotFormatSurroundingCode", "simplifyDoublyNestedBlock", "simplifyNestedBlock", "rewrite-java-tck"})
public interface RemoveUnneededBlockTest
extends JavaRecipeTest {
    @NotNull
    public Recipe getRecipe();

    @Test
    public void doNotChangeMethod(@NotNull JavaParser var1);

    @Test
    public void doNotChangeLabeledBlock(@NotNull JavaParser var1);

    @Test
    public void doNotChangeEmptyIfBlock(@NotNull JavaParser var1);

    @Test
    public void doNotRemoveDoubleBraceInitBlocksInMethod(@NotNull JavaParser var1);

    @Test
    public void doNotRemoveDoubleBraceInitBlocks(@NotNull JavaParser var1);

    @Test
    public void doNotRemoveObjectArrayInitializer(@NotNull JavaParser var1);

    @Test
    public void doNotRemoveObjectArrayArrayInitializer(@NotNull JavaParser var1);

    @Test
    public void simplifyNestedBlock(@NotNull JavaParser var1);

    @Test
    public void simplifyDoublyNestedBlock(@NotNull JavaParser var1);

    @Test
    public void simplifyBlockNestedInIfBlock(@NotNull JavaParser var1);

    @Test
    public void simplifyBlockInStaticInitializerIfBlock(@NotNull JavaParser var1);

    @Test
    public void simplifyCraziness(@NotNull JavaParser var1);

    @Test
    public void simplifyDoesNotFormatSurroundingCode(@NotNull JavaParser var1);

    @Test
    public void simplifyDoesNotFormatInternalCode(@NotNull JavaParser var1);

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static Recipe getRecipe(@NotNull RemoveUnneededBlockTest $this) {
            return (Recipe)new RemoveUnneededBlock();
        }

        @Test
        public static void doNotChangeMethod(@NotNull RemoveUnneededBlockTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default($this, jp, null, null, "\n            class A {\n                void test() {\n                }\n            }\n        ", null, 22, null);
        }

        @Test
        public static void doNotChangeLabeledBlock(@NotNull RemoveUnneededBlockTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default($this, jp, null, null, "\n            class A {\n                void test() {\n                    testLabel: {\n                        System.out.println(\"hello!\");\n                    }\n                }\n            }\n        ", null, 22, null);
        }

        @Test
        public static void doNotChangeEmptyIfBlock(@NotNull RemoveUnneededBlockTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default($this, jp, null, null, "\n            class A {\n                void test() {\n                    if(true) { }\n                }\n            }\n        ", null, 22, null);
        }

        @Test
        public static void doNotRemoveDoubleBraceInitBlocksInMethod(@NotNull RemoveUnneededBlockTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default($this, null, null, null, "\n            import java.util.HashSet;\n            import java.util.Set;\n            public class T {\n                public void whenInitializeSetWithDoubleBraces_containsElements() {\n                    Set<String> countries = new HashSet<String>() {\n                        {\n                           add(\"a\");\n                           add(\"b\");\n                        }\n                    };\n                }\n            }\n        ", null, 23, null);
        }

        @Test
        public static void doNotRemoveDoubleBraceInitBlocks(@NotNull RemoveUnneededBlockTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default($this, null, null, null, "\n            import java.util.HashSet;\n            import java.util.Set;\n            public class T {\n                final Set<String> countries = new HashSet<String>() {\n                    {\n                       add(\"a\");\n                       add(\"b\");\n                    }\n                };\n            }\n        ", null, 23, null);
        }

        @Test
        public static void doNotRemoveObjectArrayInitializer(@NotNull RemoveUnneededBlockTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default($this, null, null, null, "\n            public class A {\n                Object[] a = new Object[] {\n                    \"a\",\n                    \"b\"\n                };\n            }\n        ", null, 23, null);
        }

        @Test
        public static void doNotRemoveObjectArrayArrayInitializer(@NotNull RemoveUnneededBlockTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default($this, null, null, null, "\n            public class A {\n                Object[][] a = new Object[][] {\n                    { \"a\", \"b\" },\n                    { \"c\", \"d\" }\n                };\n            }\n        ", null, 23, null);
        }

        @Test
        public static void simplifyNestedBlock(@NotNull RemoveUnneededBlockTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default($this, jp, null, null, "\n            public class A {\n                void test() {\n                    {\n                        System.out.println(\"hello!\");\n                    }\n                }\n            }\n        ", null, "\n            public class A {\n                void test() {\n                    System.out.println(\"hello!\");\n                }\n            }\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void simplifyDoublyNestedBlock(@NotNull RemoveUnneededBlockTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default($this, jp, null, null, "\n            public class A {\n                void test() {\n                    {\n                         { System.out.println(\"hello!\"); }\n                    }\n                }\n            }\n        ", null, "\n            public class A {\n                void test() {\n                    System.out.println(\"hello!\");\n                }\n            }\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void simplifyBlockNestedInIfBlock(@NotNull RemoveUnneededBlockTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default($this, jp, null, null, "\n            public class A {\n                void test() {\n                    if (true) {\n                         { System.out.println(\"hello!\"); }\n                    }\n                }\n            }\n        ", null, "\n            public class A {\n                void test() {\n                    if (true) {\n                        System.out.println(\"hello!\");\n                    }\n                }\n            }\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void simplifyBlockInStaticInitializerIfBlock(@NotNull RemoveUnneededBlockTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default($this, jp, null, null, "\n            public class A {\n                static {\n                    {\n                         {\n                            System.out.println(\"hello static!\");\n                            System.out.println(\"goodbye static!\");\n                         }\n                    }\n                }\n\n                {\n                    {\n                        System.out.println(\"hello init!\");\n                        System.out.println(\"goodbye init!\");\n                    }\n                }\n            }\n        ", null, "\n            public class A {\n                static {\n                    System.out.println(\"hello static!\");\n                    System.out.println(\"goodbye static!\");\n                }\n\n                {\n                    System.out.println(\"hello init!\");\n                    System.out.println(\"goodbye init!\");\n                }\n            }\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void simplifyCraziness(@NotNull RemoveUnneededBlockTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default($this, jp, null, null, "\n            import java.util.HashSet;\n            import java.util.Set;\n            public class A {\n                static {\n                    {\n                         new HashSet<String>() {\n                            {\n                                add(\"a\");\n                                add(\"b\");\n                                {\n                                    System.out.println(\"hello static!\");\n                                    System.out.println(\"goodbye static!\");\n                                }\n                            }\n                         };\n                    }\n                }\n\n                {\n                    {\n                         new HashSet<String>() {\n                            {\n                                add(\"a\");\n                                add(\"b\");\n                                {\n                                    System.out.println(\"hello init!\");\n                                    System.out.println(\"goodbye init!\");\n                                }\n                            }\n                         };\n                    }\n                }\n            }\n        ", null, "\n            import java.util.HashSet;\n            import java.util.Set;\n            public class A {\n                static {\n                    new HashSet<String>() {\n                        {\n                            add(\"a\");\n                            add(\"b\");\n                            System.out.println(\"hello static!\");\n                            System.out.println(\"goodbye static!\");\n                        }\n                    };\n                }\n\n                {\n                    new HashSet<String>() {\n                        {\n                            add(\"a\");\n                            add(\"b\");\n                            System.out.println(\"hello init!\");\n                            System.out.println(\"goodbye init!\");\n                        }\n                    };\n                }\n            }\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void simplifyDoesNotFormatSurroundingCode(@NotNull RemoveUnneededBlockTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default($this, jp, null, null, "\n            public class A {\n                static {\n                    int[] a = new int[] { 1, 2, 3 };\n                    int[] b = new int[] {4,5,6};\n                    {\n                        System.out.println(\"hello static!\");\n                    }\n                }\n            }\n        ", null, "\n            public class A {\n                static {\n                    int[] a = new int[] { 1, 2, 3 };\n                    int[] b = new int[] {4,5,6};\n                    System.out.println(\"hello static!\");\n                }\n            }\n        ", 0, 0, null, null, 982, null);
        }

        @Test
        public static void simplifyDoesNotFormatInternalCode(@NotNull RemoveUnneededBlockTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default($this, jp, null, null, "\n            public class A {\n                static {\n                    int[] a = new int[] { 1, 2, 3 };\n                    int[] b = new int[] {4,5,6};\n                    {\n                        System.out.println(\"hello!\");\n                        System.out.println( \"world!\" );\n                    }\n                }\n            }\n        ", null, "\n            public class A {\n                static {\n                    int[] a = new int[] { 1, 2, 3 };\n                    int[] b = new int[] {4,5,6};\n                    System.out.println(\"hello!\");\n                    System.out.println(\"world!\");\n                }\n            }\n        ", 0, 0, null, null, 982, null);
        }

        @NotNull
        public static JavaParser getParser(@NotNull RemoveUnneededBlockTest $this) {
            return JavaRecipeTest.DefaultImpls.getParser($this);
        }

        @NotNull
        public static ExecutionContext getExecutionContext(@NotNull RemoveUnneededBlockTest $this) {
            return JavaRecipeTest.DefaultImpls.getExecutionContext($this);
        }

        @BeforeEach
        public static void beforeRecipe(@NotNull RemoveUnneededBlockTest $this) {
            JavaRecipeTest.DefaultImpls.beforeRecipe($this);
        }

        @AfterEach
        public static void afterRecipe(@NotNull RemoveUnneededBlockTest $this) {
            JavaRecipeTest.DefaultImpls.afterRecipe($this);
        }

        public static void assertChanged(@NotNull RemoveUnneededBlockTest $this, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged($this, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull RemoveUnneededBlockTest $this, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged($this, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertUnchanged(@NotNull RemoveUnneededBlockTest $this, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged($this, parser, recipe2, executionContext, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull RemoveUnneededBlockTest $this, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged($this, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        public static void assertChangedBase(@NotNull RemoveUnneededBlockTest $this, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase($this, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull RemoveUnneededBlockTest $this, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase($this, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertUnchangedBase(@NotNull RemoveUnneededBlockTest $this, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase($this, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        public static void assertUnchangedBase(@NotNull RemoveUnneededBlockTest $this, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase($this, parser, recipe2, executionContext, before, dependsOn);
        }

        @NotNull
        public static Recipe fromRuntimeClasspath(@NotNull RemoveUnneededBlockTest $this, @NotNull String recipe2) {
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            return JavaRecipeTest.DefaultImpls.fromRuntimeClasspath($this, recipe2);
        }

        @NotNull
        public static Recipe toRecipe(@NotNull RemoveUnneededBlockTest $this, @NotNull Function0<? extends TreeVisitor<?, ExecutionContext>> supplier) {
            Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
            return JavaRecipeTest.DefaultImpls.toRecipe($this, supplier);
        }
    }
}

