/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.cleanup.RemoveMethodCallVisitor;
import org.openrewrite.java.cleanup.RemoveMethodCallVisitorTest;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0017J\b\u0010\u0004\u001a\u00020\u0003H\u0017J\b\u0010\u0005\u001a\u00020\u0003H\u0017J\b\u0010\u0006\u001a\u00020\u0003H\u0017J\f\u0010\u0007\u001a\u00020\b*\u00020\bH\u0016J.\u0010\t\u001a\u00020\b*\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\rH\u0016\u00a8\u0006\u0011"}, d2={"Lorg/openrewrite/java/cleanup/RemoveMethodCallVisitorTest;", "Lorg/openrewrite/test/RewriteTest;", "asertTrue(false) is not removed", "", "asertTrue(message, true) is removed", "asertTrue(true) is removed", "does not remove assertTrue(true) if return value is used", "asserTrueTestVisitor", "Lorg/openrewrite/test/RecipeSpec;", "testVisitor", "methodMatcher", "Lorg/openrewrite/java/MethodMatcher;", "argumentPredicate", "Lkotlin/Function2;", "", "Lorg/openrewrite/java/tree/Expression;", "", "rewrite-java-tck"})
public interface RemoveMethodCallVisitorTest
extends RewriteTest {
    @NotNull
    public RecipeSpec testVisitor(@NotNull RecipeSpec var1, @NotNull MethodMatcher var2, @NotNull Function2<? super Integer, ? super Expression, Boolean> var3);

    @NotNull
    public RecipeSpec asserTrueTestVisitor(@NotNull RecipeSpec var1);

    @Test
    public void asertTrue(true) is removed();

    @Test
    public void asertTrue(false) is not removed();

    @Test
    public void asertTrue(message, true) is removed();

    @Test
    public void does not remove assertTrue(true) if return value is used();

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static RecipeSpec testVisitor(@NotNull RemoveMethodCallVisitorTest $this, @NotNull RecipeSpec $receiver, @NotNull MethodMatcher methodMatcher, @NotNull Function2<? super Integer, ? super Expression, Boolean> argumentPredicate) {
            Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
            Intrinsics.checkNotNullParameter((Object)methodMatcher, (String)"methodMatcher");
            Intrinsics.checkNotNullParameter(argumentPredicate, (String)"argumentPredicate");
            RecipeSpec recipeSpec = $receiver.recipe(RewriteTest.toRecipe(() -> DefaultImpls.testVisitor$lambda$1(methodMatcher, argumentPredicate)));
            Intrinsics.checkNotNullExpressionValue((Object)recipeSpec, (String)"recipe(RewriteTest.toRec\u2026\n            )\n        })");
            return recipeSpec;
        }

        @NotNull
        public static RecipeSpec asserTrueTestVisitor(@NotNull RemoveMethodCallVisitorTest $this, @NotNull RecipeSpec $receiver) {
            Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
            return $this.testVisitor($receiver, new MethodMatcher("* assertTrue(..)"), (Function2<? super Integer, ? super Expression, Boolean>)((Function2)asserTrueTestVisitor.1.INSTANCE));
        }

        @Test
        public static void asertTrue(true) is removed(@NotNull RemoveMethodCallVisitorTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                abstract void assertTrue(boolean condition);\n\n                void test() {\n                    System.out.println(\"Hello\");\n                    assertTrue(true);\n                    System.out.println(\"World\");\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                abstract void assertTrue(boolean condition);\n\n                void test() {\n                    System.out.println(\"Hello\");\n                    System.out.println(\"World\");\n                }\n            }\n            ")};
            $this.rewriteRun(arg_0 -> DefaultImpls.asertTrue_true__is_removed$lambda$2($this, arg_0), sourceSpecsArray);
        }

        @Test
        public static void asertTrue(false) is not removed(@NotNull RemoveMethodCallVisitorTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                abstract void assertTrue(boolean condition);\n\n                void test() {\n                    System.out.println(\"Hello\");\n                    assertTrue(false);\n                    System.out.println(\"World\");\n                }\n            }\n            ")};
            $this.rewriteRun(arg_0 -> DefaultImpls.asertTrue_false__is_not_removed$lambda$3($this, arg_0), sourceSpecsArray);
        }

        @Test
        public static void asertTrue(message, true) is removed(@NotNull RemoveMethodCallVisitorTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                abstract void assertTrue(String message, boolean condition);\n\n                void test() {\n                    System.out.println(\"Hello\");\n                    assertTrue(\"message\", true);\n                    System.out.println(\"World\");\n                }\n            }\n            ", (String)"\n            abstract class Test {\n                abstract void assertTrue(String message, boolean condition);\n\n                void test() {\n                    System.out.println(\"Hello\");\n                    System.out.println(\"World\");\n                }\n            }\n            ")};
            $this.rewriteRun(arg_0 -> DefaultImpls.asertTrue_message__true__is_removed$lambda$4($this, arg_0), sourceSpecsArray);
        }

        @Test
        public static void does not remove assertTrue(true) if return value is used(@NotNull RemoveMethodCallVisitorTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            abstract class Test {\n                abstract int assertTrue(boolean condition);\n\n                void test() {\n                    System.out.println(\"Hello\");\n                    int value = assertTrue(true);\n                    System.out.println(\"World\");\n                }\n            }\n            ")};
            $this.rewriteRun(arg_0 -> DefaultImpls.does_not_remove_assertTrue_true__if_return_value_is_used$lambda$5($this, arg_0), sourceSpecsArray);
        }

        private static boolean testVisitor$lambda$1$lambda$0(Function2 $tmp0, Integer p0, Expression p1) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke((Object)p0, (Object)p1);
        }

        private static TreeVisitor testVisitor$lambda$1(MethodMatcher $methodMatcher, Function2 $argumentPredicate) {
            Intrinsics.checkNotNullParameter((Object)$methodMatcher, (String)"$methodMatcher");
            Intrinsics.checkNotNullParameter((Object)$argumentPredicate, (String)"$argumentPredicate");
            return (TreeVisitor)new RemoveMethodCallVisitor($methodMatcher, (arg_0, arg_1) -> DefaultImpls.testVisitor$lambda$1$lambda$0($argumentPredicate, arg_0, arg_1));
        }

        private static void asertTrue_true__is_removed$lambda$2(RemoveMethodCallVisitorTest this$0, RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullExpressionValue((Object)spec, (String)"spec");
            this$0.asserTrueTestVisitor(spec);
        }

        private static void asertTrue_false__is_not_removed$lambda$3(RemoveMethodCallVisitorTest this$0, RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullExpressionValue((Object)spec, (String)"spec");
            this$0.asserTrueTestVisitor(spec);
        }

        private static void asertTrue_message__true__is_removed$lambda$4(RemoveMethodCallVisitorTest this$0, RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullExpressionValue((Object)spec, (String)"spec");
            this$0.testVisitor(spec, new MethodMatcher("* assertTrue(..)"), (Function2<? super Integer, ? super Expression, Boolean>)((Function2)asertTrue(message, true) is removed.1.1.INSTANCE));
        }

        private static void does_not_remove_assertTrue_true__if_return_value_is_used$lambda$5(RemoveMethodCallVisitorTest this$0, RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullExpressionValue((Object)spec, (String)"spec");
            this$0.asserTrueTestVisitor(spec);
        }
    }
}

