/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.Recipe;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.cleanup.RemoveEmptyJavaDocParameters;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0003H\u0017J\b\u0010\u0007\u001a\u00020\u0003H\u0017J\b\u0010\b\u001a\u00020\u0003H\u0017J\b\u0010\t\u001a\u00020\u0003H\u0017J\b\u0010\n\u001a\u00020\u0003H\u0017J\b\u0010\u000b\u001a\u00020\u0003H\u0017J\b\u0010\f\u001a\u00020\u0003H\u0017\u00a8\u0006\r"}, d2={"Lorg/openrewrite/java/cleanup/RemoveEmptyJavaDocParametersTest;", "Lorg/openrewrite/test/RewriteTest;", "defaults", "", "spec", "Lorg/openrewrite/test/RecipeSpec;", "emptyReturn", "emptyThrows", "emptyThrowsOnFirstLine", "multipleEmptyLines", "removeEmptyParams", "removeParamWithNoPrefix", "singleLineParam", "rewrite-java-tck"})
public interface RemoveEmptyJavaDocParametersTest
extends RewriteTest {
    public void defaults(@NotNull RecipeSpec var1);

    @Test
    public void singleLineParam();

    @Test
    public void removeParamWithNoPrefix();

    @Test
    public void removeEmptyParams();

    @Test
    public void multipleEmptyLines();

    @Test
    public void emptyReturn();

    @Test
    public void emptyThrows();

    @Test
    public void emptyThrowsOnFirstLine();

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        public static void defaults(@NotNull RemoveEmptyJavaDocParametersTest $this, @NotNull RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            spec.recipe((Recipe)new RemoveEmptyJavaDocParameters());
        }

        @Test
        public static void singleLineParam(@NotNull RemoveEmptyJavaDocParametersTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                /**@param arg0*/\n                void method(int arg0) {\n                }\n            }\n          ", (String)"\n            class Test {\n                /***/\n                void method(int arg0) {\n                }\n            }\n          ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void removeParamWithNoPrefix(@NotNull RemoveEmptyJavaDocParametersTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                /**\n                 *@param arg0\n                 */\n                void method(int arg0) {\n                }\n            }\n          ", (String)"\n            class Test {\n                /**\n                 */\n                void method(int arg0) {\n                }\n            }\n          ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void removeEmptyParams(@NotNull RemoveEmptyJavaDocParametersTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                /**\n                 * @param arg0 description1\n                 * @param arg1\n                 * @param arg2 description3\n                 */\n                void method(int arg0, int arg1, int arg2) {\n                }\n            }\n          ", (String)"\n            class Test {\n                /**\n                 * @param arg0 description1\n                 * @param arg2 description3\n                 */\n                void method(int arg0, int arg1, int arg2) {\n                }\n            }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void multipleEmptyLines(@NotNull RemoveEmptyJavaDocParametersTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                /**\n                 * @param arg0\n                 * \n                 * \n                 * \n                 * @param arg1 description\n                 */\n                void method(int arg0, int arg1) {\n                }\n            }\n          ", (String)"\n            class Test {\n                /**\n                 * \n                 * \n                 * \n                 * @param arg1 description\n                 */\n                void method(int arg0, int arg1) {\n                }\n            }\n          ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void emptyReturn(@NotNull RemoveEmptyJavaDocParametersTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                /**\n                 * @return\n                 */\n                int method() {\n                }\n            }\n          ", (String)"\n            class Test {\n                /**\n                 */\n                int method() {\n                }\n            }\n          ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void emptyThrows(@NotNull RemoveEmptyJavaDocParametersTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n          class Test {\n              /**\n               * @throws\n               */\n              void method() throws IllegalStateException {\n              }\n          }\n        ", (String)"\n          class Test {\n              /**\n               */\n              void method() throws IllegalStateException {\n              }\n          }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void emptyThrowsOnFirstLine(@NotNull RemoveEmptyJavaDocParametersTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                /** @throws*/\n                void method() throws IllegalStateException {\n                }\n            }\n          ", (String)"\n            class Test {\n                /***/\n                void method() throws IllegalStateException {\n                }\n            }\n          ")};
            $this.rewriteRun(sourceSpecsArray);
        }
    }
}

