/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.openrewrite.Recipe;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.cleanup.FinalizeLocalVariables;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\r\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0017J\b\u0010\u0004\u001a\u00020\u0003H\u0017J\b\u0010\u0005\u001a\u00020\u0003H\u0017J\b\u0010\u0006\u001a\u00020\u0003H\u0017J\b\u0010\u0007\u001a\u00020\u0003H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0003H\u0017J\b\u0010\f\u001a\u00020\u0003H\u0017J\b\u0010\r\u001a\u00020\u0003H\u0017J\b\u0010\u000e\u001a\u00020\u0003H\u0017J\b\u0010\u000f\u001a\u00020\u0003H\u0017J\b\u0010\u0010\u001a\u00020\u0003H\u0017J\b\u0010\u0011\u001a\u00020\u0003H\u0017J\b\u0010\u0012\u001a\u00020\u0003H\u0017J\b\u0010\u0013\u001a\u00020\u0003H\u0017J\b\u0010\u0014\u001a\u00020\u0003H\u0017J\b\u0010\u0015\u001a\u00020\u0003H\u0017J\b\u0010\u0016\u001a\u00020\u0003H\u0017\u00a8\u0006\u0017"}, d2={"Lorg/openrewrite/java/cleanup/FinalizeLocalVariablesTest;", "Lorg/openrewrite/test/RewriteTest;", "calculateLocalVariablesInitializerBranching", "", "calculateLocalVariablesInitializerOffset", "catchBlocksIgnored", "classInitializersIgnored", "classVariablesIgnored", "defaults", "spec", "Lorg/openrewrite/test/RecipeSpec;", "forEachLoopAssignmentMadeFinal", "forEachLoopScopeAwareness", "forLoopVariablesIgnored", "identifyReassignedLocalVariables", "initializedInWhileLoop", "instanceVariablesIgnored", "lambdaVariablesIgnored", "localVariableScopeAwareness", "localVariablesAreMadeFinal", "methodParameterVariablesIgnored", "multipleVariablesDeclarationOnSingleLine", "nonModifyingUnaryOperatorAwareness", "rewrite-java-tck"})
public interface FinalizeLocalVariablesTest
extends RewriteTest {
    public void defaults(@NotNull RecipeSpec var1);

    @Test
    public void initializedInWhileLoop();

    @Test
    public void localVariablesAreMadeFinal();

    @Test
    public void identifyReassignedLocalVariables();

    @Disabled(value="consider uninitialized local variables non final")
    @Test
    public void multipleVariablesDeclarationOnSingleLine();

    @Disabled(value="consider uninitialized local variables non final")
    @Test
    public void calculateLocalVariablesInitializerOffset();

    @Test
    @Disabled
    public void calculateLocalVariablesInitializerBranching();

    @Disabled(value="consider uninitialized local variables non final")
    @Test
    public void forEachLoopAssignmentMadeFinal();

    @Test
    public void localVariableScopeAwareness();

    @Test
    @Disabled(value="consider uninitialized local variables non final")
    public void forEachLoopScopeAwareness();

    @Test
    public void catchBlocksIgnored();

    @Test
    public void instanceVariablesIgnored();

    @Test
    public void classVariablesIgnored();

    @Test
    public void classInitializersIgnored();

    @Test
    public void methodParameterVariablesIgnored();

    @Test
    public void lambdaVariablesIgnored();

    @Test
    public void forLoopVariablesIgnored();

    @Test
    public void nonModifyingUnaryOperatorAwareness();

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        public static void defaults(@NotNull FinalizeLocalVariablesTest $this, @NotNull RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            spec.recipe((Recipe)new FinalizeLocalVariables());
        }

        @Test
        public static void initializedInWhileLoop(@NotNull FinalizeLocalVariablesTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.io.BufferedReader;\n            class T {\n                public void doSomething(StringBuilder sb, BufferedReader br) {\n                    String line;\n                    try {\n                        while ((line = br.readLine()) != null) {\n                            sb.append(line);\n                        }\n                    } catch (Exception e) {\n                        error(\"Exception\", e);\n                    }\n                }\n                private static void error(String s, Exception e) {\n                \n                } \n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void localVariablesAreMadeFinal(@NotNull FinalizeLocalVariablesTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class A {\n                public void test() {\n                    int n = 1;\n                    for(int i = 0; i < n; i++) {\n                    }\n                }\n            }\n        ", (String)"\n            class A {\n                public void test() {\n                    final int n = 1;\n                    for(int i = 0; i < n; i++) {\n                    }\n                }\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void identifyReassignedLocalVariables(@NotNull FinalizeLocalVariablesTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class A {\n                public void test() {\n                    int a = 0;\n                    int b = 0;\n                    int c = 10;\n                    for(int i = 0; i < c; i++) {\n                        a = i + c;\n                        b++;\n                    }\n                }\n            }\n        ", (String)"\n            class A {\n                public void test() {\n                    int a = 0;\n                    int b = 0;\n                    final int c = 10;\n                    for(int i = 0; i < c; i++) {\n                        a = i + c;\n                        b++;\n                    }\n                }\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Disabled(value="consider uninitialized local variables non final")
        @Test
        public static void multipleVariablesDeclarationOnSingleLine(@NotNull FinalizeLocalVariablesTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class A {\n                public void multiVariables() {\n                    int a, b = 1;\n                    a = 0;\n                }\n            }\n        ", (String)"\n            class A {\n                public void multiVariables() {\n                    final int a, b = 1;\n                    a = 0;\n                }\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Disabled(value="consider uninitialized local variables non final")
        @Test
        public static void calculateLocalVariablesInitializerOffset(@NotNull FinalizeLocalVariablesTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class A {\n                public void testOne() {\n                    int a;\n                    a = 0;\n                    System.out.println(a);\n                }\n\n                public void testTwo() {\n                    int a;\n                    a = 0;\n                    a = 0;\n                    System.out.println(a);\n                }\n\n                public void testThree() {\n                    int a;\n                    a = 0;\n                    a++;\n                    System.out.println(a);\n                }\n            }\n        ", (String)"\n            class A {\n                public void testOne() {\n                    final int a;\n                    a = 0;\n                    System.out.println(a);\n                }\n\n                public void testTwo() {\n                    int a;\n                    a = 0;\n                    a = 0;\n                    System.out.println(a);\n                }\n\n                public void testThree() {\n                    int a;\n                    a = 0;\n                    a++;\n                    System.out.println(a);\n                }\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        @Disabled
        public static void calculateLocalVariablesInitializerBranching(@NotNull FinalizeLocalVariablesTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class A {\n                public void test(boolean hasThing) {\n                    int a;\n                    if (hasThing) {\n                        a = 0;\n                    } else {\n                        a = 1;\n                    }\n                    System.out.println(a);\n                }\n            }\n        ", (String)"\n            class A {\n                public void test(boolean hasThing) {\n                    final int a;\n                    if (hasThing) {\n                        a = 0;\n                    } else {\n                        a = 1;\n                    }\n                    System.out.println(a);\n                }\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Disabled(value="consider uninitialized local variables non final")
        @Test
        public static void forEachLoopAssignmentMadeFinal(@NotNull FinalizeLocalVariablesTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                public static void testForEach(String[] args) {\n                    for (String a : args) {\n                        System.out.println(a);\n                    }\n\n                    for (String b : args) {\n                        b = b.toUpperCase();\n                        System.out.println(b);\n                    }\n                }\n            }\n        ", (String)"\n            class Test {\n                public static void testForEach(String[] args) {\n                    for (final String a : args) {\n                        System.out.println(a);\n                    }\n\n                    for (String b : args) {\n                        b = b.toUpperCase();\n                        System.out.println(b);\n                    }\n                }\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void localVariableScopeAwareness(@NotNull FinalizeLocalVariablesTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                public static void testA() {\n                    int a = 0;\n                    a = 1;\n                }\n\n                public static void testB() {\n                    int a = 0;\n                }\n            }\n        ", (String)"\n            class Test {\n                public static void testA() {\n                    int a = 0;\n                    a = 1;\n                }\n\n                public static void testB() {\n                    final int a = 0;\n                }\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        @Disabled(value="consider uninitialized local variables non final")
        public static void forEachLoopScopeAwareness(@NotNull FinalizeLocalVariablesTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                public static void testForEach(String[] args) {\n                    for (String i : args) {\n                        System.out.println(i);\n                    }\n\n                    for (String i : args) {\n                        i = i.toUpperCase();\n                        System.out.println(i);\n                    }\n                }\n            }\n        ", (String)"\n            class Test {\n                public static void testForEach(String[] args) {\n                    for (final String i : args) {\n                        System.out.println(i);\n                    }\n\n                    for (String i : args) {\n                        i = i.toUpperCase();\n                        System.out.println(i);\n                    }\n                }\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void catchBlocksIgnored(@NotNull FinalizeLocalVariablesTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.io.IOException;\n            \n            class Test {\n                static {\n                    try {\n                        throw new IOException();\n                    } catch (RuntimeException | IOException e) {\n                        System.out.println(\"oops\");\n                    }\n                }\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void instanceVariablesIgnored(@NotNull FinalizeLocalVariablesTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                int instanceVariableUninitialized;\n                int instanceVariableInitialized = 0;\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void classVariablesIgnored(@NotNull FinalizeLocalVariablesTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                static int classVariableInitialized = 0;\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void classInitializersIgnored(@NotNull FinalizeLocalVariablesTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                static {\n                    int n = 1;\n                    for(int i = 0; i < n; i++) {\n                    }\n                }\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void methodParameterVariablesIgnored(@NotNull FinalizeLocalVariablesTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                private static int testMath(int x, int y) {\n                    y = y + y;\n                    return x + y;\n                }\n\n                public static void main(String[] args) {\n                }\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void lambdaVariablesIgnored(@NotNull FinalizeLocalVariablesTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.stream.Stream;\n            class A {\n                public boolean hasFoo(Stream<String> input) {\n                    return input.anyMatch(word -> word.equalsIgnoreCase(\"foo\"));\n                }\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void forLoopVariablesIgnored(@NotNull FinalizeLocalVariablesTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.concurrent.FutureTask;\n            \n            class A {\n                void f() {\n                    for(FutureTask<?> future; (future = new FutureTask<>(() -> \"hello world\")) != null;) { }\n                }\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void nonModifyingUnaryOperatorAwareness(@NotNull FinalizeLocalVariablesTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                void test() {\n                    int i = 1;\n                    int j = -i;\n                    int k = +j;\n                    int l = ~k;\n                }\n            }\n        ", (String)"\n            class Test {\n                void test() {\n                    final int i = 1;\n                    final int j = -i;\n                    final int k = +j;\n                    final int l = ~k;\n                }\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }
    }
}

