/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.ChangeType;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.RemoveImport;
import org.openrewrite.java.RemoveImportTest;
import org.openrewrite.java.TypeValidator;
import org.openrewrite.java.style.ImportLayoutStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.style.NamedStyles;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0017J\b\u0010\u0004\u001a\u00020\u0003H\u0017J\b\u0010\u0005\u001a\u00020\u0003H\u0017J\b\u0010\u0006\u001a\u00020\u0003H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0013\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0014\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0015\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0017J\u001a\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u001d\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u001e\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u001f\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010 \u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010!\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\"\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010#\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0017J\b\u0010$\u001a\u00020\u0003H\u0017J\b\u0010%\u001a\u00020\u0003H\u0017\u00a8\u0006&"}, d2={"Lorg/openrewrite/java/RemoveImportTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "doNotUnfoldPackage", "", "doNotUnfoldStaticPackage", "doNotUnfoldStaticSubPackage", "doNotUnfoldSubPackage", "doesNotAffectClassBodyFormatting", "jp", "Lorg/openrewrite/java/JavaParser;", "generateNewUUIDPerUnfoldedImport", "leaveAloneIfThreeOrMoreStaticsAreInUse", "leaveImportIfRemovedTypeIsStillReferredTo", "leaveNamedStaticImportIfReferenceStillExists", "leaveStarImportInPlaceIfFiveOrMoreTypesStillReferredTo", "leaveStarStaticImportIfReferenceStillExists", "leaveWildcardImportIfRemovedTypeIsStillReferredTo", "preservesWhitespaceAfterPackageDeclaration", "preservesWhitespaceAfterPackageDeclarationNoImportsRemain", "preservesWhitespaceAfterRemovedImport", "preservesWhitespaceBetweenGroupsOfImports", "removeFromWildcardAndDuplicateImport", "removeImport", "Lorg/openrewrite/Recipe;", "type", "", "force", "", "removeNamedImport", "removeStarImportEvenIfReferredTo", "removeStarImportIfNoTypesReferredTo", "removeStarStaticImport", "removeStarStaticImportWhenRemovingSpecificMethod", "removeStaticImport", "replaceStarImportWithNamedImportIfOnlyOneReferencedTypeRemains", "unfoldStaticImportIfTwoOrLessAreUsed", "unfoldStaticSubpackage", "unfoldSubpackage", "rewrite-java-tck"})
public interface RemoveImportTest
extends JavaRecipeTest {
    @NotNull
    public Recipe removeImport(@NotNull String var1, boolean var2);

    @Test
    public void removeNamedImport(@NotNull JavaParser var1);

    @Test
    public void leaveImportIfRemovedTypeIsStillReferredTo(@NotNull JavaParser var1);

    @Test
    public void leaveWildcardImportIfRemovedTypeIsStillReferredTo(@NotNull JavaParser var1);

    @Test
    public void removeStarImportIfNoTypesReferredTo(@NotNull JavaParser var1);

    @Test
    public void replaceStarImportWithNamedImportIfOnlyOneReferencedTypeRemains(@NotNull JavaParser var1);

    @Test
    public void leaveStarImportInPlaceIfFiveOrMoreTypesStillReferredTo(@NotNull JavaParser var1);

    @Test
    public void removeStarStaticImport(@NotNull JavaParser var1);

    @Test
    public void removeStarStaticImportWhenRemovingSpecificMethod(@NotNull JavaParser var1);

    @Test
    public void removeStarImportEvenIfReferredTo(@NotNull JavaParser var1);

    @Test
    public void leaveStarStaticImportIfReferenceStillExists(@NotNull JavaParser var1);

    @Test
    public void removeStaticImport(@NotNull JavaParser var1);

    @Test
    public void leaveNamedStaticImportIfReferenceStillExists(@NotNull JavaParser var1);

    @Test
    public void preservesWhitespaceAfterPackageDeclaration(@NotNull JavaParser var1);

    @Test
    public void preservesWhitespaceAfterRemovedImport(@NotNull JavaParser var1);

    @Test
    public void preservesWhitespaceAfterPackageDeclarationNoImportsRemain(@NotNull JavaParser var1);

    @Test
    public void preservesWhitespaceBetweenGroupsOfImports(@NotNull JavaParser var1);

    @Test
    public void doesNotAffectClassBodyFormatting(@NotNull JavaParser var1);

    @Test
    public void removeFromWildcardAndDuplicateImport(@NotNull JavaParser var1);

    @Test
    public void generateNewUUIDPerUnfoldedImport(@NotNull JavaParser var1);

    @Test
    public void leaveAloneIfThreeOrMoreStaticsAreInUse(@NotNull JavaParser var1);

    @Test
    public void unfoldStaticImportIfTwoOrLessAreUsed(@NotNull JavaParser var1);

    @Test
    public void doNotUnfoldPackage();

    @Test
    public void doNotUnfoldSubPackage();

    @Test
    public void unfoldSubpackage();

    @Test
    public void doNotUnfoldStaticPackage();

    @Test
    public void doNotUnfoldStaticSubPackage();

    @Test
    public void unfoldStaticSubpackage();

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static Recipe removeImport(@NotNull RemoveImportTest $this, @NotNull String type, boolean force) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            return $this.toRecipe(new Function0<TreeVisitor<?, ExecutionContext>>(type, force){
                final /* synthetic */ String $type;
                final /* synthetic */ boolean $force;
                {
                    this.$type = $type;
                    this.$force = $force;
                    super(0);
                }

                @NotNull
                public final TreeVisitor<?, ExecutionContext> invoke() {
                    return (TreeVisitor)new RemoveImport(this.$type, this.$force);
                }
            });
        }

        public static /* synthetic */ Recipe removeImport$default(RemoveImportTest removeImportTest, String string, boolean bl, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: removeImport");
            }
            if ((n & 2) != 0) {
                bl = false;
            }
            return removeImportTest.removeImport(string, bl);
        }

        @Test
        public static void removeNamedImport(@NotNull RemoveImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default($this, jp, DefaultImpls.removeImport$default($this, "java.util.List", false, 2, null), null, "\n            import java.util.List;\n            class A {}\n        ", null, "class A {}", 0, 0, null, null, 980, null);
        }

        @Test
        public static void leaveImportIfRemovedTypeIsStillReferredTo(@NotNull RemoveImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default($this, jp, DefaultImpls.removeImport$default($this, "java.util.List", false, 2, null), null, "\n            import java.util.List;\n            class A {\n               List<Integer> list;\n            }\n        ", null, 20, null);
        }

        @Test
        public static void leaveWildcardImportIfRemovedTypeIsStillReferredTo(@NotNull RemoveImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default($this, jp, DefaultImpls.removeImport$default($this, "java.util.*", false, 2, null), null, "\n            import java.util.*;\n            class A {\n               List<Integer> list;\n            }\n        ", null, 20, null);
        }

        @Test
        public static void removeStarImportIfNoTypesReferredTo(@NotNull RemoveImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default($this, jp, DefaultImpls.removeImport$default($this, "java.util.List", false, 2, null), null, "\n            import java.util.*;\n            class A {}\n        ", null, "class A {}", 0, 0, null, null, 980, null);
        }

        @Test
        public static void replaceStarImportWithNamedImportIfOnlyOneReferencedTypeRemains(@NotNull RemoveImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default($this, jp, DefaultImpls.removeImport$default($this, "java.util.List", false, 2, null), null, "\n            import java.util.*;\n            \n            class A {\n               Collection<Integer> c;\n            }\n        ", null, "\n            import java.util.Collection;\n            \n            class A {\n               Collection<Integer> c;\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void leaveStarImportInPlaceIfFiveOrMoreTypesStillReferredTo(@NotNull RemoveImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default($this, jp, DefaultImpls.removeImport$default($this, "java.util.List", false, 2, null), null, "\n            import java.util.*;\n            class A {\n               Collection<Integer> c;\n               Set<Integer> s = new HashSet<>();\n               Map<Integer, Integer> m = new HashMap<>();\n            }\n        ", null, 20, null);
        }

        @Test
        public static void removeStarStaticImport(@NotNull RemoveImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default($this, jp, DefaultImpls.removeImport$default($this, "java.util.Collections", false, 2, null), null, "\n            import static java.util.Collections.*;\n            class A {}\n        ", null, "class A {}", 0, 0, null, null, 980, null);
        }

        @Test
        public static void removeStarStaticImportWhenRemovingSpecificMethod(@NotNull RemoveImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default($this, jp, DefaultImpls.removeImport$default($this, "java.util.Collections.emptyList", false, 2, null), null, "\n            import static java.util.Collections.*;\n            class A {\n                Object o = emptySet();\n            }\n        ", null, "\n            import static java.util.Collections.emptySet;\n            class A {\n                Object o = emptySet();\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void removeStarImportEvenIfReferredTo(@NotNull RemoveImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default($this, jp, $this.removeImport("java.util.List", true), null, "\n            import java.util.List;\n            class A {\n                List<String> l;\n            }\n        ", null, "\n            class A {\n                List<String> l;\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void leaveStarStaticImportIfReferenceStillExists(@NotNull RemoveImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default($this, jp, DefaultImpls.removeImport$default($this, "java.util.Collections", false, 2, null), null, "\n            import static java.util.Collections.*;\n            class A {\n               Object o = emptyList();\n            }\n        ", null, "import static java.util.Collections.emptyList;\nclass A {\n   Object o = emptyList();\n}", 0, 0, null, null, 980, null);
        }

        @Test
        public static void removeStaticImport(@NotNull RemoveImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default($this, jp, DefaultImpls.removeImport$default($this, "java.time.DayOfWeek.MONDAY", false, 2, null), null, "\n            import java.time.DayOfWeek;\n            \n            import static java.time.DayOfWeek.MONDAY;\n            import static java.time.DayOfWeek.TUESDAY;\n            \n            class WorkWeek {\n                DayOfWeek shortWeekStarts(){\n                    return TUESDAY;\n                }\n            }\n        ", null, "\n            import java.time.DayOfWeek;\n            \n            import static java.time.DayOfWeek.TUESDAY;\n            \n            class WorkWeek {\n                DayOfWeek shortWeekStarts(){\n                    return TUESDAY;\n                }\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void leaveNamedStaticImportIfReferenceStillExists(@NotNull RemoveImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default($this, jp, DefaultImpls.removeImport$default($this, "java.util.Collections", false, 2, null), null, "\n            import static java.util.Collections.emptyList;\n            import static java.util.Collections.emptySet;\n            \n            class A {\n               Object o = emptyList();\n            }\n        ", null, "\n            import static java.util.Collections.emptyList;\n            \n            class A {\n               Object o = emptyList();\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void preservesWhitespaceAfterPackageDeclaration(@NotNull RemoveImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default($this, jp, DefaultImpls.removeImport$default($this, "java.util.List", false, 2, null), null, "\n            package com.example.foo;\n            \n            import java.util.List;\n            import java.util.ArrayList;\n            \n            public class A {\n                ArrayList<String> foo = new ArrayList<>();\n            }\n        ", null, "\n            package com.example.foo;\n            \n            import java.util.ArrayList;\n            \n            public class A {\n                ArrayList<String> foo = new ArrayList<>();\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void preservesWhitespaceAfterRemovedImport(@NotNull RemoveImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default($this, jp, DefaultImpls.removeImport$default($this, "java.util.List", false, 2, null), null, "\n            package com.example.foo;\n            \n            import java.util.Collection;\n            import java.util.List;\n            \n            import java.util.ArrayList;\n            \n            public class A {\n            }\n        ", null, "\n            package com.example.foo;\n            \n            import java.util.Collection;\n            \n            import java.util.ArrayList;\n            \n            public class A {\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void preservesWhitespaceAfterPackageDeclarationNoImportsRemain(@NotNull RemoveImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default($this, jp, DefaultImpls.removeImport$default($this, "java.util.List", false, 2, null), null, "\n            package com.example.foo;\n            \n            import java.util.List;\n            \n            public class A {\n            }\n        ", null, "\n            package com.example.foo;\n            \n            public class A {\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void preservesWhitespaceBetweenGroupsOfImports(@NotNull RemoveImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Recipe recipe2 = DefaultImpls.removeImport$default($this, "java.util.List", false, 2, null);
            String[] stringArray = new String[]{"\n            package com.yourorg.b;\n            public class B {}\n        "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default($this, jp, recipe2, null, "\n            package com.example.foo;\n            \n            import com.yourorg.b.B;\n            \n            import java.util.List;\n            import java.util.ArrayList;\n            \n            public class A {\n                ArrayList<B> foo = new ArrayList<>();\n            }\n        ", stringArray2, "\n            package com.example.foo;\n            \n            import com.yourorg.b.B;\n            \n            import java.util.ArrayList;\n            \n            public class A {\n                ArrayList<B> foo = new ArrayList<>();\n            }\n        ", 0, 0, null, null, 964, null);
        }

        @Test
        public static void doesNotAffectClassBodyFormatting(@NotNull RemoveImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default($this, jp, DefaultImpls.removeImport$default($this, "java.util.List", false, 2, null), null, "\n            package com.example.foo;\n            \n            import java.util.List;\n            import java.util.ArrayList;\n            \n            public class A {\n            // Intentionally misaligned to ensure AutoFormat has not been applied to the class body\n            ArrayList<String> foo = new ArrayList<>();\n            }\n        ", null, "\n            package com.example.foo;\n            \n            import java.util.ArrayList;\n            \n            public class A {\n            // Intentionally misaligned to ensure AutoFormat has not been applied to the class body\n            ArrayList<String> foo = new ArrayList<>();\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void removeFromWildcardAndDuplicateImport(@NotNull RemoveImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default($this, jp, DefaultImpls.removeImport$default($this, "java.util.Collection", false, 2, null), null, "\n            package a;\n\n            import java.util.*;\n            import java.util.List;\n\n            public class A {\n                Set<Integer> s;\n                List<Integer> l;\n            }\n        ", null, "\n            package a;\n\n            import java.util.Set;\n            import java.util.List;\n\n            public class A {\n                Set<Integer> s;\n                List<Integer> l;\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void generateNewUUIDPerUnfoldedImport(@NotNull RemoveImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = $this;
            Recipe recipe2 = DefaultImpls.removeImport$default($this, "java.util.Collection", false, 2, null).doNext((Recipe)new ChangeType("java.util.List", "java.util.Collection", null));
            Intrinsics.checkNotNullExpressionValue((Object)recipe2, (String)"removeImport(\"java.util.\u2026.util.Collection\", null))");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, jp, recipe2, null, "\n            package a;\n\n            import java.util.*;\n            import java.util.List;\n\n            public class A {\n                Set<Integer> s;\n                List<Integer> l;\n            }\n        ", null, "\n            package a;\n\n            import java.util.Collection;\n            import java.util.Set;\n\n            public class A {\n                Set<Integer> s;\n                Collection<Integer> l;\n            }\n        ", 0, 0, null, generateNewUUIDPerUnfoldedImport.1.INSTANCE, 468, null);
        }

        @Test
        public static void leaveAloneIfThreeOrMoreStaticsAreInUse(@NotNull RemoveImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Recipe recipe2 = new Recipe[]{"\n            package org.test;\n            public class Example {\n                public static final int VALUE_1 = 1;\n                public static final int VALUE_2 = 2;\n                public static final int VALUE_3 = 3;\n                public static int method1() { return 1; }\n            }\n        "};
            Recipe recipe3 = recipe2;
            recipe2 = DefaultImpls.removeImport$default($this, "org.test.Example.VALUE_1", false, 2, null);
            JavaRecipeTest.DefaultImpls.assertUnchanged$default($this, jp, recipe2, null, "\n            package org.test.a;\n            \n            import static org.test.Example.*;\n            \n            public class Test {\n                public void method() {\n                    int value2 = VALUE_2;\n                    int value3 = VALUE_3;\n                    int methodValue = method1();\n                }\n            }\n        ", (String[])recipe3, 4, null);
        }

        @Test
        public static void unfoldStaticImportIfTwoOrLessAreUsed(@NotNull RemoveImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Recipe recipe2 = new Recipe[]{"\n            package org.test;\n            public class Example {\n                public static final int VALUE_1 = 1;\n                public static final int VALUE_2 = 2;\n                public static final int VALUE_3 = 3;\n                public static int method1() { return 1; }\n            }\n        "};
            Recipe recipe3 = recipe2;
            recipe2 = DefaultImpls.removeImport$default($this, "org.test.Example.VALUE_1", false, 2, null);
            JavaRecipeTest.DefaultImpls.assertChanged$default($this, jp, recipe2, null, "\n            package org.test.a;\n            \n            import static org.test.Example.*;\n            \n            public class Test {\n                public void method() {\n                    int value2 = VALUE_2;\n                    int methodValue = method1();\n                }\n            }\n        ", (String[])recipe3, "\n            package org.test.a;\n            \n            import static org.test.Example.method1;\n            import static org.test.Example.VALUE_2;\n            \n            public class Test {\n                public void method() {\n                    int value2 = VALUE_2;\n                    int methodValue = method1();\n                }\n            }\n        ", 0, 0, null, null, 964, null);
        }

        @Test
        public static void doNotUnfoldPackage(@NotNull RemoveImportTest $this) {
            JavaRecipeTest javaRecipeTest = $this;
            JavaParser javaParser = JavaParser.fromJavaVersion().styles((Iterable)CollectionsKt.listOf((Object)new NamedStyles(Tree.randomId(), "test", "test", "test", SetsKt.emptySet(), (Collection)CollectionsKt.listOf((Object)ImportLayoutStyle.builder().packageToFold("java.util.*").importAllOthers().importStaticAllOthers().build())))).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"fromJavaVersion().styles\u2026      )\n        ).build()");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(javaRecipeTest, javaParser, DefaultImpls.removeImport$default($this, "java.util.Map", false, 2, null), null, "\n            import java.util.*;\n            \n            class Test {\n                List<String> l;\n            }\n        ", null, 20, null);
        }

        @Test
        public static void doNotUnfoldSubPackage(@NotNull RemoveImportTest $this) {
            JavaRecipeTest javaRecipeTest = $this;
            JavaParser javaParser = JavaParser.fromJavaVersion().styles((Iterable)CollectionsKt.listOf((Object)new NamedStyles(Tree.randomId(), "test", "test", "test", SetsKt.emptySet(), (Collection)CollectionsKt.listOf((Object)ImportLayoutStyle.builder().packageToFold("java.util.*").importAllOthers().importStaticAllOthers().build())))).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"fromJavaVersion().styles\u2026      )\n        ).build()");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(javaRecipeTest, javaParser, DefaultImpls.removeImport$default($this, "java.util.concurrent.ConcurrentLinkedQueue", false, 2, null), null, "\n            import java.util.*;\n            import java.util.concurrent.*;\n            \n            class Test {\n                Map<Integer, Integer> m = new ConcurrentHashMap<>();\n            }\n        ", null, 20, null);
        }

        @Test
        public static void unfoldSubpackage(@NotNull RemoveImportTest $this) {
            JavaRecipeTest javaRecipeTest = $this;
            JavaParser javaParser = JavaParser.fromJavaVersion().styles((Iterable)CollectionsKt.listOf((Object)new NamedStyles(Tree.randomId(), "test", "test", "test", SetsKt.emptySet(), (Collection)CollectionsKt.listOf((Object)ImportLayoutStyle.builder().packageToFold("java.util.*", Boolean.valueOf(false)).importAllOthers().importStaticAllOthers().build())))).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"fromJavaVersion().styles\u2026      )\n        ).build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, DefaultImpls.removeImport$default($this, "java.util.concurrent.ConcurrentLinkedQueue", false, 2, null), null, "\n            import java.util.*;\n            import java.util.concurrent.*;\n            \n            class Test {\n                Map<Integer, Integer> m = new ConcurrentHashMap<>();\n            }\n        ", null, "\n            import java.util.*;\n            import java.util.concurrent.ConcurrentHashMap;\n            \n            class Test {\n                Map<Integer, Integer> m = new ConcurrentHashMap<>();\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void doNotUnfoldStaticPackage(@NotNull RemoveImportTest $this) {
            JavaRecipeTest javaRecipeTest = $this;
            JavaParser javaParser = JavaParser.fromJavaVersion().styles((Iterable)CollectionsKt.listOf((Object)new NamedStyles(Tree.randomId(), "test", "test", "test", SetsKt.emptySet(), (Collection)CollectionsKt.listOf((Object)ImportLayoutStyle.builder().staticPackageToFold("java.util.Collections.*").importAllOthers().importStaticAllOthers().build())))).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"fromJavaVersion().styles\u2026      )\n        ).build()");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(javaRecipeTest, javaParser, DefaultImpls.removeImport$default($this, "java.util.Collections.emptyMap", false, 2, null), null, "\n            import java.util.*;\n            import static java.util.Collections.*;\n            \n            class Test {\n                List<String> l = emptyList();\n            }\n        ", null, 20, null);
        }

        @Test
        public static void doNotUnfoldStaticSubPackage(@NotNull RemoveImportTest $this) {
            JavaRecipeTest javaRecipeTest = $this;
            JavaParser javaParser = JavaParser.fromJavaVersion().styles((Iterable)CollectionsKt.listOf((Object)new NamedStyles(Tree.randomId(), "test", "test", "test", SetsKt.emptySet(), (Collection)CollectionsKt.listOf((Object)ImportLayoutStyle.builder().staticPackageToFold("java.util.*").importAllOthers().importStaticAllOthers().build())))).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"fromJavaVersion().styles\u2026      )\n        ).build()");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(javaRecipeTest, javaParser, DefaultImpls.removeImport$default($this, "java.util.Collections.emptyMap", false, 2, null), null, "\n            import java.util.List;\n            import static java.util.Collections.*;\n            \n            class Test {\n                List<Integer> l = emptyList();\n            }\n        ", null, 20, null);
        }

        @Test
        public static void unfoldStaticSubpackage(@NotNull RemoveImportTest $this) {
            JavaRecipeTest javaRecipeTest = $this;
            JavaParser javaParser = JavaParser.fromJavaVersion().styles((Iterable)CollectionsKt.listOf((Object)new NamedStyles(Tree.randomId(), "test", "test", "test", SetsKt.emptySet(), (Collection)CollectionsKt.listOf((Object)ImportLayoutStyle.builder().packageToFold("java.util.*", Boolean.valueOf(false)).importAllOthers().importStaticAllOthers().build())))).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"fromJavaVersion().styles\u2026      )\n        ).build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, DefaultImpls.removeImport$default($this, "java.util.Collections.emptyMap", false, 2, null), null, "\n            import java.util.List;\n            import static java.util.Collections.*;\n            \n            class Test {\n                List<Integer> l = emptyList();\n            }\n        ", null, "\n            import java.util.List;\n            import static java.util.Collections.emptyList;\n            \n            class Test {\n                List<Integer> l = emptyList();\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @NotNull
        public static JavaParser getParser(@NotNull RemoveImportTest $this) {
            return JavaRecipeTest.DefaultImpls.getParser($this);
        }

        @NotNull
        public static ExecutionContext getExecutionContext(@NotNull RemoveImportTest $this) {
            return JavaRecipeTest.DefaultImpls.getExecutionContext($this);
        }

        @BeforeEach
        public static void beforeRecipe(@NotNull RemoveImportTest $this) {
            JavaRecipeTest.DefaultImpls.beforeRecipe($this);
        }

        @AfterEach
        public static void afterRecipe(@NotNull RemoveImportTest $this) {
            JavaRecipeTest.DefaultImpls.afterRecipe($this);
        }

        public static void assertChanged(@NotNull RemoveImportTest $this, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged($this, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull RemoveImportTest $this, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged($this, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertUnchanged(@NotNull RemoveImportTest $this, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged($this, parser, recipe2, executionContext, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull RemoveImportTest $this, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged($this, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        @Nullable
        public static Recipe getRecipe(@NotNull RemoveImportTest $this) {
            return JavaRecipeTest.DefaultImpls.getRecipe($this);
        }

        public static void assertChangedBase(@NotNull RemoveImportTest $this, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase($this, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull RemoveImportTest $this, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase($this, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertUnchangedBase(@NotNull RemoveImportTest $this, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase($this, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        public static void assertUnchangedBase(@NotNull RemoveImportTest $this, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase($this, parser, recipe2, executionContext, before, dependsOn);
        }

        @NotNull
        public static Recipe fromRuntimeClasspath(@NotNull RemoveImportTest $this, @NotNull String recipe2) {
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            return JavaRecipeTest.DefaultImpls.fromRuntimeClasspath($this, recipe2);
        }

        @NotNull
        public static Recipe toRecipe(@NotNull RemoveImportTest $this, @NotNull Function0<? extends TreeVisitor<?, ExecutionContext>> supplier) {
            Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
            return JavaRecipeTest.DefaultImpls.toRecipe($this, supplier);
        }
    }
}

