/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.OrderImports;
import org.openrewrite.java.style.ImportLayoutStyle;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.style.Style;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u001b\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0017J\b\u0010\u0004\u001a\u00020\u0003H\u0017J\b\u0010\u0005\u001a\u00020\u0003H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\u0003H\u0017J\b\u0010\n\u001a\u00020\u0003H\u0017J\b\u0010\u000b\u001a\u00020\u0003H\u0017J\b\u0010\f\u001a\u00020\u0003H\u0017J\b\u0010\r\u001a\u00020\u0003H\u0017J\b\u0010\u000e\u001a\u00020\u0003H\u0017J\b\u0010\u000f\u001a\u00020\u0003H\u0017J\b\u0010\u0010\u001a\u00020\u0003H\u0017J\b\u0010\u0011\u001a\u00020\u0003H\u0017J\b\u0010\u0012\u001a\u00020\u0003H\u0017J\b\u0010\u0013\u001a\u00020\u0003H\u0017J\b\u0010\u0014\u001a\u00020\u0003H\u0017J\b\u0010\u0015\u001a\u00020\u0003H\u0017J\b\u0010\u0016\u001a\u00020\u0003H\u0017J\b\u0010\u0017\u001a\u00020\u0003H\u0017J\b\u0010\u0018\u001a\u00020\u0003H\u0017J\b\u0010\u0019\u001a\u00020\u0003H\u0017J\b\u0010\u001a\u001a\u00020\u0003H\u0017J\b\u0010\u001b\u001a\u00020\u0003H\u0017J\b\u0010\u001c\u001a\u00020\u0003H\u0017J\b\u0010\u001d\u001a\u00020\u0003H\u0017J\b\u0010\u001e\u001a\u00020\u0003H\u0017J\b\u0010\u001f\u001a\u00020\u0003H\u0017J\b\u0010 \u001a\u00020\u0003H\u0017J\b\u0010!\u001a\u00020\u0003H\u0017J\b\u0010\"\u001a\u00020\u0003H\u0017\u00a8\u0006#"}, d2={"Lorg/openrewrite/java/OrderImportsTest;", "Lorg/openrewrite/test/RewriteTest;", "blankLinesBetweenImports", "", "blankLinesNotFollowedByBlockArentAdded", "collapsesDifferentStaticImportsFromSamePackage", "defaults", "spec", "Lorg/openrewrite/test/RecipeSpec;", "detectBlockPattern", "doNotFoldImports", "doNotFoldPackageWithJavaLangClassNames", "foldGroupOfStaticImportsThatAppearLast", "foldIntoExistingStar", "foldIntoStar", "foldPackageWithExistingImports", "groupImportsIsAwareOfNestedClasses", "idempotence", "importSorting", "multipleClassesWithTheSameNameButDifferentPackages", "orderAndDoNotFoldImports", "orderAndDoNotFoldStaticClasses", "packagePatternEscapesDots", "preservesDifferentStaticImportsFromSamePackage", "preservesStaticInheritanceImport", "preservesStaticMethodArguments", "preservesStaticStarImportWhenRemovingUnused", "removeUnused", "removesRedundantImports", "sortInnerAndOuterClassesInTheSamePackage", "springCloudFormat", "twoImportsFollowedByStar", "unfoldStar", "unfoldStarMultiple", "unfoldStaticStar", "rewrite-java-tck"})
public interface OrderImportsTest
extends RewriteTest {
    public void defaults(@NotNull RecipeSpec var1);

    @Test
    public void sortInnerAndOuterClassesInTheSamePackage();

    @Test
    public void multipleClassesWithTheSameNameButDifferentPackages();

    @Test
    public void foldIntoStar();

    @Test
    public void blankLinesNotFollowedByBlockArentAdded();

    @Test
    public void foldIntoExistingStar();

    @Test
    public void idempotence();

    @Test
    public void unfoldStar();

    @Test
    public void unfoldStarMultiple();

    @Test
    public void removeUnused();

    @Test
    public void unfoldStaticStar();

    @Test
    public void packagePatternEscapesDots();

    @Test
    public void twoImportsFollowedByStar();

    @Test
    public void springCloudFormat();

    @Test
    public void importSorting();

    @Test
    public void foldGroupOfStaticImportsThatAppearLast();

    @Test
    public void preservesStaticStarImportWhenRemovingUnused();

    @Test
    public void preservesStaticInheritanceImport();

    @Test
    public void preservesStaticMethodArguments();

    @Test
    public void preservesDifferentStaticImportsFromSamePackage();

    @Test
    public void collapsesDifferentStaticImportsFromSamePackage();

    @Test
    public void removesRedundantImports();

    @Test
    public void blankLinesBetweenImports();

    @Test
    public void groupImportsIsAwareOfNestedClasses();

    @Test
    public void detectBlockPattern();

    @Test
    public void doNotFoldImports();

    @Test
    public void orderAndDoNotFoldStaticClasses();

    @Test
    public void orderAndDoNotFoldImports();

    @Test
    public void doNotFoldPackageWithJavaLangClassNames();

    @Test
    public void foldPackageWithExistingImports();

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        public static void defaults(@NotNull OrderImportsTest $this, @NotNull RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            spec.recipe((Recipe)new OrderImports(Boolean.valueOf(false)));
        }

        @Test
        public static void sortInnerAndOuterClassesInTheSamePackage(@NotNull OrderImportsTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"class Test {}")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void multipleClassesWithTheSameNameButDifferentPackages(@NotNull OrderImportsTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.awt.List;\n            import java.util.List;\n            \n            class Test {}\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void foldIntoStar(@NotNull OrderImportsTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.List;\n            import java.util.ArrayList;\n            import java.util.regex.Pattern;\n            import java.util.Objects;\n            import java.util.Set;\n            import java.util.Map;\n        ", (String)"\n            import java.util.*;\n            import java.util.regex.Pattern;\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void blankLinesNotFollowedByBlockArentAdded(@NotNull OrderImportsTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.List;\n            \n            import static java.util.Collections.*;\n            \n            class A {}\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void foldIntoExistingStar(@NotNull OrderImportsTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.*;\n            import java.util.ArrayList;\n            import java.util.regex.Pattern;\n            import java.util.Objects;\n        ", (String)"\n            import java.util.*;\n            import java.util.regex.Pattern;\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void idempotence(@NotNull OrderImportsTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.*;\n            import java.util.regex.Pattern;\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void unfoldStar(@NotNull OrderImportsTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.*;\n            \n            class A {\n                List<Integer> list;\n                List<Integer> list2;\n            }\n        ", (String)"\n            import java.util.List;\n            \n            class A {\n                List<Integer> list;\n                List<Integer> list2;\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::unfoldStar$lambda$0, sourceSpecsArray);
        }

        @Test
        public static void unfoldStarMultiple(@NotNull OrderImportsTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.*;\n            \n            class A {\n                List<Integer> list;\n                Map<Integer, Integer> map;\n            }\n        ", (String)"\n            import java.util.List;\n            import java.util.Map;\n            \n            class A {\n                List<Integer> list;\n                Map<Integer, Integer> map;\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::unfoldStarMultiple$lambda$1, sourceSpecsArray);
        }

        @Test
        public static void removeUnused(@NotNull OrderImportsTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.*;\n        ", (String)"")};
            $this.rewriteRun(DefaultImpls::removeUnused$lambda$2, sourceSpecsArray);
        }

        @Test
        public static void unfoldStaticStar(@NotNull OrderImportsTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.List;\n            \n            import static java.util.Collections.*;\n            \n            class A {\n                List<Integer> list = emptyList();\n            }\n        ", (String)"\n            import java.util.List;\n            \n            import static java.util.Collections.emptyList;\n            \n            class A {\n                List<Integer> list = emptyList();\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::unfoldStaticStar$lambda$3, sourceSpecsArray);
        }

        @Test
        public static void packagePatternEscapesDots(@NotNull OrderImportsTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import javax.annotation.Nonnull;\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void twoImportsFollowedByStar(@NotNull OrderImportsTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.io.IOException;\n            import java.io.UncheckedIOException;\n            import java.nio.files.*;\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void springCloudFormat(@NotNull OrderImportsTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.io.ByteArrayOutputStream;\n            import java.nio.charset.StandardCharsets;\n            import java.util.Collections;\n            import java.util.zip.GZIPOutputStream;\n            \n            import javax.servlet.ReadListener;\n            import javax.servlet.ServletInputStream;\n            import javax.servlet.ServletOutputStream;\n            \n            import com.fasterxml.jackson.databind.ObjectMapper;\n            import org.apache.commons.logging.Log;\n            import reactor.core.publisher.Mono;\n            \n            import org.springframework.core.io.buffer.DataBuffer;\n            import org.springframework.core.io.buffer.DataBufferFactory;\n            import org.springframework.http.HttpHeaders;\n            import org.springframework.util.MultiValueMap;\n            import org.springframework.web.bind.annotation.PathVariable;\n            import org.springframework.web.server.ServerWebExchange;\n            \n            import static java.util.Arrays.stream;\n            import static org.springframework.cloud.gateway.support.ServerWebExchangeUtils.toAsyncPredicate;\n            \n            class A {}\n        ")};
            $this.rewriteRun(DefaultImpls::springCloudFormat$lambda$4, sourceSpecsArray);
        }

        @Test
        public static void importSorting(@NotNull OrderImportsTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import r.core.Flux;\n            import s.core.Flux;\n            import com.fasterxml.jackson.databind.ObjectMapper;\n            import org.apache.commons.logging.Log;\n            import reactor.core.publisher.Mono;\n        ", (String)"\n            import com.fasterxml.jackson.databind.ObjectMapper;\n            import org.apache.commons.logging.Log;\n            import r.core.Flux;\n            import reactor.core.publisher.Mono;\n            import s.core.Flux;\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void foldGroupOfStaticImportsThatAppearLast(@NotNull OrderImportsTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import static java.util.stream.Collectors.toList;\n            import static java.util.stream.Collectors.toMap;\n            import static java.util.stream.Collectors.toSet;\n        ", (String)"\n            import static java.util.stream.Collectors.*;\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void preservesStaticStarImportWhenRemovingUnused(@NotNull OrderImportsTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import static java.util.Collections.*;\n            \n            class Test {\n                Object[] o = new Object[] { emptyList(), emptyMap(), emptySet() };\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::preservesStaticStarImportWhenRemovingUnused$lambda$5, sourceSpecsArray);
        }

        @Test
        public static void preservesStaticInheritanceImport(@NotNull OrderImportsTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            package my;\n            public class MyCollections extends java.util.Collections {}\n        "), Assertions.java((String)"\n            import static my.MyCollections.*;\n            \n            class Test {\n                Object[] o = new Object[] { emptyList(), emptyMap(), emptySet() };\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::preservesStaticInheritanceImport$lambda$6, sourceSpecsArray);
        }

        @Test
        public static void preservesStaticMethodArguments(@NotNull OrderImportsTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import static java.util.Collections.*;\n            \n            class Test {\n                Object[] o = new Object[] { emptyList(), emptyMap(), emptySet() };\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::preservesStaticMethodArguments$lambda$7, sourceSpecsArray);
        }

        @Test
        public static void preservesDifferentStaticImportsFromSamePackage(@NotNull OrderImportsTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import static java.util.Collections.emptyList;\n            import static java.util.Collections.emptyMap;\n            import static java.util.GregorianCalendar.getAvailableCalendarTypes;\n            import static java.util.GregorianCalendar.getAvailableLocales;\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void collapsesDifferentStaticImportsFromSamePackage(@NotNull OrderImportsTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import static java.util.Collections.emptyList;\n            import static java.util.Collections.emptyMap;\n            import static java.util.Collections.emptySet;\n            import static java.util.GregorianCalendar.getAvailableCalendarTypes;\n            import static java.util.GregorianCalendar.getAvailableLocales;\n            import static java.util.GregorianCalendar.getInstance;\n        ", (String)"\n            import static java.util.Collections.*;\n            import static java.util.GregorianCalendar.*;\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void removesRedundantImports(@NotNull OrderImportsTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.List;\n            import java.util.List;\n        ", (String)"\n            import java.util.List;\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void blankLinesBetweenImports(@NotNull OrderImportsTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.List;\n            import static java.util.Collections.singletonList;\n            class Test {\n            }\n        ", (String)"\n            import static java.util.Collections.singletonList;\n            \n            import java.util.List;\n            \n            class Test {\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::blankLinesBetweenImports$lambda$8, sourceSpecsArray);
        }

        @Test
        public static void groupImportsIsAwareOfNestedClasses(@NotNull OrderImportsTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import org.openrewrite.java.J.CompilationUnit;\n            import org.openrewrite.java.J;\n            import org.openrewrite.java.JavaVisitor;\n            import org.openrewrite.java.JavaPrinter;\n            import org.openrewrite.java.ChangeMethodName;\n            import org.openrewrite.java.ChangeType;\n        ", (String)"\n            import org.openrewrite.java.*;\n            import org.openrewrite.java.J.CompilationUnit;\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void detectBlockPattern(@NotNull OrderImportsTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            // org.slf4j should be detected as a block pattern, and not be moved to all other imports.\n            import org.slf4j.Logger;\n            import org.slf4j.LoggerFactory;\n            \n            import java.util.Arrays;\n            import java.util.List;\n            \n            public class C {\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void doNotFoldImports(@NotNull OrderImportsTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.ArrayList;\n            import java.util.Collections;\n            import java.util.HashSet;\n            import java.util.List;\n            import java.util.Set;\n            \n            import javax.persistence.Entity;\n            import javax.persistence.FetchType;\n            import javax.persistence.JoinColumn;\n            import javax.persistence.JoinTable;\n            import javax.persistence.ManyToMany;\n            import javax.persistence.Table;\n            \n            public class C {\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::doNotFoldImports$lambda$9, sourceSpecsArray);
        }

        @Test
        public static void orderAndDoNotFoldStaticClasses(@NotNull OrderImportsTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import static org.openrewrite.java.J.CompilationUnit.*;\n            import static org.openrewrite.java.J.ClassDeclaration.*;\n            import static org.openrewrite.java.J.MethodInvocation.*;\n            import static org.openrewrite.java.J.MethodDeclaration.*;\n            import static org.openrewrite.java.J.If.*;\n        ", (String)"\n            import static org.openrewrite.java.J.ClassDeclaration.*;\n            import static org.openrewrite.java.J.CompilationUnit.*;\n            import static org.openrewrite.java.J.If.*;\n            import static org.openrewrite.java.J.MethodDeclaration.*;\n            import static org.openrewrite.java.J.MethodInvocation.*;\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void orderAndDoNotFoldImports(@NotNull OrderImportsTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.aws.List;\n            import java.awt.Panel;\n            import java.util.Collection;\n            import java.util.List;\n            import java.awt.Point;\n            import java.awt.Robot;\n            import java.util.TreeMap;\n            import java.util.Map;\n            import java.util.Set;\n            import java.awt.Polygon;\n        ", (String)"\n            import java.aws.List;\n            import java.awt.Panel;\n            import java.awt.Point;\n            import java.awt.Polygon;\n            import java.awt.Robot;\n            import java.util.Collection;\n            import java.util.List;\n            import java.util.Map;\n            import java.util.Set;\n            import java.util.TreeMap;\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void doNotFoldPackageWithJavaLangClassNames(@NotNull OrderImportsTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import kotlin.DeepRecursiveFunction;\n            import kotlin.Function;\n            import kotlin.Lazy;\n            import kotlin.Pair;\n            import kotlin.String;\n        ")};
            $this.rewriteRun(DefaultImpls::doNotFoldPackageWithJavaLangClassNames$lambda$11, sourceSpecsArray);
        }

        @Test
        public static void foldPackageWithExistingImports(@NotNull OrderImportsTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.List;\n        ", (String)"\n            import java.util.*;\n        ")};
            $this.rewriteRun(DefaultImpls::foldPackageWithExistingImports$lambda$12, sourceSpecsArray);
        }

        private static void unfoldStar$lambda$0(RecipeSpec spec) {
            spec.recipe((Recipe)new OrderImports(Boolean.valueOf(true)));
        }

        private static void unfoldStarMultiple$lambda$1(RecipeSpec spec) {
            spec.recipe((Recipe)new OrderImports(Boolean.valueOf(true)));
        }

        private static void removeUnused$lambda$2(RecipeSpec spec) {
            spec.recipe((Recipe)new OrderImports(Boolean.valueOf(true)));
        }

        private static void unfoldStaticStar$lambda$3(RecipeSpec spec) {
            spec.recipe((Recipe)new OrderImports(Boolean.valueOf(true)));
        }

        private static void springCloudFormat$lambda$4(RecipeSpec spec) {
            spec.parser((Parser.Builder)JavaParser.fromJavaVersion().styles((Iterable)CollectionsKt.listOf((Object)new NamedStyles(Tree.randomId(), "spring", "spring", "spring", SetsKt.emptySet(), (Collection)CollectionsKt.listOf((Object)ImportLayoutStyle.builder().classCountToUseStarImport(999).nameCountToUseStarImport(999).importPackage("java.*").blankLine().importPackage("javax.*").blankLine().importAllOthers().blankLine().importPackage("org.springframework.*").blankLine().importStaticAllOthers().build())))));
        }

        private static void preservesStaticStarImportWhenRemovingUnused$lambda$5(RecipeSpec spec) {
            spec.recipe((Recipe)new OrderImports(Boolean.valueOf(true)));
        }

        private static void preservesStaticInheritanceImport$lambda$6(RecipeSpec spec) {
            spec.recipe((Recipe)new OrderImports(Boolean.valueOf(true)));
        }

        private static void preservesStaticMethodArguments$lambda$7(RecipeSpec spec) {
            spec.recipe((Recipe)new OrderImports(Boolean.valueOf(true)));
        }

        private static void blankLinesBetweenImports$lambda$8(RecipeSpec spec) {
            JavaParser.Builder builder = JavaParser.fromJavaVersion();
            UUID uUID = Tree.randomId();
            Set set = SetsKt.emptySet();
            ImportLayoutStyle importLayoutStyle = ImportLayoutStyle.builder().classCountToUseStarImport(9999).nameCountToUseStarImport(9999).importStaticAllOthers().blankLine().importAllOthers().blankLine().build();
            Intrinsics.checkNotNull((Object)importLayoutStyle, (String)"null cannot be cast to non-null type org.openrewrite.style.Style");
            spec.parser((Parser.Builder)builder.styles((Iterable)CollectionsKt.listOf((Object)new NamedStyles(uUID, "custom", "custom style", null, set, (Collection)CollectionsKt.listOf((Object)((Style)importLayoutStyle))))));
        }

        private static void doNotFoldImports$lambda$9(RecipeSpec spec) {
            JavaParser.Builder builder = JavaParser.fromJavaVersion();
            UUID uUID = Tree.randomId();
            Set set = SetsKt.emptySet();
            ImportLayoutStyle importLayoutStyle = ImportLayoutStyle.builder().classCountToUseStarImport(Integer.MAX_VALUE).nameCountToUseStarImport(Integer.MAX_VALUE).importPackage("java.*").blankLine().importPackage("javax.*").blankLine().importAllOthers().blankLine().importStaticAllOthers().build();
            Intrinsics.checkNotNull((Object)importLayoutStyle, (String)"null cannot be cast to non-null type org.openrewrite.style.Style");
            spec.parser((Parser.Builder)builder.styles((Iterable)CollectionsKt.listOf((Object)new NamedStyles(uUID, "custom", "custom style", null, set, (Collection)CollectionsKt.listOf((Object)((Style)importLayoutStyle))))));
        }

        /*
         * WARNING - void declaration
         */
        private static void doNotFoldPackageWithJavaLangClassNames$lambda$11(RecipeSpec spec) {
            void $this$doNotFoldPackageWithJavaLangClassNames_u24lambda_u2411_u24lambda_u2410;
            InMemoryExecutionContext inMemoryExecutionContext;
            InMemoryExecutionContext inMemoryExecutionContext2 = inMemoryExecutionContext = new InMemoryExecutionContext();
            RecipeSpec recipeSpec = spec;
            boolean bl = false;
            $this$doNotFoldPackageWithJavaLangClassNames_u24lambda_u2411_u24lambda_u2410.putMessage("org.openrewrite.java.skipSourceSetTypeGeneration", (Object)false);
            recipeSpec.executionContext((ExecutionContext)inMemoryExecutionContext).recipe((Recipe)new OrderImports(Boolean.valueOf(false)));
        }

        private static void foldPackageWithExistingImports$lambda$12(RecipeSpec spec) {
            spec.parser((Parser.Builder)JavaParser.fromJavaVersion().styles((Iterable)CollectionsKt.listOf((Object)new NamedStyles(Tree.randomId(), "test", "test", "test", SetsKt.emptySet(), (Collection)CollectionsKt.listOf((Object)ImportLayoutStyle.builder().packageToFold("java.util.*", Boolean.valueOf(false)).importAllOthers().importStaticAllOthers().build())))));
        }
    }
}

