/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.ChangeStaticFieldToMethod;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.TypeValidator;
import org.openrewrite.java.tree.J;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\bf\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fJ\b\u0010\u0006\u001a\u00020\u0007H\u0017J\b\u0010\b\u001a\u00020\u0007H\u0017J\b\u0010\t\u001a\u00020\u0007H\u0017J\b\u0010\n\u001a\u00020\u0007H\u0017J\b\u0010\u000b\u001a\u00020\u0007H\u0017J\b\u0010\f\u001a\u00020\u0007H\u0017J\b\u0010\r\u001a\u00020\u0007H\u0017J\b\u0010\u000e\u001a\u00020\u0007H\u0017R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0010"}, d2={"Lorg/openrewrite/java/ChangeStaticFieldToMethodTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "recipe", "Lorg/openrewrite/java/ChangeStaticFieldToMethod;", "getRecipe", "()Lorg/openrewrite/java/ChangeStaticFieldToMethod;", "constantToMethodOnStaticTarget", "", "ignoresUnrelatedFields", "leavesOwnerAlone", "migratesFieldInitializer", "migratesFullyQualifiedField", "migratesQualifiedField", "migratesStaticImportedField", "migratesToJavaLangClass", "Companion", "rewrite-java-tck"})
public interface ChangeStaticFieldToMethodTest
extends JavaRecipeTest {
    @NotNull
    public static final Companion Companion = org.openrewrite.java.ChangeStaticFieldToMethodTest$Companion.$$INSTANCE;

    @NotNull
    public ChangeStaticFieldToMethod getRecipe();

    @Test
    public void migratesQualifiedField();

    @Test
    public void migratesStaticImportedField();

    @Test
    public void migratesFullyQualifiedField();

    @Test
    public void migratesFieldInitializer();

    @Test
    public void ignoresUnrelatedFields();

    @Test
    public void migratesToJavaLangClass();

    @Test
    public void leavesOwnerAlone();

    @Test
    public void constantToMethodOnStaticTarget();

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/openrewrite/java/ChangeStaticFieldToMethodTest$Companion;", "", "()V", "acmeLists", "", "staticStringClass", "rewrite-java-tck"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @Language(value="java")
        @NotNull
        private static final String acmeLists = "\n            package com.acme;\n\n            import java.util.Collections;\n            import java.util.List;\n\n            class Lists {\n                static <E> List<E> of() {\n                    return Collections.emptyList();\n                }\n            }\n        ";
        @Language(value="java")
        @NotNull
        private static final String staticStringClass = "\n            package com.acme;\n\n            public class Example {\n                public static final String EXAMPLE = \"example\";\n            }\n        ";

        private Companion() {
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static ChangeStaticFieldToMethod getRecipe(@NotNull ChangeStaticFieldToMethodTest $this) {
            return new ChangeStaticFieldToMethod("java.util.Collections", "EMPTY_LIST", "com.acme.Lists", null, "of");
        }

        @Test
        public static void migratesQualifiedField(@NotNull ChangeStaticFieldToMethodTest $this) {
            String[] stringArray = new String[]{"\n            package com.acme;\n\n            import java.util.Collections;\n            import java.util.List;\n\n            class Lists {\n                static <E> List<E> of() {\n                    return Collections.emptyList();\n                }\n            }\n        "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default($this, null, null, null, "\n            import java.util.Collections;\n            import java.util.List;\n\n            class A {\n                static List<String> empty() {\n                    return Collections.EMPTY_LIST;\n                }\n            }\n        ", stringArray2, "\n            import com.acme.Lists;\n\n            import java.util.List;\n\n            class A {\n                static List<String> empty() {\n                    return Lists.of();\n                }\n            }\n        ", 0, 0, null, null, 967, null);
        }

        @Test
        public static void migratesStaticImportedField(@NotNull ChangeStaticFieldToMethodTest $this) {
            String[] stringArray = new String[]{"\n            package com.acme;\n\n            import java.util.Collections;\n            import java.util.List;\n\n            class Lists {\n                static <E> List<E> of() {\n                    return Collections.emptyList();\n                }\n            }\n        "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default($this, null, null, null, "\n            import static java.util.Collections.EMPTY_LIST;\n\n            class A {\n                static Object empty() {\n                    return EMPTY_LIST;\n                }\n            }\n        ", stringArray2, "\n            import com.acme.Lists;\n\n            class A {\n                static Object empty() {\n                    return Lists.of();\n                }\n            }\n        ", 0, 0, null, null, 967, null);
        }

        @Test
        public static void migratesFullyQualifiedField(@NotNull ChangeStaticFieldToMethodTest $this) {
            String[] stringArray = new String[]{"\n            package com.acme;\n\n            import java.util.Collections;\n            import java.util.List;\n\n            class Lists {\n                static <E> List<E> of() {\n                    return Collections.emptyList();\n                }\n            }\n        "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default($this, null, null, null, "\n            class A {\n                static Object empty() {\n                    return java.util.Collections.EMPTY_LIST;\n                }\n            }\n        ", stringArray2, "\n            import com.acme.Lists;\n\n            class A {\n                static Object empty() {\n                    return Lists.of();\n                }\n            }\n        ", 0, 0, null, null, 967, null);
        }

        @Test
        public static void migratesFieldInitializer(@NotNull ChangeStaticFieldToMethodTest $this) {
            String[] stringArray = new String[]{"\n            package com.acme;\n\n            import java.util.Collections;\n            import java.util.List;\n\n            class Lists {\n                static <E> List<E> of() {\n                    return Collections.emptyList();\n                }\n            }\n        "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default($this, null, null, null, "\n            import java.util.Collections;\n\n            class A {\n                private final Object collection = Collections.EMPTY_LIST;\n            }\n        ", stringArray2, "\n            import com.acme.Lists;\n\n            class A {\n                private final Object collection = Lists.of();\n            }\n        ", 0, 0, null, null, 967, null);
        }

        @Test
        public static void ignoresUnrelatedFields(@NotNull ChangeStaticFieldToMethodTest $this) {
            JavaRecipeTest.DefaultImpls.assertUnchanged$default($this, null, null, null, "\n            import java.util.Collections;\n\n            class A {\n                static Object EMPTY_LIST = null;\n\n                static Object empty1() {\n                    return A.EMPTY_LIST;\n                }\n\n                static Object empty2() {\n                    return EMPTY_LIST;\n                }\n            }\n        ", null, 23, null);
        }

        @Test
        public static void migratesToJavaLangClass(@NotNull ChangeStaticFieldToMethodTest $this) {
            ChangeStaticFieldToMethod changeStaticFieldToMethod = new ChangeStaticFieldToMethod("com.acme.Example", "EXAMPLE", "java.lang.System", null, "lineSeparator");
            String[] stringArray = new String[]{"\n            package com.acme;\n\n            public class Example {\n                public static final String EXAMPLE = \"example\";\n            }\n        "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default($this, null, (Recipe)changeStaticFieldToMethod, null, "\n            package example;\n\n            import com.acme.Example;\n\n            class A {\n                static String lineSeparator() {\n                    return Example.EXAMPLE;\n                }\n            }\n        ", stringArray2, "\n            package example;\n\n            class A {\n                static String lineSeparator() {\n                    return System.lineSeparator();\n                }\n            }\n        ", 0, 0, null, null, 965, null);
        }

        @Test
        public static void leavesOwnerAlone(@NotNull ChangeStaticFieldToMethodTest $this) {
            JavaRecipeTest.DefaultImpls.assertUnchanged$default($this, null, (Recipe)new ChangeStaticFieldToMethod("com.example.Test", "EXAMPLE", "com.doesntmatter.Foo", null, "BAR"), null, "\n            package com.example;\n            \n            class Test {\n                public static Object EXAMPLE = null;\n            }\n        ", null, 21, null);
        }

        @Test
        public static void constantToMethodOnStaticTarget(@NotNull ChangeStaticFieldToMethodTest $this) {
            ChangeStaticFieldToMethod changeStaticFieldToMethod = new ChangeStaticFieldToMethod("constants.Constants", "SUCCESS_CODE", "io.netty.handler.codec.http.HttpResponseStatus", "OK", "codeAsText");
            String[] stringArray = new String[]{"\n                package constants;\n\n                public class Constants {\n                    public static final String SUCCESS_CODE = \"200\";\n                }\n            ", "\n                package io.netty.handler.codec.http;\n\n                public class HttpResponseStatus {\n                    public static final HttpResponseStatus OK = new HttpResponseStatus(200);\n\n                    private final int code;\n                    private HttpResponseStatus(int code) {\n                        this.code = code;\n                    }\n                    \n                    String codeAsText() {\n                        return String.valueOf(code);\n                    }\n                }\n\n            "};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default($this, null, (Recipe)changeStaticFieldToMethod, null, "\n            package com.example;\n            \n            import constants.Constants;\n            \n            class Test {\n                public static String testMe() {\n                    return Constants.SUCCESS_CODE;\n                }\n            }\n        ", stringArray2, "\n            package com.example;\n            \n            import io.netty.handler.codec.http.HttpResponseStatus;\n            \n            class Test {\n                public static String testMe() {\n                    return HttpResponseStatus.OK.codeAsText();\n                }\n            }\n        ", 0, 0, null, null, 965, null);
        }

        @NotNull
        public static JavaParser getParser(@NotNull ChangeStaticFieldToMethodTest $this) {
            return JavaRecipeTest.DefaultImpls.getParser($this);
        }

        @NotNull
        public static ExecutionContext getExecutionContext(@NotNull ChangeStaticFieldToMethodTest $this) {
            return JavaRecipeTest.DefaultImpls.getExecutionContext($this);
        }

        @BeforeEach
        public static void beforeRecipe(@NotNull ChangeStaticFieldToMethodTest $this) {
            JavaRecipeTest.DefaultImpls.beforeRecipe($this);
        }

        @AfterEach
        public static void afterRecipe(@NotNull ChangeStaticFieldToMethodTest $this) {
            JavaRecipeTest.DefaultImpls.afterRecipe($this);
        }

        public static void assertChanged(@NotNull ChangeStaticFieldToMethodTest $this, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged($this, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull ChangeStaticFieldToMethodTest $this, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged($this, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertUnchanged(@NotNull ChangeStaticFieldToMethodTest $this, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged($this, parser, recipe2, executionContext, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull ChangeStaticFieldToMethodTest $this, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged($this, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        public static void assertChangedBase(@NotNull ChangeStaticFieldToMethodTest $this, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase($this, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull ChangeStaticFieldToMethodTest $this, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase($this, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertUnchangedBase(@NotNull ChangeStaticFieldToMethodTest $this, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase($this, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        public static void assertUnchangedBase(@NotNull ChangeStaticFieldToMethodTest $this, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase($this, parser, recipe2, executionContext, before, dependsOn);
        }

        @NotNull
        public static Recipe fromRuntimeClasspath(@NotNull ChangeStaticFieldToMethodTest $this, @NotNull String recipe2) {
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            return JavaRecipeTest.DefaultImpls.fromRuntimeClasspath($this, recipe2);
        }

        @NotNull
        public static Recipe toRecipe(@NotNull ChangeStaticFieldToMethodTest $this, @NotNull Function0<? extends TreeVisitor<?, ExecutionContext>> supplier) {
            Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
            return JavaRecipeTest.DefaultImpls.toRecipe($this, supplier);
        }
    }
}

