/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.ExperimentalPathApi;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.search.FindTypes;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaParserTest;
import org.openrewrite.java.tree.JavaType;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005H\u0017J\u0018\u0010\u0006\u001a\u00020\u00032\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005H\u0017J\u0018\u0010\u0007\u001a\u00020\u00032\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005H\u0017J\u0018\u0010\b\u001a\u00020\u00032\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005H\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\nH\u0017\u00a8\u0006\u000b"}, d2={"Lorg/openrewrite/java/tree/JavaParserTest;", "", "byteArrayAsClasspathElement", "", "jp", "Lorg/openrewrite/java/JavaParser$Builder;", "dependenciesFromClasspathDoesntExist", "dependsOn", "matchMultipleDependenciesWithOneName", "relativeSourcePath", "Lorg/openrewrite/java/JavaParser;", "rewrite-java-tck"})
public interface JavaParserTest {
    @Test
    public void dependenciesFromClasspathDoesntExist(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void matchMultipleDependenciesWithOneName(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    @ExperimentalPathApi
    public void byteArrayAsClasspathElement(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void relativeSourcePath(@NotNull JavaParser var1);

    @Test
    public void dependsOn(@NotNull JavaParser.Builder<?, ?> var1);

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @Test
        public static void dependenciesFromClasspathDoesntExist(@NotNull JavaParserTest $this, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            Assertions.assertThatThrownBy(DefaultImpls::dependenciesFromClasspathDoesntExist$lambda$0).hasMessageStartingWith("Unable to find runtime dependencies beginning with: 'another', 'dne'");
        }

        @Test
        public static void matchMultipleDependenciesWithOneName(@NotNull JavaParserTest $this, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            String[] stringArray = new String[]{"junit"};
            Assertions.assertThat((int)JavaParser.dependenciesFromClasspath((String[])stringArray).size()).isGreaterThan(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Test
        @ExperimentalPathApi
        public static void byteArrayAsClasspathElement(@NotNull JavaParserTest $this, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            Object object = new String[]{"junit-jupiter-api"};
            List list = JavaParser.dependenciesFromClasspath((String[])object);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"dependenciesFromClasspath(\"junit-jupiter-api\")");
            ZipFile zipFile = new ZipFile(((Path)CollectionsKt.first((List)list)).toFile());
            Closeable closeable = zipFile;
            object = null;
            try {
                ZipFile zip = (ZipFile)closeable;
                boolean bl = false;
                Enumeration<? extends ZipEntry> enumeration = zip.entries();
                Intrinsics.checkNotNullExpressionValue(enumeration, (String)"zip.entries()");
                List classpath2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration)), (Function1)byteArrayAsClasspathElement.1.classpath.1.INSTANCE), (Function1)((Function1)new Function1<ZipEntry, byte[]>(zip){
                    final /* synthetic */ ZipFile $zip;
                    {
                        this.$zip = $zip;
                        super(1);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @NotNull
                    public final byte[] invoke(ZipEntry entry) {
                        byte[] byArray;
                        Closeable closeable = this.$zip.getInputStream(entry);
                        Throwable throwable = null;
                        try {
                            InputStream input = (InputStream)closeable;
                            boolean bl = false;
                            Intrinsics.checkNotNullExpressionValue((Object)input, (String)"input");
                            byArray = ByteStreamsKt.readBytes((InputStream)input);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        }
                        return byArray;
                    }
                })));
                InMemoryExecutionContext context = new InMemoryExecutionContext(DefaultImpls::byteArrayAsClasspathElement$lambda$2$lambda$1);
                Collection $this$toTypedArray$iv = classpath2;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                Object object2 = (byte[][])thisCollection$iv.toArray((T[])new byte[0][]);
                JavaParser javaParser = jp.classpath((byte[][])Arrays.copyOf((Object[])object2, ((Object[])object2).length)).logCompilationWarningsAndErrors(true).build();
                object2 = new String[1];
                object2[0] = (byte[])"class Test {\n    @org.junit.jupiter.api.Test\n    void test() {\n    }\n}";
                List cus = javaParser.parse((ExecutionContext)context, (String[])object2);
                ListAssert listAssert = (ListAssert)Assertions.assertThat((List)new FindTypes("org.junit.jupiter.api.Test", Boolean.valueOf(false)).run(cus).getResults()).isNotEmpty();
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
            }
        }

        @Test
        public static void relativeSourcePath(@NotNull JavaParserTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Path projectDir = Paths.get("/Users/jon/test", new String[0]);
            Path sourcePath = Paths.get("/Users/jon/test/src/main/java/Test.java", new String[0]);
            J.CompilationUnit cu = (J.CompilationUnit)jp.parseInputs((Iterable)CollectionsKt.listOf((Object)new Parser.Input(sourcePath, DefaultImpls::relativeSourcePath$lambda$3)), projectDir, (ExecutionContext)new InMemoryExecutionContext()).get(0);
            Assertions.assertThat((Path)cu.getSourcePath()).isEqualTo((Object)Paths.get("src/main/java/Test.java", new String[0]));
        }

        @Test
        public static void dependsOn(@NotNull JavaParserTest $this, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            String[] stringArray = new String[]{"class Test {\n    A a;\n}"};
            List cu = jp.dependsOn((Collection)Collections.singletonList(Parser.Input.fromString((String)"class A {}"))).build().parse(stringArray);
            Object e = ((J.ClassDeclaration)((J.CompilationUnit)cu.get(0)).getClasses().get(0)).getBody().getStatements().get(0);
            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDeclarations");
            JavaType.FullyQualified fullyQualified = ((J.VariableDeclarations)e).getTypeAsFullyQualified();
            Assertions.assertThat((String)(fullyQualified != null ? fullyQualified.getFullyQualifiedName() : null)).isEqualTo("A");
        }

        private static void dependenciesFromClasspathDoesntExist$lambda$0() {
            String[] stringArray = new String[]{"dne", "another"};
            JavaParser.dependenciesFromClasspath((String[])stringArray);
        }

        private static void byteArrayAsClasspathElement$lambda$2$lambda$1(Throwable t) {
            t.printStackTrace();
            System.out.println(Unit.INSTANCE);
        }

        private static InputStream relativeSourcePath$lambda$3() {
            String string = "class Test {}";
            Charset charset = Charsets.UTF_8;
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            return new ByteArrayInputStream(byArray);
        }
    }
}

