/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaTreeTest;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0018\u0010\n\u001a\u00020\u00032\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000bH\u0017J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\r"}, d2={"Lorg/openrewrite/java/tree/ImportTest;", "Lorg/openrewrite/java/tree/JavaTreeTest;", "classImport", "", "jp", "Lorg/openrewrite/java/JavaParser;", "compare", "compareSamePackageDifferentNameLengths", "packageName", "starImport", "typeName", "Lorg/openrewrite/java/JavaParser$Builder;", "uppercasePackage", "rewrite-java-tck"})
public interface ImportTest
extends JavaTreeTest {
    @Test
    public void typeName(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void packageName(@NotNull JavaParser var1);

    @Test
    public void classImport(@NotNull JavaParser var1);

    @Test
    public void starImport(@NotNull JavaParser var1);

    @Test
    public void compare(@NotNull JavaParser var1);

    @Test
    public void compareSamePackageDifferentNameLengths(@NotNull JavaParser var1);

    @Test
    public void uppercasePackage(@NotNull JavaParser var1);

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        /*
         * WARNING - void declaration
         */
        @Test
        public static void typeName(@NotNull ImportTest $this, @NotNull JavaParser.Builder<?, ?> jp) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            Object[] objectArray = new String[]{"import static java.util.Map.Entry;\nimport java.util.Map.Entry;\n\nimport java.util.List;\nimport java.util.*;\n\nimport static java.nio.charset.StandardCharsets.UTF_8;\nimport static java.util.Collections.emptyList;"};
            J.CompilationUnit cu = (J.CompilationUnit)jp.logCompilationWarningsAndErrors(true).build().parse((String[])objectArray).get(0);
            List list = cu.getImports();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"cu.imports");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                J.Import import_ = (J.Import)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getTypeName());
            }
            objectArray = new String[]{"java.util.Map$Entry", "java.util.Map$Entry", "java.util.List", "java.util.*", "java.nio.charset.StandardCharsets", "java.util.Collections"};
            Assertions.assertThat((List)((List)destination$iv$iv)).containsExactly(objectArray);
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void packageName(@NotNull ImportTest $this, @NotNull JavaParser jp) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Object[] objectArray = new String[]{"import static java.util.Map.Entry;\nimport java.util.Map.Entry;\n\nimport java.util.List;\nimport java.util.*;\n\nimport static java.nio.charset.StandardCharsets.UTF_8;\nimport static java.util.Collections.emptyList;"};
            J.CompilationUnit cu = (J.CompilationUnit)jp.parse((String[])objectArray).get(0);
            List list = cu.getImports();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"cu.imports");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                J.Import import_ = (J.Import)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getPackageName());
            }
            objectArray = new String[]{"java.util", "java.util", "java.util", "java.util", "java.nio.charset", "java.util"};
            Assertions.assertThat((List)((List)destination$iv$iv)).containsExactly(objectArray);
        }

        @Test
        public static void classImport(@NotNull ImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            $this.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.CompilationUnit, "\n            import java.util.List;\n            public class A {}\n        ", new String[0]);
        }

        @Test
        public static void starImport(@NotNull ImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            $this.assertParsePrintAndProcess(jp, JavaTreeTest.NestingLevel.CompilationUnit, "\n            import java.util.*;\n            public class A {}\n        ", new String[0]);
        }

        @Test
        public static void compare(@NotNull ImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Object object = new String[]{"import b.B;\nimport c.c.C;"};
            J.CompilationUnit a = (J.CompilationUnit)jp.parse((String[])object).get(0);
            object = a.getImports();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"imports");
            J.Import b = (J.Import)object.get(0);
            J.Import c = (J.Import)object.get(1);
            org.junit.jupiter.api.Assertions.assertTrue((b.compareTo(c) < 0 ? 1 : 0) != 0);
            org.junit.jupiter.api.Assertions.assertTrue((c.compareTo(b) > 0 ? 1 : 0) != 0);
        }

        @Test
        public static void compareSamePackageDifferentNameLengths(@NotNull ImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Object object = new String[]{"import org.springframework.context.annotation.Bean;\nimport org.springframework.context.annotation.Configuration;"};
            J.CompilationUnit a = (J.CompilationUnit)jp.parse((String[])object).get(0);
            object = a.getImports();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"imports");
            J.Import b = (J.Import)object.get(0);
            J.Import c = (J.Import)object.get(1);
            org.junit.jupiter.api.Assertions.assertTrue((b.compareTo(c) < 0 ? 1 : 0) != 0);
            org.junit.jupiter.api.Assertions.assertTrue((c.compareTo(b) > 0 ? 1 : 0) != 0);
        }

        @Test
        public static void uppercasePackage(@NotNull ImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n            package org.openrewrite.BadPackage;\n            \n            public class Foo {\n                public static class Bar {\n                }\n            }\n        ", "\n            package org.openrewrite;\n            \n            import org.openrewrite.BadPackage.Foo;\n            import org.openrewrite.BadPackage.Foo.Bar;\n            \n            public class Bar {\n                private Foo foo; \n            }\n            \n        "};
            List cus = jp.parse(stringArray);
            J.Package package_ = ((J.CompilationUnit)cus.get(0)).getPackageDeclaration();
            Intrinsics.checkNotNull((Object)package_);
            Assertions.assertThat((String)package_.getPackageName()).isEqualTo("org.openrewrite.BadPackage");
            Assertions.assertThat((String)((J.Import)((J.CompilationUnit)cus.get(1)).getImports().get(0)).getPackageName()).isEqualTo("org.openrewrite.BadPackage");
            Assertions.assertThat((String)((J.Import)((J.CompilationUnit)cus.get(1)).getImports().get(1)).getPackageName()).isEqualTo("org.openrewrite.BadPackage");
        }
    }
}

