/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.TypeValidator;
import org.openrewrite.java.search.FindAnnotations;
import org.openrewrite.java.tree.J;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\bf\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017J\b\u0010\u0002\u001a\u00020\u0003H\u0017J\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0018\u0010\t\u001a\u00020\u00032\u000e\u0010\u0005\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\nH\u0017J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0018\u0010\f\u001a\u00020\u00032\u000e\u0010\u0005\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\nH\u0017J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0018\u0010\u000f\u001a\u00020\u00032\u000e\u0010\u0005\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\nH\u0017J\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0017\u00a8\u0006\u0018"}, d2={"Lorg/openrewrite/java/search/FindAnnotationsTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "checkValidation", "", "doesNotMatchDifferentNamedParameters", "jp", "Lorg/openrewrite/java/JavaParser;", "doesNotMatchDifferentSingleAnnotationParameter", "doesNotMatchNotFullyQualifiedAnnotations", "enumArgument", "Lorg/openrewrite/java/JavaParser$Builder;", "findAnnotationWithClassTypeArgument", "matchMetaAnnotation", "matchesAnnotationOnField", "matchesAnnotationOnMethod", "matchesClassArgument", "matchesNamedParameters", "matchesNamedParametersRegardlessOfOrder", "matchesPartialNamedParameters", "matchesSimpleFullyQualifiedAnnotation", "matchesSingleAnnotationParameter", "matchesSubpackageWildcard", "matchesWildcard", "Companion", "rewrite-java-tck"})
public interface FindAnnotationsTest
extends JavaRecipeTest {
    @NotNull
    public static final Companion Companion = org.openrewrite.java.search.FindAnnotationsTest$Companion.$$INSTANCE;
    @NotNull
    public static final String foo = "\n            package com.netflix.foo;\n            public @interface Foo {\n                String bar();\n                String baz();\n            }\n        ";

    @Test
    public void matchMetaAnnotation(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void matchesClassArgument(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void matchesSimpleFullyQualifiedAnnotation(@NotNull JavaParser var1);

    @Test
    public void matchesWildcard(@NotNull JavaParser var1);

    @Test
    public void matchesSubpackageWildcard(@NotNull JavaParser var1);

    @Test
    public void matchesAnnotationOnMethod(@NotNull JavaParser var1);

    @Test
    public void matchesAnnotationOnField(@NotNull JavaParser var1);

    @Test
    public void doesNotMatchNotFullyQualifiedAnnotations(@NotNull JavaParser var1);

    @Test
    public void matchesSingleAnnotationParameter(@NotNull JavaParser var1);

    @Test
    public void doesNotMatchDifferentSingleAnnotationParameter(@NotNull JavaParser var1);

    @Test
    public void matchesNamedParameters(@NotNull JavaParser var1);

    @Test
    public void doesNotMatchDifferentNamedParameters(@NotNull JavaParser var1);

    @Test
    public void matchesPartialNamedParameters(@NotNull JavaParser var1);

    @Test
    public void matchesNamedParametersRegardlessOfOrder(@NotNull JavaParser var1);

    @Test
    public void checkValidation();

    @Test
    public void findAnnotationWithClassTypeArgument(@NotNull JavaParser var1);

    @Test
    public void enumArgument(@NotNull JavaParser.Builder<?, ?> var1);

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/openrewrite/java/search/FindAnnotationsTest$Companion;", "", "()V", "foo", "", "rewrite-java-tck"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        public static final String foo = "\n            package com.netflix.foo;\n            public @interface Foo {\n                String bar();\n                String baz();\n            }\n        ";

        private Companion() {
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @Test
        public static void matchMetaAnnotation(@NotNull FindAnnotationsTest $this, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = $this;
            JavaParser javaParser = jp.classpath((Collection)JavaParser.runtimeClasspath()).logCompilationWarningsAndErrors(true).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.classpath(JavaParser.\u2026gsAndErrors(true).build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, (Recipe)new FindAnnotations("@javax.annotation.Nonnull", Boolean.valueOf(true)), null, "\n            import org.openrewrite.internal.lang.Nullable;\n            public class Test {\n                @Nullable String name;\n            }\n        ", null, "\n            import org.openrewrite.internal.lang.Nullable;\n            public class Test {\n                /*~~>*/@Nullable String name;\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void matchesClassArgument(@NotNull FindAnnotationsTest $this, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            String[] stringArray = new String[]{"junit-jupiter-api"};
            JavaParser javaParser = jp.classpath(stringArray).build();
            stringArray = new FindAnnotations("@org.junit.jupiter.api.extension.ExtendWith(org.openrewrite.MyExtension.class)", null);
            String[] stringArray2 = new String[]{"\n                package org.openrewrite;\n                import org.junit.jupiter.api.extension.Extension;\n                public class MyExtension implements Extension {}\n            "};
            String[] stringArray3 = stringArray2;
            JavaRecipeTest javaRecipeTest = $this;
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, (Recipe)stringArray, null, "\n            import org.junit.jupiter.api.extension.ExtendWith;\n            import org.openrewrite.MyExtension;\n            @ExtendWith(MyExtension.class) public class A {}\n            @ExtendWith({MyExtension.class}) class B {}\n            @ExtendWith(value = MyExtension.class) class C {}\n            @ExtendWith(value = {MyExtension.class}) class D {}\n        ", stringArray3, "\n            import org.junit.jupiter.api.extension.ExtendWith;\n            import org.openrewrite.MyExtension;\n            /*~~>*/@ExtendWith(MyExtension.class) public class A {}\n            /*~~>*/@ExtendWith({MyExtension.class}) class B {}\n            /*~~>*/@ExtendWith(value = MyExtension.class) class C {}\n            /*~~>*/@ExtendWith(value = {MyExtension.class}) class D {}\n        ", 0, 0, null, null, 964, null);
        }

        @Test
        public static void matchesSimpleFullyQualifiedAnnotation(@NotNull FindAnnotationsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default($this, jp, (Recipe)new FindAnnotations("@java.lang.Deprecated", null), null, "@Deprecated public class A {}", null, "/*~~>*/@Deprecated public class A {}", 0, 0, null, null, 980, null);
        }

        @Test
        public static void matchesWildcard(@NotNull FindAnnotationsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default($this, jp, (Recipe)new FindAnnotations("@java.lang.*", null), null, "@Deprecated public class A {}", null, "/*~~>*/@Deprecated public class A {}", 0, 0, null, null, 980, null);
        }

        @Test
        public static void matchesSubpackageWildcard(@NotNull FindAnnotationsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default($this, jp, (Recipe)new FindAnnotations("@java..*", null), null, "@Deprecated public class A {}", null, "/*~~>*/@Deprecated public class A {}", 0, 0, null, null, 980, null);
        }

        @Test
        public static void matchesAnnotationOnMethod(@NotNull FindAnnotationsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default($this, jp, (Recipe)new FindAnnotations("@java.lang.Deprecated", null), null, "\n            public class A {\n                @Deprecated\n                public void foo() {}\n            }\n        ", null, "\n            public class A {\n                /*~~>*/@Deprecated\n                public void foo() {}\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void matchesAnnotationOnField(@NotNull FindAnnotationsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default($this, jp, (Recipe)new FindAnnotations("@java.lang.Deprecated", null), null, "\n            public class A {\n                @Deprecated String s;\n            }\n        ", null, "\n            public class A {\n                /*~~>*/@Deprecated String s;\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @Test
        public static void doesNotMatchNotFullyQualifiedAnnotations(@NotNull FindAnnotationsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default($this, jp, (Recipe)new FindAnnotations("@Deprecated", null), null, "@Deprecated public class A {}", null, 20, null);
        }

        @Test
        public static void matchesSingleAnnotationParameter(@NotNull FindAnnotationsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default($this, jp, (Recipe)new FindAnnotations("@java.lang.SuppressWarnings(\"deprecation\")", null), null, "@SuppressWarnings(\"deprecation\") public class A {}", null, "/*~~>*/@SuppressWarnings(\"deprecation\") public class A {}", 0, 0, null, null, 980, null);
        }

        @Test
        public static void doesNotMatchDifferentSingleAnnotationParameter(@NotNull FindAnnotationsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default($this, jp, (Recipe)new FindAnnotations("@java.lang.SuppressWarnings(\"foo\")", null), null, "@SuppressWarnings(\"deprecation\") public class A {}", null, 20, null);
        }

        @Test
        public static void matchesNamedParameters(@NotNull FindAnnotationsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            FindAnnotations findAnnotations = new FindAnnotations("@com.netflix.foo.Foo(bar=\"quux\",baz=\"bar\")", null);
            String[] stringArray = new String[]{FindAnnotationsTest.foo};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default($this, jp, (Recipe)findAnnotations, null, "\n            import com.netflix.foo.Foo;\n            @Foo(bar=\"quux\", baz=\"bar\")\n            public class A {}\n        ", stringArray2, "\n            import com.netflix.foo.Foo;\n            /*~~>*/@Foo(bar=\"quux\", baz=\"bar\")\n            public class A {}\n        ", 0, 0, null, null, 964, null);
        }

        @Test
        public static void doesNotMatchDifferentNamedParameters(@NotNull FindAnnotationsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{FindAnnotationsTest.foo};
            JavaRecipeTest.DefaultImpls.assertUnchanged$default($this, jp, (Recipe)new FindAnnotations("@com.netflix.foo.Foo(bar=\"qux\",baz=\"baz\")", null), null, "\n            import com.netflix.foo.Foo;\n            @Foo(bar=\"quux\", baz=\"bar\")\n            public class A {} \n        ", stringArray, 4, null);
        }

        @Test
        public static void matchesPartialNamedParameters(@NotNull FindAnnotationsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            FindAnnotations findAnnotations = new FindAnnotations("@com.netflix.foo.Foo(baz=\"bar\")", null);
            String[] stringArray = new String[]{FindAnnotationsTest.foo};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default($this, jp, (Recipe)findAnnotations, null, "\n            import com.netflix.foo.Foo;\n            @Foo(bar=\"quux\", baz=\"bar\")\n            public class A {}\n        ", stringArray2, "\n            import com.netflix.foo.Foo;\n            /*~~>*/@Foo(bar=\"quux\", baz=\"bar\")\n            public class A {}\n        ", 0, 0, null, null, 964, null);
        }

        @Test
        public static void matchesNamedParametersRegardlessOfOrder(@NotNull FindAnnotationsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            FindAnnotations findAnnotations = new FindAnnotations("@com.netflix.foo.Foo(baz=\"bar\",bar=\"quux\")", null);
            String[] stringArray = new String[]{FindAnnotationsTest.foo};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default($this, jp, (Recipe)findAnnotations, null, "\n            import com.netflix.foo.Foo;\n            @Foo(bar=\"quux\", baz=\"bar\")\n            public class A {}\n        ", stringArray2, "\n            import com.netflix.foo.Foo;\n            /*~~>*/@Foo(bar=\"quux\", baz=\"bar\")\n            public class A {}\n        ", 0, 0, null, null, 964, null);
        }

        @Test
        public static void checkValidation(@NotNull FindAnnotationsTest $this) {
            FindAnnotations recipe2 = new FindAnnotations(null, null);
            Validated valid = recipe2.validate();
            Assertions.assertThat((boolean)valid.isValid()).isFalse();
            Assertions.assertThat((List)valid.failures()).hasSize(1);
            Assertions.assertThat((String)((Validated.Invalid)valid.failures().get(0)).getProperty()).isEqualTo("annotationPattern");
            recipe2 = new FindAnnotations("@com.netflix.foo.Foo(baz=\"bar\",bar=\"quux\")", null);
            valid = recipe2.validate();
            Assertions.assertThat((boolean)valid.isValid()).isTrue();
        }

        @Test
        public static void findAnnotationWithClassTypeArgument(@NotNull FindAnnotationsTest $this, @NotNull JavaParser jp) {
            Object v2;
            block1: {
                Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
                Object object = new String[]{"\n            package com.foo;\n            \n            import java.lang.annotation.ElementType;\n            import java.lang.annotation.Inherited;\n            import java.lang.annotation.Retention;\n            import java.lang.annotation.RetentionPolicy;\n            import java.lang.annotation.Target;\n            \n            @Retention(RetentionPolicy.RUNTIME)\n            @Target({ElementType.TYPE})\n            @Inherited\n            public @interface Example { \n                Class<?> value();\n            }\n        ", "\n            package com.foo;\n            \n            @Example(Foo.class)\n            public class Foo {}\n        "};
                List list = jp.parse((String[])object);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"jp.parse(\"\"\"\n           \u2026class Foo {}\n        \"\"\")");
                object = list;
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Object t = iterator.next();
                    J.CompilationUnit it = (J.CompilationUnit)t;
                    boolean bl = false;
                    List list2 = it.getClasses();
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"it.classes");
                    if (!Intrinsics.areEqual((Object)((J.ClassDeclaration)CollectionsKt.first((List)list2)).getSimpleName(), (Object)"Foo")) continue;
                    v2 = t;
                    break block1;
                }
                v2 = null;
            }
            Intrinsics.checkNotNull(v2);
            J.CompilationUnit fooClass = v2;
            Set maybeExample = FindAnnotations.find((J)((J)fooClass), (String)"@com.foo.Example(com.foo.Foo.class)");
            Assertions.assertThat((Collection)maybeExample).hasSize(1);
        }

        @Test
        public static void enumArgument(@NotNull FindAnnotationsTest $this, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = $this;
            String[] stringArray = new String[]{"jackson-annotations"};
            JavaParser javaParser = jp.classpath(stringArray).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.classpath(\"jackson-annotations\").build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, (Recipe)new FindAnnotations("@com.fasterxml.jackson.annotation.JsonTypeInfo(use=com.fasterxml.jackson.annotation.JsonTypeInfo$Id.CLASS)", null), null, "\n            import com.fasterxml.jackson.annotation.JsonTypeInfo;\n            import com.fasterxml.jackson.annotation.JsonTypeInfo.Id;\n            \n            class PenetrationTesting {\n                @JsonTypeInfo(use = Id.CLASS)\n                Object name;\n            }\n        ", null, "\n            import com.fasterxml.jackson.annotation.JsonTypeInfo;\n            import com.fasterxml.jackson.annotation.JsonTypeInfo.Id;\n            \n            class PenetrationTesting {\n                /*~~>*/@JsonTypeInfo(use = Id.CLASS)\n                Object name;\n            }\n        ", 0, 0, null, null, 980, null);
        }

        @NotNull
        public static JavaParser getParser(@NotNull FindAnnotationsTest $this) {
            return JavaRecipeTest.DefaultImpls.getParser($this);
        }

        @NotNull
        public static ExecutionContext getExecutionContext(@NotNull FindAnnotationsTest $this) {
            return JavaRecipeTest.DefaultImpls.getExecutionContext($this);
        }

        @BeforeEach
        public static void beforeRecipe(@NotNull FindAnnotationsTest $this) {
            JavaRecipeTest.DefaultImpls.beforeRecipe($this);
        }

        @AfterEach
        public static void afterRecipe(@NotNull FindAnnotationsTest $this) {
            JavaRecipeTest.DefaultImpls.afterRecipe($this);
        }

        public static void assertChanged(@NotNull FindAnnotationsTest $this, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged($this, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull FindAnnotationsTest $this, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged($this, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertUnchanged(@NotNull FindAnnotationsTest $this, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged($this, parser, recipe2, executionContext, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull FindAnnotationsTest $this, @NotNull JavaParser parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged($this, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        @Nullable
        public static Recipe getRecipe(@NotNull FindAnnotationsTest $this) {
            return JavaRecipeTest.DefaultImpls.getRecipe($this);
        }

        public static void assertChangedBase(@NotNull FindAnnotationsTest $this, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase($this, parser, recipe2, executionContext, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull FindAnnotationsTest $this, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase($this, parser, recipe2, executionContext, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertUnchangedBase(@NotNull FindAnnotationsTest $this, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase($this, parser, recipe2, executionContext, before, relativeTo, dependsOn);
        }

        public static void assertUnchangedBase(@NotNull FindAnnotationsTest $this, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull ExecutionContext executionContext, @NotNull String before, @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase($this, parser, recipe2, executionContext, before, dependsOn);
        }

        @NotNull
        public static Recipe fromRuntimeClasspath(@NotNull FindAnnotationsTest $this, @NotNull String recipe2) {
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            return JavaRecipeTest.DefaultImpls.fromRuntimeClasspath($this, recipe2);
        }

        @NotNull
        public static Recipe toRecipe(@NotNull FindAnnotationsTest $this, @NotNull Function0<? extends TreeVisitor<?, ExecutionContext>> supplier) {
            Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
            return JavaRecipeTest.DefaultImpls.toRecipe($this, supplier);
        }
    }
}

