/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.cleanup.RenameLocalVariablesToCamelCase;
import org.openrewrite.java.marker.JavaVersion;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0003H\u0017J\b\u0010\u0007\u001a\u00020\u0003H\u0017J\b\u0010\b\u001a\u00020\u0003H\u0017J\b\u0010\t\u001a\u00020\u0003H\u0017J\b\u0010\n\u001a\u00020\u0003H\u0017J\b\u0010\u000b\u001a\u00020\u0003H\u0017J\b\u0010\f\u001a\u00020\u0003H\u0017J\b\u0010\r\u001a\u00020\u0003H\u0017J\b\u0010\u000e\u001a\u00020\u0003H\u0017J\b\u0010\u000f\u001a\u00020\u0003H\u0017J\b\u0010\u0010\u001a\u00020\u0003H\u0017\u00a8\u0006\u0011"}, d2={"Lorg/openrewrite/java/cleanup/RenameLocalVariablesToCamelCaseTest;", "Lorg/openrewrite/test/RewriteTest;", "defaults", "", "spec", "Lorg/openrewrite/test/RecipeSpec;", "doNotChangeCatch", "doNotChangeIfToNameExists", "doNotChangeInheritedFields", "doNotChangeStaticImports", "doNotForLoop", "doNotRenameConstantVariable", "lowerCamelVariableHasNonLowerCamelVariableSibling", "recordCompactConstructor", "renameAllCapsAcronyms", "renameJavaDocParam", "renameLocalVariables", "rewrite-java-tck"})
public interface RenameLocalVariablesToCamelCaseTest
extends RewriteTest {
    public void defaults(@NotNull RecipeSpec var1);

    @Test
    public void lowerCamelVariableHasNonLowerCamelVariableSibling();

    @Test
    public void renameAllCapsAcronyms();

    @Test
    public void renameLocalVariables();

    @Test
    public void renameJavaDocParam();

    @Test
    public void doNotChangeStaticImports();

    @Test
    public void doNotChangeInheritedFields();

    @Test
    public void doNotChangeIfToNameExists();

    @Test
    public void doNotChangeCatch();

    @Test
    public void doNotForLoop();

    @Test
    public void doNotRenameConstantVariable();

    @Test
    public void recordCompactConstructor();

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        public static void defaults(@NotNull RenameLocalVariablesToCamelCaseTest $this, @NotNull RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            spec.recipe((Recipe)new RenameLocalVariablesToCamelCase());
        }

        @Test
        public static void lowerCamelVariableHasNonLowerCamelVariableSibling(@NotNull RenameLocalVariablesToCamelCaseTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class A {\n                void m()  {\n                    boolean secure = _secure > 0;\n                    final int _secure = 0;\n                    \n                    int _notSecure = 0;\n                    boolean notSecure = _notSecure < 1;\n                }\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void renameAllCapsAcronyms(@NotNull RenameLocalVariablesToCamelCaseTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                void test() {\n                    String ID;\n                }\n            }\n        ", (String)"\n            class Test {\n                void test() {\n                    String id;\n                }\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void renameLocalVariables(@NotNull RenameLocalVariablesToCamelCaseTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                int DoNoTChange;\n\n                public int addTen(int rename_one) {\n                    double RenameTwo = 2.0;\n                    float __rename__three__ = 2.0;\n                    long _Rename__Four = 2.0;\n                    return rename_one + RenameTwo + __rename__three__ + _Rename__Four + 10;\n                }\n            }\n        ", (String)"\n            class Test {\n                int DoNoTChange;\n\n                public int addTen(int renameOne) {\n                    double renameTwo = 2.0;\n                    float renameThree = 2.0;\n                    long renameFour = 2.0;\n                    return renameOne + renameTwo + renameThree + renameFour + 10;\n                }\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void renameJavaDocParam(@NotNull RenameLocalVariablesToCamelCaseTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                /**\n                 * @param rename_one\n                 */\n                public void addTen(int rename_one) {\n                }\n            }\n        ", (String)"\n            class Test {\n                /**\n                 * @param renameOne\n                 */\n                public void addTen(int renameOne) {\n                }\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void doNotChangeStaticImports(@NotNull RenameLocalVariablesToCamelCaseTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class B {\n                public static int _staticImport_ = 0;\n            }\n        "), Assertions.java((String)"\n            import static B._staticImport_;\n\n            class Test {\n                public int addTen(int testValue) {\n                    _staticImport_++;\n                    return testValue;\n                }\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void doNotChangeInheritedFields(@NotNull RenameLocalVariablesToCamelCaseTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class A {\n                public int _inheritedField_ = 0;\n            }\n        "), Assertions.java((String)"\n            class Test extends A {\n                public int addTen(int testValue) {\n                    _inheritedField_++;\n                    return testValue;\n                }\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void doNotChangeIfToNameExists(@NotNull RenameLocalVariablesToCamelCaseTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                int DoNoTChange;\n\n                public int addTen(int test_value) {\n                    int testValue = 10;\n                    return test_value + testValue;\n                }\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void doNotChangeCatch(@NotNull RenameLocalVariablesToCamelCaseTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                int DoNoTChange;\n\n                public int addTen(String value) {\n                    try {\n                        Integer.valueOf(value);\n                    // Rule does not apply to catch variables with 1 character.\n                    } catch (Exception E){\n                        throw new NumberFormatException(\"Test\", E);\n                    }\n                    return DoNoTChange + 10;\n                }\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void doNotForLoop(@NotNull RenameLocalVariablesToCamelCaseTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            class Test {\n                int DoNoTChange;\n\n                public void addTen() {\n                    // Rule does not apply to for loop control variables.\n                    for (int do_not_change = 0; do_not_change < 10; do_not_change++) {\n                       DoNoTChange += do_not_change; \n                    }\n                }\n            }\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void doNotRenameConstantVariable(@NotNull RenameLocalVariablesToCamelCaseTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            import java.util.ArrayList;\n            import java.util.List;\n            class Test {\n                public List<String> testFoo() {\n                    return new ArrayList<>() {\n                        private final int DO_NOT_CHANGE = 1;\n                   \n                    };\n                    \n                }\n            }\n\n        ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void recordCompactConstructor(@NotNull RenameLocalVariablesToCamelCaseTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n            public record MyRecord(\n               boolean bar,\n               String foo\n            ) {\n               public MyRecord {\n                  if (foo == null) {\n                      foo = \"defaultValue\";\n                  }\n              }\n            }\n        ")};
            $this.rewriteRun(DefaultImpls::recordCompactConstructor$lambda$1, sourceSpecsArray);
        }

        private static void recordCompactConstructor$lambda$1$lambda$0(RecipeSpec $spec, List sf) {
            String javaRuntimeVersion = System.getProperty("java.runtime.version");
            String javaVendor = System.getProperty("java.vm.vendor");
            if (new JavaVersion(Tree.randomId(), javaRuntimeVersion, javaVendor, javaRuntimeVersion, javaRuntimeVersion).getMajorVersion() != 17) {
                $spec.recipe(Recipe.noop());
            }
        }

        private static void recordCompactConstructor$lambda$1(RecipeSpec spec) {
            spec.beforeRecipe(arg_0 -> DefaultImpls.recordCompactConstructor$lambda$1$lambda$0(spec, arg_0));
        }
    }
}

