/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.Recipe;
import org.openrewrite.java.Assertions;
import org.openrewrite.java.cleanup.InlineVariable;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTest;
import org.openrewrite.test.SourceSpecs;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0017J\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0003H\u0017J\b\u0010\b\u001a\u00020\u0003H\u0017\u00a8\u0006\t"}, d2={"Lorg/openrewrite/java/cleanup/InlineVariableTest;", "Lorg/openrewrite/test/RewriteTest;", "annotatedReturnIdentifier", "", "defaults", "spec", "Lorg/openrewrite/test/RecipeSpec;", "inlineVariable", "preserveComments", "rewrite-java-tck"})
public interface InlineVariableTest
extends RewriteTest {
    public void defaults(@NotNull RecipeSpec var1);

    @Test
    public void inlineVariable();

    @Test
    public void preserveComments();

    @Test
    public void annotatedReturnIdentifier();

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        public static void defaults(@NotNull InlineVariableTest $this, @NotNull RecipeSpec spec) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            spec.recipe((Recipe)new InlineVariable());
        }

        @Test
        public static void inlineVariable(@NotNull InlineVariableTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                import java.util.List;\n                import java.util.stream.Collectors;\n                \n                class Test {\n                    int test() {\n                        int n = 0;\n                        return n;\n                    }\n                    \n                    int test2() {\n                        int n = 0;\n                        System.out.println(n);\n                        return n;\n                    }\n                    \n                    void test3() {}\n                    \n                    void test4(String arg) throws IllegalArgumentException {\n                        if (arg == null || arg.isEmpty()) {\n                            IllegalArgumentException e = new IllegalArgumentException(\"arg should not be empty or null\");\n                            throw e;\n                        }\n                    }\n                    \n                    List<String> testLambda(List<String> names) {\n                        return names.stream().map(n -> {\n                            String un = n.toLowerCase();\n                            return un;\n                        }).collect(Collectors.toList());\n                    }\n                }\n            ", (String)"\n                import java.util.List;\n                import java.util.stream.Collectors;\n                \n                class Test {\n                    int test() {\n                        return 0;\n                    }\n                    \n                    int test2() {\n                        int n = 0;\n                        System.out.println(n);\n                        return n;\n                    }\n                    \n                    void test3() {}\n                    \n                    void test4(String arg) throws IllegalArgumentException {\n                        if (arg == null || arg.isEmpty()) {\n                            throw new IllegalArgumentException(\"arg should not be empty or null\");\n                        }\n                    }\n                    \n                    List<String> testLambda(List<String> names) {\n                        return names.stream().map(n -> {\n                            return n.toLowerCase();\n                        }).collect(Collectors.toList());\n                    }\n                }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void preserveComments(@NotNull InlineVariableTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                class Test {\n                    String getGreeting() {\n                        // sometimes there are comments\n                        // keep them\n                        String s = \"hello\";\n                        return s;\n                    }\n                    \n                    void test4(String arg) throws IllegalArgumentException {\n                        if (arg == null || arg.isEmpty()) {\n                            // some comment for the illegal argument\n                            IllegalArgumentException e = new IllegalArgumentException(\"arg should not be empty or null\");\n                            throw e;\n                        }\n                    }\n                }\n            ", (String)"\n                class Test {\n                    String getGreeting() {\n                        // sometimes there are comments\n                        // keep them\n                        return \"hello\";\n                    }\n                    \n                    void test4(String arg) throws IllegalArgumentException {\n                        if (arg == null || arg.isEmpty()) {\n                            // some comment for the illegal argument\n                            throw new IllegalArgumentException(\"arg should not be empty or null\");\n                        }\n                    }\n                }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }

        @Test
        public static void annotatedReturnIdentifier(@NotNull InlineVariableTest $this) {
            SourceSpecs[] sourceSpecsArray = new SourceSpecs[]{Assertions.java((String)"\n                class Test {\n                    String test() {\n                        @SuppressWarnings(\"unchecked\")\n                        String someString = (String)getSomething();\n                        return someString;\n                    }\n                    \n                    Object getSomething() {return null;}\n                }\n            ")};
            $this.rewriteRun(sourceSpecsArray);
        }
    }
}

